/* bmutil.c */
#include <stdio.h>
#include <stdlib.h>
#include <alloc.h>
#include <string.h>
#include <ctype.h>
#include <time.h>

#define		SETVBUF
#include <sys/stat.h>
#include <fcntl.h>
#include "bm.h"
#include "header.h"

char         *getname(  );
static unsigned long mboxsize;
static int    anyread;
static unsigned long mfsize;
char          reply_addr[LINELEN];
char          badchar[] = "Invalid name\r\n";

#ifdef SETVBUF
#define		MYBUF	4096
char         *inbuf = NULLCHAR;	/* the stdio buffer for the mail file */
char         *outbuf = NULLCHAR;/* the stdio file io buffer for the temp file */
#endif

int
initnotes(  )
{
  FILE         *tmpfile(  );
  FILE         *ifile;
  register struct let *cmsg;
  int           i, ret;
  struct stat   mstat;

  nmsgs = 0;
  current = 0;
  change = 0;
  newmsgs = 0;
  anyread = 0;
  if ( !stat( mfilename, &mstat ) )
    mboxsize = mstat.st_size;
  else
    mboxsize = 0;
  if ( ( ifile = fopen( mfilename, "r" ) ) == NULLFILE )
  {
    printf( nomail );
    mfile = NULLFILE;
    return 0;
  }

#ifdef	SETVBUF
  if ( inbuf == NULLCHAR )
    inbuf = malloc( MYBUF );
  setvbuf( ifile, inbuf, _IOFBF, MYBUF );
#endif

  if ( ( mfile = tmpfile(  ) ) == NULLFILE )
  {
    printf( "Unable to create tmp file\r\n" );
    ( void ) fclose( ifile );
    mfile = NULLFILE;
    return 0;
  }

#ifdef SETVBUF
  if ( outbuf == NULLCHAR )
    outbuf = malloc( MYBUF );
  setvbuf( mfile, outbuf, _IOFBF, MYBUF );
#endif

  ret = readnotes( ifile );
  ( void ) fclose( ifile );
  if ( ret != 0 )
    return -1;

#ifdef SETVBUF
  if ( inbuf != NULLCHAR )
  {
    ( void ) free( inbuf );
    inbuf = NULLCHAR;
  }
#endif

  for ( cmsg = &mbox[1], i = 1; i <= nmsgs; i++, cmsg++ )
    if ( ( cmsg->status & READ ) == 0 )
    {
      newmsgs++;
      if ( current == 0 )
	current = i;
    }
  /* start at one if no new messages */
  if ( current == 0 )
    current++;
  /* file is empty or not a mail file */
  if ( nmsgs == 0 )
  {
    ( void ) fclose( mfile );
    printf( nomail );
    mfile = NULLFILE;
  }
  return 0;
}

/* readnotes assumes that ifile is pointing to the first
 * message that needs to be read.  For initial reads of a
 * notefile, this will be the beginning of the file.  For
 * rereads when new mail arrives, it will be the first new
 * message.
 */
readnotes( ifile )
FILE         *ifile;
{
  char          tstring[LINELEN];
  long          cpos;
  register struct let *cmsg;
  register char *line;
  long          ftell(  );

  cmsg = ( struct let * ) NULL;
  line = tstring;
  while ( !feof( ifile ) )
  {
    if ( fgets( line, LINELEN, ifile ) == NULLCHAR )
      break;
    /* scan for beginning of a message */
    if ( strncmp( line, "From ", 5 ) == 0 )
    {
      cpos = ftell( mfile );
      fputs( line, mfile );
      if ( nmsgs == maxlet - 1 )
      {
	printf( "Mailbox full: > %d messages\r\n", maxlet - 1 );
	( void ) fclose( mfile );
	return -1;
      }
      nmsgs++;
      cmsg = &mbox[nmsgs];
      cmsg->start = cpos;
      cmsg->status = 0;
      cmsg->size = strlen( line );
      while ( !feof( ifile ) )
      {
	if ( fgets( line, LINELEN, ifile ) == NULLCHAR )
	  break;
	if ( *line == '\n' )
	{			/* done header part */
	  cmsg->size++;
	  putc( *line, mfile );
	  break;
	}
	if ( htype( line ) == STATUS )
	{
	  if ( line[8] == 'R' )
	    cmsg->status |= READ;
	  continue;
	}
	cmsg->size += strlen( line );
	if ( fputs( line, mfile ) == EOF )
	{
	  perror( "tmp file" );
	  ( void ) fclose( mfile );
	  return -1;
	}

      }
    }
    else if ( recv_pgp( line, ifile, mfile, cmsg ) )
      ;
    else if ( cmsg )
    {
      cmsg->size += strlen( line );
      fputs( line, mfile );
    }
  }
  return 0;
}

/* list headers of a notefile */
listnotes( to_list, argc, argv, msg_num, mlines )
int           to_list;
int           argc;
char         *argv[];
int           msg_num;
int           mlines;
{
  register struct let *cmsg;
  register char *a, *b, *p, *q, *s, *D, *M, *T;
  char          smtp_date[LINELEN], smtp_Day[LINELEN], smtp_Month[LINELEN];
  char          smtp_Time[LINELEN], smtp_from[LINELEN], smtp_From[LINELEN];
  char          smtp_subject[LINELEN], smtp_to[LINELEN], tstring[LINELEN];
  char          qstring[LINELEN];
  int           i, c, patt, frm, hdr;
  long          size;

  if ( mfile == NULLFILE )
    return;

/*	screen_clear(); */

  if ( nmsgs == 1 && argc == 0 )
    printf( "Mailbox %s %ld bytes - %d message %d new\r\n\n", mfilename, mboxsize, nmsgs, newmsgs );
  else if ( argc == 0 )
    printf( "Mailbox %s %ld bytes - %d messages %d new\r\n\n", mfilename, mboxsize, nmsgs, newmsgs );
  if ( argc != 0 )
  {
    a = argv[0];
    to_lower( a );
  }
  if ( msg_num == 0 )
    i = 1;
  else
    i = msg_num;
  for ( cmsg = &mbox[i]; i <= nmsgs; i++, cmsg++ )
  {
    *smtp_date = '\0';
    *smtp_Day = '\0';
    *smtp_Month = '\0';
    *smtp_Time = '\0';
    *smtp_from = '\0';
    *smtp_From = '\0';
    *smtp_subject = '\0';
    *smtp_to = '\0';
    patt = 0;
    frm = 0;
    hdr = 0;
    fseek( mfile, cmsg->start, 0 );
    size = cmsg->size;
    while ( !feof( mfile ) && size > 0 )
    {
      if ( fgets( tstring, sizeof( tstring ), mfile ) == NULLCHAR )
	break;
      if ( argc != 0 )
      {
	strcpy( qstring, tstring );
	b = qstring;
	to_lower( b );
	rip( b );
      }
      if ( strncmp( tstring, "From ", 5 ) == 0 )
      {
	if ( frm == 1 )
	  break;
	frm = 1;
	p = &tstring[5];
	q = &tstring[5];
	while ( *p && *p != ' ' && *p != '\t' && *p != '(' )
	  p++;
	*p = '\0';
	p = &tstring[5];
	while ( *q != ' ' && *q != '\t' )
	  q++;
	while ( *q == ' ' || *q == '\t' )
	  q++;
	M = smtp_Month;
	*M++ = *q++;
	*M++ = *q++;
	*M++ = *q++;
	*M = '\0';
	while ( *q == ' ' || *q == '\t' )
	  q++;
	D = smtp_Day;
	if ( atoi( q ) < 10 && *q != '0' )
	  *D++ = ' ';
	else if ( atoi( q ) < 10 && *q == '0' )
	{
	  *D++ = ' ';
	  q++;
	}
	else
	  *D++ = *q++;
	*D++ = *q++;
	*D = '\0';
	while ( *q == ' ' || *q == '\t' )
	  q++;
	T = smtp_Time;
	*T++ = *q++;
	*T++ = *q++;
	if ( *q == ':' )
	{
	  *T++ = *q++;
	  *T++ = *q++;
	  *T++ = *q++;
	  *T = '\0';
	}
	else
	{
	  *T = '\0';
	  *smtp_Day = '\0';
	  *smtp_Month = '\0';
	  *smtp_Time = '\0';
	}
	rip( smtp_Day );
	rip( smtp_Month );
	rip( smtp_Time );
	rip( p );
	sprintf( smtp_From, "%.30s", p );
      }
      if ( argc != 0 && patt == 0 )
	if ( strstr( b, a ) != 0 )
	  patt = 1;
      if ( *tstring == '\n' )	/* end of header */
	if ( argc == 0 )
	  break;
	else
	  hdr = 1;
      size -= strlen( tstring );
      rip( tstring );
      /* handle continuation later */
      if ( *tstring == ' ' || *tstring == '\t' )
	continue;
      if ( hdr == 0 || argc == 0 )
      {
	switch ( htype( tstring ) )
	{
	  case FROM:
	    if ( ( p = getname( tstring ) ) == NULLCHAR )
	    {
	      p = &tstring[6];
	      while ( *p && *p != ' ' && *p != '\t' && *p != '(' )
		p++;
	      *p = '\0';
	      p = &tstring[6];
	    }
	    cleanup_line( p );
	    sprintf( smtp_from, "%.30s", p );
	    break;
	  case TO:
	    if ( ( p = getname( tstring ) ) == NULLCHAR )
	      p = &tstring[4];
	    cleanup_line( p );
	    sprintf( smtp_to, "%.30s", p );
	    break;
	  case SUBJECT:
	    p = &tstring[9];
	    while ( *p == ' ' || *p == '\t' )
	      p++;
	    cleanup_line( p );
	    sprintf( smtp_subject, "%.34s", p );
	    break;
	  case DATE:
	    if ( ( p = strchr( tstring, ',' ) ) == NULLCHAR )
	      p = &tstring[6];
	    else
	      p++;
	    /* skip spaces */
	    while ( *p == ' ' || *p == '\t' )
	      p++;
	    if ( strlen( p ) < 17 )
	      break;		/* not a valid length */
	    s = smtp_date;
	    /* copy day */
	    if ( atoi( p ) < 10 && *p != '0' )
	      *s++ = ' ';
	    else if ( atoi( p ) < 10 && *p == '0' )
	    {
	      *s++ = ' ';
	      p++;
	    }
	    else
	      *s++ = *p++;
	    *s++ = *p++;
	    *s++ = ' ';
	    while ( *p == ' ' || *p == '\t' )
	      p++;
	    /* copy month */
	    *s++ = *p++;
	    *s++ = *p++;
	    *s++ = *p++;
	    while ( *p == ' ' || *p == '\t' )
	      p++;
	    /* skip year */
	    while ( isdigit( *p ) )
	      p++;
	    /* copy time */
	    *s++ = *p++;	/* space */
	    *s++ = *p++;	/* hour */
	    *s++ = *p++;
	    if ( *p == ':' )
	    {
	      *s++ = *p++;	/* : */
	      *s++ = *p++;	/* min */
	      *s++ = *p++;
	      *s = '\0';
	    }
	    else
	    {
	      *s = '\0';
	      *smtp_date = '\0';
	    }
	    break;
	  case NOHEADER:
	    break;
	}
      }
    }
    if ( *smtp_from == 0 )
      strcpy( smtp_from, smtp_From );
    if ( *smtp_date == 0 || strlen( smtp_date ) < 12 )
    {
      strcpy( smtp_date, smtp_Day );
      strcat( smtp_date, " " );
      strcat( smtp_date, smtp_Month );
      strcat( smtp_date, " " );
      strcat( smtp_date, smtp_Time );
      if ( strlen( smtp_date ) < 12 )
	*smtp_date = '\0';
    }
    if ( to_list )
      strcpy( smtp_from, smtp_to );
    if ( argc == 0 || patt )
    {
      printf( "%c%c%c%3d %-27.27s %-12.12s %5ld %.25s\r\n",
	      ( i == current ? '>' : ' ' ),
	      ( cmsg->status & DELETE ? 'D' : ' ' ),
	      ( cmsg->status & READ ? 'Y' : 'N' ),
	      i, smtp_from, smtp_date,
	      cmsg->size, smtp_subject );
      if ( ( ++mlines % ( MAXROWS - 1 ) ) == 0 )
      {
	printf( "--More--" );
	c = getrch(  );
	printf( "\r         \r" );
	if ( c == EOF || c == 'q' || c == 'Q' || c == 'a' || c == 'A' ||
	     c == 'n' || c == 'N' || c == 's' || c == 'S' )
	  break;
	mlines = 0;
      }
    }
  }
}

to_lower( s )
register char *s;
{
  while ( *s )
  {
    if ( isupper( *s ) )
      *s = tolower( *s );
    s++;
  }
}

/*  save msg on stream - if noheader set don't output the header */
/*  - if tab put "> " in front of line */
int
msgtofile( msg, tfile, noheader, tab )
int           msg;
FILE         *tfile;		/* already open for write */
int           noheader;
int           tab;
{
  char          tstring[LINELEN];
  long          size;

  if ( mfile == NULLFILE )
  {
    printf( nomail );
    return -1;
  }
  fseek( mfile, mbox[msg].start, 0 );
  size = mbox[msg].size;
  if ( ( mbox[msg].status & READ ) == 0 )
  {
    mbox[msg].status |= READ;
    change = 1;
  }

  if ( noheader )
  {
    /* skip header */
    while ( !feof( mfile ) && size > 0 )
    {
      fgets( tstring, sizeof( tstring ), mfile );
      size -= strlen( tstring );
      if ( *tstring == '\n' )
	break;
    }
  }
  while ( !feof( mfile ) && size > 0 )
  {
    fgets( tstring, sizeof( tstring ), mfile );
    size -= strlen( tstring );
    if ( tab )
      fputs( "> ", tfile );
    fputs( tstring, tfile );
    if ( ferror( tfile ) )
    {
      printf( "Error writing mail file\r\n" );
      ( void ) fclose( tfile );
      return -1;
    }
  }
  return 0;
}

/*  delmsg - delete message in current notefile */
delmsg( msg )
int           msg;
{
  mbox[msg].status |= DELETE;
  change = 1;
}

/*  reply - to a message  */
Reply( msg, org, rf, test_addr, aliasmsg )
int           msg;
int           org;
int           rf;
int           test_addr;
int           aliasmsg;
{
  char          to[LINELEN];
  char          subject[LINELEN];
  char          tstring[LINELEN];
  char          msgid[LINELEN];
  char          date[LINELEN];
  char         *f, *p, *q, *s;
  char         *toarg[1];
  long          size;
  int           msgno;
  char          from[LINELEN];

  *to = '\0';
  *subject = '\0';
  *msgid = '\0';
  *date = '\0';
  *from = '\0';
  fseek( mfile, mbox[msg].start, 0 );
  size = mbox[msg].size;
  while ( !feof( mfile ) && size > 0 )
  {
    fgets( tstring, sizeof( tstring ), mfile );
    size -= strlen( tstring );
    if ( *tstring == '\n' )	/* end of header */
      break;
    rip( tstring );
    if ( strncmp( tstring, "From ", 5 ) == 0 )
    {
      f = &tstring[5];
      while ( *f && *f != ' ' && *f != '\t' && *f != '(' )
	f++;
      *f = '\0';
      f = &tstring[5];
      sprintf( from, "%s", f );
    }
    if ( htype( tstring ) == DATE )
    {
      q = &tstring[6];
      while ( *q == ' ' || *q == '\t' )
	q++;
      if ( *q == '\0' )
	*date = '\0';
      else
	sprintf( date, "%s", q );
    }
    if ( htype( tstring ) == MSGID )
    {
      q = &tstring[12];
      while ( *q == ' ' || *q == '\t' )
	q++;
      if ( *q == '\0' )
	*msgid = '\0';
      else
	sprintf( msgid, "%s", q );
    }
    if ( ( *to == '\0' && htype( tstring ) == FROM )
	 || htype( tstring ) == REPLYTO )
    {
      s = getname( tstring );
      if ( s == NULLCHAR )
      {
	p = strchr( tstring, ':' );
	p += 2;
	s = p;
	while ( *p && *p != ' ' && *p != '\t' && *p != '(' )
	  p++;
	*p = '\0';
      }
      *to = '\0';
      strncat( to, s, sizeof( to ) );
    }
    else if ( htype( tstring ) == SUBJECT )
    {
      q = &tstring[9];
      while ( *q == ' ' || *q == '\t' )
	q++;
      if ( *q == '\0' )
	*subject = '\0';
      else
      {
	if ( strncmp( q, "Re:", 3 ) )	/* No Re: yet? */
	  if ( strncmp( q, "RE:", 3 ) )	/* No RE: yet? */
	    if ( strncmp( q, "re:", 3 ) )	/* No re: yet? */
	      sprintf( subject, "Re: %s", q );
	    else		/* there's an re:, let's not add another */
	      sprintf( subject, "%s", q );
	  else			/* there's an RE:, let's not add another */
	    sprintf( subject, "%s", q );
	else			/* there's an Re:, let's not add another */
	  sprintf( subject, "%s", q );
      }
    }
  }
  if ( *subject == '\0' )
    strcpy( subject, "Re: Your mail" );
  if ( *to == '\0' || rf )
  {
    if ( *from != '\0' )
      strcpy( to, from );
    else
    {
      *to = '\0';
      printf( "No reply address in message\r\n" );
    }
  }
  if ( aliasmsg )
    strcpy( reply_addr, to );
  else
  {
    if ( *to != '\0' )
    {
      toarg[0] = to;
      msgno = msg;
      if ( test_addr )
	print_reply_addr( toarg );
      else if ( org )
	dosmtpsend( NULLFILE, toarg, 1, subject, 1, msgno, msgid,
		    0, 1, date );
      else
	dosmtpsend( NULLFILE, toarg, 1, subject, 0, msgno, msgid,
		    0, 1, date );
    }
  }
}

print_reply_addr( toargs )
char         *toargs[];
{
  struct addr  *tolist;

  if ( ( tolist = make_tolist( 1, toargs ) ) == NULLADDR )
    printf( "Invalid address\r\n" );
  else
    printtolist( tolist, 0 );
}

/* close the temp file while copying mail back to the mailbox */
int
closenotes(  )
{
  register struct let *cmsg;
  register char *line;
  char          tstring[LINELEN];
  long          size;
  int           i;
  int           ret;
  FILE         *nfile;
  struct stat   mstat;

  if ( mfile == NULLFILE )
    return 0;
  if ( !change )
  {
    ( void ) fclose( mfile );
    return 0;
  }
  line = tstring;
  fseek( mfile, 0L, 2 );
  if ( isnewmail(  ) )
  {
    if ( ( nfile = fopen( mfilename, "r" ) ) == NULLFILE )
      perror( mfilename );
    else
    {
      /* seek to end of old msgs */
      fseek( nfile, mboxsize, 0 );
      /* seek to end of tempfile */
      fseek( mfile, 0L, 2 );
      ret = readnotes( nfile );	/* get the new mail */
      ( void ) fclose( nfile );
      if ( ret != 0 )
      {
	printf( "Error updating mail file\r\n" );
	return -1;
      }
    }
  }
  if ( ( nfile = fopen( mfilename, "w" ) ) == NULLFILE )
  {
    printf( "Unable to open %s\r\n", mfilename );
    return 0;
  }
  /* copy tmp file back to notes file */
  for ( cmsg = &mbox[1], i = 1; i <= nmsgs; i++, cmsg++ )
  {
    fseek( mfile, cmsg->start, 0 );
    size = cmsg->size;
    if ( ( cmsg->status & DELETE ) )
      continue;
    /* copy the header */
    while ( !feof( mfile ) && size > 0 )
    {
      fgets( line, LINELEN, mfile );
      size -= strlen( line );
      if ( *line == '\n' )
      {
	if ( ( cmsg->status & READ ) != 0 )
	  fprintf( nfile, "Status: R\n" );
	fputs( "\n", nfile );
	break;
      }
      fputs( line, nfile );
    }
    while ( !feof( mfile ) && size > 0 )
    {
      fgets( line, LINELEN, mfile );
      fputs( line, nfile );
      size -= strlen( line );
      if ( ferror( nfile ) )
      {
	printf( "Error writing mail file\r\n" );
	( void ) fclose( nfile );
	( void ) fclose( mfile );
	return 0;
      }
    }
  }
  nmsgs = 0;
  ( void ) fclose( nfile );
  ( void ) fclose( mfile );
  mfile = NULLFILE;

  /* remove a zero length file */
  if ( stat( mfilename, &mstat ) == 0 && mstat.st_size == 0 )
    if ( dflag || fflag )
      ( void ) unlink( mfilename );

  return 0;
}

/* get a message id from the sequence file */
long
get_msgid(  )
{
  char          sfilename[LINELEN];
  char          s[20];
  long          sequence = 0L;
  FILE         *sfile;
  long          atol(  );

  sprintf( sfilename, "%s/sequence.seq", mqueue );
  cleanup_fname( sfilename );
  sfile = fopen( sfilename, "r" );

  /* if sequence file exists, get the value, otherwise set it */
  if ( sfile != NULLFILE )
  {
    fgets( s, sizeof( s ), sfile );
    sequence = atol( s );
    /* Keep it in range of an 8 digit number to use for dos name prefix. */
    if ( sequence < 0L || sequence >= 99999999L )
      sequence = 0L;
    ( void ) fclose( sfile );
  }

  /* increment sequence number, and write to sequence file */
  if ( ( sfile = fopen( sfilename, "w" ) ) == NULLFILE )
  {
    perror( sfilename );
    return -1;
  }
  fprintf( sfile, "%ld", ++sequence );
  ( void ) fclose( sfile );
  return sequence;
}

/* Given a string of the form <user@host>, extract the part inside the
 * brackets and return a pointer to it.
 */
char         *
getname( cp )
register char *cp;
{
  char         *cp1;

  if ( ( cp = strchr( cp, '<' ) ) == NULLCHAR )
    return NULLCHAR;
  cp++;				/* cp -> first char of name */
  if ( ( cp1 = strchr( cp, '>' ) ) == NULLCHAR )
    return NULLCHAR;
  *cp1 = '\0';
  return cp;
}

/* create mail lockfile */
int
mlock( dir, id )
char         *dir;
char         *id;
{
  char          lockname[LINELEN];
  int           fd;

  /* Try to create the lock file in an atomic operation */
  sprintf( lockname, "%s/%.8s.lck", dir, id );
  cleanup_fname( lockname );
  if ( ( fd = open( lockname, O_WRONLY | O_EXCL | O_CREAT, 0600 ) ) == -1 )
    return -1;
  ( void ) close( fd );
  return 0;
}

/* remove mail lockfile */
int
rmlock( dir, id )
char         *dir;
char         *id;
{
  char          lockname[LINELEN];

  sprintf( lockname, "%s/%.8s.lck", dir, id );
  cleanup_fname( lockname );
  ( void ) unlink( lockname );
}

/* parse a line into argv array. Return argc */
int
parse( line, argv, maxargs )
register char *line;
char         *argv[];
int           maxargs;
{
  int           argc;
  int           pflag;
  register char *cp;

  for ( argc = 0; argc < maxargs; argc++ )
    argv[argc] = NULLCHAR;

  for ( argc = 0; argc < maxargs; )
  {
    pflag = 0;
    /* Skip leading white space */
    while ( *line == ' ' || *line == '\t' )
      line++;
    if ( *line == '\0' )
      break;
    /* Check for quoted token */
    if ( *line == '"' )
    {
      line++;			/* Suppress quote */
      pflag = 1;
    }
    argv[argc++] = line;	/* Beginning of token */
    /* Find terminating delimiter */
    if ( pflag )
    {
      /* Find quote, it must be present */
      if ( ( line = strchr( line, '"' ) ) == NULLCHAR )
      {
	return -1;
      }
      *line++ = '\0';
    }
    else
    {
      /*
       * Find space or tab. If not present, then we've already found the last
       * token.
       */
      for ( cp = line; *cp; cp++ )
      {
	if ( *cp == ' ' || *cp == '\t' )
	  break;
      }
      if ( *cp == '\0' )
	break;
      *cp++ = '\0';
      line = cp;
    }
  }
  return argc;
}

lockit(  )
{
  char          line[LINELEN];
  char         *p;

  while ( mlock( maildir, notename ) )
  {
    printf( "Mail file \"%s\" is busy, Abort or Retry (a/R) ? ", notename );
    gets( line );
    p = line;
    while ( *p == ' ' || *p == '\t' )
      p++;
    if ( *p == 'A' || *p == 'a' )
    {
      if ( mfile != NULLFILE )
	( void ) fclose( mfile );
      mfile = NULLFILE;
      return 1;
    }
  }
  return 0;
}

/* print the next message or the current on of new */
printnext(  )
{
  if ( mfile == NULLFILE )
    return;
  if ( ( mbox[current].status & READ ) != 0 )
  {
    if ( current == 1 && anyread == 0 )
      ;
    else if ( current < nmsgs )
    {
      current++;
    }
    else
    {
      printf( "Last message\r\n" );
      return;
    }
  }
  displaymsg( current );
}

/*  display message on the crt given msg number */
displaymsg( msg )
int           msg;
{
  register int  c;
  register int  col;
  char          buf[MAXCOL + 2];/* line buffer */
  int           lines;
  int           cnt;
  long          tsize, size;
  char          cmd[LINELEN];
  FILE         *ftmpmsg;
  char          msgfile[LINELEN];
  char         *tmf = "bmXXXXXX";

  anyread = 1;
  if ( pager != NULLCHAR && *pager != '\0' )
  {
    sprintf( msgfile, "%s\\%s", tmpdir, tmf );
    mktemp( msgfile );
    if ( ( ftmpmsg = fopen( msgfile, "w+" ) ) == NULLFILE )
    {
      perror( msgfile );
      return;
    }
    fprintf( ftmpmsg, "Message #%d %s\n",
	     msg, mbox[msg].status & DELETE ? "[Deleted]" : "" );
    if ( ( mbox[msg].status & READ ) == 0 )
    {
      mbox[msg].status |= READ;
      change = 1;
    }
    msgtofile( msg, ftmpmsg, 0, 0 );
    ( void ) fclose( ftmpmsg );
    sprintf( cmd, "%s %s", pager, msgfile );
    system( cmd );
    ( void ) unlink( msgfile );
    return;
  }
  else
  {

/*	screen_clear(); */
    fseek( mfile, mbox[msg].start, 0 );
    size = mbox[msg].size;
    tsize = size;

    printf( "Message #%d %s\r\n",
	    msg, mbox[msg].status & DELETE ? "[Deleted]" : "" );
    if ( ( mbox[msg].status & READ ) == 0 )
    {
      mbox[msg].status |= READ;
      change = 1;
    }
    lines = 1;
    col = 0;
    while ( !feof( mfile ) && size > 0 )
    {
      for ( col = 0; col < MAXCOL - 2; )
      {
	c = getc( mfile );
	size--;
	if ( feof( mfile ) || size == 0 )	/* end this line */
	  break;
	if ( c == '\t' )
	{
	  cnt = col + 8 - ( col & 7 );
	  if ( cnt >= MAXCOL )	/* end this line */
	    break;
	  while ( col < cnt )
	    buf[col++] = ' ';
	}
	else if ( c == '\n' )
	  break;
	else
	  buf[col++] = c;
      }
#ifdef __TURBOC__
      buf[col++] = '\r';
      buf[col++] = '\n';
      buf[col] = '\0';
      cputs( buf );
#else
      buf[col] = '\0';
      puts( buf );
#endif
      col = 0;
      if ( ( ++lines == ( MAXROWS - 1 ) ) )
      {
	printf( "--More--(%d%%)", ( tsize - size ) * 100 / tsize );
	c = getrch(  );
	printf( "\r               \r" );
	if ( c == EOF || c == 'q' || c == 'Q' || c == 'a' || c == 'A' || c == 'n' || c == 'N' || c == 's' || c == 'S' )
	  break;
/*			screen_clear(); */
	lines = 0;
      }
    }
  }
}

/* list jobs waiting to be sent in the mqueue */
listqueue(  )
{
  register struct tm *tminfo;
  struct tm    *localtime(  );
  char          tstring[LINELEN];
  char          workfile[LINELEN];
  char          line[20];
  char          host[LINELEN];
  char          to[LINELEN];
  char          from[LINELEN];
  char         *p;
  char          status;
  struct stat   stbuf;
  FILE         *fp;
  time_t        t;

  time( &t );
  printf( "S  Job_ID    Size Date  Time  Host                 From\r\n" );
  sprintf( workfile, "%s/%s", mqueue, WORK );
  cleanup_fname( workfile );
  filedir( workfile, 0, line );
  while ( line[0] != '\0' )
  {
    sprintf( tstring, "%s/%s", mqueue, line );
    cleanup_fname( tstring );
    if ( ( fp = fopen( tstring, "r" ) ) != NULLFILE )
    {
      if ( ( p = strrchr( line, '.' ) ) != NULLCHAR )
	*p = '\0';
      sprintf( tstring, "%s/%s.lck", mqueue, line );
      cleanup_fname( tstring );
      if ( access( tstring, 0 ) )
	status = ' ';
      else
	status = 'L';
      sprintf( tstring, "%s/%s.txt", mqueue, line );
      cleanup_fname( tstring );
      stat( tstring, &stbuf );
      tminfo = localtime( &stbuf.st_ctime );
      *host = '\0';
      fgets( host, sizeof( host ), fp );
      rip( host );
      *from = '\0';
      fgets( from, sizeof( from ), fp );
      rip( from );
      cleanup_line( host );
      cleanup_line( from );
      printf( "%c %7s %7ld %02d/%02d %02d:%02d %-20.20s %s\r\n",
	      status, line, stbuf.st_size,
	      tminfo->tm_mon + 1,
	      tminfo->tm_mday,
	      tminfo->tm_hour,
	      tminfo->tm_min,
	      host, from );
      printf( "To:" );
      *to = '\0';
      while ( fgets( to, sizeof( to ), fp ) != NULLCHAR )
      {
	rip( to );
	cleanup_line( to );
	printf( " %s", to );
      }
      printf( "\r\n" );
      ( void ) fclose( fp );
    }
    else
      perror( tstring );
    filedir( workfile, 1, line );
  }
}

/* kill a job in the mqueue */
killjob( j )
char         *j;
{
  char          s[LINELEN];
  char          tbuf[LINELEN];
  char         *p;
  char         *q;
  char          tstring[XXLINELEN];

  sprintf( s, "%s/%s.lck", mqueue, j );
  cleanup_fname( s );
  p = strrchr( s, '.' );
  if ( !access( s, 0 ) )
  {
    sprintf( tstring, "Warning: Job_ID %s is locked by SMTP. Remove (y/N) ? ", j );
    fputs( tstring, stdout );
    gets( tbuf );
    q = tbuf;
    while ( *q == ' ' || *q == '\t' )
      q++;
    if ( *q == 'y' || *q == 'Y' )
      ( void ) unlink( s );
    else
      return;
  }
  strcpy( p, ".wrk" );
  if ( unlink( s ) )
  {
    sprintf( tstring, "Job_ID %s not found\r\n", j );
    fputs( tstring, stdout );
  }
  strcpy( p, ".txt" );
  ( void ) unlink( s );
}

/* check the current mailbox to see if new mail has arrived.
* checks to see if the file has increased in size.
* returns true if new mail has arrived.
*/
isnewmail(  )
{
  struct stat   mstat;

  if ( !stat( mfilename, &mstat ) )
    if ( mstat.st_size > mboxsize )
      return 1;
  return 0;
}

cleanup_fname( name )
register char *name;
{
  while ( *name )
  {
    if ( !isprint( *name ) )
      *name = '@';

    if ( *name == '/' )
      *name = '\\';

    if ( isupper( *name ) )
      *name = tolower( *name );

    name++;
  }
}

cleanup_line( line )
register char *line;
{
  while ( *line )
  {
    if ( *line == '\t' )
      *line = ' ';
    line++;
  }
}

cleanup_notename( name )
register char *name;
{
  while ( *name )
  {

    if ( !isalnum( *name ) && ( *name != '_' ) && ( *name != '^' ) && ( *name != '$' ) && ( *name != '~' ) && ( *name != '!' ) && ( *name != '#' ) && ( *name != '%' ) && ( *name != '&' ) && ( *name != '-' ) && ( *name != '{' ) && ( *name != '}' ) && ( *name != '(' ) && ( *name != ')' ) && ( *name != '\'' ) && ( *name != '`' ) )
      *name = '@';
    if ( isupper( *name ) )
      *name = tolower( *name );
    if ( *name == '\\' || *name == '/' )
      *name = '@';
    name++;
  }
}

/* list or change mbox */
mboxnames( argc, argv, sv )
int           argc;
char         *argv[];
int           sv;
{
  register char *cp;
  int           ret;
  char          line[LINELEN];
  char          buf[LINELEN];
  char         *mfile_name;
  struct stat   mstat;
  char          mbuf[LINELEN];

  if ( argc != 0 )
  {
    if ( !fflag && lockit(  ) )
      return;
    ret = closenotes(  );
    if ( !fflag )
      rmlock( maildir, notename );
    if ( ret != 0 )
    {
      if ( sv )
	savetpfile(  );
      exit( 1 );
    }
    if ( strcmp( argv[0], "!" ) == 0 )
    {
      fflag = 0;
      lflag = 0;
      strncpy( notename, username, 8 );
      notename[8] = '\0';
      cleanup_notename( notename );
      sprintf( notefile, "%s\\%s.txt", maildir, notename );
      cleanup_fname( notefile );
      mfilename = notefile;
    }
    else if ( strcmp( argv[0], ">" ) == 0 )
    {
      fflag = 1;
      lflag = 0;
      strncpy( notename, username, 8 );
      notename[8] = '\0';
      cleanup_notename( notename );
      sprintf( mfilename, "%s", savebox );
      cleanup_fname( mfilename );
    }
    else if ( strcmp( argv[0], "<" ) == 0 )
    {
      fflag = 1;
      lflag = 1;
      strncpy( notename, username, 8 );
      notename[8] = '\0';
      cleanup_notename( notename );
      sprintf( mfilename, "%s", record );
      cleanup_fname( mfilename );
    }
    else if ( strpbrk( argv[0], "/\\" ) != NULLCHAR )
    {
      fflag = 1;
      lflag = 0;
      strncpy( notename, username, 8 );
      notename[8] = '\0';
      cleanup_notename( notename );
      mfile_name = argv[0];
      sprintf( mfilename, "%s", mfile_name );
      cleanup_fname( mfilename );
    }
    else
    {
      fflag = 0;
      lflag = 0;
      mfilename = notefile;
      strncpy( notename, argv[0], 8 );
      notename[8] = '\0';
      cleanup_notename( notename );

      sprintf( notefile, "%s\\%s.txt", maildir, notename );
      cleanup_fname( notefile );
    }
    if ( !fflag && lockit(  ) )
    {
      if ( sv )
	savetpfile(  );
      exit( 1 );
    }
    ret = initnotes(  );
    if ( !fflag )
      rmlock( maildir, notename );
    if ( ret != 0 )
    {
      if ( sv )
	savetpfile(  );
      exit( 1 );
    }
    if ( lflag )
      listnotes( 1, 0, NULLCHAR, 0, 2 );
    else
      listnotes( 0, 0, NULLCHAR, 0, 2 );

  }
  else
  {				/* he wants to see what notefiles there are */
    sprintf( buf, "%s\\*.txt", maildir );
    cleanup_fname( buf );
    filedir( buf, 0, line );
    while ( line[0] != '\0' )
    {
      sprintf( mbuf, "%s/%s", maildir, line );
      cleanup_fname( mbuf );
      if ( !stat( mbuf, &mstat ) )
      {
	mfsize = mstat.st_size;
	cp = strchr( line, '.' );
	*cp = '\0';
	printf( "Notefile -> %-8.8s %7ld bytes\r\n", line, mfsize );
      }
      filedir( buf, 1, line );
    }
  }
}

alias_msg( msg_num )
int           msg_num;
{
  char          line[LINELEN];
  char         *p;
  char          abuf[LINELEN];
  char         *q;
  int           ret = 1;
  FILE         *alfile;

  Reply( msg_num, 0, 1, 0, 1 );
  if ( *reply_addr != '\0' )
  {
    printf( "Name: " );
    gets( line );
    p = line;
    while ( *p == ' ' || *p == '\t' )
      p++;
    if ( *p != '\0' )
      ret = chkname( p );
    else
      printf( "No name specified\r\n" );
  }
  if ( *reply_addr != '\0' && ret == 0 )
  {
    if ( ( in_alias( 1, NULLCHAR, p ) ) == 0 )
    {
      printf( "%s  %s\r\n", p, reply_addr );
      printf( "Accept new alias (Y/n) ? " );
      gets( abuf );
      q = abuf;
      while ( *q == ' ' || *q == '\t' )
	q++;
      if ( *q != 'n' && *q != 'N' )
      {
	if ( ( alfile = fopen( aliases, "a" ) ) == NULLFILE )
	  perror( aliases );
	else
	{
	  fprintf( alfile, "%s  %s\n", p, reply_addr );
	  ( void ) fclose( alfile );
	  printf( "%s appended\r\n", aliases );
	}
      }
    }
    else
      printf( "Already an alias for %s\r\n", p );
  }
}

chkname( s )
register char *s;
{
  if ( *s == ',' || *s == '#' || !isprint( *s ) )
  {
    printf( badchar );
    return 1;
  }
  else
  {
    for ( ; *s; s++ )
    {
      if ( *s == ' ' || *s == '\t' )
      {
	*s = '\0';
	break;
      }
      if ( *s == ',' || !isprint( *s ) )
      {
	printf( badchar );
	return 1;
      }
    }
  }
  return 0;
}
