/* Is it time for something to happen? */

/* Written by Bernie Roehl, May 1990 */

/* First line of file is elapsed time since GMT origin, in seconds;
   second line is human-readable date/time (from ctime()) */

#include <stdio.h>
#include <stdlib.h>
#include <time.h>

char *progname = "ISITTIME";

void main(int argc, char *argv[])
	{
	long inter;
	FILE *tmpf;
	time_t then, now;
	if (argc < 3 || argc > 4) {
		printf("%s: correct usage is 'ISITTIME file interval [units]'\n", progname);
		exit(2);
		}
	inter = atol(argv[2]);  /* interval (in seconds if no units given) */
	if (argc > 3)  /* units were specified... scale interval */
		switch(tolower(*argv[3])) {
			case 'd': inter *= 24;
			case 'h': inter *= 60;
			case 'm': inter *= 60;
			case 's': break;
			default: printf("%s: unit '%s' bad; must be one of days, hours, minutes or seconds\n", progname, argv[3]);
					exit(3);
					break;
			}
	time(&now);
	if ((tmpf = fopen(argv[1], "r")) != NULL) {
		fscanf(tmpf, "%ld", &then);
		fclose(tmpf);
		}
	else
		then = 0L;  /* the beginning of time :-) */
	if ((then + inter) < now) {
		if ((tmpf = fopen(argv[1], "w")) == NULL)
			printf("%s: can't update '%s'\n", progname, argv[1]);
		else {
			fprintf(tmpf, "%ld\n%s", now, ctime(&now));
			fclose(tmpf);
			}
		exit(1);
		}
	exit(0);
	}
