/*
 *========================================================================== 
 * Copyright 1991, 1992 Avinash Chopde, All Rights Reserved.
 */

static char S_RCSID[] = "$Header: f:/itrans/src/rcs/itrans.c 1.20 95/02/22 19:15:11 avinash Exp $";

#include "itrans.h"
#include "ifm.h"
#include "version.h"

static char S_copyright[] = "\
%%\n\
%% ---------------------------------------------------------\n\
%% ITRANS %s\n\
%% Copyright 1991--1994 Avinash Chopde, All Rights Reserved.\n\
%% ---------------------------------------------------------\n\
%%\n\
";

/* =================================================================== */
#ifdef TCC
/* Under Turbo-C++, declare the stacklen to be larger */
extern unsigned _stklen = 7000U; /* was 7000 */
#endif
/* =================================================================== */

int G_verbose;

int G_currfontsize;
int G_psout; /* if TRUE produce PostScript output, else TeX output */

static allfonts_t	S_allfonts;
static marker_t		S_markers[MARKERS_MAX];

font_t*			G_current_font = NULL; /*GLOBAL*/
			/* when yyparse() is active, 
			 * this always holds: G_current_font  != NULL
			 */

static void S_usage(FILE*);

#define CUS_MAX	100
static comp_unit_t	S_cus[CUS_MAX];

	/* input words are converted to TeX or PostScript commands here */
static char S_comm[CONVWORD_LEN];
    /* must be large enough to store one word -
     * which in TeX can get very large..what with raise boxes, \char defs etc
     * made it static since it is currently 8K bytes, and on the PC stack
     * space is at a premium...
     */

/* =================================================================== */
process_letter(letter_t in)
{
    int i;

#ifdef DEBUG
    int c1, c2, v;
#endif

    /*
    fprintf(stderr, ":offset is %d in.v %d, in.c1 %d, in.c2 %d\n", OFFSET_TOK,
    			in.v, in.c1, in.c2);
    */

    if (in.v < OFFSET_TOK && in.v != HALF_FORM && in.v != IMPLICIT_FORM) {
        fprintf(stderr,"illegal vowel val (c[0] is %d) - will use 'a' form\n", in.cons[0]);
    }


#ifdef DEBUG
    /* this switch is for printing debugging stmts only... */
    switch(in.type) {
    case VOWEL_TYPE:
	v = _I_(in.v);
	fprintf(stderr, "process_letter: vowel %d\n", v);

	break;
    case SPECIAL_TYPE:
	c1 = _I_(in.cons[0]);

	fprintf(stderr, "process_letter: special %d\n", c1);
	

	break;
    case CONSONANT_SINGLE_TYPE:
	c1 = _I_(in.cons[0]);
	v = _I_(in.v);
	fprintf(stderr, "process_letter: cons single %d vowel %d\n", c1, v);
	

	break;

    case CONSONANT_DOUBLE_TYPE:
	c1 = _I_(in.cons[0]);
	c2 = _I_(in.cons[1]);
	v = _I_(in.v);

	fprintf(stderr,"process_letter: cons double %d %d vowel %d\n",c1,c2,v);

	break;

    case CONSONANT_MANY_TYPE:
	c1 = _I_(in.cons[0]);
	c2 = _I_(in.cons[1]);
	v = _I_(in.v);

	fprintf(stderr,"process_letter: cons many %d %d vowel %d\n", c1, c2, v);

	break;
    }
#endif /*DEBUG*/

    i = make_letter(G_current_font, in, S_cus, CUS_MAX);

	/* warning: there are no checks in make_letter, so CUS_MAX
         * may be execeeded!
         */
    if (i > CUS_MAX) {
        fprintf(stderr, "Program error: possible stack corruption; CUS_MAX (%d) is too low - increase it to %d atleast\n", CUS_MAX, i);
        fprintf(stderr, "CUS_MAX is defined in itrans.c\n");
	exit(10);
    }

    if (i > 0) {

	if (G_psout) cus_to_ps(S_cus, G_current_font->psfm, S_comm);
	else { 
	    cus_to_tex(S_cus, G_current_font->psfm, S_comm);
	}

	fputs(S_comm, stdout);

	if (G_psout) printf("\n");
    }

    return TRUE;
}

/* =================================================================== */
extern	yyparse();

int main(int argc, char *argv[])
{
    extern int yydebug;
    int ch;
    int psout;
    extern char * optarg;

    FILE* fp;
    int i;

#ifdef sgi
    mallopt(M_DEBUG, TRUE);
#endif

    for (ch = 0; ch < FONTS_MAX; ch++) S_allfonts[ch] = NULL;

    G_currfontsize = 30;
    G_verbose = 0;
    psout = FALSE; /* by default, produce TeX output */

	/* --- Collect Args */
    while ((ch = getopt(argc, argv, "hHPf:o:i:v")) != EOF) {
	switch (ch) {
	case 'h':
	case 'H':
	   S_usage(stderr);
	   exit(0);
	   break;
	case 'v':
	   G_verbose++;
	   break;
	case 'P':
	   psout = TRUE;
	   break;
	case 'f':
	   sscanf(optarg, "%d", &G_currfontsize);
	   break;
	case 'i':
	   if (!freopen(optarg, "r", stdin)) {
	       fprintf(stderr,"Error: Could not open %s for reading\n", optarg);
	       exit(20);
	   }
	   break;
	case 'o':
	   if (!freopen(optarg, "w", stdout)) {
	       fprintf(stderr,"Error: Could not open %s for writing\n", optarg);
	       exit(30);
	   }
	   break;
	default:
	   S_usage(stderr);
	   break;
	} /* switch */
    }
    
    G_psout = psout;

    for (ch = 0; ch < FONTS_MAX; ch++) {
	S_allfonts[ch] = NULL;
    }
    init_markers(S_markers, MARKERS_MAX);

    G_current_font = S_markers[0].curr_font; /* default font */

    /* dump_font(S_allfonts[0], stderr); */

    yydebug = 0;
    if (psout) {
	printf("%%!PS\n%% *** Need files itrans.pro and <lang>.ps before this line..\n");
	fprintf(stderr, "** itrans, version %s (PostScript Interface)\n", VERSION);
    } else {
	fprintf(stderr, "** itrans, version %s (TeX Interface)\n", VERSION);
    }

    printf(S_copyright, VERSION);

    if (psout) {
	outps_start(G_currfontsize);

	/*
	% BASEFONTNAME should be defined by the user program..
	% so that it refers to the correct font name (bengali font, etc)
	% (itrans.c::main() defines it to be a devenagari font...)
	% just to be upwards compatible with old .ips files...
	*/
	printf("/BASEFONTNAME /DevnacPlain def %% define a default devanagari font\n");

    } else {
	outtex_start();
    }

    yyparse();

    if (psout) {
	outps_end();
	printf("%%%% ITRANS Font Files List\n");
	for (ch = 0; ch < MARKERS_MAX; ch ++) {
	    if (S_markers[ch].curr_font && S_markers[ch].curr_font->pname)
	        printf("%%%% Font File Needed: %s\n", S_markers[ch].curr_font->pname);
	}
	printf("%%%% End of ITRANS Font Files List\n");
    } else {
	outtex_end();
    }

    return 0;
}
/* =================================================================== */
process_newline()
{
    if (G_psout) printf("%%\nnewline\n");
    else printf("\n");
    return TRUE;
}
/* =================================================================== */
process_space()
{
    if (G_psout) printf("( ) show ");
    else printf(" ");
    return TRUE;
}
/* =================================================================== */
process_otherchar(int c)
{
    int i;

    i = make_other(G_current_font, c, S_cus, CUS_MAX);

    if (i > 0) {

        if (G_psout) cus_to_ps(S_cus, G_current_font->psfm, S_comm);
        else cus_to_tex(S_cus, G_current_font->psfm, S_comm);

	fputs(S_comm, stdout);

    } else {
	/* this character is not defined in the IFM file,
	 * assume it is something else that the user needs to output.
	 */
	if (G_psout) {
	    /* in case of PostScript, assume that the user wants the
	     * character to be output using a show command.
	     * Otherwise, such extra characters may very well lead to
	     * errors in the output file.
	     * If the user does desire the characters to be output as they
	     * are, without a (c) show command, that is possible by exiting
	     * the indian language text portion -- use the endmarker to end it.
	     * (that requires a show command, of course).
	     * In case of the { and } characters, do not do anything -
	     * since they are also used to break the lexical scan:
	     * for example the only way to represent the ka-shha ligature
	     * is {k}shha since ksh itself is a consonant
	     */
	    if (c == '(' || c == ')') {
		printf("(\\%03o) show ", c);
	    } else {
		if (c != '{' && c != '}') {
		    printf("(%c) show ", c);
		}
	    }
	    
	} else { /* TeX */

	    putchar(c);

	}
    }

    /* warning checks */
    if (!ispunct(c) && !isdigit(c) && !isspace(c))  {
        fprintf(stderr, "Note (around line %d): character <%c> (dec %d) unrecognized by lexer, echoing to output\n", G_lineno, c, c);
    }
    return TRUE;
}
/* =================================================================== */
process_init_word(char* word)
{
    char wd[LINELEN];
    int i;

	/* word may contain newlines - suppress them, since extra
	 * newlines may create havoc in TeX.
	 */
    strncpy(wd, word, LINELEN);
    wd[LINELEN-1] = '\0';
    i = strlen(wd);
    for (; i >=0; i --)
	if (wd[i] == '\n') wd[i] = ' ';

    printf("%% previous word:%s:\n", wd);
    return TRUE;
}
/* =================================================================== */
process_end_word(char* word)
{
    /*
    Can't print a comment here, since in TeX everything following 
    also becomes a comment, even on the next line.
    And, since the space following the word may not have been
    seen yet, it gets eaten up if a comment is printed here,
    therefore, the word is printed in the function process_init_word()
    instead..clumsy..

    printf("%%\n%% Just saw word <%s>\n", word);
    */
    word[0] = word[0]; /* to prevent unused warning ... */
    return TRUE;
}
/* =================================================================== */
process_command(char in[])
{
    char com[1024], *cptr;
    float amt;

    strcpy(com, in);

    if (!G_psout) printf("\\%s", in); /* TeX, just copy commands */
    else { /* is postscript out */

        if (!strncmp(com, "kern", 4)) { /* check if kern command */
	    cptr = &com[4];
	    if (sscanf(cptr, "%f", &amt) != 1) {
	        fprintf(stderr, "illegal kern amount <%f>\n", amt);
	        return FALSE;
	    }
	    printf("%s %.3f mul 0.0 rmoveto %% output of a kern command\n",
			    EMSIZE, -amt);
        } else if (!strncmp(com, "-", 1)) { /* check if \- command */
	    printf(" \\- ");
        } else {
            fprintf(stderr, "PostScript out: command not implemented yet %s\n", in);
        }
    } /* else: is postscript out*/

    return TRUE;

}
/* =================================================================== */
void process_istart(int marker_tok)
{

    int i = marker_tok - IMARKER_TOK;

    if (!G_psout) printf("{"); /* provide an enclosing scope for indian
    				* language text stuff for TeX output
				*/

    /* set the correct IFM file, and echo out font settings, if any.. */
    G_current_font = S_markers[i].curr_font;
    if (!G_current_font) {
	fprintf(stderr, "Warning: No IFM file specified for language %s (line %d)\n", 
			S_markers[i].name, G_lineno);
	fprintf(stderr, "        (this may lead to problems in future ITRANS releases...)\n");
	fprintf(stderr, "        (see the example files in the doc directory for correct usage)\n");
	fprintf(stderr, "        (statements: \\<lang>ifm=... and \\<lang>font=...)\n");

	i = 0;
	G_current_font = S_markers[i].curr_font;
    	if (!G_current_font) {
	    fprintf(stderr, "Error: Could not locate the default IFM file!\n");
	    exit(40);
    	}
    }

    /* Check for output validity */
    if (G_psout && G_current_font->prop == TEX_FONT) {
	fprintf(stderr, "Font %s is for TeX output only - cannot do PostScript out\n", G_current_font->fname);

	/***** EXITS HERE *****/
	exit(50);
    }

    /* Check for output validity */
    if (!G_psout && G_current_font->prop == PS_FONT) {
	fprintf(stderr, "Font %s is for PostScript output only - cannot do TeX out\n", G_current_font->fname);

	/***** EXITS HERE *****/
	exit(60);
    }


    /* echo out font settings */
    if (S_markers[i].curr_fontcmd) printf("%s", S_markers[i].curr_fontcmd);
}
/* =================================================================== */
void process_iend()
{
    if (!G_psout) printf("}"); /* close the enclosing scope for indian
    				* language text stuff for TeX output
				* (see process_istart())
				*/

    printf("%% End of Indian Language\n");
}
/* =================================================================== */
int setifm(int marker_tok, char* ifmtok)
{
    int i = marker_tok - IMARKER_TOK;
#ifdef DEBUG
    fprintf(stderr, "loading in language %d at line %d %s\n", marker_tok,
    		G_lineno, ifmtok);
#endif /*DEBUG*/

    if (!find_load_ifm(&S_markers[i], S_allfonts, ifmtok)) {
	 fprintf(stderr, "Warning: could not load in IFM file (line %d, %s) (hope you don't need it..ERROR otherwise..)\n", G_lineno, ifmtok);
	 return FALSE;
    }

    return TRUE;
}
/* =================================================================== */
int setfontcmd(int marker_tok, char ifmtok[])
{
    int i = marker_tok - IMARKER_TOK;
    char* eqp;

#ifdef DEBUG
    fprintf(stderr, "setting font for language %d at line %d %s\n", marker_tok,
    		G_lineno, ifmtok);
#endif /*DEBUG*/

    if (!S_markers[i].curr_font) {
	fprintf(stderr, "Error: line %d - there must be a setifm comand before setfont command\n",
		G_lineno);
	fprintf(stderr, "     i.e., \\indianifm=..... and then \\indianfont=...\n");

	/***** EXITS HERE *****/
	exit(70);
    }

    if (S_markers[i].curr_fontcmd) free(S_markers[i].curr_fontcmd);
    S_markers[i].curr_fontcmd = NULL;

    eqp = strchr(ifmtok, '=');
    if (eqp == NULL) {
        fprintf(stderr, "Illegal Indian Font name line: %s (line %d) \n",
			ifmtok, G_lineno);
        return FALSE;
    }

    eqp ++;

    if (strlen(eqp) > 0) {
        S_markers[i].curr_fontcmd = (char*) malloc(sizeof(char)*(strlen(eqp)+1));

		/* eat up all white space around it..*/
        sprintf(S_markers[i].curr_fontcmd, "%s", eqp);

	if (G_verbose > 1)
          fprintf(stderr,"Set font command to: (%s)\n",S_markers[i].curr_fontcmd);

#if 0
old code.
now #indianfont arg is not a TeX font, but any TeX command.
so, cannot use hyphenchar here.
users has to provide \hyphenchar themselves.

	/* in TeX mode, inhibit hyphenation if no hyphenchar defined in IFM file */
	if (!G_psout) {
	    if (S_markers[i].curr_font && S_markers[i].curr_font->hyphenchar >= 0) {
		/* hyphenation enabled */
                printf("\\hyphenchar%s=%d %% itrans:hyphenate words using this char\n",
			 S_markers[i].curr_fontcmd, S_markers[i].curr_font->hyphenchar);
	    } else {
		/* hyphenation disabled */
                printf("\\hyphenchar%s=-1 %% itrans:do not hyphenate words using this font\n",
			 S_markers[i].curr_fontcmd);
	    }

	}
#endif

    }

    return TRUE;
}
/* =================================================================== */
static void S_usage(FILE *fp)
{
    fprintf(fp,"Usage: itrans [-v] [-P [-f <fontsize>]] [-i <infile>] [-o <outfile>] [-h|H]\n");
    fprintf(fp,"            -P for PostScript output, TeX output by default\n");
    fprintf(fp,"            -i input file name, stdin by default\n");
    fprintf(fp,"            -o output file name, stdout by default\n");
    fprintf(fp,"            -v verbose mode\n");
    fprintf(fp,"            -h|H for this message\n");
}
/* =================================================================== */
/* hook for the lexer */
int hook_get_lang_tok()
{
    if (G_current_font) {
	return G_current_font->lang_tok;
    }
    
    return HINDI_TOK; /* default, some harmless value... */
}

/* hook for the parser */
int hook_get_default_vowel()
{
    if (G_current_font) {
	return G_current_font->default_vowel;
    }
    
    return HALF_TOK; /* default, if a consonant is missing a vowel,
		      * print it in half form
		      * this is normally defined in the IFM file
		      * using keyword DEFAULTVOWEL
		      * is either A_TOK (hindi, marathi) or HALF_TOK (others)
		      */
}

/* =================================================================== */
int print_disc_hyphen()
{
    if (!G_psout && G_current_font->hyphenchar >= 0) {
        printf("\\-"); /* discretionary hyphen - TeX mode */
        return TRUE;
    }
    return FALSE;
}
/* =================================================================== */
