program     VDEMO;                                                      (*
*                                                                        *
*                    Sample program for the demonstration                *
*                      of OptiVec for Borland Pascal                     *
*                                                                        *
*                                                                        *
*   Copyright 1996-2002 by OptiCode - Dr. Martin Sander Software Dev.    *
*                                                                        *
*   before compiling, please check and correct the BGI path statement    *
*   below as necessary!                                                  *
**************************************************************************)

{$E-} {$N+} {$D+}
uses VecLib, VFstd, VFmath, VCFstd, VCFmath, Vgraph, DOS, Graph;

const BGIDIR = '\BP\BGI\';
type  TimeRec = record  Hour, Min, Sec, Sec100 : Word; end;
var   t1, t2: TimeRec;

procedure starttime;
begin
   gettime( t1.Hour, t1.Min, t1.Sec, t1.Sec100 );
end;

function stoptime: Double;
var  tBegin, tEnd:double;
begin
   gettime( t2.Hour, t2.Min, t2.Sec, t2.Sec100 );
   tBegin := (t1.Hour*60 + t1.Min) * 60 + t1.Sec + t1.Sec100 * 0.01;
   tEnd   := (t2.Hour*60 + t2.Min) * 60 + t2.Sec + t2.Sec100 * 0.01;
   StopTime :=  tEnd - tBegin;
end;

 {the following function is needed to avoid the CRT unit,
   as it does not work with Win95B }
function ReadKeyNew: Char;
var xchar: Char;
begin
    asm mov ax, $0700; int $21; xor ah, ah; mov word ptr xchar, ax end;
    ReadKeyNew := xchar;
end;

const  xsize   = 4096;
       specsiz =  512;

var
   i, j                             :  Word;
   a, b, c,
   deltat, fOscill, fNyquist        :  Single;
   extime                           :  Double;
   za, zb                           :  fComplex;
   X, Y, Win, Time, Freq,
   XDum, YDum                       :  fVector;
   CX, CY                           :  cfVector;
   Spc                              :  array[0..specsiz] of Single;
   (*  this last declaration is preferred over the declaration as fVector,
       because one element will be referenced as Spc[specsiz], which
       is not possible with dynamically allocated vectors.        *)

begin
   writeln; writeln;
   writeln( 'This is a short demonstration of VectorLib for Pascal' );
   writeln( 'in DOS real mode.' );
   writeln( 'Hit any key to continue  or abort with [ESC] !' );
   if ReadKeyNew = #27 then Halt;

   X    := VF_vector( xsize );
   Y    := VF_vector( xsize );
   Win  := VF_vector( 2*specsiz );
   Time := VF_vector( xsize );
   Freq := VF_vector( specsiz+1 );

   deltat   := 0.001;  (* sampling interval 1 millisecond *)
   fNyquist := 0.5 / deltat;   (* Nyquist frequency = 500 Hz *)
   fOscill  := 100;   (* say we are sampling a 100 Hz oscillation *)
   VF_ramp( Time, xsize, 0, deltat );
   VF_ramp( Freq, specsiz+1, 0, fNyquist / specsiz );
   VFx_sin( X, Time, xsize, 2*PI*fOscill, 0, 1 );  (* sin( omega*t) *)
   VF_cmpC( X, X, xsize, 0.3 ); (* get an asymmetric square wave;
                  Play around with the last parameter of this call!  *)
   V_initgraph( BGIDIR );  (* this should be your correct path, see above! *)

   VF_Welch( Win, 2*specsiz );
               (* You might as well take VF_Parzen or VF_Hanning  *)
   Spc[specsiz] := VF_spectrum( @Spc, specsiz, X, xsize, Win );
               (* notice that the static array Spc has to be passed
                  using the @ operator!  *)

   VF_xyautoplot( Time, X, 101, PS_SOLID, GREEN );
     SetViewport( 1, 1, getmaxx div 5, 200, FALSE ); clearviewport;
     SetTextJustify( LeftText, TopText );
     SetTextStyle( TriplexFont, HorizDir, 2 );
     SetColor( WHITE );
     OutTextXY( 5,  20, 'Portion' );
     OutTextXY( 5,  40, 'of an' );
     OutTextXY( 5,  60, 'asymmetric' );
     OutTextXY( 5,  80, 'square' );
     OutTextXY( 5, 100, 'wave' );
     OutTextXY( 5, 100, 'f = 100 Hz' );
     if ReadKeyNew = #27 then Halt;
   VF_xyautoplot( Freq, @Spc, specsiz+1, PS_SOLID or SY_CROSS, GREEN );
     SetViewport( 1, 1, getmaxx div 5, 200, FALSE ); clearviewport;
     SetTextJustify( LeftText, TopText );
     SetTextStyle( TriplexFont, HorizDir, 2 );
     SetColor( WHITE );
     OutTextXY( 5,  20, 'Power' );
     OUtTextXY( 5,  40, 'Density' );
     OutTextXY( 5,  60, 'Spectrum' );
     OutTextXY( 5,  80, 'of the' );
     OutTextXY( 5, 100, 'same' );
     OutTextXY( 5, 120, 'square' );
     OutTextXY( 5, 140, 'wave.' );
     OutTextXY( 5, 160, 'Note the' );
     OutTextXY( 5, 180, 'higher' );
     OutTextXY( 5, 200, 'harmonics' );
     OutTextXY( 5, 220, 'of the' );
     OutTextXY( 5, 240, '100 Hz' );
     OutTextXY( 5, 260, 'ground freq.' );
     if ReadKeyNew = #27 then Halt;
   V_free( Win ); V_free( Time ); V_free( Freq );


   (* let's have a look at complex arithmetics  *)
   CX := VCF_vector( 1000 );
   CY := VCF_vector( 1000 );
   za.Re := Pi;   za.Im := 0;
   zb.Re := 0.04; zb.Im := 0.0001;
   VCF_ramp( CX, 1000, za, zb );
   VCF_sin( CY, CX, 1000 );
   VCF_cos( CX, CX, 1000 );
        (*  Try also with other complex functions! *)

   VCF_2autoplot( CY, 1000, PS_SOLID, GREEN,
                  CX, 1000, PS_SOLID, RED );
     SetViewport( 1, 1, getmaxx div 5, 200, FALSE );  clearviewport;
     SetTextJustify( LeftText, TopText );
     SetTextStyle( TriplexFont, HorizDir, 2 );
     SetColor( WHITE );
     OutTextXY( 5,  20, 'Playing with' );
     OutTextXY( 5,  40, 'functions in' );
     OutTextXY( 5,  60, 'the complex' );
     OutTextXY( 5,  80, 'plane:' );
     OutTextXY( 5, 105, 'Green:' );
     OutTextXY( 5, 125, '    sine,' );
     OutTextXY( 5, 150, 'Red:');
     OutTextXY( 5, 170, '    cosine.' );
   if ReadKeyNew = #27 then Halt;
   V_free( CX ); V_free( CY );
   closegraph;

   VF_ramp( X, xsize, -10, 0.020 );
   a := 1.1;  b := -0.15;  c := 0.02;   (* or any other arbitrary values... *)
   writeln;
   writeln('To end this short sample program, let us make a crude speed' );
   writeln('comparison between compiled code and VectorLib functions:');
   writeln('Example: Evaluate the exponential function');
   writeln('         y[i] := c * exp( a * x[i] + b )');
   writeln('         for a vector of 4096 elements (500 runs). Please Wait!' );
   writeln;
   writeln('Execution time of compiled code' );
   write('(normal loop, but with fast pointer arithmetics):');
   starttime;
   for i:=0 to 500 do   (* repeat enough times to see the difference *)
   begin
      XDum := X;  YDum := Y;
      for j:=0 to xsize do
      begin
           YDum^ := c * exp( a * XDum^ + b );
           inc( VRec( XDum ).Off, sizeof( Single ));
           inc( VRec( YDum ).Off, sizeof( Single ));
                       (* use at least fast pointers! *)
      end;
   end;
   extime := stoptime;
   writeln( extime:5:2, ' sec' );
      (* now the OptiVec solution to the same simple problem:  *)
   writeln;
   write('Execution time of the corresponding VectorLib function:');
   starttime;
   for i := 0 to 500 do VFx_exp( Y, X, xsize, a, b, c );
   extime := stoptime;
   writeln( extime:5:2, ' sec' );

   writeln;
   writeln( 'Normally, the OptiVec function is about 2-4 times faster' );
   writeln( 'than compiled code. In some environments, up to a factor of 10' );
   writeln( 'may be gained.' ); writeln;
   writeln( 'Change the source code of this example program and try also');
   writeln( 'other mathematical functions, like the sine, hyperbolic sine...');
   writeln( 'For now, hit any key to end this demo.' );  ReadKeyNew;

   V_freeAll;
end.

