{ EFLIB | Extended Function Library (C) Johan Larsson, 1992 - 1997
          All rights reserved. E-mail to jola@ts.umu.se.

          EXAMPLE PROGRAM                  [x] Real mode
        | Datatype/Lists/List4.pas         [x] Protected mode

  Example of the doubly linked list ADT. This example demonstrates
  some example techniques.

  EFLIB IS PROTECTED BY THE COPYRIGHT LAW AND MAY NOT BE MANIPULATED,
  DISTRIBUTED OR COPIED. THIS DEMONSTRATION PROGRAM MAY FREELY BE USED
  AND DISTRIBUTED.                                                        }

program Example;

uses EFLIST, EFELEM, EFSTRING;


var List      : tList;
    Index     : word;
    Memory    : longint;

begin
     Memory := MemAvail;

     with List do begin

          Initialize ( SizeOf(Index) );

          { Generate a structure containing
            some ordered elements: (1, 2, 3, ..., 2000). }
          for Index := 1 to 2000 do
              Store (Index);

          { Reverse the order of all elements: the list
            becomes (2000, ..., 3, 2, 1). }
          Reverse;
          { Circulate the list, that is, move the last
            element to the front: (1, 2000, ..., 3, 2). }
          Circulate;

          { Erase the first and the last element inside
            the list. It now becomes: (2000, ..., 3). }
          EraseFirst;
          EraseLast;

          { Show some of the elements inside the list. }
          with CreateIterator^ do begin

               Write ('(');
               for Index := 1 to 2 do begin
                   Write (Word(Content^), ', ');
                   WalkForward; { Iterator }
               end;

               Write (' ..., ');
               { Iterator: }
               Last; Walk (-2); { Walk to last element, and back two. }

               while not IsEnd do begin
                     Write (Word(Content^));
                     if Position <> Elements
                        then Write (', ');
                     WalkForward; { Iterator }
               end;

               Free; { Iterator }
               WriteLn (')');
          end;

          if IsIntact
             then WriteLn ('Link integrity OK.');

          Intercept;
     end;

     if Memory <> MemAvail then WriteLn ('Error in structure disposal.');
     WriteLn  ('Testing completed.');
end.