{$IFNDEF VER60}
{$A+,B+,F-,G+,I-,O+,P+,Q-,R-,S-,T-,V-,X+,Y-}
{$ELSE}
{$A+,B+,F-,G+,I-,O+,R-,S-,V-,X+}
{$ENDIF}
UNIT GR_CIRR;
{----------------------------------------------------------------------------}
{ Unit for Cirrus Logic Graphics Devices                                     }
{ for use in Stefan Goehler's graphics unit                                  }
{ Author : Hristo Chilingirov e-mail : hgch@usa.net                          }
{ NOT COMPLETE YET !!! but works ok                                          }
{----------------------------------------------------------------------------}

INTERFACE

uses gr_vars{, iso_dpmi, dos};

function  detect_cirrus : boolean;
procedure enableext_CLstd;
procedure enableext_CLAlpine;
procedure enableext_cirrus;
procedure setbank_stdGD54(bank : word);
procedure setbank2_stdGD54(bank : word);
procedure incbank_stdGD54;
procedure decbank_stdGD54;
procedure bitBLT_stdGD54(x1,y1,x2,y2,dstx,dsty : integer);
procedure clear_stdGD54;
procedure clear_CLVisualMedia;
procedure bar_stdGD54(x1,y1,x2,y2 : integer);
procedure setfillstyle_cirrus(pattern : word;color : word);
procedure scroll_stdGD54(ypos : word);

var
   bar_cirrus : procedure(x1,y1,x2,y2 : integer);
   cleardevice_cirrus : procedure;
   bitblit_cirrus : procedure(x1,y1,x2,y2,dstx,dsty : integer);
   putimage_cirrus : procedure(x,y: integer;p : pointer);
   setbank2_cirrus : procedure(bank : word);
   setbank_cirrus : procedure(bank : word);
   incbank_cirrus : procedure;
   decbank_cirrus : procedure;
   scroll_cirrus : procedure(ypos : word);

IMPLEMENTATION

CONST
     SRX = $3C4;
     CRX = $3D4;
     GRX = $3CE;
     AlpineFamily : set of 0..255= [$31..$33, $35..$36];
     VisualMediaFamily : set of 0..255= [$39, $3A];
     LagunaFamily : set of 0..255= [$60..$61,$64];
     stdGD54Family : set of 0..255= [$10..$19];
     bitBLTGD54Family : set of 0..255= [$15,$18..$19];

function  detect_cirrus : boolean;
{ We have to use 2 detectors here because on some cards, the original
  from Hristo didn't work properly ;(... I heard already about a
  Cirrus-Matrox ;))) }
var
  i : byte;
begin
  move(ptr(getrmselector(
  (longint(vesainfoblock.oemstringptr) shr 16)),
  (longint(vesainfoblock.oemstringptr) and $FFFF))^,s[1],255);
  for i := 1 to 255 do if s[i] = #0 then break;
  s[0] := chr(i);
  for i := 1 to length(s) do s[i] := upcase(s[i]);
  if pos('CIRRUS',s) = 0 then exit;
  asm
    mov  ax,$1233
    mov  bx,$0080
    int  10h
    mov  card.chipnum,ax
  end;
  if (lo(card.chipnum) = $33) then exit;
  with card do
  case chipnum of
      $02 : chipname:= '510/520';
      $03 : chipname:= '610/620';
      $04 : chipname:= '5320';
      $05 : chipname:= '6410';
      $06 : chipname:= '5410';
      $07 : chipname:= '6420';
      $08 : chipname:= '6412';
      $09 : chipname:= '6416';
      $10 : chipname:= '5401';
      $13 : chipname:= '5422';
      $14 : chipname:= '5424';
      $15 : chipname:= '5426';
  $12,$16 : chipname:= '5420';
  $11,$17 : chipname:= '5402';
      $18 : chipname:= '5428';
      $19 : chipname:= '5429';
      $20 : chipname:= '6205';
      $21 : chipname:= '6215';
      $22 : chipname:= '6225';
      $23 : chipname:= '6235';
      $24 : chipname:= '6245';
      $30 : chipname:= '5432';
      $32 : chipname:= '5430';
  $31,$33 : chipname:= '5434';
      $35 : chipname:= '5440';
      $36 : chipname:= '5436';
      $39 : chipname:= '5446';
      $3A : chipname:= '5480';
      $40 : chipname:= '6440';
      $41 : chipname:= 'Nordic 7542';
      $42 : chipname:= 'Viking 7543';
      $43 : chipname:= 'Nordic Lite 7541';
  $50,$52 : chipname:= 'Northstar 5452';
      $60 : chipname:= '5462';
      $61 : chipname:= '5464';
      $64 : chipname:= '5465';
      else chipname:='unknown ID='+MakeStr(chipnum);
  end;
  detect_cirrus := true;
end;

procedure enableext_CLstd;
begin
  wrinx( CRX,6,$12);            {Enable Extensions}
  setinx( CRX,$1B,2);           {Enable mem >256K}
  setinx( GRX, $0B,$20);        {Set 16K banks}
  if (rdinx(GRX,$0b) and $20)<>0 then shifter:=2 else shifter:=1;
end;

procedure enableext_CLAlpine;
begin
     {Ext regs are always unlocked}
  setinx( CRX,$1B,2);           {Enable mem >256K}
  setinx( GRX, $0B,$20);        {Set 16K banks}
  if (rdinx(GRX,$0b) and $20)<>0 then shifter:=2 else shifter:=1;
end;

procedure enableext_CLVisualMedia;
begin
     {Ext regs are always unlocked}
  setinx( CRX,$1B,2);           {Enable mem >256K}
  setinx( GRX, $0B,$20);        {Set 16K banks}
  if (rdinx(GRX,$0b) and $20)<>0 then shifter:=2 else shifter:=1;
end;

procedure init_bitBLT_stdGD54;
begin
  wrinx2(GRX,$24,bytesperscanline);
  wrinx2(GRX,$26,bytesperscanline);
  wrinx(GRX,$30,0);
  wrinx(GRX,$33,0);
  wrinx (GRX,$32,$D);{????}
end;

procedure enableext_cirrus;
begin
     if card.chipnum in stdGD54Family then
     begin
       enableext_CLstd;
       card.speedups.bar     := false;
       card.speedups.bitblit := false;
       card.speedups.banking := true;
       setbank2_cirrus := setbank2_stdGD54;
       setbank_cirrus := setbank_stdGD54;
       incbank_cirrus := incbank_stdGD54;
       decbank_cirrus := decbank_stdGD54;
       scroll_cirrus := scroll_stdGD54;
     end;
     if card.chipnum in bitBLTGD54Family then
     begin
       enableext_CLstd;
       init_bitBLT_stdGD54;
       bitblit_cirrus := bitBLT_stdGD54;
       cleardevice_cirrus := clear_stdGD54;
       bar_cirrus:=bar_stdGD54;
       card.speedups.bar     := true;
       card.speedups.bitblit := true;
       card.speedups.banking := true;
       setbank2_cirrus := setbank2_stdGD54;
       setbank_cirrus := setbank_stdGD54;
       incbank_cirrus := incbank_stdGD54;
       decbank_cirrus := decbank_stdGD54;
       scroll_cirrus := scroll_stdGD54;
     end;
     if card.chipnum in AlpineFamily then
     begin
       enableext_CLAlpine;
       init_bitBLT_stdGD54;
       bitblit_cirrus := bitBLT_stdGD54;
       cleardevice_cirrus := clear_stdGD54;
       bar_cirrus:=bar_stdGD54;
       card.speedups.bar      := true;
       card.speedups.bitblit  := true;
       card.speedups.banking  := true;
       setbank2_cirrus := setbank2_stdGD54;
       setbank_cirrus := setbank_stdGD54;
       incbank_cirrus := incbank_stdGD54;
       decbank_cirrus := decbank_stdGD54;
       scroll_cirrus := scroll_stdGD54;
     end;
     if card.chipnum in VisualMediaFamily then
     begin
       enableext_CLVisualMedia;
       init_bitBLT_stdGD54;
       bitblit_cirrus := bitBLT_stdGD54;
       cleardevice_cirrus := clear_CLVisualMedia;
       bar_cirrus:=bar_stdGD54;
       card.speedups.bar     := true;
       card.speedups.bitblit := true;
       card.speedups.banking := true;
       setbank2_cirrus := setbank2_stdGD54;
       setbank_cirrus := setbank_stdGD54;
       incbank_cirrus := incbank_stdGD54;
       decbank_cirrus := decbank_stdGD54;
       scroll_cirrus := scroll_stdGD54;
     end;
     if card.chipnum in LagunaFamily then
     begin
       card.speedups.bar := false;     {not supported yet}
       card.speedups.bitblit := false; {not supported yet}
       card.speedups.banking := true;
       setbank2_cirrus := setbank2_stdGD54;
       setbank_cirrus := setbank_stdGD54;
       incbank_cirrus := incbank_stdGD54;
       decbank_cirrus := decbank_stdGD54;
       scroll_cirrus := scroll_stdGD54;
     end;
end;

procedure setbank_stdGD54(bank : word);assembler;
asm
  push ax
  push dx
  push cx
  mov  ah,byte ptr bank
  cmp  ah,byte ptr lastbank
  je   @end
  mov  byte ptr lastbank,ah
  mov  dx, GRX
  mov  cl, shifter
  shl  ah, cl
  mov  al,9
  out  dx,ax
  @end:
  pop  cx
  pop  dx
  pop  ax
end;

procedure setbank2_stdGD54(bank : word);assembler;
asm
  push ax
  push dx
  push cx
  mov  ah,byte ptr bank
  mov  byte ptr lastbank,ah
  mov  dx, GRX
  mov  cl, shifter
  shl  ah, cl
  mov  al,9
  out  dx,ax
  pop  cx
  pop  dx
  pop  ax
end;

procedure incbank_stdGD54;assembler;
asm
  push ax
  push dx
  push cx
  mov  ah,byte ptr lastbank
  inc  ah
  mov  byte ptr lastbank,ah
  mov  dx, GRX
  mov  cl, shifter
  shl  ah, cl
  mov  al,9
  out  dx,ax
  pop  cx
  pop  dx
  pop  ax
end;

procedure decbank_stdGD54;assembler;
asm
  push ax
  push dx
  push cx
  mov  ah,byte ptr lastbank
  dec  ah
  mov  byte ptr lastbank,ah
  mov  dx, GRX
  mov  cl, shifter
  shl  ah, cl
  mov  al,9
  out  dx,ax
  pop  cx
  pop  dx
  pop  ax
end;

procedure bitBLT_stdGD54(x1, y1, x2, y2, dstx, dsty : integer);
begin
{  inc(x1,actviewport.x1);
  inc(x2,actviewport.x1);
  inc(y1,pageadd+actviewport.y1);
  inc(y2,pageadd+actviewport.y1);
{  if actviewport.clip then begin
    if dy-pageadd > actviewport.mxy then dy := actviewport.mxy+pageadd;
    if dx > actviewport.mxy then dx := actviewport.mxx;
  end;}
  repeat until (rdinx(GRX,$31) and 1)=0;
  wrinx2(GRX,$20, x2-x1); { ABS ???}
  wrinx2(GRX,$22, y2-y1); { ABS ???}
  wrinx3(GRX,$28,longint(dsty)*bytesperscanline+dstx*bytesperpixel);
  wrinx3(GRX,$2C,longint(y1)*bytesperscanline+x1*bytesperpixel);
{  modinx(GRX,$30,$CF,dir);} {???}
  wrinx (GRX,$31,2);
  repeat until (rdinx(GRX,$31) and 1)=0;
end;

procedure clear_stdGD54;
var
  old : byte;
begin
  repeat until (rdinx(GRX,$31) and 1)=0;
  wrinx2(GRX,$20, maxx);
  wrinx2(GRX,$22, maxy);
  wrinx3(GRX,$28,longint(pageadd)*bytesperscanline);
  wrinx3(GRX,$2C,longint(pageadd)*bytesperscanline);
  old:=rdinx(GRX, $32);
  wrinx (GRX,$32,$0);
  wrinx (GRX,$31,2);
  repeat until (rdinx(GRX,$31) and 1)=0;
  wrinx (GRX,$32,old);
end;

procedure clear_CLVisualMedia;
var
  o1,o2,o3 : byte;
begin
  repeat until (rdinx(GRX,$31) and $1)=0;
  wrinx2(GRX,$20, maxx);
  wrinx2(GRX,$22, maxy);
  wrinx3(GRX,$28,longint(pageadd)*bytesperscanline);
  o1:=rdinx(GRX, $33); wrinx (GRX,$33,o1 or 4);
  o2:=rdinx(GRX, $30); wrinx (GRX,$30,(o2 or $C0) and (not 8));
  o3:=rdinx(GRX, $1); wrinx (GRX,$1, 0);
  wrinx (GRX,$31,2);
  repeat until (rdinx(GRX,$31) and $1)=0;
  wrinx (GRX,$33,o1); wrinx (GRX,$30,o2); wrinx (GRX,$1,o3);
end;

procedure bar_stdGD54(x1,y1,x2,y2 : integer);
var
  sizex,sizey : integer;
  o1 : byte;
begin
  if y1 > y2 then swap(y1,y2);
  if x1 > x2 then swap(x1,x2);
  inc(x1,actviewport.x1);
  inc(y1,actviewport.y1);
  inc(x2,actviewport.x1);
  inc(y2,actviewport.y1);

  if (y1 > fillviewport.y2) or (y2 < fillviewport.y1) then exit;
  if (x1 > fillviewport.x2) or (x2 < fillviewport.x1) then exit;
  if x1 < fillviewport.x1 then x1 := fillviewport.x1;
  if x2 > fillviewport.x2 then x2 := fillviewport.x2;
  if y1 < fillviewport.y1 then y1 := fillviewport.y1;
  if y2 > fillviewport.y2 then y2 := fillviewport.y2;

  sizex := abs(x2-x1);
  sizey := abs(y2-y1);
  inc(y1,pageadd+actviewport.y1);
  inc(y2,pageadd+actviewport.y1);
  repeat until (rdinx(GRC,$31) and 1) = 0;
  wrinx(GRX, 0, bkcolor);
  wrinx(GRX, 1, fillcolor);
  if bitsperpixel >= 15 then wrinx(GRC,$11,fillcolor shr 8);
  if bitsperpixel >= 24 then wrinx(GRC,$13,fillcolor shr 16);
  wrinx2(GRX,$20,sizex);
  wrinx2(GRX,$22,sizey);
  wrinx3(GRX,$28,longint(y1)*bytesperscanline+x1*bytesperpixel);
  wrinx3(GRX,$2C,vesainfoblock.totalmemory*64*longint(1024)-8);
  o1:=rdinx(GRX,$30);
  wrinx (GRX,$30,$C0);
  wrinx (GRX,$31,2);
  repeat until (rdinx(GRX,$31) and 1)=0;
  wrinx (GRX,$30, o1);
end;

procedure setfillstyle_cirrus(pattern : word;color : word);
var
  i : integer;
begin
  fillcolor := color;
  fillstyle := filloutpattern[pattern];
  setbank_cirrus(vesainfoblock.totalmemory-1);
  move2(filloutpattern[pattern,1],ptr(writeptr,$fff8)^, 8);
  fillstylenum := pattern;
end;

procedure scroll_stdGD54(ypos : word);assembler;
asm
  push ax
  push bx
  push cx
  push dx
  mov  ax, ypos
  mov  cx, bytesperscanline
  shr  cx, 2
  mul  cx
  mov  cx, ax
  mov  bx, dx
  mov  dx, CRX
  mov  al, 0Dh
  mov  ah, cl
  out  dx, ax
  mov  al, 0Ch
  mov  ah, ch
  out  dx, ax
  mov  al, 1Bh
  out  dx, al
  inc  dx
  in   al, dx
  and  al, 0F2h
  mov  cl, bl
  and  cl, 1
  or   al, cl
  mov  cl, bl
  shr  cl, 1
  and  cl, 3
  shl  cl, 2
  or   al, cl
  out  dx, al
  mov  dx, CRX
  mov  al, 1Dh
  out  dx, al
  inc  dx
  in   al, dx
  shr  bl, 3
  and  bl, 1
  shl  bl, 7
  and  al, 7Fh
  or   al, bl
  out  dx, al
  pop  dx
  pop  cx
  pop  bx
  pop  ax
end;

BEGIN
     @bar_cirrus :=nil;
     @cleardevice_cirrus :=nil;
     @bitblit_cirrus :=nil;
     @putimage_cirrus :=nil;
     @setbank2_cirrus :=nil;
     @setbank_cirrus :=nil;
     @incbank_cirrus :=nil;
     @decbank_cirrus :=nil;
     @scroll_cirrus :=nil;
END.