{ SRTTSTW.PAS - Test SRTLIB.PAS unit (MS-Windows version)

  Title    : SRTTSTW
  Version  : 3.0
  Date     : Nov 14,1995
  Author   : J R Ferguson
  Language : Borland Pascal v7.0 with Object Windows
  Target   : MS-Windows v3.1
  Usage    : Windows 3.1 application
}

{$B-} { short circuit Boolean expression evaluation }
{$V-} { relaxed var-string checking }
{$X+} { extended syntax }

program SRTTSTW;
uses
  OWindows, ODialogs,  WinTypes, Strings,
  SrtLib;

{$R SRTTSTW.RES}
{$I SRTTSTW.INC}

const
  ApplIdn     = 'SRTTSTW';
  C_Count     = 100;
  C_MaxValue  = 1000;

type
  P_Integer     = ^Integer;
  P_Data        = ^T_Data;
  P_MainDlgBuf  = ^T_MainDlgBuf;
  P_Application = ^T_Application;
  P_MainWindow  = ^T_MainWindow;

  T_SortMethod  = (C_SortInsert,C_SortSelect,C_SortQuick);

  T_DataInd     = 0..C_Count;
  T_Data        = array[1..C_Count] of integer;

  T_MainDlgBuf  = record
    IO_SortInsert, IO_SortSelect, IO_SortQuick : word;
  end;

  T_MainWindow  = object(TDlgWindow)
    SortMethod  : T_SortMethod;
    Before,After: P_Data;
    constructor Init(V_Parent: PWindowsObject; V_Title: PChar);
    destructor  Done; virtual;
    function    GetClassName: PChar; virtual;
    procedure   GetWindowClass(var V_Class: TWndClass); virtual;
    procedure   SetupWindow; virtual;
    procedure   DataInit;
    procedure   DataTerm;
    procedure   DlgInit;
    procedure   DlgTerm;
    procedure   DlgImport;
    procedure   DlgExport;
    procedure   IDNewData(var V_Msg:TMessage); virtual id_First + id_NewData;
    procedure   IDSort   (var V_Msg:TMessage); virtual id_First + id_Sort;
  end;

  T_Application = object(TApplication)
    procedure InitMainWindow; virtual;
  end;

{ --- General routines --- }

function SetCheck(b: boolean): word;
begin if b then SetCheck:= bf_Checked else SetCheck:= bf_UnChecked; end;

procedure InitData(V_Data: P_Data);
var i: T_DataInd;
begin Randomize; for i:= 1 to C_Count do V_Data^[i]:= Random(C_MaxValue); end;

procedure CopyData(V_Dst,V_Src: P_Data);
var i: T_DataInd;
begin for i:= 1 to C_Count do V_Dst^[i]:= V_Src^[i]; end;

function CompareData(e1,e2:SrtElmPtr): integer; far;
begin CompareData:= P_Integer(e1)^ - P_Integer(e2)^ end;

procedure SortData(V_SortMethod: T_SortMethod; V_Dst: P_Data);
begin case V_SortMethod of
  C_SortInsert : SrtBinIns(V_Dst,C_Count,SizeOf(Integer),CompareData);
  C_SortSelect : SrtSelect(V_Dst,C_Count,SizeOf(Integer),CompareData);
  C_SortQuick  : SrtQuick (V_Dst,C_Count,SizeOf(Integer),CompareData);
end end;


{ --- T_MainWindow methods --- }

constructor T_MainWindow.Init(V_Parent: PWindowsObject; V_Title: PChar);
begin
  Inherited Init(V_Parent,V_Title);
  DataInit;
  DlgInit;
end;

destructor T_MainWindow.Done;
begin
  DlgTerm;
  DataTerm;
  inherited Done;
end;

function    T_MainWindow.GetClassName: PChar;
begin GetClassName:= 'SRTTSTWMAIN'; end;

procedure   T_MainWindow.GetWindowClass(var V_Class: TWndClass);
begin inherited GetWindowClass(V_Class); end;

procedure   T_MainWindow.SetupWindow;
begin
  inherited SetupWindow;
  DlgImport;
end;

procedure   T_MainWindow.DataInit;
begin
  New(Before); New(After);
  InitData(Before);
  CopyData(After,Before);
end;

procedure   T_MainWindow.DataTerm;
begin Dispose(Before); Dispose(After); end;

procedure   T_MainWindow.DlgInit;
var Control: PControl;
begin
  SortMethod:= C_SortInsert;
  Control:= New(PRadioButton, Initresource(@Self,id_SortInsert));
  Control:= New(PRadioButton, Initresource(@Self,id_SortSelect));
  Control:= New(PRadioButton, Initresource(@Self,id_SortQuick ));
  TransferBuffer:= new(P_MainDlgBuf);
end;

procedure   T_MainWindow.DlgTerm;
begin Dispose(TransferBuffer); end;

procedure   T_MainWindow.DlgImport;
var i: T_DataInd; ItemP: string[4]; ItemZ: array[0..4] of char;
begin
  with P_MainDlgBuf(TransferBuffer)^ do begin
    IO_SortInsert:= SetCheck(SortMethod = C_SortInsert);
    IO_SortSelect:= SetCheck(SortMethod = C_SortSelect);
    IO_SortQuick := SetCheck(SortMethod = C_SortQuick );
  end;
  TransferData(tf_SetData);
  SendDlgItemMsg(id_ListBefore,lb_ResetContent,0,0);
  SendDlgItemMsg(id_ListAfter ,lb_ResetContent,0,0);
  for i:= 1 to C_Count do begin
    Str(Before^[i]:10,ItemP); StrPCopy(ItemZ,ItemP);
    SendDlgItemMsg(id_ListBefore,lb_AddString,0,LongInt(@ItemZ));
    Str(After^ [i]:10,ItemP); StrPCopy(ItemZ,ItemP);
    SendDlgItemMsg(id_ListAfter ,lb_AddString,0,LongInt(@ItemZ));
  end;
end;

procedure   T_MainWindow.DlgExport;
begin with P_MainDlgBuf(TransferBuffer)^ do begin
  TransferData(tf_GetData);
  if IO_SortInsert = bf_Checked then SortMethod:= C_SortInsert;
  if IO_SortSelect = bf_Checked then SortMethod:= C_SortSelect;
  if IO_SortQuick  = bf_Checked then SortMethod:= C_SortQuick ;
end end;

procedure   T_MainWindow.IDNewData(var V_Msg:TMessage);
begin
  DlgExport;
  InitData(Before);
  CopyData(After,Before);
  DlgImport;
end;

procedure   T_MainWindow.IDSort   (var V_Msg:TMessage);
begin
  DlgExport;
  CopyData(After,Before);
  SortData(SortMethod,After);
  DlgImport;
end;


{ --- T_Application methods --- }

procedure T_Application.InitMainWindow;
begin
  MainWindow:= New(P_MainWindow, Init(nil,MakeIntResource(DLG_MAINWINDOW)));
end;


{ --- Main program  --- }

BEGIN
  Application:= New(P_Application,Init(ApplIdn));
  Application^.Run;
  Dispose(Application,Done);
END.
