{ TIMTST.PAS : Test TIMLIB unit

  Title   : TIMTST
  Version : 5.0
  Date    : Nov 10,1996
  Author  : J.R. Ferguson
  Language: Borland Turbo Pascal v4.0 t/m 7.0 (all targets)
  Usage   : Test program
}

{$R- : range check off for test purposes. }

program TimTst;

uses
{$IFDEF WINDOWS}
  WinCrt,
{$ELSE}
  Crt,
{$ENDIF}
  TimLib, DefLib, ConLib, ChrLib;

var  date    : TimDateRec;
     time    : TimTimeRec;
     packdate: longint;
     packtime: longint;
     DateOK,
     TimeOK  : boolean;
     option  : char;

procedure wrln2; begin writeln; writeln; end;

procedure ErrorMessage(ok: boolean);
begin
  writeln;
  if ok then writeln('OK') else writeln(chr(AsciiBEL),'ERROR')
end;

procedure AskDate(var date: TimDateRec);
begin with date do begin
  write('Day    (1..31)      : '); readln(Day);
  write('Month  (1..12)      : '); readln(Month);
  write('Year   (1980..2099) : '); readln(Year)
end end;

procedure AskTime(var time: TimTimeRec);
begin with time do begin
  write('Hours    (0..23) : '); readln(Hours);
  write('Minutes  (0..59) : '); readln(Minutes);
  write('Seconds  (0..59) : '); readln(Seconds);
  write('CentiSec (0..99) : '); readln(CentiSec);
end end;

procedure AskLongint(var n: longint);
begin write('n: '); readln(n); end;

procedure WriteDate(date: TimDateRec);
begin with date do begin
  writeln('date (dd-mm-jjjj)  = ',Day:2,'-',Month:2,'-',Year:4)
end end;

procedure WriteTime(time: TimTimeRec);
  procedure wr2dig(n:integer);
  begin if n<10 then write('0',n) else write(n) end;
begin with time do begin
  write('time (hh:mm:ss,cc) = ');
  wr2dig(Hours); write(':'); wr2dig(Minutes); write(':');
  wr2dig(Seconds); write(','); wr2dig(CentiSec); writeln;
end end;

procedure WriteLongint(n: longint);
begin writeln('n=',n); end;

procedure xPackDate;
begin
  wrln2;
  AskDate(date);
  ErrorMessage(TimPackDate(date,packdate));
  WriteLongint(packdate);
  ErrorMessage(TimUnpackdate(packdate,date));
  WriteDate(date);
  wrln2;
end;

procedure xPackTime;
begin
  wrln2;
  AskTime(time);
  ErrorMessage(TimPackTime(time,packtime));
  WriteLongint(packtime);
  ErrorMessage(TimUnpackTime(packtime,time));
  WriteTime(time);
  wrln2;
end;

procedure xUnpackDate;
begin
  wrln2;
  AskLongint(packdate);
  ErrorMessage(TimUnpackDate(packdate,date));
  WriteDate(date);
  ErrorMessage(TimPackDate(date,packdate));
  WriteLongint(packdate);
  wrln2;
end;

procedure xUnpackTime;
begin
  wrln2;
  AskLongint(packtime);
  ErrorMessage(TimUnpackTime(packtime,time));
  WriteTime(time);
  ErrorMessage(TimPackTime(time,packtime));
  WriteLongint(packtime);
  wrln2;
end;

procedure xGetDateTime;
begin
  wrln2;
  TimGetDate(date); WriteDate(date);
  TimGetTime(time); WriteTime(time);
  wrln2;
end;

procedure xSetDate;
begin
  wrln2;
  AskDate(date);
  ErrorMessage(TimSetDate(date));
  xGetDateTime;
end;

procedure xSetTime;
begin
  wrln2;
  AskTime(time);
  ErrorMessage(TimSetTime(time));
  xGetDateTime;
end;

{$I TIMTSTM1.PAS}
{$I TIMTSTM2.PAS}
{$I TIMTSTM.PAS}

begin
  TIMTSTM;
{$IFDEF WINDOWS}
  DoneWinCrt;
{$ELSE}
  writeln('Exit'); writeln
{$ENDIF}
end.
