{ͻ
                                 MSC v1.2                                   
 ͹
  Coded by Zuul as BouFFtou as Cheveau Frdric.                            
  Contactez moi sur le 36.15 RTEL1 - Bal "BouFFtou" ou Bal "Sybaris".       
  Internet : Zuulcoder@hotmail.com ou Sybaris@multimania.com                
  Vous pouvez avoir plus de renseignements sur : www.multimania.com/mos     
 ͼ}

{$M 25000,0,65520}                      {*Stack And Heap*}

Program MSC;                            {*Nom du Programme*}

Uses  Dos,
      MOS_DSK, MOS_VAR, MOS_STR,
      MOS_LFN, MOS_FIL, MOS_CRT,
      MOS_XMS;                          {*MOS & BP7 Units*}

Const Program_name ='MSC';
      Ver_Num      ='v1.2';
      Last_update  ='13.02.1998';
      Copyright    ='(C)1997-98 F.Cheveau';
                   {'(C)1997-98 JP.Planas';}
      Authors  ='Written by F.CHEVEAU '+Last_Update+'. Tel: 04.68.50.77.15';
               {'Written by JP.PLANAS '+Last_Update+'. Tel: 04.68.61.19.77';}

    Max_Actions=400;                    {*Nb Actions Mmorisables au Maximum*}
    Max_StringSize=64;                  {*Taille Maximum des Strings*}

    CMD_REPLACESTRING=1;                {*Commandes Interprtables*}
    CMD_DELETESTRING=2;
    CMD_REPLACEITEM=17;
    CMD_DELETEITEM=18;
    CMD_INSERTPARAM=3;
    CMD_DELETEPARAM=4;
    CMD_INSERTLINE=5;                   {*Abstrait !*}
    CMD_INSERTLINEBEFORE=12;            {*Fille de INSERTLINE*}
    CMD_INSERTLINEAFTER=13;             {*Fille de INSERTLINE*}
    CMD_DELETELINE=6;
    CMD_DELETELINES=19;
    CMD_UPPER=7;
    CMD_MIDDER=8;
    CMD_LOWER=9;
    CMD_DEFINE=10;
    CMD_REPLACEHEXA=11;
    CMD_DELETEBLOCK=14;
    CMD_INSERTBLOCK=15;
    CMD_DELETEOCCURENCE=20;
    CMD_SKIP=16;
    CMD_EXIT=21;
    CMD_WRITE=22;
    CMD_CLS=23;

    LAST_COMMAND=23;                    {*Dernire Commande*}

Type TAction=Record                     {*Structure pour Une Action*}
   Command:Integer;
   Source,Target:String[Max_StringSize];
   Position:Shortint;                   {*Position du Paramtre*}
   QttFound:Integer;                    {*Quantit du String Dtecte*}
   Busy:Boolean;                        {*Used by some functions*}
   End;

Type TInfos=Record                      {*Structure pour Infos Commandes*}
   Info:String;                         {*Informations sur la Commande*}
   Qtt_Done:Integer;                    {*Nombre d'action Faites*}
   End;

Var Actions:Array[1..Max_Actions]  of TAction;
    Infos  :Array[1..LAST_COMMAND] of TInfos;

Var FPath         :DirStr;              {*FSplit Source*}
    FName         :NameStr;
    FExt          :ExtStr;
    Source        :String;              {*Fichier Source*}
    Target        :String;              {*Fichier Destinantion*}
    NoMess        :Boolean;             {*Pas de Messages*}
    A             :Integer;             {*Loop*}
    Action        :Byte;                {*Numro de l'action  Faire*}
    Sub           :Boolean;             {*Parcours en Rcursif....*}
    Backup        :Boolean;             {*Cration d'un Backup par Fichier*}
    Par           :String;              {*Paramtres*}
    FD            :DirStr;              {*FSplit...*}
    FN            :NameStr;
    FE            :ExtStr;

    DoneOne       :Boolean;             {*Trouve au Moins au Fichier avec Alias*}
    Alias         :Boolean;             {*Le nom Fichier Comporte des "*" *}
    DirI          :SearchRec;           {*Struct Dir Infos*}
    Mask          :String;              {*Masque Gnral pour Alias*}

    Qtt_Cmd       :Integer;             {*Quantit de Commandes Trouves*}
    Qtt_Line      :Integer;             {*Numro de la ligne Lue*}
    Qtt_Rem       :Integer;             {*Nombre de Lignes Avec REM*}
    Err_Cmd       :Integer;             {*Nombre d'erreurs dans le Commandes*}
    Info_Conv     :Boolean;             {*Affiche les Infos sur la Convertion*}
    ResCom        :Integer;             {*Rsultat de l'ouverture du fichier de Commandes*}
    Error         :Integer;             {*Erreur d'analyse Lexicale*}
    Command_File  :String;              {*Fichier de Commandes Spcial*}

{ͻ
                                   Authors                                  
 ͹
  OUT....: Affiche plus d'informations concernant les autheurs              
 ͼ}

Procedure Sybaris_Info;
Begin
 Writeln(Program_name,' ',ver_num,' - Code by J.P. PLANAS as SYBARIS.');
 Writeln;
 Writeln('PLANAS Jean-Pierre Alias SYBARIS ');
 Writeln('41 Route de perpignan ');
 Writeln('66240 Saint-Estve ');
 Writeln('FRANCE');
 Writeln('E-Mail : sybaris@multimania.com');
 Writeln('Minitel : 36.15 RTEL1. BAL : SYBARIS');
 Writeln('Membre du Club Informatique Stphanois (CIS)');
 Writeln('CIS Cami dels horts 66240 Saint-Estve');
 Writeln;
 Halt(0);
End;

Procedure Zuul_Info;
Begin
 Writeln(Program_name,' ',ver_num,' - Code by F.CHEVEAU as ZuuL.');
 Writeln;
 Writeln('CHEVEAU Frdric Alias ZuulCoder ');
 Writeln('8 Passage des grillons');
 Writeln('66000 Perpignan');
 Writeln('FRANCE');
 Writeln('E-Mail : zuulcoder@hotmail.com');
 Writeln('Minitel : 36.15 RTEL1. BAL : BouFFtou');
 Writeln('Membre du Club Informatique Stphanois (CIS)');
 Writeln('CIS Cami dels horts 66240 Saint-Estve');
 Writeln;
 Halt(0);
End;

{ͻ
                                    HELP                                    
 ͹
  OUT....: Affiche l'aide du logiciel                                       
 ͼ}

Procedure Help;
Begin
 Writeln(Program_Name,' ',Ver_Num,' - MOS Sourcefiles Tool.');
 Writeln(Authors);
 Writeln(Program_Name,' is a Source File Converter specialized in MOS sources convertions.');
 Writeln('With the CMD command file, you are able to customize the convertion.');
 Writeln('In extention, you can convert all the text files as you want.');
 Writeln;
 Writeln('Synopsis: ',Program_Name,' <File> /Commands /Switches');
 Writeln('Inputfile <File>        : File(s) to be processed');
 Writeln;
 Writeln('Commands: /?            : This help');
 Writeln('          /Author       : More information about the author');
 Writeln('Switches: /Nm           : No display messages');
 Writeln('          /S            : Recurse subdirectories');
 Writeln('          /B            : Create backup file');
 Writeln('          /I            : Detailled convertion per file');
 Writeln('          /C=<File>     : Use specified command file');
 Writeln('Example : ',Program_Name,' *.PAS /I');
 Writeln;
 Writeln('Note    : Please note that aliases and jockers are supported.');
 Writeln('          Commands and switches are not case sensitives.');
 Writeln('          Redirection to a file possible with > and >>.');
 Writeln('          Support long filenames (Windows and NT OS).');
 Halt(0);
End;

{ͻ
                   TESTE SI UNE CHAINE EST REMPLIE D'ESPACES                
 ͼ}

Function TEST_EMPTY_STRING(St:String):Boolean;
Var A:Integer;
Begin
For A:=1 to Length(St) do If Copy(St,A,1)<>' ' Then
   Begin
   TEST_EMPTY_STRING:=False;            {*Erreur*}
   Exit;
   End;
TEST_EMPTY_STRING:=True;
End;

{ͻ
              TESTE SI LE CARACTERE PEUT FAIRE PARTIR D'UN MOT              
 ͼ}

Function TEST_CHAR_NAME(C:Char):Boolean;
Begin
If ((Ord(C)>=48) And (Ord(C)<=57)) Or   {*Chiffres*}
   ((Ord(C)>=65) And (Ord(C)<=90)) Or   {*Lettres a<=>z*}
   ((Ord(C)>=97) And (Ord(C)<=122)) Or  {*Lettres A<=>Z*}
    (Ord(C)=95)                         {*Underscore '_'*}
   Then TEST_CHAR_NAME:=True
   Else TEST_CHAR_NAME:=False;
End;

{ͻ
                   RENVOIS LA POSITION DU Nieme PARAMETRE                   
 ͼ}

Function GET_POS_PARAM(Title, St:String; Num:Byte; Var Result:Byte):Byte;
Var A,N,P1,PPar:Integer;
    SubSt:String;
Begin
P1:=Pos(Title,St);
If P1=0 Then Begin                      {*Erreur On n'est pas dans la Bonne Fonction*}
   GET_POS_PARAM:=0;
   Exit;
   End;
SubSt:=Copy(St,P1,255);                 {*On dcoupe la Sous-String*}

N:=1;
If Num=1 Then
   Begin
   GET_POS_PARAM:=P1+Pos('(',SubSt);    {*1er Paramtre...*}
   Result:=1;
   Exit;
   End;

A:=0;
Repeat
   Inc(A);                              {*Next Char...*}
   If SubSt[A]=',' Then Inc(N);
   If N=Num Then
      Begin
      If Pos(',',Copy(SubSt,A+1,255))>0 Then
         Begin
         GET_POS_PARAM:=P1+A;           {*Position Parameter du Milieu*}
         Result:=2;
         Exit;
         End
         Else Begin
         GET_POS_PARAM:=P1+A-1;         {*Position Last Parameter*}
         Result:=3;
         Exit;
         End;
      End;
Until (A>=Length(SubSt)) Or (SubSt[A]=')');

Result:=0;
GET_POS_PARAM:=0;                       {*Erreur !*}
End;

{ͻ
                   RENVOIS LA POSITION DU Nieme PARAMETRE                   
 ͼ}

Function GET_QTT_PARAM(Title, St:String):Byte;
Var A,N,P1,PPar:Integer;
    SubSt:String;
Begin
P1:=Pos(Title,St);
If P1=0 Then Begin                      {*Erreur On n'est pas dans la Bonne Fonction*}
   GET_QTT_PARAM:=0;
   Exit;
   End;
SubSt:=Copy(St,P1,255);                 {*On dcoupe la Sous-String*}

N:=1; A:=0;
Repeat
   Inc(A);                              {*Next Char...*}
   If SubSt[A]=',' Then Inc(N);
Until (A>=Length(SubSt)) Or (SubSt[A]=')');

GET_QTT_PARAM:=N;                       {*Le Rsultat*}
End;

{ͻ
                  RENVOIS LA POSITION DU PROCHAIN PARAMETRE                 
 ͼ}

Function GET_NEXT_PARAM(St:String):Byte;
Var A:Integer;
Begin
A:=0;
Repeat
   Inc(A);                              {*Next Char...*}
   If St[A]=',' Then
      Begin
      GET_NEXT_PARAM:=A;                {*Renvois la Position*}
      Exit;
      End;
Until (A>=Length(St)) Or (St[A]=')');

If St[A]=')' Then GET_NEXT_PARAM:=A-1   {*Dernier Paramtre*}
             Else GET_NEXT_PARAM:=0;    {*Erreur !*}
End;

{ͻ
                  REMPLIS LES INFORMATIONS SUR LES COMMANDES                
 ͼ}

Procedure FILL_COMMANDS_INFO;
Begin
Infos[CMD_REPLACESTRING].Info  :='   Replaced strings....:';
Infos[CMD_DELETESTRING].Info   :='   Deleted strings.....:';
Infos[CMD_REPLACEITEM].Info    :='   Replaced items......:';
Infos[CMD_DELETEITEM].Info     :='   Deleted items.......:';
Infos[CMD_INSERTPARAM].Info    :='   Inserted parameters.:';
Infos[CMD_DELETEPARAM].Info    :='   Deleted parameters..:';
Infos[CMD_INSERTLINE].Info     :='   Inserted lines......:';
Infos[CMD_DELETELINE].Info     :='   Deleted lines.......:';
Infos[CMD_UPPER].Info          :='   Strings to upper....:';
Infos[CMD_MIDDER].Info         :='   Strings to midder...:';
Infos[CMD_LOWER].Info          :='   Strings to lower....:';
Infos[CMD_DEFINE].Info         :='   Define internal CMD.:';
Infos[CMD_REPLACEHEXA].Info    :='   Replaced hexacode...:';
Infos[CMD_DELETEBLOCK].Info    :='   Deleted blocks......:';
Infos[CMD_INSERTBLOCK].Info    :='   Inserted blocks.....:';
Infos[CMD_DELETEOCCURENCE].Info:='   Deleted occurences..:';
Infos[CMD_SKIP].Info           :='   Skipped blank lines.:';
Infos[CMD_EXIT].Info           :='   Exit from script....:';
Infos[CMD_WRITE].Info          :='   Write output message:';
Infos[CMD_CLS].Info            :='   Clear screen........:';
End;

{ͻ
                   AFFICHAGE DES ERREURS D'INTERPRETATIONS                  
 ͼ}

Procedure PRINT_ERROR(Err:Integer; St:String);
Begin
If TEST_EMPTY_STRING(St)=True Then Exit;{*Chaine Vide*}

Error:=Err;
Inc(Err_Cmd);
If Not NoMess Then
   Begin
   Write('   Line ',Qtt_Line:3,'  ');
   Textcolor(15);
   Case Err of
       2: Write('Command not found');
       3: Write('Unknown command');
       4: Write('Missing "]" in source string');
       5: Write('Missing "[" in source string');
       6: Write('Missing "]" in target string');
       7: Write('Missing "[" in target string');
       8: Write('Empty command');
       9: Write('Missing "<" in command');
      10: Write('Missing ">" in command');
      11: Write('Swapped markers in command');
      12: Write('Swapped markers in source string');
      13: Write('Swapped markers in target string');
      14: Write('Missing reserved word "is"');
      15: Write('Empty source string');
      16: Write('Empty target string');
      17: Write('Missing reserved word "by"');
      18: Write('Missing reserved word "in"');
      19: Write('Missing reserved word "at"');
      20: Write('Negative parameters not allowed');
      21: Write('Strings not allowed');
      22: Write('Missing reserved word "before" or "after"');
      23: Write('Choose "before" or "after" reserved word');
      24: Write('Missing reserved word "pos"');
      25: Write('Missing reserved word "size"');
      26: Write('Too many commands loaded');
      27: Write('Missing parameter position');
      28: Write('Missing reserved word "after"');
      29: Write('Defined string too long (Max=',Max_StringSize,')');
      End;
   Textcolor(7);
   Writeln(': ',St);
   End;
End;

{ͻ
                   LECTURE DU FICHIER DATAS DE COMMANDES                    
 ͼ}

Function LOAD_COMMAND_FILE(FName:String):Shortint;
Var F:Text;
    St:String;
    SCommand,SSource,STarget,SParam:String;
    P_Inf,P_Sup,P_By,P_At,P_In,P_Is,P_After,P_Before,P_Pos,P_Size:Byte;
    P_C1o,P_C1c, P_C2o,P_C2c, P_C3o,P_C3c:Byte;
    P_Pa:Shortint;
    Command,Code:Integer;

Begin
Assign(F,FName);
{$I-}
Reset(F);                               {*Open Command File*}
{$I+}
If IOResult=0 Then                      {*No Errors ? => Ok !*}
   Begin
   Readln(F,St);
   Qtt_Line:=2;
   If St<>'MSC v1.0 Command File' Then  {*Ce n'est pas le bon fichier*}
      Begin
      LOAD_COMMAND_FILE:=-2;            {*Error*}
      Exit;
      End;

   Readln(F,St);                        {*Recherche du Word 'Command'*}
   Repeat
      Readln(F,St);
      Inc(Qtt_Line);
   Until (Eof(F)) Or (Upper(St)='[COMMANDS]');

   While Not Eof(F) do                  {*On  le dbut des commandes*}
      Begin
      Readln(F,St);                     {*Lecture d'une Ligne*}
      Inc(Qtt_Line);
      Error:=0;
      P_Pa:=0;

      P_Inf:=Pos('<',St);               {*Recherche des Marqueurs*}
      P_Sup:=Pos('>',St);
      P_C1o:=Pos('[',St);
      P_C1c:=Pos(']',St);
      If (P_C1o>0) And (P_C1c>0) Then
         Begin
         P_C2o:=Pos('[',Copy(St,P_C1c+1,256))+P_C1c;
         P_C2c:=Pos(']',Copy(St,P_C1c+1,256))+P_C1c;
         End
         Else Begin P_C2o:=0; P_C2c:=0; End;
      If (P_C2o>0) And (P_C2c>0) Then
         Begin
         P_C3o:=Pos('[',Copy(St,P_C2c+1,256))+P_C2c;
         P_C3c:=Pos(']',Copy(St,P_C2c+1,256))+P_C2c;
         End
         Else Begin P_C2o:=0; P_C2c:=0; End;
      P_By    :=Pos('BY',Upper(Copy(St,P_C1c+1,P_C2o-P_C1c-1)));
      P_At    :=Pos('AT',Upper(Copy(St,P_C2c+1,P_C3o-P_C2c-1)));
      P_In    :=Pos('IN',Upper(Copy(St,P_C1c+1,P_C2o-P_C1c-1)));
      P_Pos   :=Pos('POS',Upper(Copy(St,P_C1c+1,P_C2o-P_C1c-1)));
      P_Size  :=Pos('SIZE',Upper(Copy(St,P_C1c+1,P_C2o-P_C1c-1)));
      P_Before:=Pos('BEFORE',Upper(Copy(St,P_C1c+1,P_C2o-P_C1c-1)));
      P_After :=Pos('AFTER', Upper(Copy(St,P_C1c+1,P_C2o-P_C1c-1)));
      P_Is    :=Pos('IS',Upper(St));

      SCommand:=Upper(Copy(St,P_Inf+1,P_Sup-P_Inf-1));
      SSource :=Copy(St,P_C1o+1,P_C1c-P_C1o-1);
      STarget :=Copy(St,P_C2o+1,P_C2c-P_C2o-1);
      SParam  :=Copy(St,P_C3o+1,P_C3c-P_C3o-1);
      If P_C1c-P_C1o-1>Max_StringSize Then PRINT_ERROR(29,SSource);
      If P_C2c-P_C2o-1>Max_StringSize Then PRINT_ERROR(29,STarget);

      If (P_C1o>0) And (P_C1c=0) Then PRINT_ERROR(4,St);
      If (P_C1o=0) And (P_C1c>0) Then PRINT_ERROR(5,St);
      If (P_C2o>0) And (P_C2c=0) Then PRINT_ERROR(6,St);
      If (P_C2o=0) And (P_C2c>0) Then PRINT_ERROR(7,St);
      If (P_C2o>0) And (P_C2c>0) Then
         Begin
{         If (TEST_EMPTY_STRING(Copy(St,P_C2o+1,P_C2c-P_C2o-1))=True) Then PRINT_ERROR(Line,16,St);}
         If (P_C2o>P_C2c) Then PRINT_ERROR(13,St);
         End;
      If (P_C1o>0) And (P_C1c>0) Then
         Begin
         If (P_C1o>P_C1c) Then PRINT_ERROR(12,St);
{         If (P_C1o<P_C1c) And (TEST_EMPTY_STRING(Copy(St,P_C1o+1,P_C1c-P_C1o-1))=True) Then PRINT_ERROR(15,St);}
         End;
                                        {*Rem Bourrin*}
      If (P_Inf=0) And (Pos('REM',Upper(St))>0) Then
         Begin Error:=1; Inc(Qtt_Rem); End;
                                        {*Rem devant une Commande*}
      If (Pos('REM',Upper(Copy(St,1,P_Inf)))>0) Then
         Begin Error:=1; Inc(Qtt_Rem); End;

      If (P_Inf=0) And (Error<>1) Then PRINT_ERROR(9,St);
      If (P_Sup=0) And (Error<>1) Then PRINT_ERROR(10,St);

      If (P_Inf>0) And (P_Sup>0) Then
         Begin
         If (P_Inf<P_Sup) And (TEST_EMPTY_STRING(Copy(St,P_Inf+1,P_Sup-P_Inf-1))=True) Then PRINT_ERROR(8,St);
         If (P_Inf>P_Sup) Then PRINT_ERROR(11,St);
         End;
      If (P_Inf=0) And (P_Sup=0) And (Error<>1) Then PRINT_ERROR(2,St);

      If Error=0 Then                   {*Analyse de la Commande*}
         Begin
         Command:=0;
         If SCommand='REPLACESTRING'   Then Command:=CMD_REPLACESTRING;
         If SCommand='DELETESTRING'    Then Command:=CMD_DELETESTRING;
         If SCommand='REPLACEITEM'     Then Command:=CMD_REPLACEITEM;
         If SCommand='DELETEITEM'      Then Command:=CMD_DELETEITEM;
         If SCommand='INSERTPARAM'     Then Command:=CMD_INSERTPARAM;
         If SCommand='DELETEPARAM'     Then Command:=CMD_DELETEPARAM;
         If SCommand='INSERTLINE'      Then Command:=CMD_INSERTLINE;
         If SCommand='DELETELINE'      Then Command:=CMD_DELETELINE;
         If SCommand='DELETELINES'     Then Command:=CMD_DELETELINES;
         If SCommand='UPPER'           Then Command:=CMD_UPPER;
         If SCommand='MIDDER'          Then Command:=CMD_MIDDER;
         If SCommand='LOWER'           Then Command:=CMD_LOWER;
         If SCommand='DEFINE'          Then Command:=CMD_DEFINE;
         If SCommand='REPLACEHEXA'     Then Command:=CMD_REPLACEHEXA;
         If SCommand='INSERTBLOCK'     Then Command:=CMD_INSERTBLOCK;
         If SCommand='DELETEBLOCK'     Then Command:=CMD_DELETEBLOCK;
         If SCommand='DELETEOCCURENCE' Then Command:=CMD_DELETEOCCURENCE;
         If SCommand='SKIP'            Then Command:=CMD_SKIP;
         If SCommand='EXIT'            Then Command:=CMD_EXIT;
         If SCommand='WRITE'           Then Command:=CMD_WRITE;
         If SCommand='CLS'             Then Command:=CMD_CLS;

         If (Command=CMD_DEFINE) And (P_Is=0) Then  {*Il manque le "Is"*}
            Begin PRINT_ERROR(14,St); Command:=-1; End;
         If (Command=CMD_SKIP) And (P_Is=0) Then    {*Il manque le "Is"*}
            Begin PRINT_ERROR(14,St); Command:=-1; End;
         If (Command=CMD_REPLACESTRING) And (P_By=0) Then {*Il manque le "By"*}
            Begin PRINT_ERROR(17,St); Command:=-1; End;
         If (Command=CMD_REPLACEITEM) And (P_By=0) Then {*Il manque le "By"*}
            Begin PRINT_ERROR(17,St); Command:=-1; End;
         If (Command=CMD_REPLACEHEXA) And (P_By=0) Then {*Il manque le "By"*}
            Begin PRINT_ERROR(17,St); Command:=-1; End;
         If (Command=CMD_INSERTPARAM) And (P_In=0) Then {*Il manque le "In"*}
            Begin PRINT_ERROR(18,St); Command:=-1; End;
         If (Command=CMD_DELETEPARAM) And (P_In=0) Then {*Il manque le "In"*}
            Begin PRINT_ERROR(18,St); Command:=-1; End;
         If (Command=CMD_INSERTPARAM) And (P_At=0) Then {*Il manque le "At"*}
            Begin PRINT_ERROR(19,St); Command:=-1; End;
         If (Command=CMD_INSERTBLOCK) And (P_Pos=0) Then {*Il manque le "Pos"*}
            Begin PRINT_ERROR(24,St); Command:=-1; End;
         If (Command=CMD_DELETEBLOCK) And (P_Size=0) Then {*Il manque le "Size"*}
            Begin PRINT_ERROR(25,St); Command:=-1; End;
         If (Command=CMD_DELETELINES) And (P_Size=0) Then {*Il manque le "Size"*}
            Begin PRINT_ERROR(25,St); Command:=-1; End;
         If (Command=CMD_DELETEOCCURENCE) And (P_After=0) Then {*Il manque le "After"*}
            Begin PRINT_ERROR(28,St); Command:=-1; End;
         If ((Command=CMD_INSERTBLOCK) Or (Command=CMD_DELETEBLOCK)) Then
            Begin
            Val(STarget,P_Pa,Code);                 {*Valeur Incorecte*}
            If Code<>0 Then PRINT_ERROR(21,St);
            If P_Pa<0  Then PRINT_ERROR(20,St);
            End;
         If (Command=CMD_DELETEBLOCK) Then
            Begin
            Val(SSource,P_Pa,Code);                 {*Valeur Incorecte*}
            If Code<>0 Then PRINT_ERROR(21,St);
            If P_Pa<0  Then PRINT_ERROR(20,St);
            End;
         If (Command=CMD_DELETEOCCURENCE) Then
            Begin
            Val(STarget,P_Pa,Code);                 {*Valeur Incorecte*}
            If Code<>0 Then PRINT_ERROR(21,St);
            If P_Pa<0  Then PRINT_ERROR(20,St);
            End;
         If (Command=CMD_DELETELINES) Then
            Begin
            Val(STarget,P_Pa,Code);                 {*Valeur Incorecte*}
            If Code<>0 Then PRINT_ERROR(21,St);
            If P_Pa<0  Then PRINT_ERROR(20,St);
            End;
         If (Command=CMD_INSERTPARAM) And (P_In>0) Then
            Begin                                   {*Il y a un 3eme Paramtre*}
            Val(SParam,P_Pa,Code);
            If Code<>0 Then PRINT_ERROR(21,St);
            If P_Pa<0  Then PRINT_ERROR(20,St);
            End;
         If (Command=CMD_DELETEPARAM) And (P_In>0) Then
            Begin
            Val(SSource,P_Pa,Code);
            If Code<>0 Then PRINT_ERROR(21,St);
            If P_Pa<0  Then PRINT_ERROR(20,St);
            End;
{         If (Command=CMD_INSERTPARAM) And (P_C3o=0) And (P_C3c=0) Then PRINT_ERROR(27,St);}

         If (Command=CMD_INSERTLINE) Then
            Begin
            If (P_After=0) And (P_Before=0) Then    {*Il manque "Before" ou "After"*}
               Begin PRINT_ERROR(22,St); Command:=-1; End;
            If (P_After>0) And (P_Before>0) Then    {*Il y a "Before" et "After"*}
               Begin PRINT_ERROR(23,St); Command:=-1; End;
            If (P_Before>0) Then                    {*C'est "Before" !*}
               Begin Command:=CMD_INSERTLINEBEFORE; End;
            If (P_After>0) Then                     {*C'est "After" !*}
               Begin Command:=CMD_INSERTLINEAFTER; End;
            End;

         If (Command=CMD_EXIT) Then
         Begin
         Inc(Infos[CMD_EXIT].Qtt_Done);
         LOAD_COMMAND_FILE:=0;          {*On ne termine pas le fichier de Commandes*}
         Exit;
         End;

         If Command>0 Then
            Begin
            If Qtt_Cmd>=Max_Actions Then
               Begin
               PRINT_ERROR(26,St);
               LOAD_COMMAND_FILE:=-4;   {*Tableau is Full !*}
               Exit;
               End;
            Inc(Qtt_Cmd);               {*1 Commande de Plus*}
            Actions[Qtt_Cmd].Command:=Command; {*Set in Array...*}
            Actions[Qtt_Cmd].Source:=SSource;
            Actions[Qtt_Cmd].Target:=STarget;
            Actions[Qtt_Cmd].Position:=P_Pa;
            Actions[Qtt_Cmd].QttFound:=0;   {! Attention, il faut reseter cette variable entre chaque fichiers}
            Actions[Qtt_Cmd].Busy:=FALSE;
            Infos[Actions[Qtt_Cmd].Command].Qtt_Done:=0;
            End;

         If (Command=0) Then PRINT_ERROR(3,St);{*Commande Inconnue*}
         End;                           {*Fin "Analyse de la Commande"*}

      LOAD_COMMAND_FILE:=0;             {*Ok*}
      End
   End
   Else Begin
   LOAD_COMMAND_FILE:=-1;               {*Error pas de Commandes ou Autre...*}
   Exit;
   End;

If Qtt_Cmd=0 Then LOAD_COMMAND_FILE:=-3;{*EOF Without any Commands*}
End;

{ͻ
                    AFFICHE LE RESULTAT DE LA COMPILATION                   
 ͼ}

Procedure SHOW_RESULTS_COMPILATION;
Var I:Integer;
Begin
If Not NoMess Then
   Begin
   If Err_Cmd>0 Then Writeln;
   Writeln('   Analysed Lines......: ',Qtt_Line);
   Writeln('   Skipped Lines.......: ',Qtt_Rem);
   Writeln('   Loaded Commands.....: ',Qtt_Cmd);
   Writeln('   Errors in Commands..: ',Err_Cmd);
   Writeln;
   End;
End;

{ͻ
                   AFFICHE TOUTES LE COMMANDES MEMORISEE                    
 ͼ}

Procedure SHOW_COMMANDS;          {* Only for DEBUGGING *}
Var I:Integer;
Begin
If Not NoMess Then
   Begin
   For I:=1 to Qtt_Cmd do
      Writeln(Actions[I].Command:2,' = ',Infos[Actions[I].Command].Info,' "',Actions[I].Source,'" "',
              Actions[I].Target,'" [',Actions[I].Position,']');
   End;
End;

{ͻ
                  PROCEDURE APELLEE A CHAQUE FICHIER TRAITE                 
 ͼ}

Function MODIFY_SOURCE(FSource,FTarget:String):Integer;
Var FIn,FOut:Text;
    StIn,StOut:String;                  {*Ligne en Entre et Sortie*}
    StInTest:String;                    {*Ligne en Entre Mais Modifie*}
    StOutTest:String;                   {*Ligne en Sortie Mais Modifie*}
    Source,Target:String;               {*Source et Target*}
    Add_Line_Before:String;             {*Ligne  Insrer Avant...*}
    Add_Line_After:String;              {*Ligne  Insrer Aprs...*}
    Add_Line_BeforeB:Boolean;
    Add_Line_AfterB:Boolean;
    A,B,C:Integer;
    KeepJustify:Boolean;                {*Justifie si Possible*}
    CaseSensitive:Boolean;              {*Est ou pas CaseSensitive*}
    SkipBlankLines:Boolean;             {*Skip ou pas les Lignes Vides*}
    IsBlankLine:Boolean;                {*Ligne Vide*}
    No_Line:Boolean;                    {*Ligne en Sortie pas Ecrite*}
    No_Lines:Boolean;                   {*Suppression de Blocks*}
    P1,P2,P3:Integer;                   {*Positions*}
    S1:Integer;                         {*Sizes*}
    St1:String;                         {*Temporaire*}
    PrevSt:String;                      {*Previous String Before Transformation*}
    Code:Integer;                       {*Code pour "Val"*}
    Tag:Byte;                           {*Tag Quantit d'Actions Faite*}
    Result:Byte;                        {*Pour Insert/Delete Param =>Resultat*}
    Qtt_Line_File:Integer;              {*Nombre de Lignes Lues*}
    NoSub_String:Boolean;               {*Ce n'est pas une Sous-Chaine*}

Begin
MODIFY_SOURCE:=0;
KeepJustify:=Yes;                       {*Justifie si Possible*}
CaseSensitive:=False;                   {*N'est pas CaseSensitive*}
SkipBlankLines:=False;                  {*Ne Saute pas les Lignes Vides*}
Qtt_Line_File:=0;                       {*Qtt Lignes Lues=0*}

Assign(FIn,FSource);                    {*Source et Detination*}
Assign(FOut,FTarget);
{$I-}
Reset(FIn);                             {*Open Source File*}
Rewrite(FOut);                          {*Create Target File*}
{$I+}
If IOResult=0 Then                      {*No Errors ? => Ok !*}
   Begin
   While Not Eof(FIn) Do                {*Parcours toutes les Lignes*}
      Begin
      Readln(FIn,StIn);
      Inc(Qtt_Line_File);               {*1 Ligne Lue de Plus*}
      Add_Line_After:='';               {*Init Lignes  Ajouter*}
      Add_Line_Before:='';
      Add_Line_AfterB:=False;
      Add_Line_BeforeB:=False;
      No_Line:=False;
      StOut:=StIn;                      {*De Base, la mme Phrase que la Source*}
      IsBlankLine:=TEST_EMPTY_STRING(StOut);

      If CaseSensitive Then             {=== FIRST PASSAGE===}
         Begin                          {*Est Case Sensitive*}
         Source:=Actions[A].Source;
         Target:=Actions[A].Target;
         StInTest:=StIn;
         End
         Else Begin                     {*N'est pas Case Sensitive*}
         Source:=Upper(Actions[A].Source);
         Target:=Upper(Actions[A].Target);
         StInTest:=Upper(StIn);
         End;

      For A:=1 to Qtt_Cmd do            {*Parcours toutes les Commandes*}
         Begin
         If CaseSensitive Then          {=== SECOND PASSAGE ===}
            Begin                       {*Est Case Sensitive*}
            Source:=Actions[A].Source;
            Target:=Actions[A].Target;
            StInTest:=StOut;
            End
            Else Begin                  {*N'est pas Case Sensitive*}
            Source:=Upper(Actions[A].Source);
            Target:=Upper(Actions[A].Target);
            StInTest:=Upper(StOut);
            End;

         PrevSt:=StInTest;              {*Stocke String Before Modif*}

         Case Actions[A].Command of
            CMD_DEFINE: Begin           {*On Dfinie*}
               If Upper(Source)='CASESENSITIVE' Then
                  If Upper(Target)='NO' {*CASE SENSITIVE*}
                     Then CaseSensitive:=False
                     Else CaseSensitive:=True;
               If Upper(Source)='KEEPJUSTIFY' Then
                  If Upper(Target)='NO' {*KEEP JUSTIFY*}
                     Then KeepJustify:=False
                     Else KeepJustify:=True;
               Inc(Infos[Actions[A].Command].Qtt_Done);
               End;

            CMD_SKIP: Begin             {*On Dfinie SKIP BLANK LINES*}
               If Upper(Source)='BLANKLINES' Then
                  If Upper(Target)='NO'
                     Then SkipBlankLines:=False
                     Else SkipBlankLines:=True;
               End;

            CMD_REPLACESTRING: Begin    {*Remplace un String*}
               Tag:=0;
               P1:=Pos(Source,StInTest);
               While P1>0 do            {*Fait toute la Phrase...*}
                  Begin
                  Delete(StOut,P1+Tag,Length(Source));
                  Insert(Actions[A].Target,StOut,P1+Tag);
                  StInTest:=Copy(StInTest,P1+Length(Source),255);{*Enlve ce qui  t Fait*}
                  Tag:=Tag+P1+Length(Target)-1; {*On dcale de P1 en Avant*}
                  P1:=Pos(Source,StInTest);
                  Inc(Infos[Actions[A].Command].Qtt_Done);
                  End;
               End;

            CMD_DELETESTRING: Begin     {*Supprime un String*}
               Tag:=0;
               P1:=Pos(Source,StInTest);
               While P1>0 do            {*Fait toute la Phrase...*}
                  Begin
                  Delete(StOut,P1+Tag,Length(Source));
                  StInTest:=Copy(StInTest,P1+Length(Source),255);{*Enlve ce qui  t Fait*}
                  Tag:=Tag+P1+Length(Target)-1; {*On dcale de P1 en Avant*}
                  P1:=Pos(Source,StInTest);
                  Inc(Infos[Actions[A].Command].Qtt_Done);
                  End;
               End;

            CMD_REPLACEITEM: Begin      {*Remplace un Item*}
               Tag:=0;
               P1:=Pos(Source,StInTest);
               While P1>0 do            {*Fait toute la Phrase...*}
                  Begin
                  If ((P1-1=0) Or  (TEST_CHAR_NAME(StInTest[P1-1])=False))
                               And (TEST_CHAR_NAME(StInTest[P1+Length(Source)])=False) Then
                     Begin
                     Delete(StOut,P1+Tag,Length(Source));
                     Insert(Actions[A].Target,StOut,P1+Tag);
                     Inc(Infos[Actions[A].Command].Qtt_Done);
                     End;
                  StInTest:=Copy(StInTest,P1+Length(Source),255);{*Enlve ce qui  t Fait*}
                  Tag:=Tag+P1+Length(Target)-1; {*On dcale de P1 en Avant*}
                  P1:=Pos(Source,StInTest);
                  End;
               End;

            CMD_DELETEITEM: Begin       {*Supprime un Item*}
               Tag:=0;
               P1:=Pos(Source,StInTest);
               While P1>0 do            {*Fait toute la Phrase...*}
                  Begin
                  If ((P1-1=0) Or  (TEST_CHAR_NAME(StInTest[P1-1])=False))
                               And (TEST_CHAR_NAME(StInTest[P1+Length(Source)])=False) Then
                     Begin
                     Delete(StOut,P1+Tag,Length(Source));
                     Inc(Infos[Actions[A].Command].Qtt_Done);
                     Tag:=Tag-Length(Source);
                     End;
                  StInTest:=Copy(StInTest,P1+Length(Source),255);{*Enlve ce qui  t Fait*}
                  Tag:=Tag+P1+Length(Target)+Length(Source)-1; {*On dcale de P1 en Avant*}
                  P1:=Pos(Source,StInTest);
                  End;
               End;

            CMD_INSERTPARAM: Begin      {*Insre un Paramtre*}
               Tag:=0;
               P1:=Pos(Target,StInTest);
               While P1>0 do            {*Fait toute la Phrase...*}
                  Begin
                  If ((P1-1=0) Or  (TEST_CHAR_NAME(StInTest[P1-1])=False))
                               And (TEST_CHAR_NAME(StInTest[P1+Length(Target)])=False)
                     Then NoSub_String:=True else NoSub_String:=False;
                  If NoSub_String Then
                     Begin              {*Ce n'est pas une Sous-Chaine...*}
                     P2:=GET_POS_PARAM(Target,StInTest,Actions[A].Position,Result);
{Writeln('Action-1=',Actions[A].Position-1,' QttPar=',GET_QTT_PARAM(Target,StInTest));}
                     If (P2>0) And ((Result=1) Or (Result=2)) Then
                        Begin           {*Dbut et Milieu*}
                        Insert(Actions[A].Source+',',StOut,P2+Tag);
                        Inc(Infos[Actions[A].Command].Qtt_Done);
                        End;
                     If (P2>0) And (Result=3) Then
                        Begin           {*Avant Dernier*}
                        Insert(','+Actions[A].Source,StOut,P2+Tag);
                        Inc(Infos[Actions[A].Command].Qtt_Done);
                        End;
                     If (P2=0) And (Result=0) And (GET_QTT_PARAM(Target,StInTest)=Actions[A].Position-1) Then
                        Begin           {*Dernier*}
                        P3:=Pos(Target,StInTest);
                        P2:=Pos(')',Copy(StInTest,P3,255))+P3-1;
                        Insert(','+Actions[A].Source,StOut,P2+Tag);
                        Inc(Infos[Actions[A].Command].Qtt_Done);
                        End;
                     End;               {*Fin Test_Char_Name*}

{Writeln('P2+Tag=',P2+Tag,'  Result=',Result,' QttPar=',GET_QTT_PARAM(Target,StInTest));
Gotoxy(P2+Tag,WhereY); Writeln(Copy('',1,Length(Source)));}
                  StInTest:=Copy(StInTest,P1+Length(Target),255);{*Enlve ce qui  t Fait*}
                  If NoSub_String Then Tag:=Tag+P1+Length(Target)+Length(Source)  {*On dcale de P1 en Avant*}
                                  Else Tag:=Tag+P1+Length(Target)-1;
                  P1:=Pos(Target,StInTest);
                  End;                  {*End du While*}
               End;

            CMD_DELETEPARAM: Begin      {*Supprime un Paramtre*}
               Tag:=0;
               P1:=Pos(Target,StInTest);
               While P1>0 do            {*Fait toute la Phrase...*}
                  Begin
                  If ((P1-1=0) Or  (TEST_CHAR_NAME(StInTest[P1-1])=False))
                               And (TEST_CHAR_NAME(StInTest[P1+Length(Target)])=False)
                     Then NoSub_String:=True else NoSub_String:=False;
                  If NoSub_String Then
                     Begin              {*Ce n'est pas une Sous-Chaine...*}
                     P2:=GET_POS_PARAM(Target,StInTest,Actions[A].Position,Result);
                     If P2>0 Then Begin
                        S1:=GET_NEXT_PARAM(Copy(StInTest,P2+1,255))+1;
                        Delete(StOut,P2+Tag,S1);
                        Inc(Infos[Actions[A].Command].Qtt_Done);
                        End;
                     End;               {*Fin de Test_Char_Name...*}
                  StInTest:=Copy(StInTest,P1+Length(Target),255);{*Enlve ce qui  t Fait*}
                  If NoSub_String Then Tag:=Tag+P1+Length(Target)-S1-1 {*On dcale de P1 en Avant*}
                                  Else Tag:=Tag+P1+Length(Target)*2-S1;
                  P1:=Pos(Target,StInTest);
                  End;
               End;

            CMD_INSERTLINEBEFORE: Begin {*On Insre Une Ligne "Before"*}
               If (Pos(Target,StInTest)>0) Or (Target=StInTest) Then
                  Begin
                  Add_Line_Before:=Source;
                  Add_Line_BeforeB:=True;
                  Inc(Infos[CMD_INSERTLINE].Qtt_Done);
                  End;
               End;

            CMD_INSERTLINEAFTER: Begin  {*On Insre Une Ligne "After"*}
               If (Pos(Target,StInTest)>0) Or (Target=StInTest) Then
                  Begin
                  Add_Line_After:=Source;
                  Add_Line_AfterB:=True;
                  Inc(Infos[CMD_INSERTLINE].Qtt_Done);
                  End;
               End;

            CMD_DELETELINE: Begin       {*On Delete Une Ligne*}
               If (Pos(Source,StInTest)>0) Or (Source=StInTest) Then
                  Begin
                  No_Line:=True;
                  Inc(Infos[Actions[A].Command].Qtt_Done);
                  End;
               End;

            CMD_DELETELINES: Begin      {*On Delete Plusieurs Lignes*}
               If (Pos(Source,StInTest)>0) Or (Source=StInTest) Then
                  Actions[A].Busy:=TRUE;{*Occup  Deleter...*}
               If Actions[A].Busy Then Begin
                  Inc(Actions[A].QttFound); {*1 Ligne de -*}
                  Inc(Infos[CMD_DELETELINE].Qtt_Done);
                  If Actions[A].QttFound>Actions[A].Position Then Begin
                     Actions[A].QttFound:=0;
                     Actions[A].Busy:=FALSE;{*Suppression Finie...*}
                     Dec(Infos[CMD_DELETELINE].Qtt_Done);{-1 Correction !}
                     End;
                  End;
               End;

            CMD_DELETEOCCURENCE: Begin  {*Delete String After une Certaine Qtt*}
               Tag:=0;
               P1:=Pos(Source,StInTest);
               While P1>0 do            {*Fait toute la Phrase...*}
                  Begin
                  If ((P1-1=0) Or  (TEST_CHAR_NAME(StInTest[P1-1])=False))
                               And (TEST_CHAR_NAME(StInTest[P1+Length(Source)])=False) Then
                     Begin
{writeln('XXX=',Actions[A].Position);}
                     Inc(Actions[A].QttFound);
                     If Actions[A].QttFound > Actions[A].Position Then
                        Begin           {*Delete String...*}
                        Delete(StOut,P1+Tag,Length(Source));
                        Inc(Infos[Actions[A].Command].Qtt_Done);
                        Tag:=Tag-Length(Source)-1;
                        End;
                     End Else Dec(Tag);
                  StInTest:=Copy(StInTest,P1+Length(Source),255);{*Enlve ce qui  t Fait*}
                  Tag:=Tag+P1+Length(Target)+Length(Source)-1; {*On dcale de P1 en Avant*}
                  P1:=Pos(Source,StInTest);
                  End;
               End;

            CMD_LOWER: Begin            {*Passe en Minuscules*}
               Tag:=0;
               P1:=Pos(Source,StInTest);
               While P1>0 do            {*Fait toute la Phrase...*}
                  Begin
                  Delete(StOut,P1+Tag,Length(Source));
                  St1:=Lower(Source);
                  Insert(St1,StOut,P1+Tag);
                  StInTest:=Copy(StInTest,P1+Length(Source),255);{*Enlve ce qui  t Fait*}
                  Tag:=Tag+P1+Length(Source)-1; {*On dcale de P1 en Avant*}
                  P1:=Pos(Source,StInTest);
                  Inc(Infos[Actions[A].Command].Qtt_Done);
                  End;
               End;

            CMD_MIDDER: Begin           {*Passe en Midder*}
               Tag:=0;
               P1:=Pos(Source,StInTest);
               While P1>0 do            {*Fait toute la Phrase...*}
                  Begin
                  Delete(StOut,P1+Tag,Length(Source));
                  St1:=Midder(Source);
                  Insert(St1,StOut,P1+Tag);
                  StInTest:=Copy(StInTest,P1+Length(Source),255);{*Enlve ce qui  t Fait*}
                  Tag:=Tag+P1+Length(Source)-1; {*On dcale de P1 en Avant*}
                  P1:=Pos(Source,StInTest);
                  Inc(Infos[Actions[A].Command].Qtt_Done);
                  End;
               End;

            CMD_UPPER: Begin            {*Passe en Majuscules*}
               Tag:=0;
               P1:=Pos(Source,StInTest);
               While P1>0 do            {*Fait toute la Phrase...*}
                  Begin
                  Delete(StOut,P1+Tag,Length(Source));
                  St1:=Upper(Source);
                  Insert(St1,StOut,P1+Tag);
                  StInTest:=Copy(StInTest,P1+Length(Source),255);{*Enlve ce qui  t Fait*}
                  Tag:=Tag+P1+Length(Source)-1; {*On dcale de P1 en Avant*}
                  P1:=Pos(Source,StInTest);
                  Inc(Infos[Actions[A].Command].Qtt_Done);
                  End;
               End;

            CMD_CLS: Begin              {*On efface l'cran*}
                  ClrScr;
                  Inc(Infos[CMD_CLS].Qtt_Done);
               End;

            CMD_WRITE: Begin            {*On affiche un Message*}
                  If Qtt_Line_File=1 Then Begin
                     Writeln(Actions[A].Source);
                     Inc(Infos[CMD_WRITE].Qtt_Done);
                     End;
               End;

            CMD_INSERTBLOCK: Begin      {*On Insre un Block  une Position*}
                  Val(Target,P1,Code);
                  Insert(Source,StOut,P1);
                  Inc(Infos[Actions[A].Command].Qtt_Done);
               End;

            CMD_DELETEBLOCK: Begin      {*On Vire un Block  une Position*}
                  Val(Source,P1,Code);
                  Val(Target,P2,Code);
                  Delete(StOut,P1,P2);
                  Inc(Infos[Actions[A].Command].Qtt_Done);
               End;

            End;                        {=== END DU CASE ===}

         If (SkipBlankLines) And (IsBlankLine) Then
            Begin                       {*Skip Blank Lines*}
            StOut:=PrevSt;
            Inc(Infos[CMD_SKIP].Qtt_Done);
            End;

         End;                           {*End du For*}

      No_Lines:=FALSE;                  {*Init Test de Supression de Blocks*}
      For C:=1 to Qtt_Cmd do            {*Parcours toutes les Commandes*}
          If Actions[C].Busy Then No_Lines:=TRUE;{*Au Moins une suppression  faire !*}

      If Add_Line_BeforeB Then Writeln(FOut,Add_Line_Before);
      If (Not No_Line) And (No_Lines=FALSE) Then Writeln(FOut,StOut);
      If Add_Line_AfterB  Then Writeln(FOut,Add_Line_After);
      End;                              {*End While Not Eof*}

   If Qtt_Line_File>0 Then              {*Calcul Qtt Commandes "Define"*}
      Infos[CMD_DEFINE].Qtt_Done:=Infos[CMD_DEFINE].Qtt_Done Div Qtt_Line_File;
   If Qtt_Cmd>0 Then                    {*Calcul Qtt "Skipped Blank Lines"*}
      Infos[CMD_SKIP].Qtt_Done:=Infos[CMD_SKIP].Qtt_Done Div Qtt_Cmd;

   Close(FIn);                          {*Close les Deux Fichiers*}
   Close(FOut);
   End;
End;

{ͻ
                  AFFICHE LES RESULTATS DE LA TRANSFORMATION                
 ͼ}

Procedure SHOW_FILE_RESULT;             {*Affiche les Rsultats de la Transformation*}
Var A:Integer;
Begin
If NoMess Then Exit;
A:=1;
Repeat                                  {*Parcours toutes les Commandes*}
   If (A<>CMD_INSERTLINEBEFORE) And (A<>CMD_INSERTLINEAFTER) And (A<>CMD_DELETELINES)
      And (A<>CMD_WRITE) And (A<>CMD_CLS)
      Then Write  (Infos[A].Info,' ',Infos[A].Qtt_Done:3,'  ');
   Inc(A);                              {*Next Value*}
   If (A<>CMD_INSERTLINEBEFORE) And (A<>CMD_INSERTLINEAFTER) And (A<>CMD_DELETELINES)
      And (A<>CMD_WRITE) And (A<>CMD_CLS)
      Then Writeln(Infos[A].Info,' ',Infos[A].Qtt_Done:3);
   Inc(A);                              {*Next Value*}
Until A>=LAST_COMMAND;
End;

{ͻ
                   EFFACE LES RESULTATS DE LA TRANSFORMATION                
 ͼ}

Procedure CLEAR_DONE_COMMANDS;
Var A:Integer;
Begin
For A:=1 to Qtt_Cmd do                  {*Parcours toutes les Commandes*}
   Infos[Actions[A].Command].Qtt_Done:=0;

For A:=1 to Max_Actions do              {*Vide All dans Main Tableau*}
   Begin
   Actions[A].QttFound:=0;
   Actions[A].Busy:=FALSE;
   End;
End;

{ͻ
                  PROCEDURE APELLEE A CHAQUE FICHIER TRAITE                 
 ͼ}

Procedure FILE_ACTION(FName:PathStr);Far;
Var Res:Integer;
    FTarget:String;
    Fil1,Fil2:Text;
Begin
DoneOne:=True;
FSplit(FName,FD,FN,FE);                 {*Split Filename*}
If Backup Then Begin
   File_Copy(FName,FD+FN+'.BAK');    {*Backup du fichier*}
   End;

If Not NoMess Then Write(FName);        {*Affiche le Nom du Fichier*}

If File_GetSize(FName)=0 Then        {*Check File Size >0*}
   Begin
   If Not NoMess Then Begin
      Textcolor(LightRed);
      Writeln(' File empty...');
      Textcolor(LightGray);
      End;
   Exit;
   End;

CLEAR_DONE_COMMANDS;                    {*Efface les Rsultats Prcdents*}

FTarget:=FD+FN+'.TMP';
Res:=MODIFY_SOURCE(FName,FTarget);      {*On Modifie la Source*}

If Not NoMess Then
   Begin
   If Res=0 Then Begin
      Textcolor(Yellow);                {*Tout est Ok !*}
      Writeln(' Ok');
      Textcolor(LightGray);
      Assign(Fil1,FName);               {*Pour Supression et Renomage*}
      Assign(Fil2,FTarget);
      Erase(Fil1);                      {*Delete et...*}
      Rename(Fil2,FName);               {*Rename*}
      End
      Else Begin                        {*Ya eu un Bug !*}
      Textcolor(LightRed);
      Writeln(' Cannot convert this file...');
      Textcolor(LightGray);
      End;
   End;

If Info_Conv Then SHOW_FILE_RESULT;     {*Affiche les Rsultats de la Transformation*}
End;

{ͻ
                     PROGRAMME PRINCIPAL (INITIALISATIONS)                  
 ͼ}

Begin
Alias:=False;                           {*Initialisations de Bases...*}
DoneOne:=False;
FPath:='';
Mask:='*.*';                            {*Au cas o ce ne serais pas dfinit*}
Qtt_Cmd:=0;
Qtt_Rem:=0;
Err_Cmd:=0;
Info_Conv:=False;
Source:=Dsk_GetCurrentDirectory;
Command_File:='MSC.CMD';                {*Fichier de Base*}
TextColor(7);

Par:='/NM';
If Parameter(Par)>0 Then NoMess:=True Else NoMess:=False;

If Not NoMess Then Clrscr;              {*Clear Screen*}

Par:='/Author';
If (Parameter(Par)>0) Then Zuul_Info;   {*Sybaris or Zuul Infos*}

Par:='/?';
If (Parameter(Par)>0) Then Help
   Else
   If Not NoMess Then Begin             {*Titre Logiciel*}
      Writeln(Program_Name,' ',Ver_Num,' - ',Copyright);
      Writeln;
      End;

Par:='/S';                              {*Parcours en Rcursif...*}
If Parameter(Par)>0 Then Sub:=Yes Else Sub:=No;

Par:='/B';                              {*Create Backup per File...*}
If Parameter(Par)>0 Then Backup:=Yes Else Backup:=No;

Par:='/I';                              {*Infos Dtaills sur Convertion...*}
If Parameter(Par)>0 Then Info_Conv:=Yes Else Info_Conv:=No;

Par:='/C';                              {*Uses Specified Command File...*}
If Parameter(Par)>0 Then
   If Par<>'/C' Then Command_File:=Par;

If Paramcount<1 Then Begin              {*Pas assez de Paramtres*}
   If Not NoMess Then Writeln('Not enougth parameters...');
   Exit;
   End;

{******************** RECHERCHE DU OU DES NOMS DE FICHIERS  *****************}

For A:=1 to ParamCount do               {*Rcupre le Nom du Fichier SOURCE*}
   If Copy(ParamStr(A),1,1)<>'/' Then Source:=Upper(ParamStr(A));
If Source='' Then Begin                 {*Pas de Source Spcifie*}
   If Not NoMess Then Writeln('Source file not specified...');
   Exit;
   End;

{******************** CHARGEMENT DES COMMANDES EN MEMOIRE *******************}

FILL_COMMANDS_INFO;                     {*Remplis les Infos Commandes*}

If Not NoMess Then Writeln('Reading Command file "',Command_File,'"...');
ResCom:=LOAD_COMMAND_FILE(Command_File);
If ResCom<>0 Then
   Begin
   If (ResCom=-1) And (Not NoMess) Then Writeln('Cannot open Command file "',Command_File,'"...');
   If (ResCom=-2) And (Not NoMess) Then Writeln('File "',Command_File,'" is not a Command file...');
   If (ResCom=-3) And (Not NoMess) Then Writeln('End of File encountered without any commands...');
   If (ResCom=-4) And (Not NoMess) Then Writeln('Please use a smaller command file (Max=',Max_Actions,' commands)...');
   Exit;
   End;

SHOW_RESULTS_COMPILATION;               {*Affiche les Rsultats de la Compilation*}
{SHOW_COMMANDS;}

If Err_Cmd>0 Then                       {*ERROR ! => Stop Compilation*}
   Begin
   If Not NoMess Then Writeln('Compilation Aborted...');
   Exit;
   End
   Else If Not NoMess Then              {*C'est Ok pour la Suite...*}
      Begin
      Writeln('Compilation Successful...');
      Writeln;
      End;

{**************************** GESTION DES ALIAS *****************************}

FSplit(Source,FD,FN,FE);                {*Construit All*}
Source:=FD;
Mask:=FN+FE;
If (Mask='') Or (Mask='.') Then Mask:='*.*';

If Pos('*',Source)>0 Then Alias:=True;  {*Il y a des "*" dans le Nom*}

File_Find(Source+Mask,Sub,FILE_ACTION);

If (Not DoneOne) And (Not NoMess)       {*Aucun Fichiers Correspondants Trouvs*}
   Then Writeln('File(s) "',Mask,'" not found...');

TextColor(7);
If NoMess Then Gotoxy(1,WhereY-1);      {*The End...*}
End.
