{--------------------------------------------------------------------.
| Task_monitor |  Turbo Vision unit for monitoring DR-DOS' tasks.    |
|--------------'                                                     |
| Background tasking inside the TV system from TVLIFE by Ben Ziegler |
| Author: Gautier.deMontmollin@Maths.UniNe.CH         v. 14.VII.1998 |
`--------------------------------------------------------------------}

{$X+}

Unit Task_monitor;

interface

USES Objects, Drivers, Views;

TYPE
  P_task_mon_Interior = ^T_task_mon_Interior;
  T_task_mon_Interior = object(TScroller)
    cmIdle: word; { the Idle event is used to execute background tasks }
    constructor Init(var Bounds: TRect;
      AVScrollBar: PScrollBar; given_cmIdle: word);
    procedure   HandleEvent(var Event:TEvent); virtual;
    procedure   Update; virtual;
    procedure   Draw; virtual;
  end;

  P_task_mon_View     = ^T_task_mon_View;
  T_task_mon_View     = object(TWindow)
    MyInterior  : P_task_mon_Interior;
    constructor Init(given_cmIdle: word);
      { given_cmIdle: the Idle event is used to execute background tasks }
      { see example tmontest.pas for usage }
    procedure MakeInterior(Bounds: TRect; given_cmIdle: word);
    procedure   handleevent(var event : Tevent); virtual;
    procedure Close; virtual;
    end;

  function Task_manager_installed: boolean;

  const Open_TM_windows: byte=0;

{----------------------------------------------------------------------------}
implementation

uses OpenDOS;

var tictac: longint;

{ ******************* }
{ T_task_mon_Interior }
{ ******************* }

CONSTRUCTOR T_task_mon_Interior.Init(var Bounds: TRect;
  AVScrollBar: PScrollBar; given_cmIdle: word);
  var tasks, maximum_tasks, foreground_task_index: word;
BEGIN
   TScroller.Init(Bounds, NIL, AVScrollBar);
   cmIdle:= given_cmIdle;
   GrowMode  := gfGrowHiX + gfGrowHiY;
   Options   := Options OR ofFramed;
   EventMask := $FFFF;                   { Listen for all types of events }
   Get_status(tasks, maximum_tasks, foreground_task_index);
   SetLimit(0, maximum_tasks);
end;

PROCEDURE T_task_mon_Interior.Draw;
const ligne1='Name             Num       ID    Open files            Swap space  ';
      ligne2='Task manager *';
      coul_l1= 30; coul_nb= 27;
      coul_nm= 26;
var I, Y: Integer; B: TDrawBuffer;
    s_idx, s_id, s_openf, s_sw1, s_sw2: string[5]; fore,chtic: char;
    l: string[80];
    available_KB, total_KB: word;
    tasks, maximum_tasks, foreground_task_index: word;
begin
  Get_status(tasks, maximum_tasks, foreground_task_index);
  Get_swap_space_info(available_KB, total_KB);
  for Y := 0 to Size.Y-1 do begin
    MoveChar(B, ' ', coul_nb, Size.X);
    I := Delta.Y + Y;
    if Y=0 then begin
      if tictac and 4=0 then chtic:='.' else chtic:= ' ';
      MoveStr(B[1], ligne1 + chtic, coul_l1)
    end else if I=1 then begin
      MoveStr(B[1], ligne2, coul_nm);
      str(available_KB,s_sw1); str(total_KB,s_sw2);
      l:= s_sw1+ '/'+ s_sw2 + ' KB';
      MoveStr(B[66-length(l)], l, coul_nb);
    end else begin
      dec(I,2);
      if I>=0 then if I < tasks then if
         (Index_to_ID(I) <> invalid_task_ID) then begin
        if I=foreground_task_index then fore:= '<' else fore:= ' ';
        str(I+1:5,s_idx); str(Index_to_ID(I):5, s_id);
        str(Check_open_files(I):5,s_openf);
        MoveStr( B[1],  Get_task_name(I), coul_nm);
        MoveChar(B[14], fore, coul_nm, 1);
        MoveStr( B[16], s_idx,   coul_nb);
        MoveStr( B[25], s_id,    coul_nb);
        MoveStr( B[39], s_openf, coul_nb);
      end
    end;
    WriteLine(0, Y, Size.X, 1, B)
  end
end;

PROCEDURE T_task_mon_Interior.Update;
BEGIN
  IF VScrollBar <> NIL THEN
     VScrollBar^.SetParams(Delta.Y, 0, Limit.Y - Size.Y, Size.Y - 1, 1);
  Draw
END;

PROCEDURE T_task_mon_Interior.HandleEvent(var event : Tevent);
VAR p,o : Tpoint;
    systime: Longint absolute $40:$6C;       { sec / 18 }
    tasks, maximum_tasks, foreground_task_index: word;

  PROCEDURE CheckScrollBar(P: PScrollBar; VAR D: Integer);
  BEGIN
    IF (Event.InfoPtr = P) AND (P^.Value <> D) THEN BEGIN
      D := P^.Value;
      Update
    END
  END;

BEGIN
 tview.handleevent(event);

 IF event.what = evBroadCast THEN begin
    if event.command = cmIdle then begin
      if systime<>tictac then begin Update; tictac:= systime end
    end else if event.command = cmScrollBarChanged then
       CheckScrollBar(VScrollBar, Delta.Y)
 END;
 
 IF (event.what AND evMouseDown) <> 0 THEN
   if event.double then BEGIN
     Get_status(tasks, maximum_tasks, foreground_task_index);
     o := event.where; MakeLocal(o, p);
     if p.x<16 then begin
       inc(p.y,Delta.Y-2);
       if p.y=-1 then Switch_to_task_manager
       else if (p.y>=0) and (p.y<tasks) then
         if p.y<>foreground_task_index then Switch_to(p.y)
     end
   END
END;


{ *************** }
{ T_task_mon_View }
{ *************** }

CONSTRUCTOR T_task_mon_View.Init(given_cmIdle: word);
var Bounds: TRect;
BEGIN
 Bounds.Assign(2, 2, 52, 16);
 Twindow.init(Bounds, 'Task monitor', 0);
 inc(Open_TM_windows);

 GetClipRect(Bounds);
 Bounds.Grow(-1,-2);
 Inc(Bounds.B.y);
 MakeInterior(Bounds,given_cmidle);

 Options := Options OR (ofFirstClick OR ofTileable);
 dragmode := dmLimitLoY
END;

procedure T_task_mon_View.MakeInterior(Bounds: TRect; given_cmIdle: word);
var VScrollBar: PScrollBar; R: TRect;
begin
  VScrollBar := StandardScrollBar(sbVertical + sbHandleKeyboard);
  GetExtent(Bounds);
  Bounds.Grow(-1,-1);
  New(MyInterior, Init(Bounds, VScrollBar, given_cmIdle));
  Insert(MyInterior)
end;

PROCEDURE T_task_mon_View.HandleEvent(var event : Tevent);
  BEGIN
   { NOTE:  this must come before twindow.he or CRASH! }
   {..:=} Message(MyInterior, event.what, event.command, nil);
   Twindow.HandleEvent(event)
  END;

procedure T_task_mon_View.Close;
  begin TWindow.Close; dec(Open_TM_windows) end;

function Task_manager_installed: boolean;
  begin Task_manager_installed:= OpenDOS.Task_manager_installed end;

END.
