{$F+} { Compiler Directive: Generate far procedures calls: On } { Do not change! }
{$O+} { Compiler Directive: Generate overlay code: On }

(*****************************************************************************

  KeyBoard
    version 2.23

    This unit holds several low level routines used by the more advanced
    units based upon it.

    Purpose:
      This unit holds the keyboard interface used by several descendent
      units.

    Features:
      Several procedures in this unit are order dependent.
      Provisions included for Joystick and Pointer commands.

    Limitations:
      Error checking code is limited to ensure faster execution speed.

    Versions
      2.0 added features for block and other commands.
      2.1 added features for pointer and joystick interfacing.
      2.20 restructured the code for better idle time processing.
      2.21 added Pointer_Enter code to easily distinguish from Press_Enter.
      2.22 updated to work with the repaired pointer unit.
      2.23 updated to compile under Speed Pascal/2.

    Copyright 1989, 1996, All rights reserved.
      P. Renaud

    Compilers:
      Turbo Pascal versions 4.0 to 6.0.
      Speed Pascal/2 version Beta 4.

    Systems:
      MS-DOS, MDOS, OS/2.

*****************************************************************************)

Unit KeyBoard;

  Interface

    Uses
      CRT,
      DOS;

(***********************************************************

  These codes are the standard result codes returned by the
  Get_Command procedure.

***********************************************************)

    Const
      Press_F1 = 1;
      Press_F2 = 2;
      Press_F3 = 3;
      Press_F4 = 4;
      Press_F5 = 5;
      Press_F6 = 6;
      Press_F7 = 7;
      Press_F8 = 8;
      Press_F9 = 9;
      Press_F10 = 10;
      Press_F11 = 11;
      Press_F12 = 12;
      Press_End = 13;
      Press_Nul = 14;
      Press_Tab = 15;
      Press_Home = 16;
      Press_Enter = 17;
      Press_Escape = 18;
      Press_Insert = 19;
      Press_Delete = 20;
      Press_Page_Up = 21;
      Press_Numbers = 22; { any number character }
      Press_Up_Arrow = 23;
      Press_Shift_F1 = 24;
      Press_Shift_F2 = 25;
      Press_Shift_F3 = 26;
      Press_Shift_F4 = 27;
      Press_Shift_F5 = 28;
      Press_Shift_F6 = 29;
      Press_Shift_F7 = 30;
      Press_Shift_F8 = 31;
      Press_Shift_F9 = 32;
      Press_Shift_F10 = 33;
      Press_Shift_F11 = 34;
      Press_Shift_F12 = 35;
      Press_Page_Down = 36;
      Press_Scroll_Up = 37;
      Press_Word_Left = 38;
      Press_Control_H = 39;
      Press_Control_J = 40;
      Press_Control_K = 41;
      Press_Control_L = 42;
      Press_Control_M = 43;
      Press_Control_N = 44;
      Press_Control_O = 45;
      Press_Control_P = 46;
      Press_Control_Q = 47;
      Press_Control_T = 48;
      Press_Control_U = 49;
      Press_Shift_Tab = 50;
      Press_Control_B = 51;
      Press_Word_Right = 52;
      Press_Down_Arrow = 53;
      Press_Left_Arrow = 54;
      Press_Delete_End = 55;
      Press_Control_F1 = 56;
      Press_Control_F2 = 57;
      Press_Control_F3 = 58;
      Press_Control_F4 = 59;
      Press_Control_F5 = 60;
      Press_Control_F6 = 61;
      Press_Control_F7 = 62;
      Press_Control_F8 = 63;
      Press_Control_F9 = 64;
      Press_Control_F10 = 65;
      Press_Control_F11 = 66;
      Press_Control_F12 = 67;
      Press_Alternate_0 = 68;
      Press_Alternate_1 = 69;
      Press_Alternate_2 = 70;
      Press_Alternate_3 = 71;
      Press_Alternate_4 = 72;
      Press_Alternate_5 = 73;
      Press_Alternate_6 = 74;
      Press_Alternate_7 = 75;
      Press_Alternate_8 = 76;
      Press_Alternate_9 = 77;
      Press_Alternate_A = 78;
      Press_Alternate_B = 79;
      Press_Alternate_C = 80;
      Press_Alternate_D = 81;
      Press_Alternate_E = 82;
      Press_Alternate_F = 83;
      Press_Alternate_G = 84;
      Press_Alternate_H = 85;
      Press_Alternate_I = 86;
      Press_Alternate_J = 87;
      Press_Alternate_K = 88;
      Press_Alternate_L = 89;
      Press_Alternate_M = 90;
      Press_Alternate_N = 91;
      Press_Alternate_O = 92;
      Press_Alternate_P = 93;
      Press_Alternate_Q = 94;
      Press_Alternate_R = 95;
      Press_Alternate_S = 96;
      Press_Alternate_T = 97;
      Press_Alternate_U = 98;
      Press_Alternate_V = 99;
      Press_Alternate_W = 100;
      Press_Alternate_X = 101;
      Press_Alternate_Y = 102;
      Press_Alternate_Z = 103;
      Press_Control_End = 104;
      Press_Right_Arrow = 105;
      Press_Scroll_Down = 106;
      Press_Delete_Line = 107;
      Press_Restore_Line = 108;
      Press_Delete_Arrow = 109;
      Press_Control_Home = 110;
      Press_Alternate_F1 = 111;
      Press_Alternate_F2 = 112;
      Press_Alternate_F3 = 113;
      Press_Alternate_F4 = 114;
      Press_Alternate_F5 = 115;
      Press_Alternate_F6 = 116;
      Press_Alternate_F7 = 117;
      Press_Alternate_F8 = 118;
      Press_Alternate_F9 = 119;
      Press_Alternate_F10 = 120;
      Press_Alternate_F11 = 121;
      Press_Alternate_F12 = 122;
      Press_Lower_Letters = 123; { any lowercase letter character }
      Press_Capital_Letters = 124; { any uppercase letter character }
      Press_Control_Page_Up = 125;
      Press_Extra_Characters = 126; { any punctuation character }
      Press_Control_Page_Down = 127;
      Press_Control_Left_Arrow = 128;
      Press_Control_Right_Arrow = 129;
      Press_Control_Print_Screen = 130;
     { These codes were defined as of version 2.0. }
      Press_Help = 131;
      Press_Search = 132;
      Press_Replace = 133;
      Press_Hide_Block = 134;
      Press_Copy_Block = 135;
      Press_Move_Block = 136;
      Press_Read_Block = 137;
      Press_Write_Block = 138;
      Press_Print_Block = 139;
      Press_Center_Text = 140;
      Press_Left_Margin = 141;
      Press_Right_Margin = 142;
      Press_Delete_Block = 143;
      Press_Move_Block_Top = 144;
      Press_Move_Block_End = 145;
      Press_Mark_Block_Top = 146;
      Press_Mark_Block_End = 147;
      Press_Other_Characters = 148;
     { These codes were defined as of version 2.1 }
      Pointer_Up = 149;
      Pointer_Down = 150;
      Pointer_Left = 151;
      Pointer_Right = 152;
      Outside_Up = 153;
      Outside_Down = 154;
      Outside_Left = 155;
      Outside_Right = 156;
      On_Frame_Top = 157;
      On_Frame_Left = 158;
      On_Frame_Right = 159;
      On_Frame_Bottom = 160;
     { These codes were defined as of version 2.22 }
      Pointer_Button1_Up = 161;
      Pointer_Button2_Up = 162;
      Pointer_Button1_Down = 163;
      Pointer_Button2_Down = 164;
      Pointer_Button1_Double = 165;
      Pointer_Button2_Double = 166;

      { These codes are default variables. }
      Pressed_Lock = Press_Control_L;
      Pressed_Move_Window_Up = Press_Control_Page_Up;
      Pressed_Move_Window_Down = Press_Control_Page_Down;
      Pressed_Move_Window_Left = Press_Control_Left_Arrow;
      Pressed_Move_Window_Right = Press_Control_Right_Arrow;
      Pressed_Expand_Window_Width = Press_Control_F4;
      Pressed_Reduce_Window_Width = Press_Control_F3;
      Pressed_Expand_Window_Height = Press_Control_F2;
      Pressed_Reduce_Window_Height = Press_Control_F1;

(***********************************************************

  These procedure allow linking between this unit and some
  of the other descendent units.

***********************************************************)

    Var
     {$IFNDEF VER40}

     { This procedure is invoked in Get_Command when Control L is pressed. }

      Lock_Routine: Procedure;

     { This procedure is invoked in Get_Command while waiting for input. }

      Wait_Routine: Procedure;

     { This function is invoked for allowing other units to provide input.
       It should return zero for nothing, otherwise it should return
       standard codes. }

      Alternative_Input: Function: Byte;

     { These are used by the alternate input routines to determine values. }
      Cursor_Row,
      Adjust_Amount,
      Cursor_Column_Start,
      Cursor_Column_Finish: Byte;
      Erase_Pointer,
      Update_Control: Procedure;
      Allow_Control: Boolean;

     {$ENDIF}

(***********************************************************

  These flags are set with the Peek procedure.
   {Not currently supported under OS/2}

***********************************************************)

      Key_Shift,
      Key_Insert,
      Key_Number,
      Key_Scroll,
      Key_Capital,
      Key_Control,
      Key_Alternate: Boolean;

(***********************************************************

  These flags are set with the Status procedure.
   {Not currently supported under OS/2}

***********************************************************)

      Key_Number_Lock,
      Key_Scroll_Lock,
      Key_Insert_Lock,
      Key_Capital_Lock: Boolean;

(***********************************************************

  This file is set up to use the standard keyboard input.

***********************************************************)

      Keys: Text;

(***********************************************************

  Procedure: Get command.

    This procedure reads in a key from the keyboard and
    returns it along with a result byte making it easier to
    identify function keys.

***********************************************************)

    Procedure Get_Command( Var Command: Char; Var Result: Byte );

(***********************************************************

  Procedure: Status.

    This procedure sets the flags to correspond with the
    current state of the keyboard toggle keys ( Num lock,
    Caps lock, Scroll lock, Insert ).
    { Not yet supported under OS/2 }

***********************************************************)

    Procedure Status;

(***********************************************************

  Procedure: Peek.

    This procedure sets the flags to correspond with the
    current state of the keyboard instant keys ( Shift,
    Control, Alternate, Insert... ).
    { Not yet supported under OS/2 }

***********************************************************)

    Procedure Peek;

(***********************************************************

  Function: Data Ready.

    This function returns true only if there is data ready
    to be read by Get_Command.

***********************************************************)

    Function Data_Ready: Boolean;

{----------------------------------------------------------------------------}

  Implementation

    Const
     { Standard codes returned for Get_Command procedure. }
      F1_Key = #59;
      F2_Key = #60;
      F3_Key = #61;
      F4_Key = #62;
      F5_Key = #63;
      F6_Key = #64;
      F7_Key = #65;
      F8_Key = #66;
      F9_Key = #67;
      F10_Key = #68;
      F11_Key = #133;
      F12_Key = #134;
      Nul_Key = #3;
      End_Key = #79;
      Tab_Key = #9;
      Home_Key = #71;
      Enter_Key = #13;
      Delete_Key = #83;
      Insert_Key = #82;
      Escape_Key = #27;
      Function_Key = #0;
      Page_Up_Key = #73;
      Up_Arrow_Key = #72;
      Shift_F1_Key = #84;
      Shift_F2_Key = #85;
      Shift_F3_Key = #86;
      Shift_F4_Key = #87;
      Shift_F5_Key = #88;
      Shift_F6_Key = #89;
      Shift_F7_Key = #90;
      Shift_F8_Key = #91;
      Shift_F9_Key = #92;
      Control_A_Key = #1;
      Control_B_Key = #2;
      Control_C_Key = #3;
      Control_D_Key = #4;
      Control_E_Key = #5;
      Control_F_Key = #6;
      Control_G_Key = #7;
      Control_H_Key = #8;
      Control_I_Key = #9;
      Control_J_Key = #10;
      Control_K_Key = #11;
      Control_L_Key = #12;
      Control_M_Key = #13;
      Control_N_Key = #14;
      Control_O_Key = #15;
      Control_P_Key = #16;
      Control_Q_Key = #17;
      Control_R_Key = #18;
      Control_S_Key = #19;
      Control_T_Key = #20;
      Control_U_Key = #21;
      Control_V_Key = #22;
      Control_W_Key = #23;
      Control_X_Key = #24;
      Control_Y_Key = #25;
      Control_Z_Key = #26;
      Shift_F10_Key = #93;
      Shift_F11_Key = #135;
      Shift_F12_Key = #136;
      Page_Down_Key = #81;
      Shift_Tab_Key = #15;
      Down_Arrow_Key = #80;
      Left_Arrow_Key = #75;
      Control_F1_Key = #94;
      Control_F2_Key = #95;
      Control_F3_Key = #96;
      Control_F4_Key = #97;
      Control_F5_Key = #98;
      Control_F6_Key = #99;
      Control_F7_Key = #100;
      Control_F8_Key = #101;
      Control_F9_Key = #102;
      Control_F10_Key = #103;
      Control_F11_Key = #137;
      Control_F12_Key = #138;
      Right_Arrow_Key = #77;
      Control_End_Key = #117;
      Alternate_0_Key = #129;
      Alternate_1_Key = #120;
      Alternate_2_Key = #121;
      Alternate_3_Key = #122;
      Alternate_4_Key = #123;
      Alternate_5_Key = #124;
      Alternate_6_Key = #125;
      Alternate_7_Key = #126;
      Alternate_8_Key = #127;
      Alternate_9_Key = #128;
      Alternate_A_Key = #30;
      Alternate_B_Key = #48;
      Alternate_C_Key = #46;
      Alternate_D_Key = #32;
      Alternate_E_Key = #18;
      Alternate_F_Key = #33;
      Alternate_G_Key = #34;
      Alternate_H_Key = #35;
      Alternate_I_Key = #23;
      Alternate_J_Key = #36;
      Alternate_K_Key = #37;
      Alternate_L_Key = #38;
      Alternate_M_Key = #50;
      Alternate_N_Key = #49;
      Alternate_O_Key = #24;
      Alternate_P_Key = #25;
      Alternate_Q_Key = #16;
      Alternate_R_Key = #19;
      Alternate_S_Key = #31;
      Alternate_T_Key = #20;
      Alternate_U_Key = #22;
      Alternate_V_Key = #47;
      Alternate_W_Key = #17;
      Alternate_X_Key = #45;
      Alternate_Y_Key = #21;
      Alternate_Z_Key = #44;
      Delete_Arrow_Key = #8;
      Control_Home_Key = #119;
      Alternate_F1_Key = #104;
      Alternate_F2_Key = #105;
      Alternate_F3_Key = #106;
      Alternate_F4_Key = #107;
      Alternate_F5_Key = #108;
      Alternate_F6_Key = #109;
      Alternate_F7_Key = #110;
      Alternate_F8_Key = #111;
      Alternate_F9_Key = #112;
      Alternate_F10_Key = #113;
      Alternate_F11_Key = #139;
      Alternate_F12_Key = #140;
      Control_Page_Up_Key = #132;
      Control_Page_Down_Key = #118;
      Control_Left_Arrow_Key = #115;
      Control_Right_Arrow_Key = #116;
      Control_Print_Screen_Key = #114;
      Others: packed array [ Control_A_Key .. Control_Z_Key ] of Char = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ';

    Var
     { System status storage locations. }
     {$IFNDEF OS2}
      Keyboard_Status_Byte1: Byte absolute $0040:$0017;
      Keyboard_Status_Byte2: Byte absolute $0040:$0018;
     {$ELSE}
      Keyboard_Status_Byte1,
      Keyboard_Status_Byte2: Byte;
     {$ENDIF}

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Wait next command.
    This procedure continues performing the wait
    routine until the key is pressed.

*************************************************)

    Procedure Wait_Next_Command;
      Begin
       {$IFNDEF Ver40}
        While not KeyPressed do
          Wait_Routine;
       {$ENDIF}
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Evaluate function key.
    This procedure maps the codes for the function
    keys.

*************************************************)

    Procedure Evaluate_Function_Key( Var Command: Char; Var Result: Byte );
      Begin
        Command := ReadKey;
        Case Command of
          Nul_Key: Result := Press_Nul;
          Shift_Tab_Key: Result := Press_Shift_Tab;
          Alternate_A_Key: Result := Press_Alternate_A;
          Alternate_B_Key: Result := Press_Alternate_B;
          Alternate_C_Key: Result := Press_Alternate_C;
          Alternate_D_Key: Result := Press_Alternate_D;
          Alternate_E_Key: Result := Press_Alternate_E;
          Alternate_F_Key: Result := Press_Alternate_F;
          Alternate_G_Key: Result := Press_Alternate_G;
          Alternate_H_Key: Result := Press_Alternate_H;
          Alternate_I_Key: Result := Press_Alternate_I;
          Alternate_J_Key: Result := Press_Alternate_J;
          Alternate_K_Key: Result := Press_Alternate_K;
          Alternate_L_Key: Result := Press_Alternate_L;
          Alternate_M_Key: Result := Press_Alternate_M;
          Alternate_N_Key: Result := Press_Alternate_N;
          Alternate_O_Key: Result := Press_Alternate_O;
          Alternate_P_Key: Result := Press_Alternate_P;
          Alternate_Q_Key: Result := Press_Alternate_Q;
          Alternate_R_Key: Result := Press_Alternate_R;
          Alternate_S_Key: Result := Press_Alternate_S;
          Alternate_T_Key: Result := Press_Alternate_T;
          Alternate_U_Key: Result := Press_Alternate_U;
          Alternate_V_Key: Result := Press_Alternate_V;
          Alternate_W_Key: Result := Press_Alternate_W;
          Alternate_X_Key: Result := Press_Alternate_X;
          Alternate_Y_Key: Result := Press_Alternate_Y;
          Alternate_Z_Key: Result := Press_Alternate_Z;
          F1_Key: Result := Press_F1;
          F2_Key: Result := Press_F2;
          F3_Key: Result := Press_F3;
          F4_Key: Result := Press_F4;
          F5_Key: Result := Press_F5;
          F6_Key: Result := Press_F6;
          F7_Key: Result := Press_F7;
          F8_Key: Result := Press_F8;
          F9_Key: Result := Press_F9;
          F10_Key: Result := Press_F10;
          F11_Key: Result := Press_F11;
          F12_Key: Result := Press_F12;
          Shift_F1_Key: Result := Press_Shift_F1;
          Shift_F2_Key: Result := Press_Shift_F2;
          Shift_F3_Key: Result := Press_Shift_F3;
          Shift_F4_Key: Result := Press_Shift_F4;
          Shift_F5_Key: Result := Press_Shift_F5;
          Shift_F6_Key: Result := Press_Shift_F6;
          Shift_F7_Key: Result := Press_Shift_F7;
          Shift_F8_Key: Result := Press_Shift_F8;
          Shift_F9_Key: Result := Press_Shift_F9;
          Shift_F10_Key: Result := Press_Shift_F10;
          Shift_F11_Key: Result := Press_Shift_F11;
          Shift_F12_Key: Result := Press_Shift_F12;
          End_Key: Result := Press_End;
          Home_Key: Result := Press_Home;
          Insert_Key: Result := Press_Insert;
          Delete_Key: Result := Press_Delete;
          Page_Up_Key: Result := Press_Page_Up;
          Up_Arrow_Key: Result := Press_Up_Arrow;
          Page_Down_Key: Result := Press_Page_Down;
          Down_Arrow_Key: Result := Press_Down_Arrow;
          Left_Arrow_Key: Result := Press_Left_Arrow;
          Right_Arrow_Key: Result := Press_Right_Arrow;
          Control_End_Key: Result := Press_Control_End;
          Control_Home_Key: Result := Press_Control_Home;
          Control_Page_Up_Key: Result := Press_Control_Page_Up;
          Control_Page_Down_Key: Result := Press_Control_Page_Down;
          Control_Left_Arrow_Key: Result := Press_Control_Left_Arrow;
          Control_Right_Arrow_Key: Result := Press_Control_Right_Arrow;
          Control_F1_Key: Result := Press_Control_F1;
          Control_F2_Key: Result := Press_Control_F2;
          Control_F3_Key: Result := Press_Control_F3;
          Control_F4_Key: Result := Press_Control_F4;
          Control_F5_Key: Result := Press_Control_F5;
          Control_F6_Key: Result := Press_Control_F6;
          Control_F7_Key: Result := Press_Control_F7;
          Control_F8_Key: Result := Press_Control_F8;
          Control_F9_Key: Result := Press_Control_F9;
          Control_F10_Key: Result := Press_Control_F10;
          Control_F11_Key: Result := Press_Control_F11;
          Control_F12_Key: Result := Press_Control_F12;
          Alternate_F1_Key: Result := Press_Alternate_F1;
          Alternate_F2_Key: Result := Press_Alternate_F2;
          Alternate_F3_Key: Result := Press_Alternate_F3;
          Alternate_F4_Key: Result := Press_Alternate_F4;
          Alternate_F5_Key: Result := Press_Alternate_F5;
          Alternate_F6_Key: Result := Press_Alternate_F6;
          Alternate_F7_Key: Result := Press_Alternate_F7;
          Alternate_F8_Key: Result := Press_Alternate_F8;
          Alternate_F9_Key: Result := Press_Alternate_F9;
          Alternate_F10_Key: Result := Press_Alternate_F10;
          Alternate_F11_Key: Result := Press_Alternate_F11;
          Alternate_F12_Key: Result := Press_Alternate_F12;
          Alternate_0_Key: Result := Press_Alternate_0;
          Alternate_1_Key: Result := Press_Alternate_1;
          Alternate_2_Key: Result := Press_Alternate_2;
          Alternate_3_Key: Result := Press_Alternate_3;
          Alternate_4_Key: Result := Press_Alternate_4;
          Alternate_5_Key: Result := Press_Alternate_5;
          Alternate_6_Key: Result := Press_Alternate_6;
          Alternate_7_Key: Result := Press_Alternate_7;
          Alternate_8_Key: Result := Press_Alternate_8;
          Alternate_9_Key: Result := Press_Alternate_9;
          Control_D_Key: Result := Press_Copy_Block;
          Control_F_Key: Result := Press_Delete_Block;
          Control_Print_Screen_Key: Result := Press_Control_Print_Screen;
        End; { Case }
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Get command.
    As previously defined.

*************************************************)

    Procedure Get_Command( Var Command: Char; Var Result: Byte );
      Var
        Other_Input: Byte;
      Begin
        Result := 0;
        Other_Input := 0;
       {$IFNDEF VER40}
        While ( Other_Input = 0 ) and ( not KeyPressed ) do
          Begin
            Other_Input := Alternative_Input;
            Wait_Routine;
          End;
       {$ENDIF}
        If ( Other_Input = 0 )
          then
            Begin
              Command := ReadKey;
              Case Command of
                '0'..'9': Result := Press_Numbers;
                'A'..'Z': Result := Press_Capital_Letters;
                'a'..'z': Result := Press_Lower_Letters;
                ' '..'~': Result := Press_Extra_Characters;
                Tab_Key: Result := Press_Tab;
                Enter_Key: Result := Press_Enter;
                Escape_Key: Result := Press_Escape;
                Function_Key: Evaluate_Function_Key( Command, Result );
                Delete_Arrow_Key: Result := Press_Delete_Arrow;
                Control_A_Key: Result := Press_Word_Left;
                Control_B_Key: Result := Press_Control_B;
                Control_C_Key: Result := Press_Page_Down;
                Control_D_Key: Result := Press_Right_Arrow;
                Control_E_Key: Result := Press_Up_Arrow;
                Control_F_Key: Result := Press_Word_Right;
                Control_G_Key: Result := Press_Delete;
                Control_H_Key: Result := Press_Control_H;
                Control_I_Key: Result := Press_Tab;
                Control_J_Key: Begin
                                 Wait_Next_Command;
                                 Command := UpCase( ReadKey );
                                 If ( Command in [ Control_A_Key .. Control_Z_Key ] )
                                   then
                                     Command := Others[ Command ];
                                 Case Command of
                                   'H': Result := Press_Help;
                                   'L': Result := Press_Restore_Line;
                                   Function_Key:  Command := ReadKey;
                                   else Result := Press_Control_J;
                                 End; { Case }
                               End;
                Control_K_Key: Begin
                                 Wait_Next_Command;
                                 Command := UpCase( ReadKey );
                                 If ( Command in [ Control_A_Key .. Control_Z_Key ] )
                                   then
                                     Command := Others[ Command ];
                                 Case Command of
                                   'B': Result := Press_Mark_Block_Top;
                                   'K': Result := Press_Mark_Block_End;
                                   'C': Result := Press_Copy_Block;
                                   'Y': Result := Press_Delete_Block;
                                   'W': Result := Press_Write_Block;
                                   'R': Result := Press_Read_Block;
                                   'P': Result := Press_Print_Block;
                                   'V': Result := Press_Move_Block;
                                   'H': Result := Press_Hide_Block;
                                   Function_Key: Command := ReadKey;
                                   else Result := Press_Control_K;
                                 End; { Case }
                               End;
                Control_L_Key: Result := Press_Control_L;
                Control_M_Key: Result := Press_Control_M;
                Control_N_Key: Result := Press_Control_N;
                Control_O_Key: Begin
                                 Wait_Next_Command;
                                 Command := UpCase( ReadKey );
                                 If ( Command in [ Control_A_Key .. Control_Z_Key ] )
                                   then
                                     Command := Others[ Command ];
                                 Case Command of
                                   'L': Result := Press_Left_Margin;
                                   'R': Result := Press_Right_Margin;
                                   'C': Result := Press_Center_Text;
                                   Function_Key: Command := ReadKey;
                                   else Result := Press_Control_O;
                                 End; { Case }
                               End;
                Control_P_Key: Result := Press_Control_P;
                Control_Q_Key: Begin
                                 Wait_Next_Command;
                                 Command := UpCase( ReadKey );
                                 If ( Command in [ Control_A_Key .. Control_Z_Key ] )
                                   then
                                     Command := Others[ Command ];
                                 Case Command of
                                   'S': Result := Press_Home;
                                   'D': Result := Press_End;
                                   'Y': Result := Press_Delete_End;
                                   'X': Result := Press_Control_End;
                                   'E': Result := Press_Control_Home;
                                   'R': Result := Press_Control_Page_Up;
                                   'C': Result := Press_Control_Page_Down;
                                   'B': Result := Press_Move_Block_Top;
                                   'K': Result := Press_Move_Block_End;
                                   'F': Result := Press_Search;
                                   'A': Result := Press_Replace;
                                   Function_Key: Command := ReadKey;
                                   else Result := Press_Control_Q;
                                 End; { Case }
                               End;
                Control_R_Key: Result := Press_Page_Up;
                Control_S_Key: Result := Press_Left_Arrow;
                Control_T_Key: Result := Press_Control_T;
                Control_U_Key: Result := Press_Control_U;
                Control_V_Key: Result := Press_Insert;
                Control_W_Key: Result := Press_Scroll_Up;
                Control_X_Key: Result := Press_Down_Arrow;
                Control_Y_Key: Result := Press_Delete_Line;
                Control_Z_Key: Result := Press_Scroll_Down;
                else  Result := Press_Other_Characters;
              End; { Case }
            End
          else
            Result := Other_Input;
       {$IFNDEF VER40}
        Erase_Pointer;
       {$ENDIF}
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Status.
    As previously defined.

*************************************************)

    Procedure Status;
      Begin
        Key_Insert_Lock := ( Keyboard_Status_Byte1 and $80 ) <> 0;
        Key_Capital_Lock := ( Keyboard_Status_Byte1 and $40 ) <> 0;
        Key_Number_Lock := ( Keyboard_Status_Byte1 and $20 ) <> 0;
        Key_Scroll_Lock := ( Keyboard_Status_Byte1 and $10 ) <> 0;
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Peek.
    As previously defined.

*************************************************)

    Procedure Peek;
      Begin
        Key_Alternate :=  ( Keyboard_Status_Byte1 and $08 ) <> 0;
        Key_Control :=  ( Keyboard_Status_Byte1 and $04 ) <> 0;
        Key_Shift :=  ( Keyboard_Status_Byte1 and $02 ) + ( Keyboard_Status_Byte1 and $01 ) <> 0;
        Key_Insert := ( Keyboard_Status_Byte2 and $80 ) <> 0;
        Key_Capital := ( Keyboard_Status_Byte2 and $40 ) <> 0;
        Key_Number := ( Keyboard_Status_Byte2 and $20 ) <> 0;
        Key_Scroll := ( Keyboard_Status_Byte2 and $10 ) <> 0;
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Substitute 1.
    This is a dummy procedure used to initialize
    the wait routine.

*************************************************)

   {$F+} { WARNING: Do not change! }
    Procedure Substitute1;
      Begin
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Function: Substitute 2.
    This is a dummy function used to initialize
    the alternative input routine.

*************************************************)

   {$F+} { WARNING: Do not change! }
    Function Substitute2: Byte;
      Begin
        Substitute2 := 0;
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Function: Data ready.
    As previously defined.

*************************************************)

    Function Data_Ready: Boolean;
      Var
        Other_Input: Byte;
      Begin;
       {$IFNDEF VER40}
        Other_Input := Alternative_Input;
        Data_Ready := KeyPressed or ( Other_Input <> 0 );
       {$ELSE}
        Data_Ready := KeyPressed;
       {$ENDIF}
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Main initialization section.
    Initialize the procedure variables.

*************************************************)

  Begin
   {$IFNDEF VER40}
    Wait_Routine := Substitute1;
    Alternative_Input := Substitute2;
    Allow_Control := False;
    Erase_Pointer := Substitute1;
    Update_Control := Substitute1;
   {$ENDIF}
   {$IFNDEF OS2}
    AssignCRT( Keys );
   {$ELSE}
    Assign( Keys, 'CON:' );
   {$ENDIF}
    Reset( Keys );
  End.


