(*****************************************************************************

  OS2Supp
    version 1.0

    This unit acts as a go between between the OS/2 operating system and
    the Speed Pascal/2 compiler.  Any type of system calls that the compiler
    doesn't support, are included here and are accessable only by special
    functions.  In this manner the functions themselves can handle any special
    requirements that the operating system needs to call them.

    It also initializes the pointer system to operate under OS/2.

    Purpose:
      This unit adds support to the other units under OS/2.
      It opens the pointer system ( Mouse ) and closes it.

    Features:
      Automatically attempts to load in the function calls for the program so
        that further action is unnecessary.
      Automatically takes care of the mouse pointer for the session.

    Limitations:
      Limited error checking.

    Versions:
      1.0 -  Initial code module.

    Copyright 1996, All rights reserved.
      P. R. Renaud

    Compiler:
      Speed Pascal/2 version 1.5

    Systems:
      OS/2

*****************************************************************************)

Unit OS2Supp;

  Interface

(*************************************************

  Max query amount
    Defines the maximum number of devices
    available per driver query.

*************************************************)

    Const
      Max_Query_Amount = 100;

(*************************************************

  Mode information type
    This record holds data used by a couple of the
    video routines.

*************************************************)

    Type
      Mode_Information_Type = Record
                                Record_Length: Word;
                                Type_Mask: Byte;
                               { Bit 0 set = Monochrome/Other }
                               { Bit 1 set = Graphics/Text }
                               { Bit 2 set = Color Burst/Off }
                               { Bit 3 set = Native Mode/VGA comp }
                                Bits_Per_Pixel: Byte; { Note 0 = Text }
                                Text_Columns,
                                Text_Rows,
                                Horizontal_Resolution,
                                Vertical_Resolution: Word;
                                Attribute_Format,
                                Attribute_Number: Byte;
                                Buffer_Address: Pointer;
                                Buffer_Length,
                                Full_Buffer_Size,
                                Partual_Buffer_Size: LongWord;
                                Extended_Pointer: Pointer;
                              End;

(*************************************************

  Device query type
    This struction holds the information returned
    from a device query.  Note that in the
    cooresponding arrays, the information matches
    each other.

*************************************************)

      Data_Type = Packed array [ 1 .. 16 ] of Char;
      Name_Type = Packed array [ 1 .. 32 ] of Char;
      Description_Type = Packed array [ 1 .. 64 ] of Char;
      Device_Query_Type = Record
                            Names: Packed array [ 1 .. Max_Query_Amount ] of Name_Type;
                            Description: Packed array [ 1 .. Max_Query_Amount ] of Description_Type;
                            Data: Packed array [ 1 .. Max_Query_Amount ] of Data_Type;
                          End;

(***********************************************************

  Procedure: Video Write Cell.
    This procedure attempts to write the data on the screen.

***********************************************************)

    Procedure VideoWriteCell( Var CellData; Length: LongWord; Row, Column: LongWord );

(***********************************************************

  Procedure: Video Read Cell.
    This procedure attempts to read the data on the screen.

***********************************************************)

    Procedure VideoReadCell( Var CellData; Length: Word; Row, Column: LongWord );

(***********************************************************

  Procedure: Video Scroll Up.
    This procedure attempts to scroll the specified screen
    region upwards.

***********************************************************)

    Procedure VideoScrollUp( Left, Top, Right, Bottom, ScrollAmount: LongWord; Var Cell );

(***********************************************************

  Procedure: Video Scroll Down.
    This procedure attempts to scroll the specified screen
    region downwards.

***********************************************************)

    Procedure VideoScrollDown( Left, Top, Right, Bottom, ScrollAmount: LongWord; Var Cell );

(***********************************************************

  Procedure: Video Scroll Left.
    This procedure attempts to scroll the specified screen
    region leftwards.

***********************************************************)

    Procedure VideoScrollLeft( Left, Top, Right, Bottom, ScrollAmount: LongWord; Var Cell );

(***********************************************************

  Procedure: Video Scroll Right.
    This procedure attempts to scroll the specified screen
    region rightwards.

***********************************************************)

    Procedure VideoScrollRight( Left, Top, Right, Bottom, ScrollAmount: LongWord; Var Cell );

(***********************************************************

  Procedure: Video Get Mode.
    This procedure polls the video system for information
    about the current video mode.

***********************************************************)

    Procedure VideoGetMode( Var Mode_Information: Mode_Information_Type );

(***********************************************************

  Procedure: Video Set Mode.
    This procedure sets the video system with a new video
    mode.

***********************************************************)

    Procedure VideoSetMode( Var Mode_Information: Mode_Information_Type );

(***********************************************************

  Procedure: Video write attribute.
    This procedure attempts to change the specified
    attributes on the screen.

***********************************************************)

    Procedure VideoWriteAttribute( Var Attribute: Byte; Length: LongWord; Row, Column: LongWord );

(***********************************************************

  Procedure: QueryDeviceNames;
    This procedure attempts to query the system about the
    names of the particular devices and any attached
    descriptions that go along with them.

   Note: Use only for Presentation Manager programs.

***********************************************************)

    Procedure QueryDeviceNames( DriverName: CString; Var Information: Device_Query_Type );

(***********************************************************

  Mouse_Available.
    This flag is set to true if the mouse is available for
    use.

***********************************************************)

    Var
      Mouse_Available: Boolean;

(***********************************************************

  Mouse_Buttons.
    This variable holds the total number of available mouse
    buttons.

***********************************************************)

      Mouse_Buttons: Word;

(***********************************************************

  Procedure: Mouse Poll Position.
    This procedure returns the current location of the
    pointer on the screen.  It will also scroll the windowed
    screen to the pointer location if it's not directly on.

***********************************************************)

    Procedure Mouse_Poll_Position( Var Row, Column: Word );

(***********************************************************

  Procedure: Mouse Poll Queue.
    This procedure returns the current information from the
    mouse queue.  It's the preferred method of polling the
    mouse system.

***********************************************************)

    Procedure Mouse_Poll_Queue( Var Row, Column: Word; Var Button1, Button2, Button3: Boolean );

(***********************************************************

  Procedure: Mouse Hide pointer.
    This procedure surpresses the mouse pointer drawing
    routine.

***********************************************************)

    Procedure Mouse_Hide_Pointer;

(***********************************************************

  Procedure: Mouse Display pointer.
    This procedure allows the mouse pointer to be drawn on
    the screen.

***********************************************************)

    Procedure Mouse_Display_Pointer;

(***********************************************************

  Procedure: Change error handling.
    This procedure alters the method the operating system
    handles the error reporting.  Be very careful when
    changing this.
    the screen.

***********************************************************)

    Procedure Change_Error_Handling( Exception_Popups, Fail_Popups: Boolean );

{----------------------------------------------------------------------------}

  Implementation

    Const
      VideoHandle: LongWord = 0;

    Type
     { This record defines the pointer location type for the pointer location system calls. }
      Pointer_Location_Type = Record
                                Row,
                                Column: Word;
                              End;
     { This record defines the control beginning for the pointer shape system calls. }
      Pointer_Shape_Type = Record
                             Total_Length,
                             Column,
                             Row,
                             Column_Offset,
                             Row_Offset: Word;
                           End;
     { This record defines the data structure for the mouse event queue poll procedures. }
      Mouse_Event_Information_Type = Record
                                       Mouse_State: Word;
                                       Event_Time: LongWord;
                                       Row,
                                       Column: Word;
                                     End;
     { This record defines the data structure for the mouse queue information poll procedure. }
      Mouse_Queue_Information_Type = Record
                                       Number_Of_Queue_Elements,
                                       Maximum_Number_Of_Queue_Elements: Word;
                                     End;
     { This record defines the data structure for the mouse scaling factors poll procedure. }
      ScaleFactors_Type = Record
                            Row_Scaling_Factor,
                            Column_Scaling_Factor: Word;
                          End;
     { This record defines the data structure for the mouse pointer drawing clipping routine. }
      Pointer_Exclude_Rectangle_Type = Record
                                         Top,
                                         Left,
                                         Bottom,
                                         Right: Word;
                                       End;
     { This record defines the data structure for the video configuration polling procedure. }
      Configuration_Data_Type = Record
                                  Record_Length: Word;
                                  Adaptor_Type: Word;
                                  Display_Type: Word;
                                  Adaptor_Memory: LongWord;
                                  Configuration_Number: Word;
                                  VDH_Version: Word;
                                  Flags: Word;
                                  Extra: packed array [ 1 .. 100 ] of byte;
                                End;

      Cell_Type = Record
                    Character: Char;
                    Attribute: Byte;
                  End;

    Imports

     { Returns the current cursor column.}
      Function VioWhereX: Byte;
        APIEntry;
        KBDVIO32 index 3;

     { Returns the current cursor row.}
      Function VioWhereY: Byte;
        APIEntry;
        KBDVIO32 index 4;

     { Registers session keyboard. }
      Function KbdRegister( ModuleName, EntryPt: CString; FunMask: LongWord ): Word;
        APIEntry;
        KBDVIO32 index 5;

     { Unregisters session keyboard. }
      Function KbdDeRegister: Word;
        APIEntry;
        KBDVIO32 index 6;

      Function KbdCharIn( Var pkbci; fWait: LongWord; KeyboardHandle: LongWord ): Word;
        APIEntry;
        KBDVIO32 index 7;

      Function KbdPeek( Var pkbci; KeyboardHandle: LongWord ): Word;
        APIEntry;
        KBDVIO32 index 8;

      Function KbdStringIn( Var CharacterBuffer; Var InLength; IOWait: LongWord; KeyboardHandle: LongWord ): Word;
        APIEntry;
        KBDVIO32 index 9;

      Function KbdFlushBuffer( KeyboardHandle: LongWord ): Word;
        APIEntry;
        KBDVIO32 index 10;

      Function KbdSetStatus( Var KeyboardStatusStructure; KeyboardHandle: LongWord ): Word;
        APIEntry;
        KBDVIO32 index 11;

      Function KbdGetStatus( Var KeyboardStatusStructure; KeyboardHandle: LongWord ): Word;
        APIEntry;
        KBDVIO32 index 12;

      Function KbdSetCp( usReserved, pidCP: LongWord; KeyboardHandle: LongWord ): Word;
        APIEntry;
        KBDVIO32 index 13;

      Function KbdGetCp( ulReserved: LongWord; Var pidCP: Word; KeyboardHandle: LongWord ): Word;
        APIEntry;
        KBDVIO32 index 14;

      Function KbdOpen( Var KeyboardHandle: LongWord ): Word;
        APIEntry;
        KBDVIO32 index 15;

      Function KbdClose( KeyboardHandle: LongWord ): Word;
        APIEntry;
        KBDVIO32 index 16;

      Function KbdGetFocus( fWait: LongWord; KeyboardHandle: LongWord ): Word;
        APIEntry;
        KBDVIO32 index 17;

      Function KbdFreeFocus( KeyboardHandle: LongWord ): Word;
        APIEntry;
        KBDVIO32 index 18;

      Function KbdSynch( ISWait: LongWord ): Word;
        APIEntry;
        KBDVIO32 index 19;

      Function KbdSetFgnd: Word;
        APIEntry;
        KBDVIO32 index 20;

     { Returns the keyboard identification value. }
      Function KbdGetHWID( Var KeyboardID; KeyboardHandle: LongWord ): Word;
        APIEntry;
        KBDVIO32 index 21;

      Function KbdSetHWID( Var KeyboardID; KeyboardHandle: LongWord ): Word;
        APIEntry;
        KBDVIO32 index 22;

      Function KbdXlate ( Var TranslationStructure; KeyboardHandle: LongWord ): Word;
        APIEntry;
        KBDVIO32 index 23;

      Function KbdSetCustXt( Var usCodePage: Word; KeyboardHandle: LongWord ): Word;
        APIEntry;
        KBDVIO32 index 24;

      Function VioRegister( pszModName, pszEntryName: Pointer; flFun1, flFun2: LongWord ): Word;
        APIEntry;
        KBDVIO32 index 25;

      Function VioDeRegister: Word;
        APIEntry;
        KBDVIO32 index 27;

      Function VioGetBuf ( Var pLVB: POINTER; Var pcbLVB: Word; VideoHandle: LongWord ): Word;
        APIEntry;
        KBDVIO32 index 28;

      Function VioGetCurPos( Var Row, Column: Word; VideoHandle: LongWord ): Word;
        APIEntry;
        KBDVIO32 index 29;

     { Moves the cursor to the given location. }
      Function VioSetCurPos( Row, Column: LongWord; VideoHandle: LongWord ): Word;
        APIEntry;
        KBDVIO32 index 30;

      Function VioGetCurType ( Var CursorData; VideoHandle: LongWord ): Word;
        APIEntry;
        KBDVIO32 index 31;

      Function VioSetCurType ( Var CursorData; VideoHandle: LongWord ): Word;
        APIEntry;
        KBDVIO32 index 32;

     { Gets the video mode information from the system.}
      Function VioGetMode( Var Mode_Information: Mode_Information_Type; VideoHandle: LongWord ): Word;
        APIEntry;
        KBDVIO32 index 33;

     { Sets the video mode of the video system. }
      Function VioSetMode( Var Mode_Information: Mode_Information_Type; VideoHandle: LongWord ): Word;
        APIEntry;
        KBDVIO32 index 34;

      Function VioGetPhysBuf ( Var DisplayBuffer; Reserved: LongWord ): Word;
        APIEntry;
        KBDVIO32 index 35;

     { Reads the given data cells from the screen. }
      Function VioReadCellStr( Var CellData; Var Length: Word; Row, Column: LongWord; VideoHandle: LongWord ): Word;
        APIEntry;
        KBDVIO32 index 36;

     { Reads the given character string from the screen. }
      Function VioReadCharStr( Var CharacterData; Var Length: Word; Row, Column: LongWord; VideoHandle: LongWord ): Word;
        APIEntry;
        KBDVIO32 index 37;

     { Writes the given cell data on the screen. }
      Function VioWrtCellStr( Var CellData; Length: LongWord; Row, Column: LongWord; VideoHandle: LongWord ): Word;
        APIEntry;
        KBDVIO32 index 38;

     { Writes the given character string to the screen. }
      Function VioWrtCharStr( Var CharacterData; Length, Row, Column: LongWord; VideoHandle: LongWord ): Word;
        APIEntry;
        KBDVIO32 index 39;

     { Scrolls the specified screen region downwards. }
      Function VioScrollDn( Top, Left, Bottom, Right, ScrollAmount: LongWord; Var Cell{: Cell_Type}; VideoHandle: LongWord ): Word;
        APIEntry;
        KBDVIO32 index 40;

     { Scrolls the specified screen region upwards. }
      Function VioScrollUp( Top, Left, Bottom, Right, ScrollAmount: LongWord; Var Cell{: Cell_Type}; VideoHandle: LongWord ): Word;
        APIEntry;
        KBDVIO32 index 41;

     { Scrolls the specified screen region leftwards. }
      Function VioScrollLf( Top, Left, Bottom, Right, ScrollAmount: LongWord; Var Cell{: Cell_Type}; VideoHandle: LongWord ): Word;
        APIEntry;
        KBDVIO32 index 42;

     { Scrolls the specified screen region rightwards. }
      Function VioScrollRt( Top, Left, Bottom, Right, ScrollAmount: LongWord; Var Cell{: Cell_Type}; VideoHandle: LongWord ): Word;
        APIEntry;
        KBDVIO32 index 43;

     { Writes the specified attribute to the screen a number of times. }
      Function VioWrtNAttr( Var Attribute: Byte; Amount, Row, Column: LongWord; VideoHandle: LongWord ): Word;
        APIEntry;
        KBDVIO32 index 44;

     { Writes the specified cell to the screen a number of times. }
      Function VioWrtNCell( Var Cell; Amount, Row, Column: LongWord; VideoHandle: LongWord ): Word;
        APIEntry;
        KBDVIO32 index 45;

     { Writes the specified character to the screen a number of times. }
      Function VioWrtNChar( Var Character; Amount, Row, Column: LongWord; VideoHandle: LongWord ): Word;
        APIEntry;
        KBDVIO32 index 46;

      Function VioWrtTTY( Var apch; Amount: LongWord; VideoHandle: LongWord ): Word;
        APIEntry;
        KBDVIO32 index 47;

      Function VioWrtCharStrAtt( Var apch; Amount, Row, Column: LongWord; Var Attribute; VideoHandle: LongWord ): Word;
        APIEntry;
        KBDVIO32 index 48;

      Function VioCheckCharType( Var PType: Word; Row, Column: LongWord; VideoHandle: LongWord ): Word;
        APIEntry;
        KBDVIO32 index 49;

      Function VioShowBuf( offLVB, Amount: LongWord; VideoHandle: LongWord ): Word;
        APIEntry;
        KBDVIO32 index 50;

      Function VioSetAnsi( fAnsi: LongWord; VideoHandle: LongWord ): Word;
        APIEntry;
        KBDVIO32 index 51;

      Function VioGetAnsi( Var pfAnsi: Word; VideoHandle: LongWord ): Word;
        APIEntry;
        KBDVIO32 index 52;

      Function VioPrtSc( VideoHandle: LongWord ): Word;
        APIEntry;
        KBDVIO32 index 53;

      Function VioPrtScToggle( VideoHandle: LongWord ): Word;
        APIEntry;
        KBDVIO32 index 54;

      Function VioSavRedrawWait( usRedrawInd: LongWord; Var pNotifyType: Word; usReserved: LongWord ): Word;
        APIEntry;
        KBDVIO32 index 56;

      Function VioSavRedrawUndo( usOwnerInd, usKillInd, usReserved: LongWord ): Word;
        APIEntry;
        KBDVIO32 index 57;

      Function VioModeWait( usReqType: LongWord; Var pNotifyType: Word; usReserved: LongWord ): Word;
        APIEntry;
        KBDVIO32 index 58;

      Function VioModeUndo( usOwnerInd, usKillInd, usReserved: LongWord ): Word;
        APIEntry;
        KBDVIO32 index 59;

      Function VioScrLock( fWait: LongWord; Var pfNotLocked: BYTE; VideoHandle: LongWord ): Word;
        APIEntry;
        KBDVIO32 index 60;

      Function VioScrUnLock( VideoHandle: LongWord ): Word;
        APIEntry;
        KBDVIO32 index 61;

      Function VioPopUp ( Var pfWait: Word; VideoHandle: LongWord ): Word;
        APIEntry;
        KBDVIO32 index 62;

      Function VioEndPopUp( VideoHandle: LongWord ): Word;
        APIEntry;
        KBDVIO32 index 63;

     { Gets the video mode configuration. }
      { Configuration_Identification of 0 = current configuration, 1 = primary configuration, 2 = secondary configuration. }
      Function VioGetConfig( Configuration_Identification: LongWord; Var Configuration_Data: Configuration_Data_Type; VideoHandle: LongWord ): Word;
        APIEntry;
        KBDVIO32 index 64;

      Function VioGetFont( Var RequestBlock; VideoHandle: LongWord ): Word;
        APIEntry;
        KBDVIO32 index 65;

      Function VioSetFont( Var RequestBlock; VideoHandle: LongWord ): Word;
        APIEntry;
        KBDVIO32 index 66;

      Function VioGetCp( usReserved: LongWord; Var pIdCodePage: Word; VideoHandle: LongWord ): Word;
        APIEntry;
        KBDVIO32 index 67;

      Function VioSetCp( usReserved, idCodePage: LongWord; VideoHandle: LongWord ): Word;
        APIEntry;
        KBDVIO32 index 68;

      Function VioGetState( Var State; VideoHandle: LongWord ): Word;
        APIEntry;
        KBDVIO32 index 69;

      Function VioSetState( Var State; VideoHandle: LongWord ): Word;
        APIEntry;
        KBDVIO32 index 70;

     { Registers a mouse subsystem within a session. }
      {  ModuleName points to an ASCIIZ string with name of module. ( Max 8 ) }
      {  EntryName should point to ASCIIZ string with the routine name. ( Max 32 ) }
      Function MouRegister( ModuleName, EntryName: CString; RegistrationMask: LongWord ): Word;
        APIEntry;
        KBDVIO32 index 71;

     { Deregisters a mouse sub-system within a session. }
      Function MouDeRegister: Word;
        APIEntry;
        KBDVIO32 index 72;

     { This flushes the mouse event queue. }
      Function MouFlushQue( DeviceHandle: Word ): Word;
        APIEntry;
        KBDVIO32 index 73;

     { Gets the current row and column coordinates of the mouse pointer. }
      Function MouGetPtrPos( Var PointerPosition: Pointer_Location_Type; DeviceHandle: Word ): Word;
        APIEntry;
        KBDVIO32 index 74;

     { Sets the current row and column coordinates of the mouse pointer. }
      Function MouSetPtrPos( Var PointerPosition: Pointer_Location_Type; DeviceHandle: Word ): Word;
        APIEntry;
        KBDVIO32 index 75;

     { Defines the current mouse pointer bitmap shape. }
      Function MouSetPtrShape( Var PointerBuffer; Var PointerDefinitionRecord: Pointer_Shape_Type; DeviceHandle: Word ): Word;
        APIEntry;
        KBDVIO32 index 76;

     { Gets a copy of the current mouse pointer bitmap shape. }
      Function MouGetPtrShape( Var PointerBuffer; Var PointerDefinitionRecord: Pointer_Shape_Type; DeviceHandle: Word ): Word;
        APIEntry;
        KBDVIO32 index 77;

     { Gets current status of the mouse driver. }
      {  Bit 0 set if event queue is busy with input/output. }
      {  Bit 1 set if block read is in progress. }
      {  Bit 2 set if flush is in progress. }
      {  Bit 3 set if pointer draw routine disabled by unsupported mode. }
      {  Bit 8 set if drawing routine is disabled. }
      {  Bit 9 set if data returned in mickeys, clear if pels. }
      Function MouGetDevStatus( Var DeviceStatus: Word; DeviceHandle: Word ): Word;
        APIEntry;
        KBDVIO32 index 78;

     { Returns the number of buttons on the current mouse device. }
      Function MouGetNumButtons( Var NumberOfButtons: Word; DeviceHandle: Word ): Word;
        APIEntry;
        KBDVIO32 index 79;

     { Reports the number of mickeys per centimeter. }
      Function MouGetNumMickeys( Var NumberOfMickeys: Word; DeviceHandle: Word ): Word;
        APIEntry;
        KBDVIO32 index 80;

     { Gets information off the mouse event queue. }
      Function MouReadEventQue( Var MouseEvent: Mouse_Event_Information_Type; Var ReadType: Word; DeviceHandle: Word ): Word;
        APIEntry;
        KBDVIO32 index 81;

     { Returns the status of the mouse event queue. }
      Function MouGetNumQueEl( Var QueueDataRecord: Mouse_Queue_Information_Type; DeviceHandle: Word ): Word;
        APIEntry;
        KBDVIO32 index 82;

     { Gets the current mask of the mouse event queue. }
      {  Bit 0 set if reports mouse events with no click or release. }
      {  Bit 1 set if reports button1 event with mouse motion. }
      {  Bit 2 set if reports button1 event without mouse motion. }
      {  Bit 3 set if reports button2 event with mouse motion. }
      {  Bit 4 set if reports button2 event without mouse motion. }
      {  Bit 5 set if reports button3 event with mouse motion. }
      {  Bit 6 set if reports button3 event without mouse motion. }
      Function MouGetEventMask( Var EventMask: Word; DeviceHandle: Word ): Word;
        APIEntry;
        KBDVIO32 index 83;

     { Sets the mouse event mask for the current driver. }
      {  Bit 0 set to report mouse events with no click or release. }
      {  Bit 1 set to report button1 event with mouse motion. }
      {  Bit 2 set to report button1 event without mouse motion. }
      {  Bit 3 set to report button2 event with mouse motion. }
      {  Bit 4 set to report button2 event without mouse motion. }
      {  Bit 5 set to report button3 event with mouse motion. }
      {  Bit 6 set to report button3 event without mouse motion. }
      Function MouSetEventMask( Var EventMask: Word ; DriverHandle: Word ): Word;
        APIEntry;
        KBDVIO32 index 84;

     { Gets the current scaling factors for the mouse. }
      Function MouGetScaleFact( Var MouseScaleFactors: ScaleFactors_Type; DeviceHandle: Word ): Word;
        APIEntry;
        KBDVIO32 index 85;

     { Sets the current scaling factors for the mouse. }
      Function MouSetScaleFact( Var MouseScaleFactors: ScaleFactors_Type; DeviceHandle: Word ): Word;
        APIEntry;
        KBDVIO32 index 86;

     { Opens the mouse device for the current session. }
      { Using a DriveName address of Nul ( 0 ) will use the default driver. }
      Function MouOpen( DriverName: CString; Var DeviceHandle: Word ): Word;
        APIEntry;
        KBDVIO32 index 87;

     { Closes mouse device for the current session. }
      Function MouClose( DeviceHandle: Word ): Word;
        APIEntry;
        KBDVIO32 index 88;

     { Notifies the mouse system that the defined window area is unavailable. }
      Function MouRemovePtr( Var PointerArea: Pointer_Exclude_Rectangle_Type; DeviceHandle: Word ): Word;
        APIEntry;
        KBDVIO32 index 89;

     { Notifies the mouse system that the window is available. }
      Function MouDrawPtr( Handle: Word ): Word;
        APIEntry;
        KBDVIO32 index 90;

     { Sets the mouse device driver status. }
      {  Bit 8 set to disable pointer drawing operations. }
      {  Bit 9 set to return data in Mickeys. }
      Function MouSetDevStatus( Var DeviceStatus: Word; DeviceHandle: Word ): Word;
        APIEntry;
        KBDVIO32 index 91;

     { Initializes the mouse pointer draw for DOS mode. }
      Function MouInitReal( DriverName: CString ): Word;
        APIEntry;
        KBDVIO32 index 92;

     { Provides synchronous access for a mouse subsystem to the driver itself. }
      Function MouSynch( IOWaitState: LongWord ): Word;
        APIEntry;
        KBDVIO32 index 93;

     { Alters method of error notification. }
      Function DosError( Error: LongWord ): LongWord;
        APIEntry;
        DOSCalls index 212;

     { Loads a module for use in the program. }
      Function DosLoadModule( ObjectName: CString; ObjectNameLength: LongWord; ModuleName: CString; Var ModuleHandle: LongWord ): LongWord;
        APIEntry;
        DOSCalls index 318;

     { Used to get the address of a procedure code segment in a DLL. }
      Function DosQueryProcAddr( ModuleHandle: LongWord; Ordinal: LongWord; Var ModuleName: CString; Var Address: ProcVar ): LongWord;
        APIEntry;
        DOSCalls index 321;

      Function DevQueryDeviceNames( Handle: LongWord; DriverName: CString; Var MaxDescriptionNumber: LongInt; Var NameArray, DescriptionArray; Var MaxDataTypes: LongInt; Var DataTypes ): Word;
        APIEntry;
        DOSCalls index 607;

      Function GetModuleHandle( Const ModuleName: CString ):LongWord;
        APIEntry;
        'KERNEL32' name 'GetModuleHandleA';

    End;

    Var
     { Holds the results of special function calls. }
      Okay: Word;
     { Used to hold previous mouse information data. }
      Previous_Data: Mouse_Event_Information_Type;
     { Holds the mouse handle for this unit. }
      Mouse_Handle: Word;
     { Holds a pointer to the exit chain. }
      Old_Exit_Procedure: Pointer;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Mouse Poll Position.
    As previously defined.

*************************************************)

    Procedure Mouse_Poll_Position( Var Row, Column: Word );
      Var
        Other_Error: Boolean;
        Pointer_Position: Pointer_Location_Type;
      Begin
        Okay := MouGetPtrPos( Pointer_Position, Mouse_Handle );
        Case Okay of
          0: Other_Error := False;
          385: Other_Error := True; { No device }
          466: Other_Error := True; { Mouse detached. }
          501: Other_Error := True; { No console. }
          505: Other_Error := True; { Extended Sg. }
          else
            Begin
              WriteLn( 'Error in OS2Supp.Mouse_Poll_Position: ', Okay );
              Halt( Okay );
            End;
        End; { Case }
        Row := Pointer_Position.Row;
        Column := Pointer_Position.Column;
        Mouse_Available := ( Not Other_Error );
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Mouse Poll Queue.
    As previously defined.

*************************************************)

    Procedure Mouse_Poll_Queue( Var Row, Column: Word; Var Button1, Button2, Button3: Boolean );
      Var
        Other_Error: Boolean;
        Read_Type: Word;
        Data: Mouse_Event_Information_Type;
      Begin
        Read_Type := 0;
        Okay := MouReadEventQue( Data, Read_Type, Mouse_Handle );
        Case Okay of
          0: Other_Error := False;
          385: Other_Error := True; { No device }
          387: Other_Error := True; { Invalid parameter }
          393: Other_Error := True; { No Data }
          466: Other_Error := True; { Mouse detached. }
          501: Other_Error := True; { No console. }
          505: Other_Error := True; { Extended Sg. }
          else
            Begin
              WriteLn( 'Error in OS2Supp.Mouse_Poll_Position: ', Okay );
              Halt( Okay );
            End;
        End; { Case }
        If ( Data.Event_Time = 0 )
          then
            Data := Previous_Data;
        Previous_Data := Data;
        Row := Data.Row;
        Column := Data.Column;
        Button1 := ( ( Data.Mouse_State and 4 ) <> 0 );
        Button2 := ( ( Data.Mouse_State and 16 ) <> 0 );
        Button3 := ( ( Data.Mouse_State and 64 ) <> 0 );
        Mouse_Available := ( Not Other_Error );
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Mouse Display Pointer.
    As previously defined.

*************************************************)

    Procedure Mouse_Display_Pointer;
      Var
        Other_Error: Boolean;
      Begin
        Okay := MouDrawPtr( Mouse_Handle );
        Case Okay of
          0: Other_Error := False;
          385: Other_Error := True; { No device. }
          466: Other_Error := True; { Mouse detached. }
          501: Other_Error := True; { No console. }
          505: Other_Error := True; { Extended Sg. }
          else
            Begin
              WriteLn( 'Error in OS2Supp.Mouse_Display_Pointer: ', Okay );
              Halt( Okay );
            End;
        End; { Case }
        Mouse_Available := ( Not Other_Error );
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Mouse Hide Pointer.
    As previously defined.

*************************************************)

    Procedure Mouse_Hide_Pointer;
      Var
        Other_Error: Boolean;
        Data: Pointer_Exclude_Rectangle_Type;
      Begin
        Data.Top := 0;
        Data.Left := 0;
        Data.Right := 128;
        Data.Bottom := 50;
        Okay := MouRemovePtr( Data, Mouse_Handle );
        Case Okay of
          0: Other_Error := False;
          385: Other_Error := True; { No device. }
          387: Other_Error := True; { Invalid Parameters. }
          466: Other_Error := True; { Mouse detached. }
          501: Other_Error := True; { No console. }
          505: Other_Error := True; { Extended Sg. }
          else
            Begin
              WriteLn( 'Error in OS2Supp.Mouse_Hide_Pointer: ', Okay );
              Halt( Okay );
            End;
        End; { Case }
        Mouse_Available := ( Not Other_Error );
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Video write cell.
    As previously defined.

*************************************************)

    Procedure VideoWriteCell( Var CellData; Length: LongWord; Row, Column: LongWord );
      Begin
        Okay := VioWrtCellStr( CellData, Length, Row, Column, VideoHandle );
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Video read cell.
    As previously defined.

*************************************************)

    Procedure VideoReadCell( Var CellData; Length: Word; Row, Column: LongWord );
      Begin
        Okay := VioReadCellStr( CellData, Length, Row, Column, VideoHandle );
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Video scroll down.
    As previously defined.

*************************************************)

    Procedure VideoScrollDown( Left, Top, Right, Bottom, ScrollAmount: LongWord; Var Cell );
      Begin
        Okay := VioScrollDn( Top, Left, Bottom, Right, ScrollAmount, Cell, VideoHandle );
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Video scroll up.
    As previously defined.

*************************************************)

    Procedure VideoScrollUp( Left, Top, Right, Bottom, ScrollAmount: LongWord; Var Cell );
      Begin
        Okay := VioScrollUp( Top, Left, Bottom, Right, ScrollAmount, Cell, VideoHandle );
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Video scroll left.
    As previously defined.

*************************************************)

    Procedure VideoScrollLeft( Left, Top, Right, Bottom, ScrollAmount: LongWord; Var Cell );
      Begin
        Okay := VioScrollLf( Top, Left, Bottom, Right, ScrollAmount, Cell, VideoHandle );
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Video scroll Right.
    As previously defined.

*************************************************)

    Procedure VideoScrollRight( Left, Top, Right, Bottom, ScrollAmount: LongWord; Var Cell );
      Begin
        Okay := VioScrollRt( Top, Left, Bottom, Right, ScrollAmount, Cell, VideoHandle );
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Video get mode.
    As previously defined.

*************************************************)

    Procedure VideoGetMode( Var Mode_Information: Mode_Information_Type );
      Begin
        Mode_Information.Record_Length := SizeOf( Mode_Information_Type );
        Okay := VioGetMode( Mode_Information, VideoHandle );
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Video set mode.
    As previously defined.

*************************************************)

    Procedure VideoSetMode( Var Mode_Information: Mode_Information_Type );
      Begin
        Mode_Information.Record_Length := SizeOf( Mode_Information_Type );
        Okay := VioSetMode( Mode_Information, VideoHandle );
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Video write attribute.
    As previously defined.

*************************************************)

    Procedure VideoWriteAttribute( Var Attribute: Byte; Length: LongWord; Row, Column: LongWord );
      Begin
        Okay := VioWrtNAttr( Attribute, Length, Row, Column, VideoHandle );
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: Change_Error_Handling.
    As previously defined.

*************************************************)

    Procedure Change_Error_Handling( Exception_Popups, Fail_Popups: Boolean );
      Var
        State: LongWord;
      Begin
        State := 0;
        If ( not Exception_Popups )
          then
            State := ( State or 2 );
        If ( Fail_Popups )
          then
            State := ( State or 1 );
        DosError( State );
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: New exit procedure.
    This procedure is called to shut down the
    mouse system at the end of the program.

*************************************************)

    Procedure New_Exit_Procedure;
      Begin
        ExitProc := Old_Exit_Procedure;
        Okay := MouClose( Mouse_Handle );
        { Ignore error, the program is stopping anyway. }
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Procedure: QueryDeviceNames;
    As previously defined.

**************************************************)

    Procedure QueryDeviceNames( DriverName: CString; Var Information: Device_Query_Type );
      Var
        Handle,
        Max_Data,
        Max_Name_Descriptions: LongInt;
      Begin
        Handle := AppHandle; {GetModuleHandle( Nil );}
        Max_Data := Max_Query_Amount;
        Max_Name_Descriptions := Max_Query_Amount;
        Okay := DevQueryDeviceNames( Handle, DriverName, Max_Name_Descriptions, Information.Names, Information.Description, Max_Data, Information.Data );
      End;

{----------------------------------------------------------------------------}

(*************************************************

  Main section.
    This section sets up the mouse system for the
    program.

*************************************************)

  Begin
    Okay := MouOpen( Nil, Mouse_Handle );
    Case Okay of
      0: Mouse_Available := True; { Everything is fine. }
      385: Mouse_Available := False; { No such device. }
      501: Mouse_Available := False; { No console. }
      390: Mouse_Available := False; { Invalid Pointer. }
      466: Mouse_Available := False; { Mouse Detached. }
      505: Mouse_Available := False; { Extended Sg. }
      else
        Begin
          WriteLn( 'Error in OS2Supp: Mouse error: ', Okay );
          Halt( Okay );
        End;
    End; {Case}
    Okay := MouGetNumButtons( Mouse_Buttons, Mouse_Handle );
    Old_Exit_Procedure := ExitProc;
    ExitProc := @New_Exit_Procedure;
  End.

