(*****************************************************************************

  Program:  Search demonstration.

  Purpose:
    This program demonstrates the ability of the search unit.

  Features:
    Search contains the Find_Location procedure which is very useful in
      finding certain files on the logical drives.

  Copyright 1995, All rights reserved.
    P. Renaud.

  Compilers:
    Turbo Pascal versions 4.0 to 6.0
    Speed Pascal/2 version 1.5

  Systems:
    MS-DOS, MDOS, OS/2

*****************************************************************************)

Program Search_Demonstration( Input, Output );

  Uses
    Search;

  Var
    Path: String;

  Begin
    WriteLn( 'Search unit demonstration program.' );
    WriteLn( 'Copyright 1995, All rights reserved.' );
    WriteLn( 'by P. Renaud.' );
    WriteLn;
    WriteLn( 'This program demonstrates the search unit.  The first search is in the' );
    WriteLn( 'current branch of the tree.  The second search is for the program itself' );
    WriteLn( 'And the last two searches are for various file across the entire system.' );
    WriteLn;
    WriteLn( 'Please press [enter] to start.' );
    ReadLn;
    { Search demo }

    Path := Find_Location( '', 'SrchDemo.Pas' );
    WriteLn( 'Path of SrchDemo.Pas is ', Path );

    Path := Super_Find( 'SrchDemo.Exe', False );
    WriteLn( 'Path of SrchDemo.Exe is ', Path );

    Path := Super_Find( 'Command.Com', False );
    WriteLn( 'Path of Command.Com is ', Path );

    Path := Super_Find_With_Date( 'CGA.BGI', 10, 23, 1990, False );
    WriteLn( 'Path of CGA.BGI is ', Path );

  End.

