PROGRAM HeapTest;  { Copyright (c) 1992,1993 Norbert Juffa }

{$A+,B-,D+,E-,F-,G-,I+,L+,N-,O-,R-,S-,V-,X-}
{$M 4096,0,655360}

USES Time;

VAR Dummy,Start, LoopTime,LoopTime2: LONGINT;
    Delta, TotalTime: LONGINT;
    L,Choice,K,T: WORD;
    BlkPtr:  ARRAY [1..1000] OF POINTER;
    BlkSize: ARRAY [1..1000] OF WORD;
    Permutation: ARRAY [1..1000] OF WORD;

BEGIN
   WriteLn ('Test of TP heap functions');
   WriteLn;
   TotalTime := 0;
   RandSeed := 997;
   WriteLn ('MaxAvail: ', MaxAvail, '   MemAvail: ', MemAvail);
   Start := Clock;
   FOR L := 1 TO 1000 DO BEGIN
   END;
   LoopTime := Clock-Start;
   FOR L := 1 TO 1000 DO BEGIN
      BlkSize [L] := Random (512) + 1;
   END;
   Write ('Allocating 1000 blocks at the end of the heap: ');
   Start := Clock;
   FOR L := 1 TO 1000 DO BEGIN
      GetMem (BlkPtr [L], BlkSize [L]);
   END;
   Delta := Clock-Start-LoopTime;
   Inc (TotalTime, Delta);
   WriteLn (Delta:5, ' ms');
   WriteLn ('MaxAvail: ', MaxAvail, '   MemAvail: ', MemAvail);
   Write ('Deallocating same 1000 blocks in reverse order:');
   Start := Clock;
   FOR L := 1 TO 1000 DO BEGIN
      FreeMem (BlkPtr [L], BlkSize [L]);
   END;
   Delta := Clock-Start-LoopTime;
   Inc (TotalTime, Delta);
   WriteLn (Delta:5, ' ms');
   WriteLn ('MaxAvail: ', MaxAvail, '   MemAvail: ', MemAvail);
   Write ('Allocating 1000 blocks at the end of the heap: ');
   Start := Clock;
   FOR L := 1 TO 1000 DO BEGIN
      GetMem (BlkPtr [L], BlkSize [L]);
   END;
   Delta := Clock-Start-LoopTime;
   Inc (TotalTime, Delta);
   WriteLn (Delta:5, ' ms');
   WriteLn ('MaxAvail: ', MaxAvail, '   MemAvail: ', MemAvail);
   FOR L := 1 TO 1000 DO BEGIN
      Permutation [L] := L;
   END;
   Start := Clock;
   FOR L := 1000 DOWNTO 1 DO BEGIN
      Choice := Random (L)+1;
      K := Permutation [Choice];
      Permutation [Choice] := Permutation [L];
   END;
   LoopTime2 := Clock - Start;
   FOR L := 1 TO 1000 DO BEGIN
      Permutation [L] := L;
   END;
   Write ('Deallocating same 1000 blocks at random:       ');
   Start := Clock;
   FOR L := 1000 DOWNTO 1 DO BEGIN
      Choice := Random (L)+1;
      K := Permutation [Choice];
      Permutation [Choice] := Permutation [L];
      FreeMem (BlkPtr [K], BlkSize [K]);
   END;
   Delta := Clock - Start - LoopTime2;
   Inc (TotalTime, Delta);
   WriteLn (Delta:5, ' ms');
   WriteLn ('MaxAvail: ', MaxAvail, '   MemAvail: ', MemAvail);
   Write ('Allocating 1000 blocks at the end of the heap: ');
   Start := Clock;
   FOR L := 1 TO 1000 DO BEGIN
      GetMem (BlkPtr [L], BlkSize [L]);
   END;
   Delta := Clock-Start-LoopTime;
   Inc (TotalTime, Delta);
   WriteLn (Delta:5, ' ms');
   WriteLn ('MaxAvail: ', MaxAvail, '   MemAvail: ', MemAvail);
   FOR L := 1 TO 1000 DO BEGIN
      Permutation [L] := L;
   END;
   Start := Clock;
   FOR L := 1000 DOWNTO 1 DO BEGIN
      Choice := Random (L)+1;
      K := Permutation [Choice];
      T:= Permutation [L];
      Permutation [L] := Permutation [Choice];
      Permutation [Choice] := T;
   END;
   LoopTime2 := Clock - Start;
   FOR L := 1 TO 1000 DO BEGIN
      Permutation [L] := L;
   END;
   Write ('Deallocating 500 blocks at random:             ');
   Start := Clock;
   FOR L := 1000 DOWNTO 501 DO BEGIN
      Choice := Random (L)+1;
      K := Permutation [Choice];
      T:= Permutation [L];
      Permutation [L] := Permutation [Choice];
      Permutation [Choice] := T;
      SYSTEM.FreeMem (BlkPtr [K], BlkSize [K]);
   END;
   Delta := Clock-Start-LoopTime2;
   Inc (TotalTime, Delta);
   WriteLn (Delta:5, ' ms');
   WriteLn ('MaxAvail: ', MaxAvail, '   MemAvail: ', MemAvail);
   Start := Clock;
   FOR L := 1 TO 1000 DO BEGIN
      Dummy := MaxAvail;
   END;
   Delta := Clock-Start;
   Inc (TotalTime, (Delta + 5) DIV 10);
   WriteLn ('1000 calls to MaxAvail:                        ', Delta:5, ' ms');
   Start := Clock;
   FOR L := 1 TO 1000 DO BEGIN
      Dummy := MemAvail;
   END;
   Delta := Clock - Start;
   Inc (TotalTime, (Delta + 5) DIV 10);
   WriteLn ('1000 calls to MemAvail:                        ', Delta:5, ' ms');
   WriteLn ('MaxAvail: ', MaxAvail, '   MemAvail: ', MemAvail);
   Write ('Reallocating deallocated 500 blocks at random: ');
   Start := Clock;
   FOR L := 501 TO 1000 DO BEGIN
      GetMem (BlkPtr [Permutation [L]], BlkSize [Permutation [L]]);
   END;
   Delta := Clock-Start-LoopTime;
   Inc (TotalTime, Delta);
   WriteLn (Delta:5, ' ms');
   WriteLn ('MaxAvail: ', MaxAvail, '   MemAvail: ', MemAvail);
   Write ('Deallocating all 1000 blocks at random:        ');
   Start := Clock;
   FOR L := 1000 DOWNTO 1 DO BEGIN
      FreeMem (BlkPtr [L], BlkSize [L]);
   END;
   Delta := Clock-Start-LoopTime;
   Inc (TotalTime, Delta);
   WriteLn (Delta:5, ' ms');
   WriteLn ('MaxAvail: ', MaxAvail, '   MemAvail: ', MemAvail);
   WriteLn;
   WriteLn ('Total time for benchmark: ', TotalTime, ' ms');
END.



