;---------------------------------------------------------------------------
; Program Name:  Check.Inc
;
; Author:        Steve Poulsen
;
; This program is an include file to check if an interrupt points to the
; procedure about to be removed.  If it doesn't [another interrupt is present]
; it could be dangerous to try to restore the vector.  In this case the carry
; is set.  Otherwise a carry clear is returned.  AL is the interrupt to check
; and ES is the segment to match it with.
;
; Entry:
;       AL = interrupt
;       ES = segment
; Return:
;       Carry Set : no match
;       Carry Clr : match
; Changes:
;       AX
;---------------------------------------------------------------------------

Check   Proc    Far
        Assume CS:Code,DS:Nothing,ES:Nothing
        CLC 
        Push ES
        Push CX
        Push BX
        Push DS
        
        Mov CX,ES                   ; Segment of procedure
        Mov AH,35h                  ; Find segment vector points to
        Int 21h
        Mov AX,ES                   ; Segment of vector
        Cmp CX,AX                   ; Are they the same?
        Pop DS
        Pop BX
        Pop CX
        Pop ES
        JE No_Error_x               
        STC                         ; If not then set the carry
                
No_Error_x:
        
        Ret
Check   EndP        
