	Page 50,132
;-------------------------------------------------------------------------
; Program Name:  Write.Asm
;
; Author:  Steve Poulsen
;
; This include file will write characters to the screen without changing the
; color and using fast screen writes.  Upon entry SI should point to the start
; of the string to write in which a $ ends.  A 13 code will cause a CR and a
; line feed all at once.  BL should contain the row to start on with zero being
; the first row.  BH should be the column. CL is the attribute.
;------------------------------------------------------------------------
Write   Proc    Near
        Assume CS:Code,DS:Code,ES:Nothing
        Push AX
        Push ES
        Push DI
        Push DS
        Push SI
        Mov AX,CS
        Mov DS,AX
        
        Push BX
        
        Mov AX,0B800h                   ; Screen memory segment for color
        Mov ES,AX
        Mov AH,0Fh                      ; Check video mode
        Int 10h
        Cmp AL,07h                      ; Monochrome?
        JNE Color
        Mov AX,0B000h                   ; Screen memory segment for mono
        Mov ES,AX
Color:  
        Pop BX      
        Mov AL,160                      ; Add 160 [80 char+80 color] for
        Mul BL                          ; each Y value.
        Mov DI,AX
        Mov AL,BH
        Mov AH,0
        Shl AX,1
        Add DI,AX
        
        
Repeat:        
        Cmp [SI],Byte Ptr 13            ; Is it a CR
        JNE EndCheck

        Inc BL                          ; Increment Y value
        Mov AL,160                      ; Refigure DI 
        Mul BL
        
        Mov DI,AX
        Mov AL,BH
        Mov AH,0
        Shl AX,1
        Add DI,AX
        Inc SI

        Jmp Repeat
EndCheck:        
        Cmp [SI],Byte Ptr '$'           ; Is it a $ ?    
        JNE MoveIt
        Jmp MoveDone                    ; If so then exit
MoveIt:
        Movsb                           ; Mov char. from DS:SI to
        Mov ES:DI,CL
        Inc DI                          ; ES:DI [screen] and inc DI twice
        
        Jmp Repeat
MoveDone:
        Pop SI
        Pop DS
        Pop DI
        Pop ES
        Pop AX
        Ret        
Write   EndP

