(*Simple ugraf example program*)
(*Shows use of scan line oriented routines*)
(*Displays Mandelbrot set*)

program ex02;

uses ugraf;

const minx=-2;
      maxx=2;
      miny=-1.5;
      maxy=1.5;
      max_iter=150;

const resolution_x  : word = 640;
      resolution_y  : word = 480;
      bits_per_pixel = 8;

var initsavedand, whentostart : longint;
    lim : double;

function mandel(paraa, parab : integer) : longint;

const
      inc_savemod=11;

var period : boolean;
    iter, savedand, savedincr, iter2 : longint;
    x, y, oldx, dist, savedx, savedy, c1, c2 : double;

begin
     period:=false;
     iter:=max_iter;
     iter2:=0;
     c1:=paraa/getmaxx*(maxx-minx)+minx;
     c2:=parab/getmaxy*(maxy-miny)+miny;
     x:=c1;
     y:=c2;
     savedx:=x;
     savedy:=y;
     savedand:=initsavedand;
     savedincr:=inc_savemod;
     repeat
           oldx:=x;
           x:=(x+y)*(x-y)+c1;
           y:=2*oldx*y+c2;
           dist:=sqr(x)+sqr(y);
           if (iter2>whentostart) then begin
              if (iter2 and savedand)=0 then begin
                 savedx:=x;
                 savedy:=y;
                 dec(savedincr);
                 if savedincr=0 then begin
                    savedand:=(savedand shl 1)+1;
                    savedincr:=inc_savemod;
                 end;
              end else begin
                  if (abs(savedx-x)<lim) and (abs(savedy-y)<lim) then begin
                     period:=true;
                     iter:=0;
                     break;
                  end;
              end;
           end;
           dec(iter);
           inc(iter2);
     until (iter=0) or (dist>4);
     mandel:=max_iter-iter;
end;

function max(a, b : longint) : longint;
begin
     if a>b then max:=a else max:=b;
end;

var line : tline;
    x, y : word;

begin
     if find_best_mode(resolution_x, resolution_y, bits_per_pixel)=-1
        then begin
             done_graf;
             writeln('Can''t find a mode !!!');
             halt(250);
        end;

     if not init_mode then begin
        done_graf;
        writeln('Can''t switch to mode : ', mode);
        halt(2);
     end;

     initsavedand:=max(round(ln(max_iter)/ln(10)), 4)*2+1;
     whentostart:=(*max(round((ln(max_iter)/ln(10))*2+1), 250)*)2;
     lim:=1*sqrt(maxx-minx)/getmaxx;

     for y:=0 to getmaxy-1 do
         begin
              for x:=0 to getmaxx-1 do
                  line[x]:=mandel(x, y);
              write_line(screen, line, y, getmaxx);
         end;

     read_key;
     done_graf;
end.