(*Simple ugraf example program*)
(*Shows use of scan line oriented routines, and image buffering techniques*)
(*Displays Mandelbrot set*)

program ex03;

uses ugraf;

const resolution_x  : word = 320;
      resolution_y  : word = 200;
      bits_per_pixel = 8;

function mandel(x, y : integer) : longint;

const minx=-2;
      maxx=2;
      miny=-1.5;
      maxy=1.5;
      max_iter=150;

var a, b, olda, c, d : double;
    iter : integer;

begin
     iter:=max_iter;
     a:=0;
     b:=0;
     olda:=0;
     c:=x/getmaxx*(maxx-minx)+minx;
     d:=y/getmaxy*(maxy-miny)+miny;
     while (iter>=0) and (sqr(a)+sqr(b)<=4) do begin
           olda:=a;
           a:=(a+b)*(a-b)+c;
           b:=2*b*olda+d;
           dec(iter);
     end;
     mandel:=max_iter-iter;
end;

var line : tline;
    x, y : word;
    bitmap : pimage;

begin
     if find_best_mode(resolution_x, resolution_y, bits_per_pixel)=-1
        then begin
             done_graf;
             writeln('Can''t find a mode !!!');
             halt(250);
        end;

     if not init_mode then begin
        done_graf;
        writeln('Can''t switch to mode : ', mode);
        halt(2);
     end;

     bitmap:=create_bitmap(getmaxx, getmaxy);
     if bitmap=nil then begin
        writeln('Not enough memory');
        done_graf;
        halt(3);
     end;

     for y:=0 to getmaxy-1 do
         begin
              for x:=0 to getmaxx-1 do
                  line[x]:=mandel(x, y);
              write_line(bitmap, line, y, getmaxx);
         end;

     (*Nothing on screen, all was calculated in standard memory*)
     printat(screen, 0, 0, 'Mandelbrot Set was calculated', $8a0f, 0);
     printat(screen, 0, 10, 'in memory, hit any key to blit', $8a0f, 0);
     printat(screen, 0, 20, 'it to screen', $8a0f, 0);
     read_key;

     (*Put it on screen*)
     wait_synchro;
     blit(bitmap, screen, 0, 0, 0, 0, getmaxx, getmaxy);
     read_key;

     destroy_bitmap(bitmap);
     done_graf;
end.