(*Simple ugraf example program*)
(*Shows image manipulation functions*)

program ex05;

uses ugraf;

const resolution_x  : word = 800;
      resolution_y  : word = 600;
      bits_per_pixel: word= 8;

var pal : tpalette;
    maxx, maxy : word;

begin
     if find_best_mode(resolution_x, resolution_y, bits_per_pixel)=-1
        then begin
             done_graf;
             writeln('Can''t find a mode !!!');
             halt(250);
        end;


     if not init_mode
        then begin
             done_graf;
             writeln('Can''t switch to mode : ', mode);
             halt(2);
        end;

     return_sizepcx('mand.pcx', maxx, maxy, bits_per_pixel);
     if (maxx>getmaxx) or (maxy>getmaxy) or (bits_per_pixel<>8)
        then begin
             done_graf;
             writeln('Argghh, this file has not the good size');
             halt(3);
        end;

     if not draw_pcx(screen, 'mand.pcx', 0, 0, pal)    (*Draw a pcx file*)
        then begin
             done_graf;
             writeln('Can''t read that file');
             halt(4);
        end;
     write_palette(pal, 0, 256);                (*Write associated palette*)

     (*Dump upper left part to file*)
     (*Error can be detected when size returned is 0*)
     if dump_to_gif(screen, 'mand.gif', 0, 0, getmaxx div 2, getmaxy div 2, 8, pal)=0
        then begin
             done_graf;
             writeln('Can''t dump to gif');
             halt(5);
        end;

     print(screen, 'Hit any key', 15, 0);
     read_key;

     cleardevice;
     if not draw_gif(screen, 'mand.gif', (getmaxx div 4)-1, (getmaxy div 4)-1, pal)
        then begin
             done_graf;
             writeln('Can''t read that gif file ...');
             halt(6);
        end;
     write_palette(pal, 0, 256);

     read_key;

     done_graf;
end.