/*  Copyright (C) 1993   Marc Stern  (internet: stern@mble.philips.be)  */

#define Uses_TEvent
#define Uses_TStreamable
#define Uses_MsgBox
#define Uses_TInputRegExp
#include "tvtools.h"
__link( RInputLine )


#include <ctype.h>
#include <stdlib.h>
#include <strstream.h>

#include "strings.h"
#include "tools.h"


// TInputRegExp

const char * const TInputRegExp::name = "TInputRegExp";

char *TInputRegExp::invMsg = " \n\03Invalid entry !";

TInputRegExp::TInputRegExp( const TRect& bounds,
                            int aMaxLen,
                            const char *aSet,
                            const char *aRegexp,
                            casetype aNewcase
                          )
             :TInputLine( bounds, aMaxLen )
{
  init( aSet, aRegexp, aNewcase );
}


TInputRegExp::TInputRegExp( int x, int y,
                            int aMaxLen,
                            const char *aSet,
                            const char *aRegexp,
                            casetype aNewcase
                          )
             :TInput1Line( x, y, aMaxLen )
{
  init( aSet, aRegexp, aNewcase );
}


void TInputRegExp::init( const char *aSet,
                         const char *aRegexp,
                         casetype aNewcase
                       )
{
  if ( aSet ) set = strdup( aSet );
              else set = 0;
  if ( aRegexp ) regexp = strdup( aRegexp );
            else regexp = 0;
  newcase = aNewcase;
  if ( newcase && set ) strcase( set, newcase );
}


TInputRegExp::~TInputRegExp()
{
  if ( set ) free( set );
  if ( regexp ) free( regexp );
}


void TInputRegExp::setState( ushort aState, Boolean enable )
{
  static Boolean inUse = False;

  if ( (aState == sfFocused) && ! enable && ! inUse )
     {
       inUse = True;  // messageBox(),... in valid() could also call setState()
       Boolean check = valid( cmReleasedFocus );
       inUse = False;
       if ( ! check ) return;
     }

  TInputLine::setState( aState, enable );
}



void TInputRegExp::handleEvent( TEvent& event )
{
  if ( (state & sfSelected) && (event.what == evKeyDown) )
     {
       uchar &key = event.keyDown.charScan.charCode;

       if ( ! iscntrl(key) ) 
          {
            if ( newcase ) key = chcase( key, newcase );

            if ( set && *set && ! matchset(key, set) )
               {
                 buzzer();
                 clearEvent( event );
                 return;
               }
           }
     }

  TInputLine::handleEvent( event );
}


Boolean TInputRegExp::valid( ushort command )
{
  switch( command )
        {
          case cmReleasedFocus: return True;

          case cmQuit :
          case cmClose:
          case cmOK   : if ( regexp && *regexp )
                           {
                             if ( recursexp(data, regexp) != strlen(data) )
                                {
                                  select();
                                  if ( invMsg && *invMsg ) messageBox( invMsg, mfError | mfOKButton );
                                  return False;
                                }
                           }
                        break;
        }

  return TInputLine::valid(command);
}

