/***************************************************************************
  toyConfig include
  Personal TVToys preferences
  PJB November 3, 1993, Internet mail to d91-pbr@nada.kth.se
  Copyright 1993, All Rights Reserved
  Free source, use at your own risk.
  If modified, please state so if you pass this around.

  All defines have been moved to one file which is included by all
  units. Any changes here affect all TVToys units.

***************************************************************************/

#if !defined( __TOYCFG_H )
#define __TOYCFG_H

/*******************************************************************
  NewMouse draws its own mouse cursor on the screen and avoids
  buggy mouse driver code which makes your mouse unusable in many
  video modes.
  Define UseNewMouse to make TToyApp automatically use NewMouse.
  Default: Not defined     Affects: toyApp, VideoTst
*******************************************************************/
//#define USENEWMOUSE
#undef TOYUSENEWMOUSE


/*******************************************************************
  Define VesaSupport to make Video recognize Vesa support
  and use Vesa calls to set and get the video mode.
  Default: Defined        Affects: Video, ModeDlg
*******************************************************************/
#define TOYVESASUPPORT
//#undef TOYVESASUPPORT


/*******************************************************************
  Define Video7Support to make Video recognize Video 7 video
  cards and use Video 7 calls to set and get the video mode.
  Default: Defined        Affects: Video
*******************************************************************/
#define TOYVIDEO7SUPPORT
//#undef TOYVIDEO7SUPPORT


/*******************************************************************
  Define V7UniVesaKludge ONLY if you want to use an old version of
  UniVesa (4.2 and older) on a Video 7 card.
  Default: Not defined      Affects: Video
*******************************************************************/
//#define V7UNIVESAKLUDGE
#undef TOYV7UNIVESAKLUDGE


/*******************************************************************
  Define DiskFonts if you want FontDlg.SelectFontDialog to
  search on disk for font files. This is defined by default to
  make VideoTst a more interesting demo. I do not recomm}
  keeping it defined, it's 3K code.
  Default: Defined          Affects: FontDlg, (VideoTst)
*******************************************************************/
//#define TOYDISKFONTS
//#undef TOYDISKFONTS


/*******************************************************************
  Define ResFonts if you want FontDlg.SelectFontDialog to
  search in a resource file for font files. This is defined by
  default to make ResDemo a more interesting demo.
  Default: Defined          Affects: FontDlg, (ResDemo)
*******************************************************************/
//#define TOYRESFONTS
//#undef TOYRESFONTS


/*******************************************************************
  Define HelpExtensions to enable the back tracking buffer and
  the cmSwitchToTopic command.
  Default: Defined          Affects: HelpFile
*******************************************************************/
#define TOYHELPEXTENSIONS
//#undef TOYHELPEXTENSIONS


/*******************************************************************
  Define ExeHelp if you want toyApp to use the ExeStrm unit to
  look in the application's EXE file for the help file.
  ExeHelp currently assumes DOS 3+ compatibility.
  This is not very useful during debugging, so you might want to
  add a DEBUG conditional so that ExeHelp is defined only if DEBUG
  is not.
  Default: Not defined      Affects: toyApp
*******************************************************************/
//#define TOYEXEHELP
//#undef TOYEXEHELP


/*******************************************************************
  Define Color to get a colorful Info dialog in the VideoTst
  demo program. This might not work if substantial changes has
  been made to Turbo Vision's internal GetColor void in
  VIEWS.PAS. If you haven't changed the library, define it.
  Default: Defined          Affects: VideoTst
*******************************************************************/
//#define TOYCOLOR
//#undef TOYCOLOR



const
  maxVideoModes = 30,
  previewTime   = 12;      // 12/18ths of a second

#ifdef PROTECT
  #define Seg0040 biosSeg;
  #define SegB000 monoSeg;
  #define SegB800 colrSeg;
#else
  extern ushort Seg0040;
  extern ushort SegB000;
  extern ushort SegB800;
#endif

#define Mem(Seg,Ofs) (*(unsigned char *)MK_FP(Seg,Ofs))
#define MemW(Seg,Ofs) (*(unsigned short *)MK_FP(Seg,Ofs))


#endif
