/*===========================================================================
SOLAR slrreply :: Module ..\slrreply\slrreply.c
Original Author : Kevin Houle <kjhoule@iowegia.des-moines.ia.us>

This source code has been placed into the public domain.
===========================================================================*/

/* Header Files */
#include <string.h>
#include <stdio.h>
#include <dir.h>
#include <values.h>
#include "codedate.h"
#include "..\common\version.h"
#include "..\common\yesno.h"
#include "slrreply.h"

/*
 * Function: int main(int argc, char *argv[])
 * Purpose : The Solar System slrreply SOUP reply packet processor
 *           for DOS systems.
 * Return  : 0 on success, non-zero on error.
*/

int main(int argc, char *argv[])
{
  extern    char    *optarg;
  extern    int     optind;
  unsigned  char    x;
  const     char    *optionS = "u:U:R:r:VvfF";

  char              orig_path[MAXPATH];
  int               message_count = 0;
  int               exit_code     = x_success;

  /* Store original directory */

  getcwd(orig_path, MAXPATH);

  /* Set internal defaults */

  strcpy(temp_path,     "NONE");
  strcpy(user_path,     "NONE");
  strcpy(config_path,   "NONE");
  strcpy(log_path,      "NONE");
  strcpy(static_path,   "NONE");
  strcpy(waffle_path,   "NONE");
  strcpy(system_path,   "NONE");
  strcpy(extern_path,   "NONE");
  strcpy(lost_path,     "NONE");
  strcpy(solar_path,    "NONE");
  strcpy(swap_path,     ".");
  strcpy(backbone,      "NONE");
  strcpy(domain_name,   "NONE");
  strcpy(uucp_name,     "NONE");
  strcpy(organization,  "NONE");
  strcpy(tz,            "NONE");
  strcpy(username,      "NONE");
  strcpy(real_name,     "NONE");

  strcpy(news_program,  NEWS_PROGRAM);
  strcpy(mail_program,  MAIL_PROGRAM);

  diskswap             = YES;
  verbose              = NO;
  _maxnewssize         = MAXLONG;
  _maxmailsize         = MAXLONG;
  use_fossil           = NO;
  port                 = 99;

  /* Parse command line */

  while ((x = getopt(argc, argv, optionS)) != '\xFF')
  {
    switch (toupper(x)) {
      case '?'  : usage();
                  exit_code = x_usage;
                  goto ExitMain;
      case 'U'  : if ((strcmp(username,"NONE")) == 0)
                  {
                    strcpy(username,optarg);
                    break;
                  }
                  else
                  {
                    strcpy(_slrerr,"main(): cannot specify username twice.");
                    exit_code = x_usage;
                    goto ExitMain;
                  }
      case 'R'  : strcpy(real_name,optarg);
                  while (argc > optind)
                  {
                    strcat(real_name," ");
                    strcat(real_name,argv[optind++]);
                  }
                  break;
      case 'V'  : verbose = YES;
                  break;
      case 'F'  : use_fossil = YES;
									break;
    }
  }

  /* Hook for future DOORS.SYS / PCBDOOR.SYS processing */

  if (strcmp(username,"NONE") == 0)
  {
    if (read_doors() != 0)
    {
      exit_code = x_usage;
      goto ExitMain;
    }
  }

  if (verbose == YES)
  {
    RPrintf("\nSOLAR v%s <> slrreply (%s)\n\n",VERSION,CODE_DATE);
    RPrintf("Processing replies for user: %s\n",username);
  }

  /* Load configuration files. */

  if ((load_static(username) != 0)    || \
      (load_config() != 0)            || \
      (set_directory(temp_path) != 0))
  {
    exit_code = x_fatal;
    goto ExitMain;
  }

  if (verbose == YES)
    RPrintf("Default directory set to %s\n",temp_path);

  if (decompress_packet() != 0)
  {
    RPrintf("%s\n",_slrerr);
    goto ExitMain;
  }

  message_count = process_packet();
  if (message_count == -1L)
    exit_code = x_fatal;

ExitMain:
  set_directory(orig_path);
  switch (exit_code) {
    case x_success  : break;
    case x_usage    : usage();
                      break;
    case x_fatal    : RPrintf("%s\n",_slrerr);
                      sprintf(logbuf,"%s",_slrerr);
                      logit("slrreply");
                      break;
  }
  return exit_code;
}

/*
 * Function: void usage()
 * Purpose : Display command line usage.
 * Return  : N/A
*/

void usage()
{
  RPrintf("\nSOLAR v%s <> slrreply (%s)\n",VERSION,CODE_DATE);
  RPrintf("\nUsage: slrreply -u username [-v] [-f] [-rReal Name]\n");
  return;
}
