/*===========================================================================
SOLAR slrxfer v0.95.3 :: Module ..\slrxfer\slrxfer.h
Original Author: Kevin Houle <kjhoule@iowegia.des-moines.ia.us>

This software module has been placed in the public domain.
===========================================================================*/

/* Common Includes */

#include "..\common\spawno.h"     /* A product of Ralph Brown */
#include "..\common\version.h"
#include "..\common\yesno.h"
#include "..\common\soup.h"
#include "..\common\exitcode.h"

/* Static Data Storage */

#define OPTIONS_FILE    "OPTIONS.SLR"
#define SEND                        0
#define RECEIVE                     1

/* Local Global Data */

char program[MAXPATH];            /* Program to execute               */
char options[80];                 /* Options for program to execute   */
int  mode;

/* External Global Data */

extern char temp_path[MAXPATH];
extern char user_path[MAXPATH];
extern char log_path[MAXPATH];
extern char config_path[MAXPATH];
extern char swap_path[MAXPATH];
extern char uucpname[15];
extern char protocol[10];
extern int  diskswap;
extern int  use_fossil;
extern int  port;
extern char _slrerr[80];
extern int  verbose;
extern char logbuf[128];

/* Global Local Functions */

int  xfer_packet(char *function);
int  load_transfer_parms(char *function);
long get_packet_size();
void clean_up();
void usage();

/* Global Common Functions */

extern int  getopt(int argc, char *argv[], const char *optionS);
extern int  convert_to_number(char *argument);
extern int  logit();
extern char *extract_parm(char string[128], char delimiter);
extern int  set_directory(char *path);

/* Global External Functions */

extern int  load_static(char username[10]); /* From config.c */
extern int  load_config();                  /* From config.c */
extern int  user_defaults();                /* From config.c */
extern int  read_doors();                   /* From doors.c  */
