
# ********************************************************************
# *                                                                  *
# *     Use this MAKE script to build                                *
# *     Borland Delphi Run-Time Library for MS-DOS and Windows.      *
# *                                                                  *
# *     Author: Cosmin Truta <cosmint@cs.ubbcluj.ro>                 *
# *     Babes-Bolyai University, Cluj-Napoca, Romania, 1996          *
# *                                                                  *
# ********************************************************************

# This MAKE script requires Borland MAKE Version 3.7 or later (MAKE.EXE),
# Turbo Assembler Version 3.2 or later (TASM.EXE), and
# Borland Resource Compiler Version 4.0 or later (BRCC.EXE).

# After installing the library, type 'MAKE -f RTL80.MAK clean'
# to restore the original configuration of the RTL source directories.

# For complete uninstall, just remove this file, the batch file,
# the directory 'GNUUTILS' and the directory 'UPDATE'.

# Base directories determined either by BP / DELPHI environment variables,
# or the constants supplied here.
!if !$d(BP)
BP = \BP
!endif
!if !$d(DELPHI)
DELPHI = \DELPHI
!endif

# You may redefine these if the update package is in other directories.
!if !$d(UPDATE)
UPDATE = update
!endif
!if !$d(GNUUTILS)
GNUUTILS = gnuutils
!endif

# Set up macros for all required directories.
RTLBP  = $(BP)\rtl
SOURCE = $(DELPHI)\source
RTL    = $(SOURCE)\rtl
RTL70  = $(SOURCE)\rtl70
BIN    = $(RTL)\bin
LIB    = $(RTL)\lib
DCU    = $(LIB)\dcu
TPU    = $(LIB)\tpu
TPP    = $(LIB)\tpp
TV     = $(LIB)\tv

# Define the tools to use, based on DEBUG define.
!if $d(DEBUG)
TASM = tasm -t -w- -z -zd
DCC  = dcc -$$d+,l+
!else
TASM = tasm -t -w- -z
DCC  = dcc -$$d-,l-
!endif
BRCC = brcc

# Define different options for DCC.
DCCW = $(DCC) -t -cw -e$(DCU) -q -u$(DCU)
DCCD = $(DCC) -t -cd -e$(TPU) -q -u$(TPU)
DCCP = $(DCC) -t -cp -e$(TPP) -q -u$(TPP)

# These Unix-like tools come from GNU.
# You should read the notes from the 'GNUUTILS' directory.
SED   = $(GNUUTILS)\sed
TOUCH = $(GNUUTILS)\touch

rtl: mkdirs.msg rtlwin rtldos rtldpmi win tv

clean:
 cd $(RTL)
 del mkdirs.msg
 del sys\main.asm
 del sys\main.old
 del sys\heap.asm
 del sys\ei86.asm
 del sys\ei87.asm
 del sys\f87h.asm
 del sys\pars.asm
 del sys\last.asm
 del sys\dapp.asm
 del sys\dlib.asm
 del sys\*.ob*
 del win\buildwin.pas
 del win\windos.pas
 deltree /y $(RTL70)\dos
 deltree /y $(RTL70)\tv
 deltree /y bin
 deltree /y lib

rtlwin: $(BIN)\delphi.dsl $(DCU)\sysutils.dcu $(DCU)\sysutils.res

rtldos: $(BIN)\turbo.tpl $(TPU)\strings.tpu $(TPU)\windos.tpu

rtldpmi: $(BIN)\tpp.tpl $(TPP)\wintypes.tpp $(TPP)\winprocs.tpp

win: $(DCU)\buildwin.exe

tv: $(TV)\buildtv.exe

mkdirs.msg:
 cd $(RTL)
 mkdir $(BIN)
 mkdir $(LIB)
 mkdir $(DCU)
 mkdir $(TPU)
 mkdir $(TPP)
 mkdir $(TV)
 mkdir $(RTL70)\dos
 mkdir $(RTL70)\tv
 echo Destination directories created.> mkdirs.msg

$(BIN)\delphi.dsl: \
$(DCU)\system.dcu $(DCU)\wintypes.dcu $(DCU)\winprocs.dcu \
$(DCU)\messages.dcu $(DCU)\wincrt.dcu
 cd $(DCU)
 copy /b system.dcu+wintypes.dcu+winprocs.dcu+messages.dcu+wincrt.dcu $(BIN)\delphi.dsl
 cd $(RTL)

$(BIN)\turbo.tpl: \
$(TPU)\system.tpu $(TPU)\overlay.tpu $(TPU)\crt.tpu $(TPU)\dos.tpu \
$(TPU)\printer.tpu
 cd $(TPU)
 copy /b system.tpu+overlay.tpu+crt.tpu+dos.tpu+printer.tpu $(BIN)\turbo.tpl
 cd $(RTL)

$(BIN)\tpp.tpl: \
$(TPP)\system.tpp $(TPP)\crt.tpp $(TPP)\dos.tpp $(TPP)\printer.tpp \
$(TPP)\strings.tpp $(TPP)\windos.tpp $(TPP)\winapi.tpp
 cd $(TPP)
 copy /b system.tpp+crt.tpp+dos.tpp+printer.tpp+strings.tpp+windos.tpp+winapi.tpp $(BIN)\tpp.tpl
 cd $(RTL)

$(DCU)\system.dcu: sys\system.tps sys\system.pas \
sys\wapp.obw sys\wlib.obw sys\exit.obw sys\wmem.obw sys\errc.obw \
sys\objh.obw sys\fdiv.obw sys\df87.obw sys\tctl.obw sys\tgpc.obw \
sys\tchr.obw sys\tstr.obw sys\tpch.obw sys\tbol.obw sys\tint.obw \
sys\tf48.obw sys\tf87.obw sys\tfun.obw sys\fctl.obw sys\fdir.obw \
sys\cint.obw sys\cf48.obw sys\cf87.obw sys\wpar.obw sys\dirh.obw \
sys\wi87.obw sys\wx87.obw sys\we87.obw sys\excp.obw \
sys\varh.obj sys\long.obj sys\lovf.obj sys\strh.obj sys\seth.obj \
sys\tfio.obj sys\fp48.obj sys\f48h.obj sys\f48f.obj sys\rand.obj \
sys\dint.obj sys\df48.obj sys\sint.obj sys\sf48.obj sys\sf87.obj \
sys\ffun.obj sys\memh.obj sys\char.obj sys\dmth.obj sys\clsh.obj \
sys\clsf.obj sys\info.obj \
sys\wf87.obj
 cd sys
 $(DCCW) system
 cd ..

$(TPU)\system.tpu: sys\system.tps sys\system.pas \
sys\main.obj sys\exit.obj sys\heap.obj sys\errc.obj sys\ei86.obj \
sys\ei87.obj sys\f87h.obj sys\excp.obj \
sys\objh.obj sys\fdiv.obj sys\df87.obj sys\tctl.obj sys\tgpc.obj \
sys\tchr.obj sys\tpch.obj sys\tstr.obj sys\tbol.obj sys\tint.obj \
sys\tf48.obj sys\tf87.obj sys\tfun.obj sys\fctl.obj sys\fdir.obj \
sys\cint.obj sys\cf48.obj sys\cf87.obj sys\pars.obj sys\dirh.obj \
sys\varh.obj sys\long.obj sys\lovf.obj sys\strh.obj sys\seth.obj \
sys\tfio.obj sys\fp48.obj sys\f48h.obj sys\f48f.obj sys\rand.obj \
sys\dint.obj sys\df48.obj sys\sint.obj sys\sf48.obj sys\sf87.obj \
sys\ffun.obj sys\memh.obj sys\char.obj sys\dmth.obj sys\clsh.obj \
sys\clsf.obj sys\info.obj sys\last.obj \
sys\em86.obj sys\em87.obj
 cd sys
 $(DCCD) system
 cd ..

$(TPP)\system.tpp: sys\system.tps sys\system.pas \
sys\dapp.obp sys\dlib.obp sys\exit.obp sys\wmem.obp sys\errc.obp \
sys\ei86.obp sys\ei87.obp sys\f87h.obp sys\excp.obp \
sys\objh.obj sys\fdiv.obj sys\df87.obj sys\tctl.obj sys\tgpc.obj \
sys\tchr.obj sys\tpch.obj sys\tstr.obj sys\tbol.obj sys\tint.obj \
sys\tf48.obj sys\tf87.obj sys\tfun.obj sys\fctl.obj sys\fdir.obj \
sys\cint.obj sys\cf48.obj sys\cf87.obj sys\pars.obj sys\dirh.obj \
sys\varh.obj sys\long.obj sys\lovf.obj sys\strh.obj sys\seth.obj \
sys\tfio.obj sys\fp48.obj sys\f48h.obj sys\f48f.obj sys\rand.obj \
sys\dint.obj sys\df48.obj sys\sint.obj sys\sf48.obj sys\sf87.obj \
sys\ffun.obj sys\memh.obj sys\char.obj sys\dmth.obj sys\clsh.obj \
sys\clsf.obj sys\info.obj \
sys\em86.obp sys\em87.obp
 cd sys
 $(DCCP) system
 cd ..

$(DCU)\wintypes.dcu: $(DCU)\system.dcu win\wintypes.pas
 cd win
 $(DCCW) wintypes
 cd ..

$(TPP)\wintypes.tpp: $(TPP)\system.tpp win\wintypes.pas
 cd win
 $(DCCP) wintypes
 cd ..

$(DCU)\winprocs.dcu: $(DCU)\system.dcu $(DCU)\wintypes.dcu win\winprocs.pas
 cd win
 $(DCCW) winprocs
 cd ..

$(TPP)\winprocs.tpp: $(TPP)\system.tpp $(TPP)\wintypes.tpp win\winprocs.pas
 cd win
 $(DCCP) winprocs
 cd ..

$(DCU)\messages.dcu: $(DCU)\system.dcu $(DCU)\wintypes.dcu win\messages.pas
 cd win
 $(DCCW) messages
 cd ..

$(DCU)\wincrt.dcu: $(DCU)\system.dcu $(DCU)\sysutils.dcu \
$(DCU)\wintypes.dcu $(DCU)\winprocs.dcu $(DCU)\messages.dcu \
win\wincrt.pas
 cd win
 $(DCCW) wincrt
 cd ..

$(DCU)\sysutils.dcu: $(DCU)\system.dcu $(DCU)\wintypes.dcu \
$(DCU)\winprocs.dcu $(DCU)\toolhelp.dcu \
sys\sysutils.pas sys\sysutils.inc sys\sysutils.rc \
sys\sfmt.obw sys\ffmt.obw
 cd sys
 $(DCCW) sysutils
 cd ..

$(DCU)\sysutils.res: sys\sysutils.inc sys\sysutils.rc
 cd sys
 $(BRCC) sysutils.rc -fo$(DCU)\sysutils.res
 cd ..

$(DCU)\toolhelp.dcu: $(DCU)\system.dcu $(DCU)\wintypes.dcu \
win\toolhelp.pas
 cd win
 $(DCCW) toolhelp
 cd ..

$(TPU)\overlay.tpu: $(TPU)\system.tpu $(RTL70)\dos\overlay.pas \
$(RTL70)\dos\overlay.obj $(RTL70)\dos\overems.obj
 cd $(RTL70)\dos
 $(DCCD) overlay
 cd $(RTL)

$(TPU)\crt.tpu: $(TPU)\system.tpu $(RTL70)\dos\crt.pas $(RTL70)\dos\crt.obj
 cd $(RTL70)\dos
 $(DCCD) crt
 cd $(RTL)

$(TPP)\crt.tpp: $(TPP)\system.tpp $(RTL70)\dos\crt.pas $(RTL70)\dos\crt.obp
 cd $(RTL70)\dos
 $(DCCP) crt
 cd $(RTL)

$(TPU)\dos.tpu: $(TPU)\system.tpu $(RTL70)\dos\dos.pas \
$(RTL70)\dos\vers.obj $(RTL70)\dos\intr.obj $(RTL70)\dos\time.obj \
$(RTL70)\dos\cbrk.obj $(RTL70)\dos\verf.obj $(RTL70)\dos\disk.obj \
$(RTL70)\dos\fatr.obj $(RTL70)\dos\ftim.obj $(RTL70)\dos\find.obj \
$(RTL70)\dos\ptim.obj $(RTL70)\dos\vect.obj $(RTL70)\dos\swap.obj \
$(RTL70)\dos\keep.obj $(RTL70)\dos\exec.obj $(RTL70)\dos\srch.obj \
$(RTL70)\dos\expn.obj $(RTL70)\dos\splt.obj $(RTL70)\dos\envs.obj \
$(RTL70)\dos\envv.obj
 cd $(RTL70)\dos
 $(DCCD) dos
 cd $(RTL)

$(TPP)\dos.tpp: $(TPP)\system.tpp $(RTL70)\dos\dos.pas \
$(RTL70)\dos\vers.obj $(RTL70)\dos\intr.obp $(RTL70)\dos\time.obj \
$(RTL70)\dos\cbrk.obj $(RTL70)\dos\verf.obj $(RTL70)\dos\disk.obj \
$(RTL70)\dos\fatr.obj $(RTL70)\dos\ftim.obj $(RTL70)\dos\find.obj \
$(RTL70)\dos\ptim.obj $(RTL70)\dos\vect.obj $(RTL70)\dos\swap.obp \
$(RTL70)\dos\keep.obj $(RTL70)\dos\exec.obj $(RTL70)\dos\srch.obj \
$(RTL70)\dos\expn.obj $(RTL70)\dos\splt.obj $(RTL70)\dos\envs.obj \
$(RTL70)\dos\envv.obj
 cd $(RTL70)\dos
 $(DCCP) dos
 cd $(RTL)

$(TPU)\printer.tpu: $(TPU)\system.tpu $(RTL70)\dos\printer.pas
 cd $(RTL70)\dos
 $(DCCD) printer
 cd $(RTL)

$(TPP)\printer.tpp: $(TPP)\system.tpp $(RTL70)\dos\printer.pas
 cd $(RTL70)\dos
 $(DCCP) printer
 cd $(RTL)

$(TPU)\strings.tpu: $(TPU)\system.tpu $(RTL70)\strings.pas
 cd $(RTL70)
 $(DCCD) strings
 cd $(RTL)

$(TPP)\strings.tpp: $(TPP)\system.tpp $(RTL70)\strings.pas
 cd $(RTL70)
 $(DCCP) strings
 cd $(RTL)

$(TPU)\windos.tpu: $(TPU)\system.tpu $(TPU)\strings.tpu \
$(RTL70)\dos\windos.pas
 cd $(RTL70)\dos
 $(DCCD) windos
 cd $(RTL)

$(TPP)\windos.tpp: $(TPP)\system.tpp $(TPP)\strings.tpp \
$(RTL70)\dos\windos.pas
 cd $(RTL70)\dos
 $(DCCP) windos
 cd $(RTL)

$(TPP)\winapi.tpp: $(TPP)\system.tpp win\winapi.pas
 cd win
 $(DCCP) winapi
 cd $(RTL)

$(DCU)\buildwin.exe: win\buildwin.pas \
win\colordlg.pas win\commdlg.pas \
win\cpl.pas win\ddeml.pas win\dispatch.pas \
win\dlgs.pas win\lzexpand.pas win\messages.pas \
win\mmsystem.pas win\ole.pas win\ole2.pas \
win\penwin.pas win\print.pas win\shellapi.pas \
win\stress.pas win\toolhelp.pas win\ver.pas \
win\wfext.pas win\winapi.pas win\wincrt.pas \
win\winmem32.pas win\winprocs.pas \
win\wintypes.pas win\windos.pas \
$(DCU)\system.dcu $(DCU)\sysutils.dcu $(DCU)\sysutils.res
 cd win
 $(DCC) -cw -m -e$(DCU) -r$(DCU) -u$(DCU) -$$F+,S- buildwin
 cd ..

win\buildwin.pas: $(UPDATE)\buildwin.pas
 copy $(UPDATE)\buildwin.pas win

win\windos.pas: $(RTL70)\windos.pas
 copy $(RTL70)\windos.pas win

$(TV)\buildtv.exe: \
$(RTL70)\tv\format.obj $(RTL70)\tv\sysint.obj $(RTL70)\tv\sysint.obp \
$(RTL70)\tv\app.pas $(RTL70)\tv\colorsel.pas $(RTL70)\tv\dialogs.pas \
$(RTL70)\tv\drivers.pas $(RTL70)\tv\editors.pas $(RTL70)\tv\histlist.pas \
$(RTL70)\tv\memory.pas $(RTL70)\tv\menus.pas $(RTL70)\tv\msgbox.pas \
$(RTL70)\tv\outline.pas $(RTL70)\tv\stddlg.pas $(RTL70)\tv\textview.pas \
$(RTL70)\tv\views.pas $(RTL70)\tv\buildtv.pas $(RTL70)\tv\objects.pas \
$(RTL70)\tv\validate.pas \
$(RTL70)\tv\menus.old $(RTL70)\tv\views.old
 cd $(RTL70)\tv
 $(DCC) -cd -m -e$(TV) -u$(TPU) -$$F+,X+,I-,S-,P- buildtv
 $(DCC) -cp -m -e$(TV) -u$(TPP) -$$F-,X+,I-,S-,P- buildtv
 cd $(RTL)

$(RTL70)\dos\crt.obj: $(RTL70)\dos\crt.asm
 $(TASM) -e -i$(RTL)\sys $(RTL70)\dos\crt.asm,$(RTL70)\dos\crt.obj

$(RTL70)\dos\crt.obp: $(RTL70)\dos\crt.asm
 $(TASM) -e -i$(RTL)\sys -d_DPMI_ $(RTL70)\dos\crt.asm,$(RTL70)\dos\crt.obp

$(RTL70)\tv\format.obj: $(RTL70)\tv\format.asm
 $(TASM) -e $(RTL70)\tv\format.asm,$(RTL70)\tv\format.obj

$(RTL70)\tv\sysint.obj: $(RTL70)\tv\sysint.asm
 $(TASM) -e $(RTL70)\tv\sysint.asm,$(RTL70)\tv\sysint.obj

$(RTL70)\tv\sysint.obp: $(RTL70)\tv\sysint.asm
 $(TASM) -j.286p -e -d_DPMI_ $(RTL70)\tv\sysint.asm,$(RTL70)\tv\sysint.obp

.asm.obj:
 $(TASM) -e -isys $*,$*.obj

.asm.obw:
 $(TASM) -j.286p -isys -e -d_Windows_ $*,$*.obw

.asm.obp:
 $(TASM) -j.286p -isys -e -d_DPMI_ $*,$*.obp


# ... and here is how to update the Borland Pascal 7.0 Runtime Library sources

sys\main.asm: $(RTLBP)\sys\main.asm $(UPDATE)\main.sed
 copy $(RTLBP)\sys\main.asm sys\main.old
 $(SED) -f $(UPDATE)\main.sed sys\main.old > sys\main.asm
# $(TOUCH) -r sys\exit.asm sys\main.asm

sys\heap.asm: $(RTLBP)\sys\heap.asm
 copy $(RTLBP)\sys\heap.asm sys\heap.asm

sys\ei86.asm: $(RTLBP)\sys\ei86.asm
 copy $(RTLBP)\sys\ei86.asm sys\ei86.asm

sys\ei87.asm: $(RTLBP)\sys\ei87.asm
 copy $(RTLBP)\sys\ei87.asm sys\ei87.asm

sys\f87h.asm: $(RTLBP)\sys\f87h.asm
 copy $(RTLBP)\sys\f87h.asm sys\f87h.asm

sys\pars.asm: $(RTLBP)\sys\pars.asm
 copy $(RTLBP)\sys\pars.asm sys\pars.asm

sys\last.asm: $(RTLBP)\sys\last.asm
 copy $(RTLBP)\sys\last.asm sys\last.asm

sys\dapp.asm: $(RTLBP)\sys\dapp.asm
 copy $(RTLBP)\sys\dapp.asm sys\dapp.asm

sys\dlib.asm: $(RTLBP)\sys\dlib.asm
 copy $(RTLBP)\sys\dlib.asm sys\dlib.asm

sys\em86.obj:
 copy $(RTLBP)\lib\*.* sys

sys\em86.obp:
 copy $(RTLBP)\lib\*.* sys

sys\em87.obj:
 copy $(RTLBP)\lib\*.* sys

sys\em87.obp:
 copy $(RTLBP)\lib\*.* sys

sys\wf87.obj:
 copy $(RTLBP)\lib\*.* sys

$(RTL70)\dos\overems.obj:
 copy $(RTLBP)\ovr\*.* $(RTL70)\dos

$(RTL70)\dos\overlay.obj:
 copy $(RTLBP)\ovr\*.* $(RTL70)\dos

$(RTL70)\dos\overlay.pas:
 copy $(RTLBP)\ovr\*.* $(RTL70)\dos

$(RTL70)\dos\crt.asm:
 copy $(RTLBP)\crt\*.* $(RTL70)\dos

$(RTL70)\dos\crt.pas:
 copy $(RTLBP)\crt\*.* $(RTL70)\dos

$(RTL70)\dos\cbrk.asm:
 copy $(RTLBP)\dos\*.* $(RTL70)\dos

$(RTL70)\dos\disk.asm:
 copy $(RTLBP)\dos\*.* $(RTL70)\dos

$(RTL70)\dos\dos.pas:
 copy $(RTLBP)\dos\*.* $(RTL70)\dos

$(RTL70)\dos\envs.pas:
 copy $(RTLBP)\dos\*.* $(RTL70)\dos

$(RTL70)\dos\envv.pas:
 copy $(RTLBP)\dos\*.* $(RTL70)\dos

$(RTL70)\dos\exec.asm:
 copy $(RTLBP)\dos\*.* $(RTL70)\dos

$(RTL70)\dos\expn.asm:
 copy $(RTLBP)\dos\*.* $(RTL70)\dos

$(RTL70)\dos\fatr.asm:
 copy $(RTLBP)\dos\*.* $(RTL70)\dos

$(RTL70)\dos\find.asm:
 copy $(RTLBP)\dos\*.* $(RTL70)\dos

$(RTL70)\dos\ftim.asm:
 copy $(RTLBP)\dos\*.* $(RTL70)\dos

$(RTL70)\dos\intr.asm:
 copy $(RTLBP)\dos\*.* $(RTL70)\dos

$(RTL70)\dos\keep.asm:
 copy $(RTLBP)\dos\*.* $(RTL70)\dos

$(RTL70)\dos\ptim.asm:
 copy $(RTLBP)\dos\*.* $(RTL70)\dos

$(RTL70)\dos\splt.asm:
 copy $(RTLBP)\dos\*.* $(RTL70)\dos

$(RTL70)\dos\srch.asm:
 copy $(RTLBP)\dos\*.* $(RTL70)\dos

$(RTL70)\dos\swap.asm:
 copy $(RTLBP)\dos\*.* $(RTL70)\dos

$(RTL70)\dos\time.asm:
 copy $(RTLBP)\dos\*.* $(RTL70)\dos

$(RTL70)\dos\vect.asm:
 copy $(RTLBP)\dos\*.* $(RTL70)\dos

$(RTL70)\dos\verf.asm:
 copy $(RTLBP)\dos\*.* $(RTL70)\dos

$(RTL70)\dos\vers.asm:
 copy $(RTLBP)\dos\*.* $(RTL70)\dos

$(RTL70)\dos\printer.pas:
 copy $(RTLBP)\prt\*.* $(RTL70)\dos

$(RTL70)\dos\windos.pas:
 copy $(RTLBP)\win\windos.pas $(RTL70)\dos

$(RTL70)\tv\objects.pas:
 copy $(RTLBP)\common\*.* $(RTL70)\tv

$(RTL70)\tv\validate.pas:
 copy $(RTLBP)\common\*.* $(RTL70)\tv

$(RTL70)\tv\app.pas:
 copy $(RTLBP)\tv\*.* $(RTL70)\tv

$(RTL70)\tv\colorsel.pas:
 copy $(RTLBP)\tv\*.* $(RTL70)\tv

$(RTL70)\tv\dialogs.pas:
 copy $(RTLBP)\tv\*.* $(RTL70)\tv

$(RTL70)\tv\drivers.pas:
 copy $(RTLBP)\tv\*.* $(RTL70)\tv

$(RTL70)\tv\editors.pas:
 copy $(RTLBP)\tv\*.* $(RTL70)\tv

$(RTL70)\tv\format.asm:
 copy $(RTLBP)\tv\*.* $(RTL70)\tv

$(RTL70)\tv\histlist.pas:
 copy $(RTLBP)\tv\*.* $(RTL70)\tv

$(RTL70)\tv\memory.pas:
 copy $(RTLBP)\tv\*.* $(RTL70)\tv

$(RTL70)\tv\menus.pas:
 copy $(RTLBP)\tv\*.* $(RTL70)\tv

$(RTL70)\tv\msgbox.pas:
 copy $(RTLBP)\tv\*.* $(RTL70)\tv

$(RTL70)\tv\outline.pas:
 copy $(RTLBP)\tv\*.* $(RTL70)\tv

$(RTL70)\tv\stddlg.pas:
 copy $(RTLBP)\tv\*.* $(RTL70)\tv

$(RTL70)\tv\sysint.asm:
 copy $(RTLBP)\tv\*.* $(RTL70)\tv

$(RTL70)\tv\textview.pas:
 copy $(RTLBP)\tv\*.* $(RTL70)\tv

$(RTL70)\tv\views.pas:
 copy $(RTLBP)\tv\*.* $(RTL70)\tv

$(RTL70)\tv\buildtv.pas:

$(RTL70)\tv\menus.old:
 ren $(RTL70)\tv\menus.pas menus.old
 $(SED) -f $(UPDATE)\menus.sed $(RTL70)\tv\menus.old > $(RTL70)\tv\menus.pas
 $(TOUCH) -r $(RTL70)\tv\menus.old $(RTL70)\tv\menus.pas

$(RTL70)\tv\views.old:
 ren $(RTL70)\tv\views.pas views.old
 $(SED) -f $(UPDATE)\views.sed $(RTL70)\tv\views.old > $(RTL70)\tv\views.pas
 $(TOUCH) -r $(RTL70)\tv\views.old $(RTL70)\tv\views.pas

