(*
	This unit makes use of the DTools Balloon Hints component for its
	custom hint window appearance. The Balloon reference can be removed
	from the uses clause, but we strongly recommend replacing this
	component with another component, disabling hints completely, or
	implementing one of the many multiline hint extensions for Delphi
	and D2.

	Some of the source code here was derived from an anonymously authored
	demo project called ICONTRAP. It also requires ICONHCKR by William
	Brooks, and ICONHCKR's companion HEADERS unit.
*)

unit Iconsorc;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms,Tgeticon,StdCtrls,ShellAPI,Commdlg,iconhckr,Balloon,
  ExtCtrls, Menus;

type
  TIconedit = class(TForm)
	BalloonHint1: TBalloonHint;
    List1Ind: TGroupBox;
	Sourcefile: TEdit;
	Picksource: TButton;
	Label4: TLabel;
	Label5: TLabel;
	GroupBox2: TGroupBox;
	Label6: TLabel;
	Label7: TLabel;
	ListBox2: TListBox;
	Targetfile: TEdit;
	Picktarget: TButton;
	Update: TButton;
	Button3: TButton;
	ListBox3: TListBox;
	ListBox4: TListBox;
	Hintson: TCheckBox;
	Label2: TLabel;
	Label1: TLabel;
    CopyOverride: TCheckBox;
	Label3: TLabel;
	Label8: TLabel;
	Button2: TButton;
    Iconind1: TEdit;
	Iconind2: TEdit;
	Icosave2: TButton;
	Bmpsave2: TButton;
    Icosave1: TButton;
    Bmpsave1: TButton;
    Image1: TImage;
    Label9: TLabel;
    Label10: TLabel;
    ListBox1: TListBox;
	procedure ListBox1DrawItem(Control: TWinControl; Index: Integer;
	  Rect: TRect; State: TOwnerDrawState);
	procedure FormCreate(Sender: TObject);
	procedure FormDestroy(Sender: TObject);
	procedure PicksourceClick(Sender: TObject);
	procedure Button3Click(Sender: TObject);
	procedure PicktargetClick(Sender: TObject);
	procedure ListBox2DrawItem(Control: TWinControl; Index: Integer;
	  Rect: TRect; State: TOwnerDrawState);
	function Iconlister( szName: PANSICHAR ): BOOLEAN;
	procedure UpdateClick(Sender: TObject);
	procedure Icosave2Click(Sender: TObject);
	procedure HintsonClick(Sender: TObject);
	procedure ListBox1Click(Sender: TObject);
	procedure ListBox2Click(Sender: TObject);
	procedure Button2Click(Sender: TObject);
	procedure Bmpsave2Click(Sender: TObject);

  private
	{ Private declarations }
	procedure Updateerr(Errindex:Byte);
	{ Public declarations }
  end;

var	Iconedit: TIconedit;
	TBm,DS:TbitMap;
	TmpIcn:Ticon;
	ICN:TExeIcon;
	INIFile: array [byte] of Char;
	Updatesource: Bool;
	Dodialog: Bool;
const Section: array [0..12] of Char = 'Defaults';

implementation

uses Iconwarn,Utils;

{$R *.DFM}


procedure TIconedit.ListBox1DrawItem(Control: TWinControl; Index: Integer;
  Rect: TRect; State: TOwnerDrawState);
Var
R1:Trect;
Begin
 R1.left:=0;
 R1.Top:=0;
 R1.Right:=Rect.right-Rect.left;
 R1.Bottom:=Rect.Right-Rect.left;

 Ds.Width:=Rect.right-Rect.left;
 DS.Height:=Listbox1.ItemHeight;
 Ds.Canvas.Brush:=Listbox1.brush;

{ Ds.Canvas.Fillrect(r1);}
 Ds.Canvas.Draw(0,0,ICN.IconAtIndex(Sourcefile.text,Index));
 Listbox1.Canvas.Draw(Rect.left,REct.Top,DS);
end;


procedure TIconedit.FormCreate(Sender: TObject);
var Retstring: array [byte] of char;
	Ret2: array [0..20] of Char;
begin
	Font.Name := 'MS Sans Serif';
{Set hinting}
	StrPCopy(INIFile, ChangeFileExt(Application.ExeName,'.INI'));
	StrPCopy(Section, 'Defaults');
	GetPrivateProfileString('Defaults','Hints','',Retstring,SizeOf(RetString),INIFile);
	If StrPas(RetString) = StrPas('Off') Then begin
		Application.ShowHint := False;
		Hintson.Checked := False;
	end else begin
		Application.ShowHint := True;
		Hintson.Checked := True;
	End;
{Initialize vars for icon types}
	Ds:=TBitmap.Create;
	ICN:=TExeIcon.Create;
End;

procedure TIconedit.FormDestroy(Sender: TObject);
begin
	Ds.free;
	ICN.Free;
end;


procedure TIconedit.PicksourceClick(Sender: TObject);
var P1: array [byte] of char;
	P2: array [0..50] of Char;
	filerec: TOpenfilename;
	I,Count:Integer;
	s: string;
begin
	StrPCopy(P1,'');
	StrPCopy(P2,'Icon sources' + #0 + '*.ico;*.exe;*.dll;*.vbx;*.ocx'+#0+#0);
	filerec.lStructSize := sizeof(TOpenFileName); {length of structure...must be SizeOf(TOpenFileName)}
	filerec.hwndOwner := Self.Handle;  {handle of owner window...mandatory}
	filerec.lpstrFilter := P2;  		{address of filter list...see how P2 was generated; two nulls are needed at end}
	filerec.lpstrCustomFilter := nil;    {custom filter address (e.g. P3)}
	filerec.nFilterIndex := 1;              {not needed here but nice to have in the template}
	filerec.lpstrFile := P1;         {pchar buffer for source filename}
	filerec.nMaxFile := 256; {size of buffer...256 is relatively safe}
	filerec.lpstrFileTitle := nil;          {buffer for saved fileNAME only in case needed by application}
	filerec.lpstrInitialDir := nil;         {initial directory displayed in save dialog}
	filerec.lpstrTitle := 'Select an icon-bearig source file:'; {title for dialog box...optional}
	filerec.Flags := OFN_FILEMUSTEXIST + OFN_HIDEREADONLY {+ OFN_NOTEXTFILECREATE + OFN_OVERWRITEPROMPT}; {optionals}
	filerec.lpstrDefExt := nil;            	{default extension}
	if (GetOpenFileName(filerec) = False) Then begin
		MessageBox(Self.Handle,'No file selected','Icon source file selection aborted',48);
		Exit;
	end else begin
		Sourcefile.Text := StrPas(P1);
		Listbox1.Items.Clear;
		Count:=ICN.IconCount(Sourcefile.Text);
{	  Status1.Sections[1]:=IntToStr(Count)+' Icons';}
		Listbox1.Visible:=False;
		For I:=0 to Count-1 do Listbox1.items.add('');
		Listbox1.Visible:=True;
{		Label3.Caption:=IntToStr(Count)+' Icons in '+S;}
	end;
end;

procedure TIconedit.Button3Click(Sender: TObject);
begin
	Application.Terminate;
end;

procedure TIconedit.PicktargetClick(Sender: TObject);
var P1: array [byte] of char;
	P2: array [0..50] of Char;
	filerec: TOpenfilename;
	I,Count:Integer;
	s: string;
begin
	StrPCopy(P1,'');
	StrPCopy(P2,'EXES and DLLs' + #0 + '*.exe;*.dll'+#0+#0);
	filerec.lStructSize := sizeof(TOpenFileName); {length of structure...must be SizeOf(TOpenFileName)}
	filerec.hwndOwner := Self.Handle;  {handle of owner window...mandatory}
	filerec.lpstrFilter := P2;  		{address of filter list...see how P2 was generated; two nulls are needed at end}
	filerec.lpstrCustomFilter := nil;    {custom filter address (e.g. P3)}
	filerec.nFilterIndex := 1;              {not needed here but nice to have in the template}
	filerec.lpstrFile := P1;         {pchar buffer for source filename}
	filerec.nMaxFile := 256; {size of buffer...256 is relatively safe}
	filerec.lpstrFileTitle := nil;          {buffer for saved fileNAME only in case needed by application}
	filerec.lpstrInitialDir := nil;         {initial directory displayed in save dialog}
	filerec.lpstrTitle := 'Select the file to be patched:'; {title for dialog box...optional}
	filerec.Flags := OFN_FILEMUSTEXIST + OFN_HIDEREADONLY {+ OFN_NOTEXTFILECREATE + OFN_OVERWRITEPROMPT}; {optionals}
	filerec.lpstrDefExt := nil;            	{default extension}
	if (GetOpenFileName(filerec) = False) Then begin
		MessageBox(Self.Handle,'No file selected','Icon target file selection aborted',48);
		Exit;
	end else begin
		Targetfile.Text := StrPas(P1);
		Listbox2.Items.Clear;
		Count:=ICN.IconCount(Targetfile.Text);
{	  Status1.Sections[1]:=IntToStr(Count)+' Icons';}
		Listbox2.Visible:=False;
		For I:=0 to Count-1 do Listbox2.items.add('');
		Listbox2.Visible:=True;
{		Label8.Caption:=IntToStr(Count)+' Icons in '+S;}
		Update.Caption := '&Update ' + ExtractFilename(Targetfile.Text);
	end;
end;


procedure TIconedit.ListBox2DrawItem(Control: TWinControl; Index: Integer;
  Rect: TRect; State: TOwnerDrawState);
var R1:Trect;
Begin
 R1.left:=0;
 R1.Top:=0;
 R1.Right:=Rect.right-Rect.left;
 R1.Bottom:=Rect.Right-Rect.left;
 Ds.Width:=Rect.right-Rect.left;
 Ds.Height:=Listbox2.ItemHeight;
 Ds.Canvas.Brush:=Listbox2.brush;
 Ds.Canvas.Fillrect(r1);
 Ds.Canvas.Draw(0,0,ICN.IconAtIndex(Targetfile.text,Index));
 Listbox2.Canvas.Draw(Rect.left,REct.Top,DS);
end;


function TIconedit.Iconlister( szName: PANSICHAR ): BOOLEAN;
var szBuffer : Array [ 0 .. 100 ] of CHAR;
begin
	if (HIWORD(LONGINT(szName)) = 0) then begin
		StrFmt(szBuffer, '%d', [LONGINT(szName)]);
		Result := FALSE;
{file has no icons}
	end else begin
		If (UpdateSource = True) and (StrPas(szName) <> StrPas(''))
			then Listbox3.Items.Add(StrPas(szName))
		else
		If (UpdateSource = False) and (StrPas(szName) <> StrPas(''))
			then Listbox4.Items.Add(StrPas(szName));
		Result := TRUE;
	end;
end;


procedure TIconEdit.UpdateErr(Errindex:Byte);
begin
	If Errindex = 0 then MessageBox(Self.Handle,'Icon patch operation complete. '
		+'Reload the patched file from '
		+'the directory where the copy was saved into the bottom browser window '
		+'to check your results. If no change is observed, consult the help for '
		+'tips on how to proceed.','Patch operation complete',64);
	If Errindex = 1 then Messagebox(Self.Handle,'No icon has been selected from your '
		+'source file. Select an icon image from the top icon display '
		+'window and try again.'
		,'Unable to modify the file',16);
	If Errindex = 2 then Messagebox(Self.Handle,'No icon has been selected as the target '
		+'icon to be replaced. Select an icon image from the bottom icon display '
		+'window and try again.','Unable to modify the file',16);
	If Errindex = 3 then MessageBox(Self.Handle,'You are attempting to patch an icon '
		+'into your source file. The copy operation will destroy the file.'+#10#10
		+'Unable to permit this patch.','Patch operation aborted',16);
	If Errindex = 4 then MessageBox(Self.Handle,'Unable to copy the file to your specified '
		+'location.','File backup aborted...unable to continue',16);
	If Errindex = 5 then MessageBox(Self.Handle,'Unable to fetch a list of valid icons in the '
		+'target file...unable to proceed.','Patch operation failed',16);
	If Errindex = 6 then MessageBox(Self.Handle,'The specified icon in the target file does '
		+'not conform to naming conventions used by the patch tool. This icon '
		+'cannot be replaced by this tool.','Unable to replace icon',16);
	If Errindex = 7 then MessageBox(Self.Handle,'Unable to fetch a list of valid icons in the '
		+'source file...unable to proceed.','Patch operation failed',16);
	If Errindex = 8 then MessageBox(Self.Handle,'The specified icon in the source file does '
		+'not conform to naming conventions used by the patch tool. '
		+'Save this icon to disk, reload it as the new source file and '
		+'retry the patch operation.','Unable to use current parameters',16);
	If Errindex = 9 then MessageBox(Self.Handle,'Unable to patch icon into target file'
		+#10+'(unknown error)','Icon patch failed',0);
end;

procedure TIconedit.UpdateClick(Sender: TObject);
var SourceIconID,TargetIconID: array [byte] of Char;
	S1,S2: string;
	i1: integer;
	l1: longint;
	SourceResFile, TargetResFile : TResourceFile;
	SourceBinary,TargetBinary: array [byte] of Char;
	SourceIsOK,TargetIsOK: Bool;
	TargetWasCreated: Bool;
{Filesave vars}
	filerec: Topenfilename;
	P1,P2,P3,P4: array [byte] of Char;
	UseTheCopy,IconWasPatched: Bool;
const DLL: String[4] = 'DLL';
label PatchIt;
label Outtahere;
begin
{NOTE: To insure smooth flow, the resfile objects are created
 in the icon browser box on-click events.
{Set booleans here}
	Updatesource := False; {always updates target list first}
	IconWasPatched := False;
	TargetWasCreated := False;
{Error-checking}
	If Listbox1.Itemindex = -1 {no icon selected} then begin
		UpdateErr(1);
		exit;
	end;
	If Listbox2.Itemindex = -1 {no icon selected} then begin
		UpdateErr(2);
		exit;
	end;
{Fill in TargetBinary and SourceBinary now}
	StrPCopy(TargetBinary,Targetfile.Text);
	StrPCopy(SourceBinary,Sourcefile.Text);
{Does user want fast action?}
	If CopyOverride.Checked = True then begin
		UseTheCopy := False;
		goto PatchIt;
	end else UseTheCopy := True;
{Get confirmation from the user}
	StrPCopy(P1,'About to patch... ' + #10#10 +ExtractFileName(Sourcefile.Text)
		+ #39 + 's icon at index number ' + Iconind1.Text + #10#10 + ' ...into... '
		+ #10#10 + ExtractFileName(TargetFile.Text) + ' at index number '
		+ Iconind2.Text + '.' + #10#10 + '...ready to proceed?');
	i1 := Messagebox(Self.Handle,P1,'Ready to patch the icon',32 + MB_YESNO);
	if i1 = ID_NO then Exit;
{Get a destination and back up the original}
	StrPCopy(P2,'All files' + #0 + '*.*'+#0+#0);
	StrPCopy(P3,'Destination for copy of ' + ExtractFileName(Targetfile.Text));
	filerec.lStructSize := sizeof(TOpenFileName); {length of structure...must be SizeOf(TOpenFileName)}
	filerec.hwndOwner := Self.Handle;  {handle of owner window...mandatory}
	filerec.lpstrFilter := P2;  		{address of filter list...see how P2 was generated; two nulls are needed at end}
	filerec.lpstrCustomFilter := nil;    {custom filter address (e.g. P3)}
	filerec.nFilterIndex := 1;              {not needed here but nice to have in the template}
	filerec.lpstrFile := TargetBinary;         {pchar buffer for source filename}
	filerec.nMaxFile := 256; {size of buffer...256 is relatively safe}
	filerec.lpstrFileTitle := nil;          {buffer for saved fileNAME only in case needed by application}
	filerec.lpstrInitialDir := nil;         {initial directory displayed in save dialog}
	filerec.lpstrTitle := P3; {title for dialog box...optional}
	filerec.Flags := OFN_HIDEREADONLY + OFN_NOTEXTFILECREATE + OFN_OVERWRITEPROMPT; {optionals}
	filerec.lpstrDefExt := nil;            	{default extension}
	if (GetSaveFileName(filerec) = False) Then begin
		MessageBox(Self.Handle,'No file selected...aborting modification','Icon not saved',48);
		Exit;
	end else begin
{Did user try to rename a DLL?  Baaaad user!!}
		S1 := ExtractFileName(UpperCase(StrPas(TargetBinary)));
		S2 := ExtractFileName(UpperCase(Targetfile.Text));
		If (ExtractFileExt(S1)=DLL) and (S1[1]+S1[2]='WH') and (S2[1]+S2[2]='WH')
		Then begin
			i1 := MessageBox(Self.Handle,'If you are attempting to save a Sorcerer DLL under a '
			+'different name from its original filename, the project using '
			+'the Sorcerer DLL may produce errors.'+#10#10
			+'Are you attempting to rename a Sorcerer DLL?'
			,'Possible conflict detected',32 + MB_YESNO);
			if i1 = ID_YES then begin
				messagebox(Self.Handle,
				 'Unable to complete the operation. This operation violates '
				+'the terms of your redistribution license. If this file is not '
				+'for redistribution, then rename it manually and reload it into '
				+'the icon patcher interface.'
				,'Unable to save this file under a different name',16);
				Exit;
			end;{copyright violation warn}
		end;{self-copy check}
	end;{GSFN = False}
{Now can we safely back up the file? If fail, bail.}
	If StrPas(TargetBinary) = SourceFile.Text then begin
		UpdateErr(3);
		Exit;
	end;
	If CopyFile(Targetfile.Text,S1) = False then begin
		UpdateErr(4);
		Exit;
	end;
PatchIt:
{%%: Always need target file, icon ID and resource list...}
	TargetResFile := TResourceFile.Create(TargetBinary);
	TargetWasCreated := True;
	TargetIsOK := TargetResFile.EnumIcons(IconLister);
	If TargetIsOK = FALSE then begin
		UpdateErr(5);
		Goto Outtahere;
	end;
	Updatesource := True; {next call to iconlister, update the source list}
{!!: Can we actually do this job? Start with executables...}
	StrPCopy(TargetIconID,ListBox4.Items[Listbox2.Itemindex]);
	If TargetResFile.FindIcon(TargetIconID) = 0 {not found} then begin
		UpdateErr(6);
		Goto Outtahere;
	end;
{Stop everything...give the system a chance to catch up}
	YieldApp;

(*************Flat ico-to-exe patch************)
{...now check the icon's integrity...}
	If UpperCase(ExtractFileExt(Sourcefile.Text)) = '.ICO' then begin
{NOW we can actually update the file.}
		IconWasPatched := TargetResFile.UpdateIcon(TargetIconID,SourceBinary);
		goto Outtahere;
	end;


(******************exe-to-exe patch*************)
{%%: only need sourcefile listing if not an ICO}
	SourceResFile := TResourceFile.Create(SourceBinary);
	If SourceResFile.EnumIcons(IconLister) = TRUE then begin
		StrPCopy(SourceIconID,Listbox3.Items[Listbox1.Itemindex])
	end else begin
		UpdateErr(7);
		Goto Outtahere;
	end;

YieldApp;
{!!: Can we use this sourcefile?}
	If SourceResFile.FindIcon(SourceIconID) = 0 {not found} then begin
		UpdateErr(8);
		Goto Outtahere;
	end;
{This icon appears to be OK...let's patch;
 ICONHCKR will try to trap any remaining errors}
	IconWasPatched := TargetResFile.UpdateIconFromImage(TargetIconID,SourceResFile,SourceIconID);
	If IconWasPatched = False Then UpdateErr(9);
{Cleanup source}
	SourceResFile.Free;{icon type check and actual patching done}

Outtahere:
{Cleanup target}
	If TargetWasCreated = True then TargetResFile.Free;
{Reinitialize the index readouts}
	Iconind1.Text := '';
	Iconind2.Text := '';
{Empty/initialize the current listboxes so user must reselect for next time}
	Listbox3.Items.Clear;
	Listbox4.Items.Clear;
	Listbox1.ItemIndex := -1;
	Listbox2.ItemIndex := -1;
{Last bit of assistance}
	If (UseTheCopy = True) and (IconWasPatched = True) then UpdateErr(0);
end;



procedure TIconedit.Icosave2Click(Sender: TObject);
var
	P1: array [byte] of Char;
	NewIcon: TIcon;
	Handle: THandle;
	P2: array [0..50] of Char;
	P3: array [byte] of char;
	filerec: TOpenfilename;
begin
	If Listbox1.Itemindex <> -1 then begin
		NewIcon := TIcon.Create;
		Handle := hInstance;
		StrPCopy(P1,Sourcefile.Text);
		NewIcon.Handle := ExtractIcon(Handle,P1,Listbox2.Itemindex);
		StrPCopy(P1,'');
		StrPCopy(P2,'Icon files' + #0 + '*.ico'+#0+#0);
		filerec.lStructSize := sizeof(TOpenFileName); {length of structure...must be SizeOf(TOpenFileName)}
		filerec.hwndOwner := Self.Handle;  {handle of owner window...mandatory}
		filerec.lpstrFilter := P2;  		{address of filter list...see how P2 was generated; two nulls are needed at end}
		filerec.lpstrCustomFilter := nil;    {custom filter address (e.g. P3)}
		filerec.nFilterIndex := 1;              {not needed here but nice to have in the template}
		filerec.lpstrFile := P1;         {pchar buffer for source filename}
		filerec.nMaxFile := 256; {size of buffer...256 is relatively safe}
		filerec.lpstrFileTitle := nil;          {buffer for saved fileNAME only in case needed by application}
		filerec.lpstrInitialDir := nil;         {initial directory displayed in save dialog}
		filerec.lpstrTitle := 'Save this icon as:'; {title for dialog box...optional}
		filerec.Flags := OFN_HIDEREADONLY + OFN_NOTEXTFILECREATE + OFN_OVERWRITEPROMPT; {optionals}
		filerec.lpstrDefExt := nil;            	{default extension}
		if (GetSaveFileName(filerec) = False) Then begin
			MessageBox(Self.Handle,'No file selected','Icon not saved',48);
			Exit;
		end else begin
			Newicon.SaveToFile(StrPas(P1));
			NewIcon.Free;
			StrPCopy(P3,'The selected icon has been saved as' + #10#10 + StrPas(P1));
			MessageBox(Self.Handle,P3,'Icon saved',64);
		end;
	end else MessageBox(Self.Handle,'No icon has been selected from the '
		+'top row of icons. Unable to save an icon.','Icon save aborted',16);
end;


procedure TIconedit.HintsonClick(Sender: TObject);
begin
	If Hintson.Checked = False then begin
		Application.ShowHint := False;
		WritePrivateProfileString(Section,'Hints','Off',INIFile);
	end else begin
		Application.ShowHint := True;
		WritePrivateProfileString(Section,'Hints','On',INIFile);
	End;

end;

procedure TIconedit.ListBox1Click(Sender: TObject);
begin
	Iconind1.Text := IntToStr(Listbox1.Itemindex);
end;

procedure TIconedit.ListBox2Click(Sender: TObject);
begin
	Iconind2.Text := IntToStr(Listbox2.Itemindex);
end;

procedure TIconedit.Button2Click(Sender: TObject);
var P1: array [0..255] of Char;
begin
	Application.HelpCommand(HELP_CONTEXT,75000);
end;

procedure TIconedit.Bmpsave2Click(Sender: TObject);
var
	P1: array [byte] of Char;
	OldIcon: TIcon;
	NewBmp: TBitmap;
	Handle: THandle;
	P2: array [0..50] of Char;
	P3: array [byte] of char;
	filerec: TOpenfilename;
	Dibrect: Trect;
begin
	If Listbox1.Itemindex = -1 then begin
		MessageBox(Self.Handle,'No bitmap has been selected from the '
			+'bottom row of icons. Unable to save an icon.','Icon save aborted',16);
		Exit;
	end;
	OldIcon := TIcon.Create;
	Handle := hInstance;
	StrPCopy(P1,Sourcefile.Text);
	OldIcon.Handle := ExtractIcon(Handle,P1,Listbox2.Itemindex);
	StrPCopy(P1,'');
	StrPCopy(P2,'Bitmap files' + #0 + '*.bmp'+#0+#0);
	filerec.lStructSize := sizeof(TOpenFileName); {length of structure...must be SizeOf(TOpenFileName)}
	filerec.hwndOwner := Self.Handle;  {handle of owner window...mandatory}
	filerec.lpstrFilter := P2;  		{address of filter list...see how P2 was generated; two nulls are needed at end}
	filerec.lpstrCustomFilter := nil;    {custom filter address (e.g. P3)}
	filerec.nFilterIndex := 1;              {not needed here but nice to have in the template}
	filerec.lpstrFile := P1;         {pchar buffer for source filename}
	filerec.nMaxFile := 256; {size of buffer...256 is relatively safe}
	filerec.lpstrFileTitle := nil;          {buffer for saved fileNAME only in case needed by application}
	filerec.lpstrInitialDir := nil;         {initial directory displayed in save dialog}
	filerec.lpstrTitle := 'Save this bitmap as:'; {title for dialog box...optional}
	filerec.Flags := OFN_HIDEREADONLY + OFN_NOTEXTFILECREATE + OFN_OVERWRITEPROMPT; {optionals}
	filerec.lpstrDefExt := nil;            	{default extension}
	if (GetSaveFileName(filerec) = False) Then begin
		MessageBox(Self.Handle,'No file selected','Bitmap not saved',48);
		Exit;
	end else begin
(*
		try
			NewBmp := TBitmap.Create;
			NewBmp.Width := Oldicon.Width;
			NewBmp.Height := Oldicon.Height;
			GetWindowRect(NewBmp.Handle,Dibrect);
			Brush.Color := clWhite;
			FillRect(NewBmp.Canvas,DibRect,Brush);
			Draw(0, 0, OldIcon);

			SelectPalette(NewBmp.Canvas.Handle,Oldicon.Canvas.Palette,True);
			with NewBmp.Canvas do begin
			end;
			NewBmp.SaveToFile(StrPas(P1));
		except
			NewBmp.Free;
			raise;
		end;{try}
*)
	end;{gofn}
	Oldicon.Free;
	StrPCopy(P3,'The selected bitmap has been saved as' + #10#10 + StrPas(P1));
	MessageBox(Self.Handle,P3,'Bitmap saved',64);
end;

end.
