@echo off
  echo -------------------------------------------------------
  echo Windows Program compile batch for MSC 6.00a Large Model
  echo by Bill Buckels December 1995
  echo -------------------------------------------------------
rem generic windows compile batch for MSC 6.00a command line compiler
rem overcomes problems with the compiler running out of far heap space
rem while using nmake on large source files

  if "%1" == "" goto USAGE

  if not exist %1.C goto SRCERR
  if not exist %1.def goto DEFERR
  if not exist %1.rc goto RCERR

  if "%2" == "RC" goto RCDEL
  if "%2" == "rc" goto RCDEL
  if "%3" == "RC" goto RCDEL
  if "%3" == "rc" goto RCDEL
  goto SKIPDEL

:RCDEL
  if exist %1.res erase %1.res
:SKIPDEL

  if "%2" == "LINK" goto LINK
  if "%2" == "link" goto LINK
  if "%3" == "LINK" goto LINK
  if "%3" == "link" goto LINK
goto BEGIN


rem -------------------- Begin Initialization Errors ----------------------
:USAGE
  echo Usage is : "winmake [filename]" (no extension)
  echo -------------------------------------------------------
  echo Switches follow filename :
  echo                Link only : "winmake [filename] LINK"
  echo                Create Res: "winmake [filename] RC"
  echo -------------------------------------------------------
goto END

:SRCERR
  echo %1.C was not found!
goto END

:DEFERR
  echo %1.DEF was not found!
goto END

:RCERR
echo %1.RC was not found!
goto END
rem -------------------- End Initialization Errors ------------------------


rem --------------Begin Compile, Link, and Bind ---------------------------

:BEGIN
  if exist %1.EXE erase %1.EXE
  if exist %1.OBJ erase %1.OBJ
CL -AL -Os -Gsw -c -Zpe %1.C >c.err

:LINK
  if not exist %1.obj goto COMPERR
  LINK /al:16 /NOD /ST:8000 %1.OBJ %3 %4,,NUL,LIBW LLIBCEW COMMDLG MMSYSTEM,%1.DEF;
  if not exist %1.exe goto LINKERR
  if exist %1.res goto SKIPRC

RC -r %1.rc
  if not exist %1.res goto RESERR

:SKIPRC
RC %1.res %1.exe
goto END
rem ----------------End Compile, Link, and Bind ---------------------------


rem -------------------- Begin Process Errors -----------------------------
:COMPERR
  echo An Error Occurred While Compiling %1.C
  echo C.Err was created!
goto END

:LINKERR
  echo An Error Occurred While Linking %1.OBJ
goto END

:RESERR
  echo Unable to Create %1.RES
goto END
rem -------------------- End Process Errors -------------------------------

:END
