/*****************************************************************************/
/* Program name:                  NCSA2NET.C                                 */
/*****************************************************************************/
/* Programmer: Kevin Georgison                                               */
/* Date:       Aug 27, 1995                                                  */
/*****************************************************************************/
/* Program Description:	Convert NCSA hot files into a format that Netscape   */
/*	can import.                                                          */
/*                                                                           */
/*****************************************************************************/
/* Comments: Modified by Jack Fitts to convert NCSA mosaic 2.0 hotlist with  */
/*	time/date stamps to Netscape import fomat.                           */
/*****************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_L_LEN 512
#define MAX_MENUS 64

int menu_search(int cur_menu_num, FILE *fs, char *ln);
int get_menu_num(char *ln);
void get_title(char *ln, char *menu_name);
void out_title(char *menu_name);
int get_item(FILE *fs, char *ln);
char test_item(char *ln);
void out_item(char *url, char *title);
void parse_item(char *ln, char *title, char *url);
int isitnew(int *done_menus, int cur_menu_num);
void initialize(int *done_menus);
int get_submenu_num(char *ln);

void main(int argc, char **argv) {
	FILE	*fs,
		*fd;
	char	ln[MAX_L_LEN],
		url[MAX_L_LEN],
		title[MAX_L_LEN],
		menu_name[MAX_L_LEN],
		i_type;
	int	done_menus[MAX_MENUS],
		menutreelevel=0,
		here_again=0,
		submenu_num,
		first_search=1,
		failed_a_prev_read=0,
		cur_menu_num=0;
	long	fp[MAX_MENUS],
		prev_line;

		if(argc == 1) {
			printf("USAGE:\n\tncsa2net file.hot > newfile.htm\n\n"
				"\tConvert a NCSA Mosaic HOT list to a NETSCAPE bookmark HTML\n\n"
				"\n\tSorry!  This program is NOT a filter. "
				"It can not accept input\n\tfrom a pipe.\n\n"
				"\tThis is FreeWare written by Kevin Georgison\n"
				"\tE-Mail comments to: ljs263@freenet.mb.ca\n\t\t\t\tor\n"
				"\tgeorgkev@mbnet.mb.ca, http://www.mbnet.mb.ca/~georgkev"
				"\n");
			exit(0);
		}
		if((fs = fopen(argv[1], "r")) == NULL) {
			printf("cannot open file %s\n", argv[1]);
			exit(1);
		}
		initialize(done_menus);

		out_title("NCSA Mosaic URL's");
		do {
			if(!get_item(fs, ln) ) {
			      if(!failed_a_prev_read || !first_search) printf("</DL><p>\r\n");
			      failed_a_prev_read=1;
			      if(menutreelevel) {
				fseek(fs, fp[--menutreelevel], SEEK_SET);
				get_item(fs, ln);
			      }
			      else break;
			}
			i_type = test_item(ln);
			switch(i_type) {
				case 'i':
					parse_item(ln, title, url);
					out_item(url, title);
					break;
				case 'n':
					if(menutreelevel) {
					    printf("</DL><p>\r\n");
					    fseek(fs, fp[--menutreelevel], SEEK_SET);
					    break;
					}
					cur_menu_num = get_menu_num(ln);
					if(!isitnew(done_menus, cur_menu_num))
					{	do {
						  prev_line = ftell(fs);
						  if(!get_item(fs, ln)) break;
						}while(*ln != '[');
						fseek(fs, prev_line, SEEK_SET);
						if(first_search) {
						  printf("</DL><p>\r\n");
						  first_search=0;
						}
						break;
					}
					first_search=1;
					if(here_again) printf("</DL><p>\r\n");
					here_again=1;
					done_menus[cur_menu_num]=cur_menu_num;
					get_item(fs, ln);
					get_title(ln, menu_name);
					out_title(menu_name);
					break;
				case 's':
					fp[menutreelevel++] = ftell(fs);
					submenu_num=get_submenu_num(ln);
					rewind(fs);
					menu_search(submenu_num, fs, ln);
					done_menus[submenu_num]=submenu_num;
					get_item(fs, ln);
					get_title(ln, menu_name);
					out_title(menu_name);
					break;
			}
		} while (1);
}
int menu_search(int cur_menu_num, FILE *fs, char *ln) {
	int n_found;

	while (*ln != '[') {
		if( (fgets(ln, MAX_L_LEN, fs)) == NULL)	return(0);
	}
	n_found = get_menu_num(ln);
	if(n_found != cur_menu_num) {
		get_item(fs, ln);
		n_found = menu_search(cur_menu_num, fs, ln);
	}
	return(n_found);
}
int get_menu_num(char *ln) {
	int menu_num;
	menu_num = atoi(&ln[10]);
	return (menu_num);
}
void get_title(char *ln, char *menu_name) {
	strcpy(menu_name, &ln[10]);
	menu_name[strlen(menu_name)-1]='\0';
	return;
}
void out_title(char *menu_name) {
	printf("<DT><H3 ADD_DATE=\"808383052\">%s"
		"</H3>\r\n<DL><p>\r\n", menu_name);
	return;
}
int get_item(FILE *fs, char *ln) {
	if (fgets(ln, MAX_L_LEN, fs) == NULL) return(0);
	return(1);
}
char test_item(char *ln) {
	char junkstr[MAX_L_LEN], *p;

	strcpy(junkstr, ln);
	switch (*junkstr) {
		case '[':	return('n');
		case 'I':	strtok(junkstr, "=");
				p=strtok(NULL, ",");
				if(!strcmp(p, "MENU")) return('s');
				else return('i');
	}
	return('\0');
}
void parse_item(char *ln, char *title, char *url) {
	char junkstr[MAX_L_LEN], *p;

	strcpy(junkstr, ln);
	strtok(junkstr, "=");
	p=strtok(NULL, ",");
	strcpy(title, p);
	p=strtok(NULL,"\n");			/* MOSAIC 1.x	*/
	if(p == NULL) p=strtok(NULL, ",");	/* MOSAIC2.x	*/
	strcpy(url, p);
	return;
}
void out_item(char *url, char *title) {
	printf("<DT><A HREF=\"%s\" ADD_DATE=\"808302856\" "
		"LAST_VISIT=\"0\">%s</A>\r\n", url, title);
	return;
}
int isitnew(int *done_menus, int cur_menu_num) {
	int n;

	for(n=0; done_menus[n] != cur_menu_num && n != MAX_MENUS; ++n);
	if(n == MAX_MENUS) return(1);
	return(0);
}
void initialize(int *done_menus) {
	int mtl;
	for(mtl=0; mtl != MAX_MENUS; ++mtl)
	{ done_menus[mtl]=MAX_MENUS; }
	return;
}
int get_submenu_num(char *ln) {
	char *p, str[MAX_L_LEN];

	strcpy(str, ln);
	strtok(str, "u");
	p=strtok(NULL, "\0");
	return(atoi(p));
}
