#ifndef DIB_API
#define DIB_API

#include "dibclass.h"

// LOGPALETTE's version number.
#define PALVERSION 0x300

// WIDTHBYTES takes # of bits in a scan line and rounds up to nearest
//  word.
#define WIDTHBYTES(bits)      (((bits) + 31) / 32 * 4)

// Given a pointer to a DIB header, return TRUE if is a Windows 3.x
//  DIB, false if otherwise (PM style DIB).
#define IS_WIN3x_DIB(lpbi)  ((BOOL)((*(LPDWORD) (lpbi)) == sizeof (BITMAPINFOHEADER)))

// Given a pointer to a DIB header, return TRUE if is an OS/2 PM
//  DIB, false if otherwise (Windows 3.x style DIB).
#define IS_OS2PM_DIB(lpbi)  ((BOOL)((*(LPDWORD) (lpbi)) == sizeof (BITMAPCOREHEADER)))

// Public Functions
extern WORD     DIBNumColors(LPSTR lpbi);
extern HPALETTE RealizeDIBPalette(HDC hDC, HANDLE hDIB);
extern LPSTR    FindDIBBits(LPSTR lpbi);
extern WORD     PaletteSize(LPSTR lpbi);
extern HPALETTE CreateDIBPalette(HANDLE hDIB);
extern DWORD    DIBHeight(LPSTR lpDIB);
extern DWORD    DIBWidth(LPSTR lpDIB);

// DIBBlt()
BOOL DIBBlt(HDC  hDC,
				int  xDst,
				int  yDst,
				int  nWidth,
				int  nHeight,
				HANDLE hDIB,
				int  xSrc,
				int  ySrc,
				DWORD dwROP);

// PaintDIBInBands()
void PaintDIBInBands(HDC hDC,
							HANDLE hDIB,
							int nDIBWidth,
							int nDIBHeight,
							int nBandHeight);

// DIBToDDB()
HBITMAP DIBToDDB(HANDLE hDIB,
						HPALETTE hPal);

BOOL AddDIBToListBox(HWND hList,
							LPSTR myStr,
							DIB * pBmp);

void RemoveListBoxDIBs(HWND hList);

#endif
