//------------------------------------------------------------------------------
//	DIBVIEW.CPP --
//
//------------------------------------------------------------------------------
#define STRICT
#include <windows.h>
#include <windowsx.h>
#pragma hdrstop
#include <mem.h>

#include "dibdll.h"


//------------------------------------------------------------------------------
// The DIBVIEW class
//------------------------------------------------------------------------------
DIBVIEW::DIBVIEW()
{
//	memset(this, 0, sizeof(DIBVIEW));
	wDisplay = DIB_ACTUAL;
}

void DIBVIEW::PaintDIB(HWND hwnd, HDC hdc)
{
	LPBITMAPINFO	lpBmpInfo = GetDib();
	HPALETTE		hOldPal;
	HANDLE		hDIB = GlobalPtrHandle(lpBmpInfo);
	LPSTR    	lpDIBHdr, lpDIBBits;

	hOldPal = RealizeDIBPalette(hdc, hDIB);

	if(lpBmpInfo)
	{
		switch(GetDisplayType())
		{
		case DIB_ACTUAL:
			PaintDIBInBands(hdc, hDIB, cxDib, cyDib, cyDib);
			break;

		case DIB_STRETCH:
			break;

		case DIB_TILE:
			{
				RECT		r;
				int		nx, ny, yOffset;

				GetClientRect(hwnd, &r);
				nx = (r.right - r.left) / cxDib;
				ny = (r.bottom - r.top) / cyDib;
				for(register int j = 0; j <= ny; j++)
				{
					yOffset = j * cyDib;
					for(register int i = 0; i <= nx; i++)
						DIBBlt(hdc, i * cxDib, yOffset, cxDib, cyDib, hDIB, 0, 0, SRCCOPY);
				}
			}
			break;
		}
	}
	hOldPal = SelectPalette(hdc, hOldPal, FALSE);
	DeleteObject(hOldPal);
}

BOOL DIBVIEW::LoadDIB(LPCSTR szDib)
{
	// Attempt to load user's chosen background tile
	if(ReadDib(szDib))
	{
		cxDib = (int)GetDibWidth();
		cyDib = (int)GetDibHeight();
		GlobalUnlockPtr(GetDib());
		return TRUE;
	}
	return FALSE;
}

