/* ------------------------------------------------------------------------ */
/* System       : Library Routines and Microsoft C                          */
/* Program      : stdkeys.h                                                 */
/* Description  : general defines used in BB.LIB and related programs       */
/*                  - the idea here is pretty much the same as Microsoft    */
/*                    had when they created windows.h... they simply put    */
/*                    all their definitions in one great big header file.   */
/*                    I have done that here as well to keep it simple...    */
/*                  - it will increase compile time if this file gets too   */
/*                    large, but only very slightly...                      */
/*                  - feel free to add your own defines here as well...     */
/*                (C) CopyLeft Bill Buckels 1997.                           */
/*                All Rights Reversed.                                      */
/*                                                                          */
/* You have a royalty-free right to use, modify, reproduce and              */
/* distribute this source code in any way you find useful,                  */
/* provided that you agree that Bill Buckels has no warranty obligations    */
/* or liability resulting from said distribution in any way whatsoever.     */
/* ------------------------------------------------------------------------ */

#ifndef _STDKEYS_H_

#define _STDKEYS_H_

#define ENTERKEY   '\x0d' /* character generated by the Enter Key          */
#define ESCKEY     '\x1b' /* character generated by the Esc key            */
#define FUNCKEY    '\x00' /* first character generated by function keys    */
#define HOMEKEY    'G'    /* second character generated by Home key        */
#define ENDKEY     'O'    /* second character generated by End key         */
#define UPARROW    'H'    /* second character generated by up-arrow key    */
#define DOWNARROW  'P'    /* second character generated by down-arrow key  */
#define LTARROW    'K'    /* second character generated by left-arrow key  */
#define LEFTARROW  LTARROW
#define RTARROW    'M'    /* second character generated by right-arrow key */
#define RIGHTARROW RTARROW
#define PGUP       'I'    /* second character generated by page up key     */
#define PAGEUP     PGUP
#define PGDOWN     'Q'    /* second character generated by page down key   */
#define PAGEDOWN   PGDOWN
#define PGDN       PGDOWN
#define SPACEBAR   '\x20'


/* starting at character 59*/
#define F1         ';'    /* second character generated by numerical fkeys */
#define F2         '<'
#define F3         '='
#define F4         '>'
#define F5         '?'
#define F6         '@'
#define F7         'A'
#define F8         'B'
#define F9         'C'
#define F10        'D'

/* ending at character 68  */

#define CRETURN '\x0d'
#define LFEED   '\x0A'
#define CTRLZ   '\x1a'
#define DELETE  '\x7f'
#define ESCAPE  '\x1b'

/* std ibm colors */
#define BLACK     0
#define BLUE      1
#define GREEN     2
#define CYAN      3
#define RED       4
#define MAGENTA   5
#define BROWN     6
#define WHITE     7
#define GRAY      8
#define LBLUE     9
#define LGREEN    10
#define LCYAN     11
#define LRED      12
#define LMAGENTA  13
#define YELLOW    14
#define BWHITE    15

#define FALSE 0
#define TRUE  1

#define DEFAULT           -1
#define SUCCESS            0
#define INVALID_HANDLE    -1
#define INVALID_HEADER    -2
#define INVALID_TYPE      -3
#define TOO_BIG           -4

#define INVALID_USAGE     1
#define INVALID_HARDWARE  2
#define EXIT_FAILURE      1

#define TEXT_VIDEO       ('\x03')

/* graphics modes */
#define LORES_CGA_VIDEO  ('\x04')
#define HIRES_CGA_VIDEO  ('\x06')
#define LORES_EGA_VIDEO  ('\x0d')
#define MEDRES_EGA_VIDEO ('\x0e')
#define MONO_EGA_VIDEO   ('\x0f')
#define EGA_VIDEO        ('\x10')
#define MONO_VGA_VIDEO   ('\x11')
#define VGA_VIDEO        ('\x12')
#define MCGA_VIDEO       ('\x13')

/* not really a mode - just used for a test and included for completeness */
#define TRUECOLOR_VIDEO  ((unsigned char)'\xff')

/* under the VESA standard which is one of the ways that we can access    */
/*   the true color mode of some (most) SVGA video cards, mode numbers    */
/*   are not consistent between card manufacturers...                     */
/*   therefore mode numbers are meaningless by themselves in that world   */
/*   more about this some other time...                                   */

#define CGA_VIDEO_SEG 0xb800
#define VGA_VIDEO_SEG 0xa000

#define CGA_INTERLEAF   8192

#define CGA_LINE_SIZE  80
#define MCGA_LINE_SIZE 320
#define VGA_LINE_SIZE  320
#define EGA_LINE_SIZE  320

#define CGA_SCREENSIZE  16000
#define MCGA_SCREENSIZE 64000

#define MCGA_SCAN_LINES 200
#define CGA_SCAN_LINES  200
#define EGA_SCAN_LINES  350
#define VGA_SCAN_LINES  480

#define MCGA_PALETTE_ENTRIES 256

#define CGA_BLACK    0
#define CGA_CYAN     1
#define CGA_MAGENTA  2
#define CGA_WHITE    3

#define CGA_X_RATE   4
#define CGA_Y_RATE   2

/* the following fill characters can be used to approximate a pixel map */
#define BLACKSPACE   219
#define WHITESPACE   32
#define TOPONLY      223
#define BOTTOMONLY   220

#define PERIOD       '.'
#define ASCIIZ       '\x00'
#define FORM_FEED    12

#define   TEMP_BUFF_LEN     256

/* note: length in pixels */
#define   MAX_SCANLINE_LEN  1280

#define  CGA_HIRES_XSCREEN 640
#define  CGA_HIRES_YSCREEN 200
#define  maxlimit(x) (x-1)

#endif
