'TELND import unit for Visual Basic

Global Const EM_ENABLED = 1
Global Const EM_HIDDEN = 2
Global Const EM_CRTOCRLF = 4

Dim blocking As Integer

  Declare Sub TelnetInit Lib "TELND.DLL" (ByVal password As String, ByVal hWndParent As Integer)
  Declare Sub TelnetSetEcho Lib "TELND.DLL" (ByVal echomode As Integer)


  Declare Sub TelnetDisconnect Lib "TELND.DLL" ()
  Declare Sub telnetRelease Lib "TELND.DLL" ()

  Declare Sub TelnetSendString Lib "TELND.DLL" (ByVal sendline As String)
  Declare Sub TelnetSendLine Lib "TELND.DLL" (ByVal sendline As String)

  Declare Function TelnetConnected Lib "TELND.DLL" () As Integer
  Declare Function TelnetCTS Lib "TELND.DLL" () As Integer
  Declare Function TelnetPendingInput Lib "TELND.DLL" () As Integer

' VT100 terminal commands
 Declare Sub TelnetVTClearscreen Lib "TELND.DLL" ()
 Declare Sub TelnetVTHome Lib "TELND.DLL" ()
 Declare Sub TelnetVTEraseLine Lib "TELND.DLL" ()
 Declare Sub TelnetVTSaveCursor Lib "TELND.DLL" ()
 Declare Sub TelnetVTRestoreCursor Lib "TELND.DLL" ()
 Declare Sub TelnetVTLocate Lib "TELND.DLL" (ByVal row As Integer, ByVal col As Integer)

'the DLL routines which return string variables are not called directly by the user:
Declare Function TDDLL_InputChar Lib "TELND.DLL" Alias "TelnetInputChar" (ByVal inputchar As String) As Integer
Declare Function TDDLL_InputLine Lib "TELND.DLL" Alias "TelnetInputLine" (ByVal inputline As String) As Integer
Declare Sub TDDLL_RemoteIP Lib "TELND.DLL" Alias "TelnetRemoteIP" (ByVal addr As String)
Declare Sub TDDLL_RemoteHost Lib "TELND.DLL" Alias "TelnetRemoteHost" (ByVal host As String)

Function TelnetBlocking () As Integer

TelnetBlocking = blocking
End Function

Function TelnetInputChar (inputchar$) As Integer

inputchar$ = " "
TelnetInputChar = TDDLL_InputChar(inputchar$)

End Function

Function TelnetInputLine (inputline$) As Integer

inputline$ = String(255, 0)
TelnetInputLine = TDDLL_InputLine(inputline$)
End Function

Sub TelnetRemoteHost (host$)

host$ = String$(255, 0)
Call TDDLL_RemoteHost(host$)

End Sub

Sub TelnetRemoteIP (addr$)

addr$ = String$(255, 0)
Call TDDLL_RemoteIP(addr$)

End Sub

Sub TelnetUnblock ()
blocking = False
DoEvents
End Sub

Function TelnetWaitChar (inputchar$) As Integer
inputchar$ = " "

blocking = True
Do
  DoEvents
Loop Until (TelnetPendingInput() <> 0) Or (Not blocking) Or (Not TelnetConnected())


If TelnetPendingInput() <> 0 Then
    TelnetWaitChar = TDDLL_InputChar(inputchar$)
   Else
   TelnetWaitChar = False
End If

blocking = False
End Function

Function TelnetWaitConnect () As Integer
blocking = True

Do
  DoEvents
Loop Until (TelnetConnected() <> 0) Or (Not blocking)

TelnetWaitConnect = TelnetConnected()

blocking = False
End Function

Function TelnetWaitLine (inputline$) As Integer

inputline$ = String(255, 0)
blocking = True

Do
  DoEvents
Loop Until (TelnetPendingInput() > 0) Or (Not blocking) Or (Not TelnetConnected())


If TelnetPendingInput() > 0 Then
    TelnetWaitLine = TDDLL_InputLine(inputline$)
   Else
   TelnetWaitLine = False
End If

blocking = False
End Function

