/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.basicgui.view;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Enumeration;
import java.util.Vector;
import org.nakedobjects.basicgui.view.Display;
import org.nakedobjects.basicgui.view.ObjectViewer;
import org.nakedobjects.basicgui.view.TextStyle;
import org.nakedobjects.basicgui.view.UsesViewer;
import org.nakedobjects.basicgui.view.ViewColor;
import org.nakedobjects.object.Naked;
import org.nakedobjects.object.NakedCollection;
import org.nakedobjects.object.NakedObject;
import org.nakedobjects.object.NakedValue;
import org.nakedobjects.object.reflect.Field;
import org.nakedobjects.utility.Debug;

public class DebugFrame
extends Frame {
    private Display display;
    private TextArea field;

    public DebugFrame() {
        this("");
    }

    public DebugFrame(String string) {
        super(string);
        ((Component)this).setBackground(ViewColor.windowBackground);
        this.setLayout(new BorderLayout(7, 7));
        final DebugFrame debugFrame = this;
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                debugFrame.dispose();
            }
        });
    }

    public static DebugFrame debug(Display display) {
        String string = ((UsesViewer)((Object)display)).idString();
        String string2 = ((UsesViewer)((Object)display)).getViewer().getObject().toString();
        final DebugFrame debugFrame = new DebugFrame("Debug: " + string + "/" + string2);
        debugFrame.display = display;
        TextArea textArea = new TextArea("", 40, 80, 0);
        textArea.setForeground(Color.blue);
        Font font = TextStyle.getStyle(6).getFont();
        System.out.println(font);
        textArea.setFont(font);
        debugFrame.add("Center", textArea);
        debugFrame.field = textArea;
        Button button = new Button("Refresh");
        debugFrame.add((Component)button, "South");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                debugFrame.refresh();
            }
        });
        debugFrame.refresh();
        return debugFrame;
    }

    private String debugCollectionGraph(NakedCollection nakedCollection, String string, int n, Vector vector) {
        StringBuffer stringBuffer = new StringBuffer();
        if (vector.contains(nakedCollection)) {
            stringBuffer.append("*\n");
        } else {
            vector.addElement(nakedCollection);
            Enumeration enumeration = nakedCollection.elements();
            while (enumeration.hasMoreElements()) {
                this.indent(stringBuffer, n);
                NakedObject nakedObject = (NakedObject)enumeration.nextElement();
                stringBuffer.append(nakedObject);
                stringBuffer.append(this.debugGraph(nakedObject, string, n + 1, vector));
            }
        }
        return stringBuffer.toString();
    }

    public String debugGraph(NakedObject nakedObject, String string, int n, Vector vector) {
        if (n > 3) {
            return "...\n";
        }
        if (vector == null) {
            vector = new Vector(25, 10);
        }
        if (nakedObject instanceof NakedCollection) {
            return "\n" + this.debugCollectionGraph((NakedCollection)nakedObject, string, n, vector);
        }
        return "\n" + this.debugObjectGraph(nakedObject, string, n, vector);
    }

    private String debugObjectGraph(NakedObject nakedObject, String string, int n, Vector vector) {
        StringBuffer stringBuffer = new StringBuffer();
        vector.addElement(nakedObject);
        Field[] fieldArray = nakedObject.getNakedClass().getFields();
        int n2 = 0;
        while (n2 < fieldArray.length) {
            Field field = fieldArray[n2];
            Naked naked = field.get(nakedObject);
            string = field.getName();
            this.indent(stringBuffer, n);
            if (naked instanceof NakedValue) {
                stringBuffer.append(string + ": ");
                if (naked == null) {
                    stringBuffer.append("unitialised - error");
                    stringBuffer.append("\n");
                } else {
                    stringBuffer.append(((NakedValue)naked).title().toString());
                    stringBuffer.append("\n");
                }
            } else if (naked instanceof NakedObject) {
                if (vector.contains(naked)) {
                    stringBuffer.append(string + ": " + naked + "*\n");
                } else {
                    stringBuffer.append(string + ": " + naked);
                    stringBuffer.append(this.debugGraph((NakedObject)naked, string, n + 1, vector));
                }
            } else {
                stringBuffer.append(string + ": " + naked);
                stringBuffer.append("\n");
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    public String dumpGraph(NakedObject nakedObject) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("GRAPH\n");
        stringBuffer.append("------\n");
        stringBuffer.append(nakedObject);
        stringBuffer.append(this.debugGraph(nakedObject, nakedObject.getClassName(), 0, new Vector()));
        return stringBuffer.toString();
    }

    public String dumpObject(NakedObject nakedObject) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("OBJECT\n");
        stringBuffer.append("------\n");
        stringBuffer.append("\n");
        stringBuffer.append(this.dumpSummary(nakedObject));
        stringBuffer.append("\n");
        stringBuffer.append(nakedObject.getNakedClass().debugInterface());
        return stringBuffer.toString();
    }

    public String dumpSummary(NakedObject nakedObject) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Summary\n");
        stringBuffer.append("  ID:         " + nakedObject.getOid() + "\n");
        stringBuffer.append("  Class:      " + nakedObject.getClass().getName() + "\n");
        StringBuffer stringBuffer2 = new StringBuffer();
        if (this instanceof NakedCollection) {
            stringBuffer2.append("Collection ");
        } else if (this instanceof NakedObject) {
            stringBuffer2.append("Object ");
        }
        if (this instanceof NakedValue) {
            stringBuffer2.append("Value ");
        }
        stringBuffer.append("  Type:       " + stringBuffer2 + "\n");
        stringBuffer.append("  Accessible: " + nakedObject.about().canAccess().isAllowed() + "\n");
        stringBuffer.append("  Editable:   " + nakedObject.about().canUse().isAllowed() + "\n");
        stringBuffer.append("  Persistent: " + nakedObject.isPersistent() + "\n");
        stringBuffer.append("  Resolved:   " + nakedObject.isResolved() + "\n");
        stringBuffer.append("  Title:      '" + nakedObject.title() + "'\n");
        stringBuffer.append("  Observers:  " + nakedObject.countObservers() + "\n");
        return stringBuffer.toString();
    }

    public Display getDisplay() {
        return this.display;
    }

    public TextArea getField() {
        return this.field;
    }

    private void indent(StringBuffer stringBuffer, int n) {
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append(Debug.indentString(4) + "|");
            ++n2;
        }
        stringBuffer.append(Debug.indentString(4) + "+--");
    }

    public void refresh() {
        ObjectViewer objectViewer = this.display.getViewer();
        StringBuffer stringBuffer = new StringBuffer();
        NakedObject nakedObject = objectViewer.getObject();
        stringBuffer.append(this.dumpObject(nakedObject));
        stringBuffer.append("\n");
        stringBuffer.append("DISPLAY\n");
        stringBuffer.append("-------\n");
        stringBuffer.append(this.display.debugDetails());
        stringBuffer.append(objectViewer.debugDetails());
        stringBuffer.append(objectViewer.getView().debugDetails());
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        ((Component)((Object)this.display)).list(printWriter);
        stringBuffer.append("Components:   " + stringWriter.toString());
        stringBuffer.append("\n");
        stringBuffer.append(this.dumpGraph(nakedObject));
        this.field.setText(stringBuffer.toString());
    }

    void setDisplay(Display display) {
        this.display = display;
    }

    void setField(TextArea textArea) {
        this.field = textArea;
    }
}

