/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.basicgui.view.border;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import org.nakedobjects.basicgui.view.ObjectViewer;
import org.nakedobjects.basicgui.view.StatusColor;
import org.nakedobjects.basicgui.view.ViewBorder;
import org.nakedobjects.basicgui.view.ViewColor;

public class LineBorder
extends ViewBorder {
    private Color color;
    private int lineWidth;

    public LineBorder() {
        this(ViewColor.outlineNormal, 1);
    }

    public LineBorder(Color color) {
        this(color, 1);
    }

    public LineBorder(Color color, int n) {
        this.color = color;
        this.lineWidth = n;
    }

    public Insets getBorderInsets(ObjectViewer objectViewer) {
        return new Insets(this.lineWidth, this.lineWidth, this.lineWidth, this.lineWidth);
    }

    public void paint(Graphics graphics, Rectangle rectangle, ObjectViewer objectViewer) {
        Color color = StatusColor.colorFor(objectViewer.getDisplayState(), this.color);
        if (color == ViewColor.textNormal) {
            graphics.setColor(ViewColor.outlineNormal);
        } else {
            graphics.setColor(color);
        }
        int n = 0;
        while (n < this.lineWidth) {
            graphics.drawRect(rectangle.x + n, rectangle.y + n, rectangle.width - n * 2 - 1, rectangle.height - n * 2 - 1);
            ++n;
        }
    }

    public String toString() {
        return "LineBorder [color=" + this.color + ",width=" + this.lineWidth + "]";
    }
}

