/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.object.distribution;

import org.nakedobjects.object.NakedClass;
import org.nakedobjects.object.ObjectStoreException;
import org.nakedobjects.object.distribution.Request;
import org.nakedobjects.object.distribution.Server;

public class HasInstancesRequest
extends Request {
    private String className;

    public HasInstancesRequest(NakedClass nakedClass) {
        this.className = nakedClass.getName();
    }

    void generateResponse(Server server) {
        try {
            NakedClass nakedClass = NakedClass.getNakedClass(this.className);
            this.response = new Boolean(server.getObjectStore().hasInstances(nakedClass));
        }
        catch (ObjectStoreException objectStoreException) {
            this.response = objectStoreException;
        }
    }

    public boolean hasInstances() throws ObjectStoreException {
        this.sendRequest();
        return (Boolean)this.response;
    }

    public String toString() {
        return "Has instances [type=" + this.className + "]";
    }
}

