/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.service;

import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.util.Hashtable;
import org.apache.tomcat.core.BufferedServletInputStream;
import org.apache.tomcat.core.RequestImpl;
import org.apache.tomcat.service.Ajp11;
import org.apache.tomcat.util.StringManager;

class AJPRequestAdapter
extends RequestImpl {
    StringManager sm = StringManager.getManager("org.apache.tomcat.service");
    Socket socket;

    public AJPRequestAdapter(Socket so) {
        this.socket = so;
        this.in = new BufferedServletInputStream(this);
    }

    protected void readNextRequest() throws IOException {
        String sport;
        InputStream sin = this.socket.getInputStream();
        Hashtable env_vars = new Hashtable();
        Ajp11.readAJPData(sin, env_vars, this.headers);
        this.method = (String)env_vars.get("REQUEST_METHOD");
        this.protocol = (String)env_vars.get("SERVER_PROTOCOL");
        this.requestURI = (String)env_vars.get("REQUEST_URI");
        this.queryString = (String)env_vars.get("QUERY_STRING");
        int idQ = this.requestURI.indexOf("?");
        if (idQ > -1) {
            this.requestURI = this.requestURI.substring(0, idQ);
        }
        if ((sport = (String)env_vars.get("SERVER_PORT")) == null) {
            sport = "80";
        }
        this.serverPort = new Integer(sport);
        this.remoteAddr = (String)env_vars.get("REMOTE_ADDR");
        this.remoteHost = (String)env_vars.get("REMOTE_ADDR");
        this.contentLength = this.headers.getIntHeader("content-length");
        this.contentType = this.headers.getHeader("content-type");
    }
}

