/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.mm.mysql;

import java.sql.SQLException;
import java.util.NoSuchElementException;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import org.gjt.mm.mysql.EscapeTokenizer;
import org.gjt.mm.mysql.Token;

class EscapeProcessor {
    public synchronized String escapeSQL(String SQL) throws SQLException {
        int next_end_brace;
        boolean replaceEscapeSequence = false;
        String EscapeSequence = null;
        StringBuffer NewSQL = new StringBuffer();
        if (SQL == null) {
            return null;
        }
        int begin_brace = SQL.indexOf("{");
        int n = next_end_brace = begin_brace != -1 ? SQL.indexOf("}", begin_brace) : -1;
        if (next_end_brace == -1) {
            return SQL;
        }
        EscapeTokenizer ET = new EscapeTokenizer(SQL);
        while (ET.hasMoreTokens()) {
            String Token2 = ET.nextToken();
            if (Token2.startsWith("{")) {
                String DD;
                String MM;
                String YYYY;
                StringTokenizer ST;
                String Argument;
                int start_pos;
                if (!Token2.endsWith("}")) {
                    throw new SQLException("Not a valid escape sequence: " + Token2);
                }
                if (Token2.toLowerCase().startsWith("{escape")) {
                    try {
                        StringTokenizer ST2 = new StringTokenizer(Token2, " '");
                        ST2.nextToken();
                        EscapeSequence = ST2.nextToken();
                        if (EscapeSequence.length() < 3) {
                            throw new SQLException("Syntax error for escape sequence '" + Token2 + "'", "42000");
                        }
                        EscapeSequence = EscapeSequence.substring(1, EscapeSequence.length() - 1);
                        replaceEscapeSequence = true;
                        continue;
                    }
                    catch (NoSuchElementException noSuchElementException) {
                        throw new SQLException("Syntax error for escape sequence '" + Token2 + "'", "42000");
                    }
                }
                if (Token2.toLowerCase().startsWith("{fn")) {
                    start_pos = Token2.indexOf("fn ") + 3;
                    int end_pos = Token2.length() - 1;
                    NewSQL.append(Token2.substring(start_pos, end_pos));
                    continue;
                }
                if (Token2.toLowerCase().startsWith("{d")) {
                    start_pos = Token2.indexOf("'") + 1;
                    int end_pos = Token2.lastIndexOf("'");
                    if (start_pos == -1 || end_pos == -1) {
                        throw new SQLException("Syntax error for DATE escape sequence '" + Token2 + "'", "42000");
                    }
                    Argument = Token2.substring(start_pos, end_pos);
                    try {
                        ST = new StringTokenizer(Argument, " -");
                        YYYY = ST.nextToken();
                        MM = ST.nextToken();
                        DD = ST.nextToken();
                        String DateString = "'" + YYYY + "-" + MM + "-" + DD + "'";
                        NewSQL.append(DateString);
                        continue;
                    }
                    catch (NoSuchElementException noSuchElementException) {
                        throw new SQLException("Syntax error for DATE escape sequence '" + Argument + "'", "42000");
                    }
                }
                if (Token2.toLowerCase().startsWith("{ts")) {
                    start_pos = Token2.indexOf("'") + 1;
                    int end_pos = Token2.lastIndexOf("'");
                    if (start_pos == -1 || end_pos == -1) {
                        throw new SQLException("Syntax error for TIMESTAMP escape sequence '" + Token2 + "'", "42000");
                    }
                    Argument = Token2.substring(start_pos, end_pos);
                    try {
                        ST = new StringTokenizer(Argument, " .-:");
                        YYYY = ST.nextToken();
                        MM = ST.nextToken();
                        DD = ST.nextToken();
                        String HH = ST.nextToken();
                        String Mm = ST.nextToken();
                        String SS = ST.nextToken();
                        String F = "";
                        if (ST.hasMoreTokens()) {
                            F = ST.nextToken();
                        }
                        NewSQL.append("'").append(YYYY).append("-").append(MM).append("-").append(DD).append(" ").append(HH).append(":").append(Mm).append(":").append(SS).append("'");
                        continue;
                    }
                    catch (NoSuchElementException noSuchElementException) {
                        throw new SQLException("Syntax error for TIMESTAMP escape sequence '" + Argument + "'", "42000");
                    }
                }
                if (Token2.toLowerCase().startsWith("{t")) {
                    start_pos = Token2.indexOf("'") + 1;
                    int end_pos = Token2.lastIndexOf("'");
                    if (start_pos == -1 || end_pos == -1) {
                        throw new SQLException("Syntax error for TIME escape sequence '" + Token2 + "'", "42000");
                    }
                    Argument = Token2.substring(start_pos, end_pos);
                    try {
                        ST = new StringTokenizer(Argument, " :");
                        String HH = ST.nextToken();
                        MM = ST.nextToken();
                        String SS = ST.nextToken();
                        String TimeString = "'" + HH + ":" + MM + ":" + SS + "'";
                        NewSQL.append(TimeString);
                        continue;
                    }
                    catch (NoSuchElementException noSuchElementException) {
                        throw new SQLException("Syntax error for escape sequence '" + Argument + "'", "42000");
                    }
                }
                if (Token2.toLowerCase().startsWith("{call") || Token2.toLowerCase().startsWith("{? = call")) {
                    throw new SQLException("Stored procedures not supported: " + Token2, "S1C00");
                }
                if (!Token2.toLowerCase().startsWith("{oj")) continue;
                NewSQL.append(Token2);
                continue;
            }
            NewSQL.append(Token2);
        }
        String EscapedSQL = NewSQL.toString();
        if (replaceEscapeSequence) {
            String CurrentSQL = EscapedSQL;
            while (CurrentSQL.indexOf(EscapeSequence) != -1) {
                int escapePos = CurrentSQL.indexOf(EscapeSequence);
                String LHS = CurrentSQL.substring(0, escapePos);
                String RHS = CurrentSQL.substring(escapePos + 1, CurrentSQL.length());
                CurrentSQL = String.valueOf(LHS) + "\\" + RHS;
            }
            EscapedSQL = CurrentSQL;
        }
        if (EscapedSQL.indexOf("||") != -1) {
            EscapedSQL = EscapeProcessor.doConcat(EscapedSQL);
        }
        return EscapedSQL;
    }

    static String doConcat(String SQL) {
        Vector<Token> TokenList = new Vector<Token>();
        StringTokenizer ST = new StringTokenizer(SQL, " '", true);
        boolean inquotes = false;
        StringBuffer QuotedString = null;
        while (ST.hasMoreTokens()) {
            Token Tok;
            String T = ST.nextToken();
            if (T.equals("'")) {
                if (inquotes) {
                    inquotes = false;
                    Tok = new Token(QuotedString.toString(), true);
                    TokenList.addElement(Tok);
                    continue;
                }
                inquotes = true;
                QuotedString = new StringBuffer();
                continue;
            }
            if (inquotes) {
                QuotedString.append(T);
                continue;
            }
            Tok = new Token(T, false);
            TokenList.addElement(Tok);
        }
        int pos = 0;
        int length = TokenList.size();
        Stack<Token> ToDo = new Stack<Token>();
        while (pos < length) {
            Token T1 = (Token)TokenList.elementAt(pos);
            if (T1.Value.equals("||")) {
                Token Pre = (Token)ToDo.pop();
                Token Post = (Token)TokenList.elementAt(++pos);
                Token Concat = new Token(String.valueOf(Pre.Value) + Post.Value, true);
                ToDo.push(Concat);
                ++pos;
                continue;
            }
            ToDo.push(T1);
            ++pos;
        }
        length = ToDo.size();
        StringBuffer NewQuery = new StringBuffer();
        int i = 0;
        while (i < length) {
            Token T = (Token)ToDo.elementAt(i);
            if (T.quoted) {
                NewQuery.append("'");
                NewQuery.append(T.Value);
                NewQuery.append("'");
            } else {
                NewQuery.append(T.Value);
            }
            ++i;
        }
        return NewQuery.toString();
    }

    EscapeProcessor() {
    }
}

