/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.core;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.tomcat.context.AutoSetup;
import org.apache.tomcat.context.DefaultCMSetter;
import org.apache.tomcat.context.LoadOnStartupInterceptor;
import org.apache.tomcat.context.LogEvents;
import org.apache.tomcat.context.WebXmlReader;
import org.apache.tomcat.context.WorkDirInterceptor;
import org.apache.tomcat.core.Container;
import org.apache.tomcat.core.Context;
import org.apache.tomcat.core.ContextInterceptor;
import org.apache.tomcat.core.Request;
import org.apache.tomcat.core.RequestImpl;
import org.apache.tomcat.core.RequestInterceptor;
import org.apache.tomcat.core.Response;
import org.apache.tomcat.core.ServerConnector;
import org.apache.tomcat.core.ServletWrapper;
import org.apache.tomcat.core.TomcatException;
import org.apache.tomcat.logging.Logger;
import org.apache.tomcat.request.SessionInterceptor;
import org.apache.tomcat.request.SimpleMapper;
import org.apache.tomcat.service.SimpleTcpConnector;
import org.apache.tomcat.service.http.HttpConnectionHandler;
import org.apache.tomcat.util.StringManager;

public class ContextManager {
    private StringManager sm = StringManager.getManager("org.apache.tomcat.core");
    private Vector requestInterceptors = new Vector();
    private Vector contextInterceptors = new Vector();
    ContextInterceptor[] cInterceptors;
    RequestInterceptor[] rInterceptors;
    private Hashtable contexts = new Hashtable();
    public static final String DEFAULT_HOSTNAME = "localhost";
    public static final int DEFAULT_PORT = 8080;
    public static final String DEFAULT_WORK_DIR = "work";
    String hostname;
    int port;
    int debug = 0;
    String workDir;
    String home;
    String tomcatHome;
    Vector connectors = new Vector();
    boolean firstLog = true;
    Logger cmLog = null;

    public void addContainer(Container container) throws TomcatException {
        ContextInterceptor[] cI = this.getContextInterceptors();
        int i = 0;
        while (i < cI.length) {
            cI[i].addContainer(container);
            ++i;
        }
    }

    public void addContext(Context ctx) throws TomcatException {
        ctx.setContextManager(this);
        String path = ctx.getPath();
        if (this.getContext(path) != null) {
            if (this.debug > 0) {
                this.log("Warning: replacing context for " + path);
            }
            this.removeContext(path);
        }
        ContextInterceptor[] cI = this.getContextInterceptors();
        int i = 0;
        while (i < cI.length) {
            cI[i].addContext(this, ctx);
            ++i;
        }
        ctx.log("Adding context path=\"" + ctx.getPath() + "\"  docBase=\"" + ctx.getDocBase() + "\"");
        this.contexts.put(path, ctx);
    }

    public void addContextInterceptor(ContextInterceptor ci) {
        if (this.debug > 0) {
            this.log("Add contextInterceptor javaClass=\"" + ci.getClass().getName() + "\" ");
        }
        this.contextInterceptors.addElement(ci);
    }

    public void addLogger(Logger logger) {
    }

    public void addRequestInterceptor(RequestInterceptor ri) {
        if (this.debug > 0) {
            this.log("Add requestInterceptor javaClass=\"" + ri.getClass().getName() + "\" ");
        }
        this.requestInterceptors.addElement(ri);
        if (ri instanceof ContextInterceptor) {
            this.contextInterceptors.addElement(ri);
        }
    }

    public synchronized void addServerConnector(ServerConnector con) {
        if (this.debug > 0) {
            this.log("Add connector javaClass=\"" + con.getClass().getName() + "\"");
        }
        con.setContextManager(this);
        this.connectors.addElement(con);
    }

    int authenticate(Request req, Response res) {
        int i = 0;
        while (i < this.requestInterceptors.size()) {
            ((RequestInterceptor)this.requestInterceptors.elementAt(i)).authenticate(req, res);
            ++i;
        }
        return 0;
    }

    int authorize(Request req, Response res) {
        int i = 0;
        while (i < this.requestInterceptors.size()) {
            int err = ((RequestInterceptor)this.requestInterceptors.elementAt(i)).authorize(req, res);
            if (err != 0) {
                return err;
            }
            ++i;
        }
        return 0;
    }

    Request createRequest(String urlPath) {
        String queryString = null;
        int i = urlPath.indexOf("?");
        int len = urlPath.length();
        if (i > -1) {
            if (i < len) {
                queryString = urlPath.substring(i + 1, urlPath.length());
            }
            urlPath = urlPath.substring(0, i);
        }
        RequestImpl lr = new RequestImpl();
        lr.setRequestURI(urlPath);
        lr.setQueryString(queryString);
        return lr;
    }

    Request createRequest(Context ctx, String urlPath) {
        String contextPath = ctx.getPath();
        String origPath = urlPath;
        if (!"".equals(contextPath) && !"/".equals(contextPath)) {
            urlPath = urlPath.startsWith("/") ? String.valueOf(contextPath) + urlPath : String.valueOf(contextPath) + "/" + urlPath;
        } else if (!urlPath.startsWith("/")) {
            urlPath = "/" + urlPath;
        }
        if (this.debug > 4) {
            this.log("createRequest " + origPath + " " + urlPath);
        }
        return this.createRequest(urlPath);
    }

    int doAfterBody(Request req, Response res) {
        int i = 0;
        while (i < this.requestInterceptors.size()) {
            ((RequestInterceptor)this.requestInterceptors.elementAt(i)).afterBody(req, res);
            ++i;
        }
        return 0;
    }

    int doBeforeBody(Request req, Response res) {
        int i = 0;
        while (i < this.requestInterceptors.size()) {
            ((RequestInterceptor)this.requestInterceptors.elementAt(i)).beforeBody(req, res);
            ++i;
        }
        return 0;
    }

    int doBeforeCommit(Request req, Response res) {
        int i = 0;
        while (i < this.requestInterceptors.size()) {
            ((RequestInterceptor)this.requestInterceptors.elementAt(i)).beforeCommit(req, res);
            ++i;
        }
        return 0;
    }

    public final void doLog(String msg) {
        this.doLog(msg, null);
    }

    public final void doLog(String msg, Throwable t) {
        if (this.firstLog) {
            this.cmLog = Logger.getLogger("tc_log");
            if (this.cmLog != null) {
                this.cmLog.setCustomOutput("true");
                this.cmLog.setVerbosityLevel(3);
            }
            this.firstLog = false;
        }
        if (this.cmLog != null) {
            this.cmLog.log(String.valueOf(msg) + "\n", t, 3);
        } else {
            System.out.println(msg);
            if (t != null) {
                t.printStackTrace(System.out);
            }
        }
    }

    static String getCanonicalPath(String name) {
        if (name == null) {
            return null;
        }
        File f = new File(name);
        try {
            return f.getCanonicalPath();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return name;
        }
    }

    public Enumeration getConnectors() {
        return this.connectors.elements();
    }

    public Context getContext(String name) {
        return (Context)this.contexts.get(name);
    }

    public ContextInterceptor[] getContextInterceptors() {
        if (this.contextInterceptors.size() == 0) {
            this.setDefaults();
        }
        if (this.cInterceptors == null || this.cInterceptors.length != this.contextInterceptors.size()) {
            this.cInterceptors = new ContextInterceptor[this.contextInterceptors.size()];
            int i = 0;
            while (i < this.cInterceptors.length) {
                this.cInterceptors[i] = (ContextInterceptor)this.contextInterceptors.elementAt(i);
                ++i;
            }
        }
        return this.cInterceptors;
    }

    public Enumeration getContextNames() {
        return this.contexts.keys();
    }

    public int getDebug() {
        return this.debug;
    }

    public String getHome() {
        if (this.home != null) {
            return this.home;
        }
        this.home = ContextManager.getCanonicalPath(this.tomcatHome);
        if (this.home != null) {
            return this.home;
        }
        this.home = ContextManager.getCanonicalPath(System.getProperty("tomcat.home"));
        if (this.home != null) {
            return this.home;
        }
        this.home = ContextManager.getCanonicalPath(".");
        return this.home;
    }

    public String getHostName() {
        if (this.hostname == null) {
            this.hostname = DEFAULT_HOSTNAME;
        }
        return this.hostname;
    }

    public int getPort() {
        if (this.port == 0) {
            this.port = 8080;
        }
        return this.port;
    }

    public RequestInterceptor[] getRequestInterceptors() {
        if (this.rInterceptors == null || this.rInterceptors.length != this.requestInterceptors.size()) {
            this.rInterceptors = new RequestInterceptor[this.requestInterceptors.size()];
            int i = 0;
            while (i < this.rInterceptors.length) {
                this.rInterceptors[i] = (RequestInterceptor)this.requestInterceptors.elementAt(i);
                ++i;
            }
        }
        return this.rInterceptors;
    }

    public String getTomcatHome() {
        if (this.tomcatHome != null) {
            return this.tomcatHome;
        }
        this.tomcatHome = System.getProperty("tomcat.home");
        if (this.tomcatHome != null) {
            return this.tomcatHome;
        }
        this.tomcatHome = this.getHome();
        return this.tomcatHome;
    }

    public String getWorkDir() {
        if (this.workDir == null) {
            this.workDir = DEFAULT_WORK_DIR;
        }
        return this.workDir;
    }

    void handleError(Request req, Response res, Throwable t, int code) {
        Context ctx = req.getContext();
        if (ctx == null) {
            ctx = this.getContext("");
        }
        if (ctx.getDebug() > 4) {
            ctx.log("In error handler " + code + " " + t + " / " + req);
        }
        String path = null;
        ServletWrapper errorServlet = null;
        if (code != 0 && code < 400) {
            errorServlet = ctx.getServletByName("tomcat.errorPage");
        } else if (req.getAttribute("javax.servlet.error.status_code") != null || req.getAttribute("javax.servlet.error.exception_type") != null) {
            if (ctx.getDebug() > 0) {
                ctx.log("Error: exception inside exception servlet " + req.getAttribute("javax.servlet.error.status_code") + " " + req.getAttribute("javax.servlet.error.exception_type"));
            }
            errorServlet = ctx.getServletByName("tomcat.errorPage");
        }
        if (t == null) {
            if (code == 0) {
                code = res.getStatus();
            }
            if (code >= 400) {
                path = ctx.getErrorPage(code);
            }
            if (code == 401) {
                if (errorServlet == null) {
                    errorServlet = ctx.getServletByName("tomcat.authServlet");
                }
                if (ctx.getDebug() > 0) {
                    ctx.log("Setting auth servlet " + errorServlet);
                }
            }
            req.setAttribute("javax.servlet.error.status_code", new Integer(code));
        } else {
            Class<?> clazz = t.getClass();
            while (path == null && clazz != null) {
                String name = clazz.getName();
                path = ctx.getErrorPage(name);
                clazz = clazz.getSuperclass();
            }
            req.setAttribute("javax.servlet.error.exception_type", t.getClass());
            req.setAttribute("javax.servlet.error.message", t.getMessage());
            req.setAttribute("tomcat.servlet.error.throwable", t);
        }
        req.setAttribute("tomcat.servlet.error.request", req);
        if (path == null && errorServlet == null) {
            req.setAttribute("tomcat.servlet.error.defaultHandler", "true");
            errorServlet = ctx.getServletByName("tomcat.errorPage");
        }
        if (errorServlet == null && path != null) {
            try {
                RequestDispatcher rd = ctx.getRequestDispatcher(path);
                res.reset();
                if (code >= 400) {
                    res.setStatus(code);
                }
                if (res.isBufferCommitted()) {
                    rd.include((ServletRequest)req.getFacade(), (ServletResponse)res.getFacade());
                } else {
                    rd.forward((ServletRequest)req.getFacade(), (ServletResponse)res.getFacade());
                }
                return;
            }
            catch (Throwable t1) {
                ctx.log(" Error in custom error handler " + t1);
            }
        }
        if (req.getAttribute("tomcat.servlet.error.handler") != null && code >= 400) {
            ctx.log("Error/loop in default error handler " + req + " " + code + " " + t + " " + path);
        } else {
            if (ctx.getDebug() > 0) {
                ctx.log("Error: Calling servlet " + errorServlet);
            }
            req.setAttribute("tomcat.servlet.error.handler", errorServlet);
            errorServlet.handleRequest(req.getFacade(), res.getFacade());
        }
    }

    public void init() throws TomcatException {
        String cp = System.getProperty("java.class.path");
        this.log("Starting tomcat install=\"" + this.getTomcatHome() + "\" home=\"" + this.home + "\" classPath=\"" + cp + "\"");
        ContextInterceptor[] cI = this.getContextInterceptors();
        int i = 0;
        while (i < cI.length) {
            cI[i].engineInit(this);
            ++i;
        }
        Enumeration enumeration = this.getContextNames();
        Context context = null;
        while (enumeration.hasMoreElements()) {
            context = this.getContext((String)enumeration.nextElement());
            try {
                this.initContext(context);
            }
            catch (TomcatException ex) {
                if (context == null) continue;
                this.log("ERROR initializing " + context.toString());
                this.removeContext(context.getPath());
                Throwable ex1 = ex.getRootCause();
                if (ex1 == null) continue;
                ex.printStackTrace();
            }
        }
    }

    public void initContext(Context ctx) throws TomcatException {
        ContextInterceptor[] cI = this.getContextInterceptors();
        int i = 0;
        while (i < cI.length) {
            cI[i].contextInit(ctx);
            ++i;
        }
    }

    public final void log(String msg) {
        this.doLog(msg);
    }

    int processRequest(Request req) {
        req.setContextManager(this);
        if (this.debug > 9) {
            this.log("ProcessRequest: " + req.toString());
        }
        int i = 0;
        while (i < this.requestInterceptors.size()) {
            ((RequestInterceptor)this.requestInterceptors.elementAt(i)).contextMap(req);
            ++i;
        }
        int i2 = 0;
        while (i2 < this.requestInterceptors.size()) {
            ((RequestInterceptor)this.requestInterceptors.elementAt(i2)).requestMap(req);
            ++i2;
        }
        if (this.debug > 9) {
            this.log("After processing: " + req.toString());
        }
        return 0;
    }

    public void removeContainer(Container container) throws TomcatException {
        ContextInterceptor[] cI = this.getContextInterceptors();
        int i = 0;
        while (i < cI.length) {
            cI[i].removeContainer(container);
            ++i;
        }
    }

    public void removeContext(String name) throws TomcatException {
        Context context = (Context)this.contexts.get(name);
        this.log("Removing context path=\"" + context.getPath() + "\" ");
        ContextInterceptor[] cI = this.getContextInterceptors();
        int i = 0;
        while (i < cI.length) {
            cI[i].removeContext(this, context);
            ++i;
        }
        if (context != null) {
            this.shutdownContext(context);
            this.contexts.remove(name);
        }
    }

    public void service(Request rrequest, Response rresponse) {
        block9: {
            try {
                rrequest.setContextManager(this);
                rrequest.setResponse(rresponse);
                rresponse.setRequest(rrequest);
                int status = rresponse.getStatus();
                if (status < 400) {
                    status = this.processRequest(rrequest);
                }
                if (status == 0) {
                    status = this.authenticate(rrequest, rresponse);
                }
                if (status == 0) {
                    status = this.authorize(rrequest, rresponse);
                }
                if (status == 0) {
                    rrequest.getWrapper().handleRequest(rrequest, rresponse);
                } else {
                    this.handleError(rrequest, rresponse, null, status);
                }
            }
            catch (Throwable t) {
                this.handleError(rrequest, rresponse, t, 0);
            }
            try {
                rresponse.finish();
                rrequest.recycle();
                rresponse.recycle();
            }
            catch (Throwable ex) {
                if (this.debug <= 0) break block9;
                this.log("Error closing request " + ex);
            }
        }
    }

    public void setDebug(int level) {
        if (level != 0) {
            System.out.println("Setting level to " + level);
        }
        this.debug = level;
    }

    public void setDefaults() {
        if (this.connectors.size() == 0) {
            if (this.debug > 5) {
                this.log("Setting default adapter");
            }
            SimpleTcpConnector sc = new SimpleTcpConnector();
            sc.setTcpConnectionHandler(new HttpConnectionHandler());
            this.addServerConnector(sc);
        }
        if (this.contextInterceptors.size() == 0) {
            if (this.debug > 5) {
                this.log("Setting default context interceptors");
            }
            this.addContextInterceptor(new LogEvents());
            this.addContextInterceptor(new AutoSetup());
            this.addContextInterceptor(new DefaultCMSetter());
            this.addContextInterceptor(new WorkDirInterceptor());
            this.addContextInterceptor(new WebXmlReader());
            this.addContextInterceptor(new LoadOnStartupInterceptor());
        }
        if (this.requestInterceptors.size() == 0) {
            if (this.debug > 5) {
                this.log("Setting default request interceptors");
            }
            SimpleMapper smap = new SimpleMapper();
            smap.setContextManager(this);
            this.addRequestInterceptor(smap);
            this.addRequestInterceptor(new SessionInterceptor());
        }
    }

    public void setHome(String home) {
        this.home = ContextManager.getCanonicalPath(home);
        this.log("Setting home to " + this.home);
    }

    public void setHostName(String host) {
        this.hostname = host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setTomcatHome(String tH) {
        this.tomcatHome = tH;
    }

    public void setWorkDir(String wd) {
        if (this.debug > 0) {
            this.log("set work dir " + wd);
        }
        this.workDir = wd;
    }

    public void shutdownContext(Context ctx) throws TomcatException {
        Enumeration enumeration = ctx.getServletNames();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            ServletWrapper wrapper = ctx.getServletByName(key);
            ctx.removeServletByName(key);
            wrapper.destroy();
        }
        ContextInterceptor[] cI = this.getContextInterceptors();
        int i = 0;
        while (i < cI.length) {
            cI[i].contextShutdown(ctx);
            ++i;
        }
    }

    public void start() throws Exception {
        Enumeration connE = this.getConnectors();
        while (connE.hasMoreElements()) {
            ((ServerConnector)connE.nextElement()).start();
        }
    }

    public void stop() throws Exception {
        if (this.debug > 0) {
            this.log("Stopping context manager ");
        }
        Enumeration connE = this.getConnectors();
        while (connE.hasMoreElements()) {
            ((ServerConnector)connE.nextElement()).stop();
        }
        ContextInterceptor[] cI = this.getContextInterceptors();
        Enumeration enumeration = this.getContextNames();
        while (enumeration.hasMoreElements()) {
            this.removeContext((String)enumeration.nextElement());
        }
    }
}

