// WinMdate version 1.4.0.2
// yay! finally got the tray component updated/installed
// and WinMdate updated for BCB 3.0 standard!

//---------------------------------------------------------------------------
#include <vcl\vcl.h>
#pragma hdrstop

#include "wm.h"
#include "about.h"
#include "mdate.h"
#include "SplashSource.h"
#include <dos.h>
//---------------------------------------------------------------------------
#pragma link "TrayIcon"
#pragma resource "*.dfm"
TMainForm *MainForm;
//---------------------------------------------------------------------------
__fastcall TMainForm::TMainForm(TComponent* Owner)
	: TForm(Owner)
{
 // run default as minimised and work out the details later
 WindowState = wsMinimized;
}
//----------------------------------------------------------------------------
void __fastcall TMainForm::FileExit(TObject */* Sender */)
{
	Close();
}
//----------------------------------------------------------------------------
// help stuff - we dont use the contents page, first ID is simpler.
void __fastcall TMainForm::HelpContents(TObject */* Sender */)
{
    Application->HelpFile = "winmdate.hlp";
	Application->HelpCommand(HELP_CONTENTS, 1);
}
//----------------------------------------------------------------------------
void __fastcall TMainForm::HelpSearch(TObject */* Sender */)
{
    Application->HelpFile = "winmdate.hlp";
	Application->HelpCommand(HELP_PARTIALKEY, Longint(""));
}
//----------------------------------------------------------------------------
void __fastcall TMainForm::HelpHowToUse(TObject */* Sender */)
{
    Application->HelpFile = "winmdate.hlp";
	Application->HelpCommand(HELP_HELPONHELP, 0);
}
//----------------------------------------------------------------------------
// main window about
void __fastcall TMainForm::HelpAboutItemClick(TObject */* Sender */)
{
     Form1 = new TForm1(Application);
     Form1->ShowModal();
     delete Form1;
}
//---------------------------------------------------------------------------
// main window quit
void __fastcall TMainForm::Exit1Click(TObject */*Sender*/)
{
	  Close();
}
//---------------------------------------------------------------------------
// heart of the thing - a truncated version of Mdate.c
void __fastcall TMainForm::Timer1Timer(TObject * /*Sender*/)
{
    julian_date thedate;

    if (set_date(&thedate) == FALSE)
	return;

    display_results(thedate);
}
//---------------------------------------------------------------------------

// Uses standard doubleclick to restore app
// from system tray - note we are deriving a method
// from the parent class - it may need adding to
// the header!!
void __fastcall TMainForm::IconDblClick(TObject *Sender)
{
    // might want to change this to only restore TMainForm
    // ie make another form the default and keep it invisible
	Application->Restore();
}
//---------------------------------------------------------------------------
// exit from the tray icon
void __fastcall TMainForm::Exit2Click(TObject *Sender)
{
	Close();
}
//---------------------------------------------------------------------------
// get version info from the tray icon popup menu
void __fastcall TMainForm::About1Click(TObject *Sender)
{
     Form1 = new TForm1(Application);
     Form1->ShowModal();
     delete Form1;
}
//---------------------------------------------------------------------------
// tray icon popup help
void __fastcall TMainForm::Help1Click(TObject *Sender)
{
    Application->HelpFile = "winmdate.hlp";
   	Application->HelpCommand(HELP_CONTENTS, 0);
}
//---------------------------------------------------------
// Here we want to use calls to mtools.dll to grab the system date,
// process into a mayan count, and make display it in
// TMainForm::Timer1Timer.

void __fastcall TMainForm::display_results(julian_date thedate)
{
    greg_date gd;
    haab_date hd;
    tzolkin_date td;
    long_count ld;
    char date_buffer[256];
    
    // just return for now, no error dialogs.
    if (!long_count_from_jdate(thedate, &ld))
      return;
  
    if (!greg_date_from_jdate(thedate, &gd))
      return;

    sprintf(date_buffer, "%.2d-%s-%d (%d/%d/%d)", 
             gd.day, gmonth_str(gd.month), gd.year, gd.day, gd.month, gd.year);
    
    Label1->Caption = date_buffer;

    jdate_to_str(thedate, date_buffer);
    Label2->Caption = date_buffer;

    long_count_to_str(ld, date_buffer);
    Label3->Caption = date_buffer;

    tzolkin_date_from_jdate(thedate, &td);
    tzolkin_date_to_str(td, date_buffer);
    Label4->Caption = date_buffer;

    haab_date_from_jdate(thedate, &hd);
    haab_date_to_str(hd, date_buffer);
    Label5->Caption = date_buffer;
    
    // This is actually pretty simple, just do another buffer
    // and make that the hint when in the tray.
    sprintf(buf,"%.2d.%2d.%.2d.%2d.%.2d  % .2d %s % .2d %s",
               ld.bak, ld.kat,ld.tun,ld.uin,ld.kin,
               td.day, td.month, hd.day, hd.month);
    TrayIcon1->Hint = date_buffer;

}
//---------------------------------------------------------------------------

void __fastcall TMainForm::FormShow(TObject *Sender)
{
 if(Splash)
 {// check to see if the pointer is valid
     delete Splash;      // Delete the splash form
     Splash = NULL;      // set the pointer so we don't do it again
 }
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::FormCreate(TObject *Sender)
{
     if (Splash)
        {
        _sleep(3);
        }
}
//---------------------------------------------------------------------------
