{ 
       _/_/_/              _/                _/          _/            _/       
    _/          _/_/    _/_/_/_/    _/_/    _/          _/    _/_/    _/_/_/    
   _/  _/_/  _/    _/    _/      _/    _/  _/    _/    _/  _/_/_/_/  _/    _/   
  _/    _/  _/    _/    _/      _/    _/    _/  _/  _/    _/        _/    _/    
   _/_/_/    _/_/        _/_/    _/_/        _/  _/        _/_/_/  _/_/_/        


  Composant TGoToWeb version 2.1 (02/02/98)
  Par CRESTO Sylvain
  Copyright  1997 CRESTO Sylvain
  cresto@mygale.org
  http://www.mygale.org/~cresto/
  La Borde / 09230 / Contrazy / France
    ----

  Composant pour Delphi 2.0 et 3.0 et C++ Builder 1.0.

  Ce composant vous permet de lancer depuis votre application le navigateur
  par dfaut et de se connecter  un site Internet ou d'envoyer une e-mail.
  Ce composant  t test et fonctionne avec Netscape (2.0 et sup.) et Internet
  Explorer (2.0 et sup.)


  Regardez le fichier d'aide pour plus d'explications...
    ----

  Ce composant est un FREEWARE, vous pouvez l'utiliser dans tous vos
  programmes (commerciaux ou pas !) et les distribuer sans rien me devoir.
  Vous utilisez ce composant  vos risques et prils.
  Par contre vous * NE DEVEZ PAS * distribuer le code source * MODIFI *
  de ce composant sans avoir eu au pralable mon accord.
                                                       Merci.



  -------------




  TGoToWeb component version 2.1 (02/02/98)
  By CRESTO Sylvain
  Copyright  1997 CRESTO Sylvain
  cresto@mygale.org
  http://www.mygale.org/~cresto/
  La Borde / 09230 / Contrazy / France
    ----

  Component for Delphi 2.0 and 3.0 and C++ Builder 1.0.


  This component allow you to launch from your application your favorite browser
  like Netscape Navigator or Internet Explorer and to go on an Url or to send
  an e-mail.
  This component has been tested with Nestcape (2.0 and higher) and Internet Explorer
  (2.0 and higher).


    ----

  This component is FREEWARE!
  No warranty is given by the author, expressed or implied.
  Do not distribute modified version without my agreement.
                                                       thanks.


  }


unit GoToWeb;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs, shellapi, DsgnIntf;

type
  TBrowserState=(gwMaximized,gwNormal);
  TAboutProperty = class(TPropertyEditor)
  private
    procedure Edit; override;
    function GetAttributes: TPropertyAttributes; override;
    function GetValue: string; override;
  end;
  TGoToWeb = class(TComponent)
  private
    FAbout:TAboutProperty;
    FUrl:String;
    FEmail:String;
    FBrowserState:TBrowserState;
    FEMailSubject:String;
    procedure SetUrl(value:string);
    procedure SetEMail(value:string);
    procedure SetBrowserState(value:TBrowserState);
    procedure SetEmailSubject(value:string);
  public
    constructor Create(aOwner : TComponent); override;
    function IsAnyBrowser : boolean;
    function BrowserPath:string;
    function Execute : boolean;
    function SendEMail:boolean;
  published
    property About : TAboutProperty read FAbout write FAbout;
    property Url : string read FUrl write SetUrl;
    property EMail : string read FEMail write SetEMail;
    property EMailSubject : string read FEmailSubject write SetEMailSubject;
    property BrowserState : TBrowserState read FBrowserState write SetBrowserState;
  end;

  function GwToSw(GwValue:TBrowserState):integer;

procedure Register;

implementation

  const nbr_extension=4;
        extension:array[0..nbr_extension-1] of string=('.HTM','.HTML','.SHTML','.SHTM');
  var para:string;

{$R GOTOWEB.RES}

procedure Register;
begin
  RegisterComponents('CRESOFT', [TGoToWeb]);
  RegisterPropertyEditor(TypeInfo(TAboutProperty), TGoToWeb, 'ABOUT', TAboutProperty);
end;

function FindBrowser:string;
  var c:byte;
      hkey1,hkey2:hkey;
      typ,taille:integer;
      tmp:array[0..1024] of char;
begin
  c:=0;
  repeat
    if regopenkeyex(hkey_classes_root,pchar(extension[c]),0,key_all_access,hkey1)=0 then
    begin
      if regqueryvalueex(hkey1,nil,nil,@typ,nil,@taille)=error_success then
      begin
        regqueryvalueex(hkey1,nil,nil,nil,@tmp,@taille);
        if tmp<>'' then
        if regopenkeyex(hkey_classes_root,pchar(tmp+'\shell\open\command'),0,key_all_access,hkey2)=error_success then
        begin
          if regqueryvalueex(hkey2,nil,nil,@typ,nil,@taille)=error_success then
          begin
            regqueryvalueex(hkey2,nil,nil,nil,@tmp,@taille);
            if tmp<>'' then
            begin
{              Arrange;}
              RegCloseKey(hkey2);
              FindBrowser:=strpas(tmp){tmpstr};
              Exit;
            end;
          end;
          regclosekey(hkey2);
        end;
        if regopenkeyex(hkey1,'shell\open\command',0,key_all_access,hkey2)=error_success then
        begin
          if regqueryvalueex(hkey2,nil,nil,@typ,nil,@taille)=error_success then
          begin
            regqueryvalueex(hkey2,nil,nil,nil,@tmp,@taille);
            if tmp<>'' then
            begin
{             Arrange;}
              RegCloseKey(hkey2);
              FindBrowser:=strpas(tmp){tmpstr};
              Exit;
            end;
          end;
        end;
      end;
      regclosekey(hkey1);
    end;
    inc(c);
  until c=nbr_extension;
  FindBrowser:='';
end;

function GwToSw(GwValue:TBrowserState):integer;
begin
  case GwValue of
    gwMaximized: GwToSw:=SW_MAXIMIZE;
    gwNormal: GwToSw:=SW_SHOWNORMAL;
    else GwToSw:=0;
  end;
end;

{ TGoToWeb }

constructor TGoToWeb.create(aOwner : Tcomponent);
begin
  inherited create(aOwner);
  FUrl:='http://www.mygale.org/~cresto/';
  FEmail:='cresto@mygale.org';
end;

function TGoToWeb.IsAnyBrowser : boolean;
begin
  IsAnyBrowser:=FileExists(BrowserPath);
end;

procedure TGotoWeb.SetEmailSubject(value:string);
begin
  FEmailSubject:=value;
end;

procedure TGotoWeb.SetBrowserState(value:TBrowserState);
begin
  FBrowserState:=value;
end;

procedure TGoToWeb.SetUrl(value:string);
begin
  FUrl:=value;
end;

procedure TGoToWeb.SetEMail(value:string);
begin
  FEMail:=value;
end;

function TGoToWeb.BrowserPath:string;
  var tmp:string;
      s,c:word;
begin
  tmp:=findbrowser;
  if tmp<>'' then
  begin
    c:=length(tmp)+1;
    repeat
      dec(c);
      para:=uppercase(copy(tmp,c-3,4));
    until (para='.EXE') or (para='.BAT') or (para='.COM');
    if c<length(tmp) then
    begin
      s:=c;
      para:=trim(copy(tmp,c+1,length(tmp)-(c)));
      c:=1;
      while (c<=length(para)) do
        if para[c]='"' then delete(para,c,1) else inc(c);
      if para<>'' then
      begin
        c:=1;
        while c<=length(para) do
        begin
          if para[c]='%' then
          begin
            while (c<=length(para)) and (para[c]<>' ') do delete(para,c,1);
          end else inc(c);
        end;
      end;
      para:=trim(para);
      delete(tmp,s+1,length(tmp)-s);
    end else para:='';
    if tmp[1]='"' then delete(tmp,1,1);
  end;
  BrowserPath:=tmp;
end;

function TGoToWeb.Execute:boolean;
  var tmp:string;
begin
  tmp:=BrowserPath;
  if tmp<>'' then
  begin
    if shellexecute(application.handle,nil,pchar(tmp),pchar(para+' '+FUrl),nil,GwToSw(FBrowserState))<33 then Execute:=false else Execute:=true;
  end else Execute:=false;
end;

function TGoToWeb.SendEMail:boolean;
  var tmp:string;
begin
  tmp:=BrowserPath;
  if tmp<>'' then
  begin
    if shellexecute(application.handle,nil,pchar(tmp),pchar(para+' mailto:'+FEMail+'?subject='+FEMailSubject),nil,GwToSw(FBrowserState))<33 then SendEMail:=false else SendEMail:=true;
  end else SendEMail:=false;
end;


{ TAboutProperty }

procedure TAboutProperty.Edit;
begin
  Application.MessageBox('By CRESTO Sylvain - 1997'#13'This component (for Delphi 2.0, 3.0x and C++ Builder 1.0) is FREEWARE.'#13#13'E-Mail : cresto@mygale.org'#13'WEB : http://www.mygale.org/~cresto/','GoToWeb component version 2.1', MB_OK+ MB_ICONINFORMATION);
end;

function TAboutProperty.GetAttributes: TPropertyAttributes;
begin
  GetAttributes:=[paDialog, paReadOnly];
end;

function TAboutProperty.GetValue: string;
begin
  GetValue:='(About)';
end;

end.
