// WinMdate version 1.4.0.2
// yay! finally got the tray component updated/installed
// and WinMdate updated for BCB 3.0 standard!

// Registry Notes:
// Our keys are in HKEY_CURRENT_USER\Software\MDT\WinMdate
// \\Positions, \\Size are integers \\Colours are converted TColor values

//---------------------------------------------------------------------------
#include <vcl\vcl.h>
#include <vcl\registry.hpp>
#pragma hdrstop

#include "wm.h"
#include "about.h"
#include "mtools.h"
#include "SplashSource.h"
#include <dos.h>
//---------------------------------------------------------------------------
#pragma link "TrayIcon"
#pragma resource "*.dfm"
TMainForm *MainForm;
//---------------------------------------------------------------------------
__fastcall TMainForm::TMainForm(TComponent* Owner)
	: TForm(Owner)
{
 // run default as minimised and work out the details later
 WindowState = wsMinimized;
}
//----------------------------------------------------------------------------
void __fastcall TMainForm::FileExit(TObject */* Sender */)
{
	Close();
}
//----------------------------------------------------------------------------
// help stuff - we dont use the contents page, first ID is simpler.
void __fastcall TMainForm::HelpContents(TObject */* Sender */)
{
    Application->HelpFile = "winmdate.hlp";
	Application->HelpCommand(HELP_CONTENTS, 1);
}
//----------------------------------------------------------------------------
void __fastcall TMainForm::HelpSearch(TObject */* Sender */)
{
    Application->HelpFile = "winmdate.hlp";
	Application->HelpCommand(HELP_PARTIALKEY, Longint(""));
}
//----------------------------------------------------------------------------
void __fastcall TMainForm::HelpHowToUse(TObject */* Sender */)
{
    Application->HelpFile = "winmdate.hlp";
	Application->HelpCommand(HELP_HELPONHELP, 0);
}
//----------------------------------------------------------------------------
// main window about
void __fastcall TMainForm::HelpAboutItemClick(TObject */* Sender */)
{
     Form1 = new TForm1(Application);
     Form1->ShowModal();
     delete Form1;
}
//---------------------------------------------------------------------------
// main window quit
void __fastcall TMainForm::Exit1Click(TObject */*Sender*/)
{
	  Close();
}
//---------------------------------------------------------------------------
// heart of the thing - a truncated version of Mdate.c
void __fastcall TMainForm::Timer1Timer(TObject * /*Sender*/)
{
    mydate thedate;

    set_date(&thedate);
    display_results(&thedate);
}
//---------------------------------------------------------------------------

// Uses standard doubleclick to restore app
// from system tray - note we are deriving a method
// from the parent class - it may need adding to
// the header!!
void __fastcall TMainForm::IconDblClick(TObject *Sender)
{
    // might want to change this to only restore TMainForm
    // ie make another form the default and keep it invisible
	Application->Restore();
}
//---------------------------------------------------------------------------
// exit from the tray icon
void __fastcall TMainForm::Exit2Click(TObject *Sender)
{
	Close();
}
//---------------------------------------------------------------------------
// get version info from the tray icon popup menu
void __fastcall TMainForm::About1Click(TObject *Sender)
{
     Form1 = new TForm1(Application);
     Form1->ShowModal();
     delete Form1;
}
//---------------------------------------------------------------------------
// tray icon popup help
void __fastcall TMainForm::Help1Click(TObject *Sender)
{
    Application->HelpFile = "winmdate.hlp";
   	Application->HelpCommand(HELP_CONTENTS, 0);
}
//---------------------------------------------------------
// Here we want to use calls to mtools.dll to grab the system date,
// process into a mayan count, and make display it in
// TMainForm::Timer1Timer.

void __fastcall TMainForm::display_results(mydate *thedate)
{
     const char *haabmonth, *tzolkinmonth;
    int haabday, tzolkinday;

    // we get the strings from the DLL without having to muck
    // about with AnsiString objects etc.
    haabmonth = get_haab_date (thedate->jdn, &haabday);
    tzolkinmonth = get_tzolkin_date (thedate->jdn, &tzolkinday);

    char buf[256];
    // the actual work is done here, pretty straightforward
    // changed for edit forms
    sprintf(buf,": %d-%s-%d (%.2d/%.2d/%.2d)",
        thedate->gdate.day, gmonth_str(thedate->gdate.month),
        thedate->gdate.year,
        thedate->gdate.day,
        thedate->gdate.month,
        thedate->gdate.year);
    Label6->Caption = buf;

    sprintf(buf,": % 9.1f", thedate->jdn);
    Label7->Caption = buf;

    sprintf(buf,": % .2d.%.2d.%.2d.%.2d.%.2d",
					thedate->ldate.bak, thedate->ldate.kat,
					thedate->ldate.tun, thedate->ldate.uin,
					thedate->ldate.kin);
    Label8->Caption = buf;
    sprintf(buf,": % .2d %-6.8s", tzolkinday, tzolkinmonth);
    Label9->Caption = buf;
    sprintf(buf,": % .2d %-6.6s ",  haabday, haabmonth);
    Label10->Caption = buf;
    // This is actually pretty simple, just do another buffer
    // and make that the hint when in the tray.
    sprintf(buf,"%.2d.%2d.%.2d.%2d.%.2d  % .2d %s % .2d %s",
               thedate->ldate.bak, thedate->ldate.kat,
               thedate->ldate.tun, thedate->ldate.uin,
               thedate->ldate.kin, tzolkinday, tzolkinmonth, haabday, haabmonth);
    TrayIcon1->Hint = buf;

}
//---------------------------------------------------------------------------

void __fastcall TMainForm::FormShow(TObject *Sender)
{
 if(Splash)
 {// check to see if the pointer is valid
     delete Splash;      // Delete the splash form
     Splash = NULL;      // set the pointer so we don't do it again
 }
}
//---------------------------------------------------------------------------

// Startup for MainForm. There is a problem with setting up/getting the \\Colours
// values - as far as I can see, unless the keys exist, the program crashes, so
// we'd better put in some default values to protect it.

void __fastcall TMainForm::FormCreate(TObject *Sender)
{
     // wait for the splashscreen
     if (Splash)
        {
        _sleep(2);
        }
    // now we do our registry stuff
    TRegistry *MyReg;
    MyReg = new TRegistry;
    MyReg->RootKey = HKEY_CURRENT_USER;

    //Write position info, do NOT attempt to create the key if it
    // doesnt exist! This code checks for the correct registry
    // paths
    if (MyReg->OpenKey("\\Software\\MDT\\WinMdate\\Positions", FALSE))
    {
        //Code to write position info goes here.
    }
    //Write size info
    if (MyReg->OpenKey("\\Software\\MDT\\WinMdate\\Size", FALSE))
    {
        //Code to write size info goes here.
    }
    //write color info
    if (MyReg->OpenKey("\\Software\\MDT\\WinMdate\\Colours", FALSE))
    {
        //Code to write color info goes here.
    }

    //Get position info
    if (MyReg->OpenKey("\\Software\\MDT\\WinMdate\\Positions", FALSE))
    {
    //Get top & left
        try
        {
            MainForm->Top = MyReg->ReadInteger("FormTop");
            MainForm->Left = MyReg->ReadInteger("FormLeft");
        }
        catch (...)
        {
            ; // Do nothing. Leave properties as they are
        }
    }
    //Get size info
    if (MyReg->OpenKey("\\Software\\MDT\\WinMdate\\Size", FALSE))
    {
        //Get width & height
        try
        {
            MainForm->Width = MyReg->ReadInteger("FormWidth");
            MainForm->Height = MyReg->ReadInteger("FormHeight");
        }
        catch (...)
        {
            ; // Do nothing. Leave Form->Top as it is
        }
    }
    //Get colour info - this is heap big problem boss:
    // very strange behaviour: at different times, this program crashes
    // if the keys dont exist. However, I've just retested it and this code
    // works now?!
    if (MyReg->OpenKey("\\Software\\MDT\\WinMdate\\Colours", FALSE))
    {
        try
        {
            MainForm->Color = StringToColor(MyReg->ReadString("MFormC"));
            Label1->Color = StringToColor(MyReg->ReadString("GregC"));
            Label2->Color = StringToColor(MyReg->ReadString("JulianC"));
            Label3->Color = StringToColor(MyReg->ReadString("LongC"));
            Label4->Color = StringToColor(MyReg->ReadString("TzolkC"));
            Label5->Color = StringToColor(MyReg->ReadString("HaabC"));
            Label1->Font->Color = StringToColor(MyReg->ReadString("GFontC"));
            Label2->Font->Color = StringToColor(MyReg->ReadString("JFontC"));
            Label3->Font->Color = StringToColor(MyReg->ReadString("LFontC"));
            Label4->Font->Color = StringToColor(MyReg->ReadString("TFontC"));
            Label5->Font->Color = StringToColor(MyReg->ReadString("HFontC"));
            Label6->Color = StringToColor(MyReg->ReadString("GDateC"));
            Label7->Color = StringToColor(MyReg->ReadString("JDateC"));
            Label8->Color = StringToColor(MyReg->ReadString("LDateC"));
            Label9->Color = StringToColor(MyReg->ReadString("TzDateC"));
            Label10->Color = StringToColor(MyReg->ReadString("HDateC"));
            Label6->Font->Color = StringToColor(MyReg->ReadString("GDateFontC"));
            Label7->Font->Color = StringToColor(MyReg->ReadString("JDateFontC"));
            Label8->Font->Color = StringToColor(MyReg->ReadString("LDateFontC"));
            Label9->Font->Color = StringToColor(MyReg->ReadString("TzDateFontC"));
            Label10->Font->Color = StringToColor(MyReg->ReadString("HDateFontC"));
        }
        catch (...)
        {
            // to protect the application, if we havent found anything, write
            // THESE default values:
            MainForm->Color = clBlack;
            Label1->Color = clGray;
            Label2->Color = clGray;
            Label3->Color = clGray;
            Label4->Color = clGray;
            Label5->Color = clGray;
            Label6->Color = clMaroon;
            Label7->Color = clMaroon;
            Label8->Color = clMaroon;
            Label9->Color = clMaroon;
            Label10->Color = clMaroon;
            Label1->Font->Color = clYellow;
            Label2->Font->Color = clYellow;
            Label3->Font->Color = clYellow;
            Label4->Font->Color = clYellow;
            Label5->Font->Color = clYellow;
            Label6->Font->Color = clWhite;
            Label7->Font->Color = clWhite;
            Label8->Font->Color = clWhite;
            Label9->Font->Color = clWhite;
            Label10->Font->Color = clWhite;
        }
    }
    // free registry pointer
    MyReg->Free();
    // refresh app
    MainForm->Refresh();

}

//---------------------------------------------------------------------------
// Now for some truly stupid additions :) All these buttons set the colours

void __fastcall TMainForm::Button1click(TObject *Sender)
{
    if (ColorDialog1->Execute())
               MainForm->Color = ColorDialog1->Color;
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::Button2click(TObject *Sender)
{
    if (ColorDialog1->Execute()) {
        Label1->Color = ColorDialog1->Color;
        Label2->Color = ColorDialog1->Color;
        Label3->Color = ColorDialog1->Color;
        Label4->Color = ColorDialog1->Color;
        Label5->Color = ColorDialog1->Color;
    }
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::Button3click(TObject *Sender)
{
    if (ColorDialog1->Execute()) {
        Label6->Color = ColorDialog1->Color;
        Label7->Color = ColorDialog1->Color;
        Label8->Color = ColorDialog1->Color;
        Label9->Color = ColorDialog1->Color;
        Label10->Color = ColorDialog1->Color;
    }
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::Button4click(TObject *Sender)
{
    if (ColorDialog1->Execute()) {
             Label1->Font->Color = ColorDialog1->Color;
             Label2->Font->Color = ColorDialog1->Color;
             Label3->Font->Color = ColorDialog1->Color;
             Label4->Font->Color = ColorDialog1->Color;
             Label5->Font->Color = ColorDialog1->Color;
    }
}
//---------------------------------------------------------------------------

void __fastcall TMainForm::button5click(TObject *Sender)
{
    if (ColorDialog1->Execute()) {
        Label6->Font->Color = ColorDialog1->Color;
        Label7->Font->Color = ColorDialog1->Color;
        Label8->Font->Color = ColorDialog1->Color;
        Label9->Font->Color = ColorDialog1->Color;
        Label10->Font->Color = ColorDialog1->Color;
    }
}
//---------------------------------------------------------------------------
// Values saved in the registry when we close
void __fastcall TMainForm::FormClose(TObject *Sender, TCloseAction &Action)
{
        TRegistry *MyReg;                    //define pointer
        MyReg = new TRegistry;               //allocate space and assign pointer
        MyReg->RootKey = HKEY_CURRENT_USER;    // set root key

        //Write position info
        if (MyReg->OpenKey("\\Software\\MDT\\WinMdate\\Positions", TRUE))
        {
        //Code to write position info goes here.
            //write top & left
            try
            {
                MyReg->WriteInteger("FormTop", MainForm->Top);
                MyReg->WriteInteger("FormLeft", MainForm->Left);
            }
            catch (...)
            {
                ; //do nothing
            }
        }
        //Write size info
        if (MyReg->OpenKey("\\Software\\MDT\\WinMdate\\Size", TRUE))
        {
        //Code to write size info goes here.
            //Write width & height
            try
            {
                MyReg->WriteInteger("FormWidth", MainForm->Width);
                MyReg->WriteInteger("FormHeight", MainForm->Height);
            }
            catch (...)
            {
                ; //do nothing
            }
        }
        // now save colours - need to save as an actual string to get this to
        // work - see ::FormCreate above
        if (MyReg->OpenKey("\\Software\\MDT\\WinMdate\\Colours", TRUE))
        {
            try
            {
                MyReg->WriteString("MFormC", ColorToString(MainForm->Color));
                MyReg->WriteString("GregC", ColorToString(Label1->Color));
                MyReg->WriteString("JulianC", ColorToString(Label2->Color));
                MyReg->WriteString("LongC", ColorToString(Label3->Color));
                MyReg->WriteString("TzolkC", ColorToString(Label4->Color));
                MyReg->WriteString("HaabC", ColorToString(Label5->Color));
                MyReg->WriteString("GFontC", ColorToString(Label1->Font->Color));
                MyReg->WriteString("JFontC", ColorToString(Label2->Font->Color));
                MyReg->WriteString("LFontC", ColorToString(Label3->Font->Color));
                MyReg->WriteString("TFontC", ColorToString(Label4->Font->Color));
                MyReg->WriteString("HFontC", ColorToString(Label5->Font->Color));
                MyReg->WriteString("GDateC", ColorToString(Label6->Color));
                MyReg->WriteString("JDateC", ColorToString(Label7->Color));
                MyReg->WriteString("LDateC", ColorToString(Label8->Color));
                MyReg->WriteString("TzDateC", ColorToString(Label9->Color));
                MyReg->WriteString("HDateC", ColorToString(Label10->Color));
                MyReg->WriteString("GDateFontC", ColorToString(Label6->Font->Color));
                MyReg->WriteString("JDateFontC", ColorToString(Label7->Font->Color));
                MyReg->WriteString("LDateFontC", ColorToString(Label8->Font->Color));
                MyReg->WriteString("TzDateFontC", ColorToString(Label9->Font->Color));
                MyReg->WriteString("HDateFontC", ColorToString(Label10->Font->Color));
            }
            catch (...)
            {
                ; //do nothing
            }
        }
        MyReg->Free();
}
//---------------------------------------------------------------------------
// allow users to reset colours back to default.
// when colour saving is implemented, this will overwrite the registry
// keys if user exits after using this
void __fastcall TMainForm::ColResetClick(TObject *Sender)
{
    MainForm->Color = clBlack;
    Label1->Color = clGray;
    Label2->Color = clGray;
    Label3->Color = clGray;
    Label4->Color = clGray;
    Label5->Color = clGray;
    Label6->Color = clMaroon;
    Label7->Color = clMaroon;
    Label8->Color = clMaroon;
    Label9->Color = clMaroon;
    Label10->Color = clMaroon;
    Label1->Font->Color = clYellow;
    Label2->Font->Color = clYellow;
    Label3->Font->Color = clYellow;
    Label4->Font->Color = clYellow;
    Label5->Font->Color = clYellow;
    Label6->Font->Color = clWhite;
    Label7->Font->Color = clWhite;
    Label8->Font->Color = clWhite;
    Label9->Font->Color = clWhite;
    Label10->Font->Color = clWhite;

}
//---------------------------------------------------------------------------

