/*
 * Decompiled with CFR 0.152.
 */
package com.rexbot.game.card;

import com.rexbot.reg.TestKey;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Category;

public class Opts
implements Serializable {
    private static Category cat = Category.getInstance(class$com$rexbot$game$card$Opts == null ? (class$com$rexbot$game$card$Opts = Opts.class$("com.rexbot.game.card.Opts")) : class$com$rexbot$game$card$Opts);
    private static String RESOURCE_NAME = "config";
    private static Opts instance = null;
    private int numOfPlayers = 10;
    private int humanPlayer = 5;
    private int betMultiplier = 1;
    private boolean learnFromHuman = true;
    private int checkpoint = 100;
    private int roundsPerShuffle = 1;
    private int mutationRate = 200;
    private int maxRaisesPerRound = 3;
    private String cardSet = "1";
    private int roundsPerMating = 1;
    private String brainSetName = "alpha";
    private List allBrainSetNames = new ArrayList();
    private int cumputerPlayerDelay = 1;
    private boolean alwaysShowWinner = false;
    private int rakePercentage = 4;
    private int freezeButtonAt = 0;
    private boolean allCardsFaceUp = false;
    private String regCode = "";
    private String userName;
    private boolean registered;
    private String background = "DEFAULT";
    private List backgroundList = new ArrayList();
    private boolean preserveHistory = false;
    private String historyFile = "history.txt";
    static /* synthetic */ Class class$com$rexbot$game$card$Opts;

    private Opts() {
        this.allBrainSetNames.add("alpha");
        this.allBrainSetNames.add("beta");
        this.allBrainSetNames.add("gamma");
        this.allBrainSetNames.add("delta");
        this.allBrainSetNames.add("epsilon");
        this.allBrainSetNames.add("zeta");
        this.allBrainSetNames.add("eta");
        this.allBrainSetNames.add("theta");
        this.allBrainSetNames.add("iota");
        this.allBrainSetNames.add("kappa");
        if (this.backgroundList.isEmpty()) {
            this.backgroundList.add("DEFAULT");
        }
    }

    public static void main(String[] args) throws Exception {
        cat.debug("Testing Opts");
        cat.debug("betMult = " + Opts.getInstance().getBetMultiplier());
        Opts.getInstance().setBetMultiplier(5);
        Opts.getInstance().save();
    }

    public static Opts getInstance() {
        if (instance == null) {
            Opts.retrieve();
        }
        return instance;
    }

    public static String getGame(int betMult) {
        int min = betMult / 2;
        int max = betMult;
        return "$" + min + "-$" + max;
    }

    public static int betMult(String game) {
        StringBuffer sb = new StringBuffer();
        char[] chars = game.toCharArray();
        for (int i = 1; i < chars.length && chars[i] != '-'; ++i) {
            sb.append(chars[i]);
        }
        try {
            return Integer.parseInt(sb.toString()) / 2;
        }
        catch (NumberFormatException nfe) {
            throw new RuntimeException("Unable to get bet multiplyer for: " + game);
        }
    }

    public void save() {
        try {
            String fileName = new File(RESOURCE_NAME).getAbsolutePath();
            FileOutputStream fos = new FileOutputStream(fileName);
            ObjectOutputStream oos = new ObjectOutputStream(fos);
            oos.writeObject(instance);
        }
        catch (Exception e) {
            cat.error("Unable to save Options!", e);
        }
    }

    public static void retrieve() {
        try {
            String fileName = new File(RESOURCE_NAME).getAbsolutePath();
            if (new File(fileName).length() > 0L) {
                FileInputStream fis = new FileInputStream(fileName);
                ObjectInputStream ois = new ObjectInputStream(fis);
                instance = (Opts)ois.readObject();
            }
        }
        catch (Exception e) {
            cat.warn("Unable to retrieve options.  This may be becouse of first use. Error=" + e, e);
        }
        if (instance == null) {
            instance = new Opts();
        }
    }

    public int getNumOfPlayers() {
        return this.numOfPlayers;
    }

    public void setNumOfPlayers(int numOfPlayers) {
        this.numOfPlayers = numOfPlayers;
    }

    public int getHumanPlayer() {
        return this.humanPlayer;
    }

    public void setHumanPlayer(int humanPlayer) {
        this.humanPlayer = humanPlayer;
    }

    public int getBetMultiplier() {
        return this.betMultiplier;
    }

    public void setBetMultiplier(int betMultiplier) {
        this.betMultiplier = betMultiplier;
    }

    public boolean isLearnFromHuman() {
        return this.learnFromHuman;
    }

    public void setLearnFromHuman(boolean learnFromHuman) {
        this.learnFromHuman = learnFromHuman;
    }

    public int getCheckpoint() {
        return this.checkpoint;
    }

    public void setCheckpoint(int checkpoint) {
        this.checkpoint = checkpoint;
    }

    public int getRoundsPerShuffle() {
        return this.roundsPerShuffle;
    }

    public void setRoundsPerShuffle(int roundsPerShuffle) {
        this.roundsPerShuffle = roundsPerShuffle;
    }

    public int getMutationRate() {
        return this.mutationRate;
    }

    public void setMutationRate(int mutationRate) {
        this.mutationRate = mutationRate;
    }

    public int getMaxRaisesPerRound() {
        return this.maxRaisesPerRound;
    }

    public void setMaxRaisesPerRound(int maxRaisesPerRound) {
        this.maxRaisesPerRound = maxRaisesPerRound;
    }

    public String getCardSet() {
        return this.cardSet;
    }

    public void setCardSet(String cardSet) {
        this.cardSet = cardSet;
    }

    public int getRoundsPerMating() {
        return this.roundsPerMating;
    }

    public void setRoundsPerMating(int roundsPerMating) {
        this.roundsPerMating = roundsPerMating;
    }

    public String getBrainSetName() {
        return this.brainSetName;
    }

    public void setBrainSetName(String brainSetName) {
        this.brainSetName = brainSetName;
    }

    public List getAllBrainSetNames() {
        return this.allBrainSetNames;
    }

    public void setAllBrainSetNames(List allBrainSetNames) {
        this.allBrainSetNames = allBrainSetNames;
    }

    public int getCumputerPlayerDelay() {
        return this.cumputerPlayerDelay;
    }

    public void setCumputerPlayerDelay(int cumputerPlayerDelay) {
        this.cumputerPlayerDelay = cumputerPlayerDelay;
    }

    public boolean isAlwaysShowWinner() {
        return this.alwaysShowWinner;
    }

    public void setAlwaysShowWinner(boolean alwaysShowWinner) {
        this.alwaysShowWinner = alwaysShowWinner;
    }

    public int getRakePercentage() {
        return this.rakePercentage;
    }

    public void setRakePercentage(int rakePercentage) {
        this.rakePercentage = rakePercentage;
    }

    public int getFreezeButtonAt() {
        return this.freezeButtonAt;
    }

    public void setFreezeButtonAt(int freezeButtonAt) {
        this.freezeButtonAt = freezeButtonAt;
    }

    public boolean isAllCardsFaceUp() {
        return this.allCardsFaceUp;
    }

    public void setAllCardsFaceUp(boolean allCardsFaceUp) {
        this.allCardsFaceUp = allCardsFaceUp;
    }

    public String getRegCode() {
        return this.regCode;
    }

    public void setRegCode(String regCode) {
        String user = null;
        try {
            user = TestKey.test(regCode);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (user != null) {
            this.setUserName(user);
            this.setRegistered(true);
            this.regCode = regCode;
        }
        this.save();
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public boolean isRegistered() {
        return this.registered;
    }

    public void setRegistered(boolean registered) {
        this.registered = registered;
    }

    public String getBackground() {
        return this.background;
    }

    public void setBackground(String background) {
        this.background = background;
    }

    public void addBackground(String background) {
        if (this.backgroundList.contains(background)) {
            return;
        }
        this.backgroundList.add(1, background);
    }

    public List getBackgroundList() {
        return this.backgroundList;
    }

    public void setBackgroundList(List backgroundList) {
        this.backgroundList = backgroundList;
    }

    public boolean isPreserveHistory() {
        return this.preserveHistory;
    }

    public void setPreserveHistory(boolean preserveHistory) {
        this.preserveHistory = preserveHistory;
    }

    public String getHistoryFile() {
        return this.historyFile;
    }

    public void setHistoryFile(String historyFile) {
        this.historyFile = historyFile;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

