Attribute VB_Name = "modElemMaker"
Type ElementEntryVars
    Invisible As Boolean
    Symbol As Variant
    ForeColor As Long
    BackColor As Long
    QuickInfo As String
    NoData As Boolean
    Data(1 To 8) As String
End Type

Type TopicEntryVars
    Author As String
    Date As String
    Locked As Boolean
    Password As String
End Type

Public Const Header = "EMFv1.0-File to be read by Element Maker v1.0"
Public Const Version = "Element Viewer v1.0"

Public CurrentSelected As Integer
Public ElementEntry(216) As ElementEntryVars
Public TopicEntry As TopicEntryVars
Public IHaveBeenClosed As Boolean
Public AboutIsOpen As Boolean
Sub ClearItUp()
    For Iodine = 1 To 216
        ElementEntry(Iodine).Invisible = False
        ElementEntry(Iodine).Symbol = ""
        ElementEntry(Iodine).BackColor = &HC0C0C0
        ElementEntry(Iodine).ForeColor = &H8
        ElementEntry(Iodine).QuickInfo = ""
        ElementEntry(Iodine).NoData = False
        ElementEntry(Iodine).QuickInfo = ""
        ElementEntry(Iodine).Data(1) = ""
        ElementEntry(Iodine).Data(2) = ""
        ElementEntry(Iodine).Data(3) = ""
        ElementEntry(Iodine).Data(4) = ""
        ElementEntry(Iodine).Data(5) = ""
        ElementEntry(Iodine).Data(6) = ""
        ElementEntry(Iodine).Data(7) = ""
        ElementEntry(Iodine).Data(8) = ""
    Next Iodine
    LoadDataTofrmTable
    TopicEntry.Author = ""
    TopicEntry.Date = ""
    TopicEntry.Locked = False
    TopicEntry.Password = ""
    SomebodyClickedMe 1
End Sub
Public Sub LoadDataTofrmTable()
    For Iodine = 1 To 216
        frmTable!Elements(Iodine).Enabled = Not ElementEntry(Iodine).Invisible
        frmTable!Elements(Iodine).Visible = Not ElementEntry(Iodine).Invisible
        frmTable!Elements(Iodine).Caption = ElementEntry(Iodine).Symbol
        frmTable!Elements(Iodine).BackColor = ElementEntry(Iodine).BackColor
        frmTable!Elements(Iodine).ForeColor = ElementEntry(Iodine).ForeColor
    Next Iodine
End Sub



Public Sub OpenFile()
    On Error GoTo ErrHandler
    frmTable!CommonDialog.ShowOpen
    CFileName = frmTable!CommonDialog.FileName
    Titled = True
    OpenToFile CFileName
    Exit Sub

ErrHandler:
    Exit Sub
End Sub
Public Sub OpenToFile(FileName As Variant)

    SetAttr FileName, vbArchive
    Free = FreeFile
       
    Open FileName For Random As #Free Len = 3 + 216
        On Error GoTo ErrHandler
        Get #Free, 1, PutHeader
        If PutHeader <> Header$ Then
            MsgBox "This file does not have the EMFv1.0 header", 48, Version
            Close #Free
            Exit Sub
        End If
        
        Get #Free, , TopicEntry
        Get #Free, , TopicEntry
        For Iodine = 1 To 216
            Get #Free, , ElementEntry(Iodine)
        Next Iodine
        LoadDataTofrmTable
        frmDescription.Hide
        frmTable!lblQuickInfo.Caption = ""
       
    Close #Free
    SomebodyClickedMe 1
'    ResizeAll
    Exit Sub
    
ErrHandler:
    MsgBox "This file does not have the EMFv1.0 format", 48, Version
    Close #Free
End Sub
Public Function WierdOpenToFile(FileName As Variant)

    SetAttr FileName, vbArchive
    Free = FreeFile
       
    Open FileName For Random As #Free Len = 3 + 216
        On Error GoTo ErrHandler
        Get #Free, 1, PutHeader
        If PutHeader <> Header$ Then
            MsgBox "This file does not have the EMFv1.0 header", 48, Version
            Close #Free
            WierdOpenToFile = True
            Exit Function
        End If
        
        Get #Free, , TopicEntry
        Get #Free, , TopicEntry
        For Iodine = 1 To 216
            Get #Free, , ElementEntry(Iodine)
        Next Iodine
        LoadDataTofrmTable
        frmDescription.Hide
        frmTable!lblQuickInfo.Caption = ""
       
    Close #Free
    SomebodyClickedMe 1
'    ResizeAll
    WierdOpenToFile = False
    Exit Function
    
ErrHandler:
    MsgBox "This file does not have the EMFv1.0 format", 48, Version
    Close #Free
    WierdOpenToFile = True
End Function



    

Public Sub SomebodyClickedMe(Selected)
    
    LastSelected = CurrentSelected
    CurrentSelected = Selected
    Select Case ElementEntry(Selected).NoData
        Case True: frmDescription.Hide
        Case False
        If ElementEntry(Selected).NoData <> ElementEntry(LastSelected).NoData Or IHaveBeenClosed Then
            frmDescription.Show
        End If
    End Select
    
    For Iodine = 1 To 8
        frmDescription!lblDataTopic(Iodine).Caption = frmDescription!txtElementEntry(Iodine).Tag + " :"
        frmDescription!txtElementEntry(Iodine).Text = " " + ElementEntry(Selected).Data(Iodine)
    Next Iodine
    
    frmDescription!lblByLine.Caption = "Made by " + TopicEntry.Author + " on " + TopicEntry.Date
    
End Sub
Public Sub SomebodyMouseOver(Selected)
    frmTable!lblQuickInfo.Caption = ElementEntry(Selected).QuickInfo
End Sub


