#!/bin/sh
# MetaCard 2.3 stack
# The following is not ASCII text,
# so now would be a good time to q out of more
exec mc $0 "$@"
                                                                                                                                 3 	launcher  7	-- copyright 2001 Garth Catterall-Heart, SpiritWorks Software Development
-- all rights reserved worldwide

on openStack
  global gRegistered
  
  if gRegistered is empty then
    insert the script of stack "splash" into back
    insert the script of this stack into back
    setLoc  "Launcher" -- for short screens
    initGlobals
    checkPassword
  end if
end openStack

on goSBTrackerStack which
  global gNewWindow,gLastCard,gStack,gTallWindows,gDontSave,gMenuChoices,gMenuStacks
  
  set cursor to watch
  lock screen
  put false into showHelp
  put the name of this card into zcard
  put the short name of this stack into prevStack
  put empty into prevCard
  
  set cursor to busy
  put item 4 of the screenRect into screenHeight
  if screenHeight = 480 OR gTallWindows is false then
    put 440 into zScreenHeight
  else put 550 into zScreenHeight
  
  put "records" into zstack
  put "help" into helpStack
  if there is not a stack zstack then exit goSBTrackerStack --***
  
  -- zstack is stack we're going to
  -- zcard is card we're coming from
  -- prevStack is stack we're coming from
  -- gLastCard is 12 line global with last card visited in each stack
  
  set cursor to busy
  if getStackLine(zstack) < 13 then
    if line getStackLine(zstack) of gLastCard is empty then
      put empty into prevCard
    else
      put line getStackLine(zstack) of gLastCard into prevCard
    end if
    put zcard && "of stack" && prevStack into line getStackLine(prevstack) of gLastCard
  else
    put empty into prevCard
  end if
  
  setLoc zstack
  open stack zstack in the window of the topstack
  
  set cursor to busy
  put the height of the topstack into zHeight
  if zHeight = 426 then -- we're on a small screen Mac
    put 440 into zHeight
    set the height of stack zstack to 440
    set the bottom of stack zstack to 480
  end if
  if zScreenHeight <> zHeight then
    switch zScreenHeight
    case 440
      set the height of stack zstack to 440
      set the width of stack zstack to 400
      if NOT gNewWindow then
        get the loc of stack zstack
        subtract 55 from item 2 of it
        set the loc of stack zstack to it
      end if
      break
    case 550
      set the height of stack zstack to 550
      set the width of stack zstack to 400
      if NOT gNewWindow then
        get the loc of stack zstack
        add 55 to item 2 of it
        set the loc of stack zstack to it
      end if
    end switch
  end if
  
  if the bottom of stack zstack > screenHeight then
    if the platform contains "mac" then
      set the bottom of stack zstack to screenHeight
    else
      set the top of stack zstack to 10
    end if
  end if
  
  if gTallWindows  then
    if there is a button "setlong" of stack zstack then
      send mouseUp to button "setlong" of stack zstack
    end if
  else
    if there is a button "setshort" of stack zstack then
      send mouseUp to button "setshort" of stack zstack
    end if
  end if
  
  -- prevCard should be last visited card of stack we're going to
  try
    go prevCard
  catch errorNum
    answer "catch errorNum = " & errorNum --**
    if errorNum is not empty then
      go last card of stack zstack
    end if
  end try
  
  set cursor to busy
  set the defaultStack to zstack
  if there is a button "first" of stack zstack then
    send setArrows to stack zstack
    saveData
  end if
  
  unlock screen with visual plain
  unlock screen with visual wipe down to card
  put zstack into gStack
  resetColors
end goSBTrackerStack

on resetColors
  global gBgColor,gBtnColor,gHlColor,gStack
  set cursor to busy
  put the backgroundcolor of stack gStack into gBgColor
  put the backgroundcolor of btn 1 of stack gStack into gBtnColor
  set the backgroundcolor of stack "answer dialog" of stack "launcher" to gBgColor
  set the backgroundcolor of stack "ask dialog" of stack "launcher" to gBgColor
  set the backgroundcolor of stack "atFind" of stack "launcher" to gBgColor
  set the backgroundcolor of stack "dates" of stack "launcher" to gBgColor
  repeat with i = 1 to the number of buttons of stack "dates" of stack "launcher"
    set the backgroundcolor of btn i of stack "dates" of stack "launcher"  to gBtnColor
  end repeat
  repeat with i = 1 to the number of buttons of stack "answer dialog" of stack "launcher"
    set the backgroundcolor of btn i of stack "answer dialog" of stack "launcher"  to gBtnColor
  end repeat
  repeat with i = 1 to the number of buttons of stack "ask dialog" of stack "launcher"
    set the backgroundcolor of btn i of stack "ask dialog" of stack "launcher"  to gBtnColor
  end repeat
  repeat with i = 1 to the number of buttons of stack "atFind" of stack "launcher"
    set the backgroundcolor of btn i of stack "atFind" of stack "launcher"  to gBtnColor
  end repeat
  set cursor to hand
end resetColors

function getStackLine zstack
  switch zstack
  case "records"
    put 1 into zLine
    break
  default
    put 13 into zLine
  end switch
  return zLine
end getStackLine

function convertDate which,zdate
  switch which
  case "short"
    convert zdate to short date
    break
  case "long"
    convert zdate to long date
    break
  case "abbr"
    convert zdate to abbr date
    break
  case "dateitems"
    convert zdate to dateitems
  end switch
  return zdate
end convertDate

function convert2USDate which,zdate -- not used
  global gUSDateFormat
  if gUSDateFormat is false then
    if which is "short" then
      set itemdelimiter to "/"
      put item 2 of zdate & "/" & item 1 of zdate & "/" & item 3 of zdate into zdate
    else
      put item 1 of zdate & comma & item 3 of zdate & comma \
          & item 2 of zdate & comma & item 4 of zdate into zdate
    end if
  end if
  return convertDate(which,zdate)
end convert2USDate

function setNumber which,numberFormatFlag
  global gUSNumFormat,gDollarSign
  if numberFormatFlag is empty then put 0 into numberFormatFlag
  if gDollarSign = "$" AND numberFormatFlag is 0 then
    set the numberformat to 0.00
  end if
  put offset(".",which) into decPos
  --  if gUSNumFormat then
  put which into temp
  if decPos > 0 then
    put char decPos to length(which) of temp into zfraction
    delete char decPos to length(which) of temp
    put getUSnumber(temp) into znumber
    if char 1 of znumber is "-" and char 2 of znumber is comma then delete char 2 of znumber
    if zfraction = 0 then
      return znumber
    else
      return znumber & zfraction
    end if
  else
    put getUSnumber(temp) into znumber
    if char 1 of znumber is "-" and char 2 of znumber is comma then delete char 2 of znumber
    return znumber
  end if
  # else -- euro numbers
  # if decPos > 0 then
  # put which into temp
  # put empty into znumber
  # put char decPos + 1 to length(which) of temp into zfraction
  # delete char decPos to length(which) of temp
  # repeat while temp <> empty --with x = length(which) down to 1
  # put length(temp) into lastChar
  # if lastChar <=3 then
  # put temp before znumber
  # exit repeat
  # else
  # put "." & char (lastChar - 3) to lastChar of temp before znumber
  # delete char (lastChar - 3) to lastChar of temp
  # end if
  # end repeat
  # return znumber & comma & zfraction
  # else
  # return which
  # end if
  # end if
end setNumber

function checkNumber which
  if validateNumber(which) is a number then
    return setNumber(which)
  else
    answer error "Not a number. Please try again."
    return empty
  end if
end checkNumber

function validateNumber which
  if which is empty then return empty
  repeat with x =  length(which) down to 1
    if char x of which is  a number then next repeat
    if char x of which is "." then next repeat
    if "!@#%^&*()_+=:;<>?/" contains char x of which then return empty
    if char x of which is "-" then next repeat
    else delete char x of which
  end repeat
  if which is a number then
    return which
  else
    return empty
  end if
end validateNumber

function getUSnumber which
  put empty into znumber
  repeat forever
    put length(which) into lastChar
    if lastChar <=3 then
      put which before znumber
      exit repeat
    else
      put comma & char (lastChar - 2) to lastChar of which before znumber
      delete char (lastChar - 2) to lastChar of which
    end if
  end repeat
  return znumber
end getUSnumber

on initGlobals
  global gVeffect,gTimeErrorReminder,gDollarSign, gDistanceFormat
  global gNewWindow,gTallWindows,gLastCard,gDefaultFont,gMainStack
  global gUSDateFormat,gUSNumFormat,gMenuChoices,gMenuStacks,gDperMile
  
  if there is a stack "records" then put field "$/mile" of card 1 of stack "records" into gDperMile
  if gDperMile is empty and dperMile is not empty then put dperMile into gDperMile
  if gDperMile is empty and dperMile is empty then put ".33" into gDperMile
  
  put the short name of this stack into gMainStack
  put field "last stack" into gLastCard
  put "launcher" into gStack
  put "launch prefs" into prefsStack
  set the lookAndFeel to the hilitedButtonName of group "LooknFeel" of stack prefsStack
  if field "hColor" of stack prefsStack is empty then
    if the lookAndFeel = "Macintosh" then
      set the hilitecolor to "CornflowerBlue"
    else
      set the hilitecolor to "DarkBlue"
    end if
    put the hiliteColor into field "hColor" of stack "launch prefs"
  else
    set the hilitecolor to field "hColor" of stack prefsStack
  end if
  if the hilitedButtonName of group "visualEffects" of stack prefsStack is "On" then
    put true into gVeffect
  else
    put false into gVeffect
  end if
  put field "symbol" of stack prefsStack into gDollarSign
  if the hilite of button "ton" of stack prefsStack then
    put true into gTimeErrorReminder
  else
    put false into gTimeErrorReminder
  end if
  -- put the hilite of button "us" of stack prefsStack into gUSDateFormat
  -- put the hilite of button "usnum" of stack prefsStack into gUSNumFormat
  put true into gUSDateFormat
  put true into gUSNumFormat
  if the hilite of button "miles" of stack prefsStack then
    put "Miles" into gDistanceFormat
  else
    put "km" into gDistanceFormat
  end if
  
  if (item 4 of screenRect() > 500) then
    set the disabled of button "Tall Windows" of stack prefsStack to false
  else
    set the disabled of button "Tall Windows" of stack prefsStack to true
    set the hilite of button "Tall windows" of stack prefsStack to false
  end if
  if the hilite of button "Tall windows" of stack prefsStack then
    put true into gTallWindows
  else
    put false into gTallWindows
  end if
  put the hilite of button "New window" of stack prefsStack into gNewWindow
  set twelveHourTime to the hilite of button "AM/PM" of stack prefsStack
  set the textArrows to true
  set the navigationArrows to false
  put "arial" into gDefaultFont
  checkRegistration
end initGlobals

on checkRegistration
  global gRegistered
  
  put field "name" of stack "register" into username
  put the regNumber of stack "register" into registrationNum
  if checkRegNumber(username,registrationNum,0) then --****
    -- if field "firstdate" of stack "Register" is "registered" then
    lock screen
    put true into gRegistered
    put field "last card" into prevCard
    put last word of prevCard into zstack
    setLoc zstack
    go stack zstack
    try
      go prevCard
    catch errorNum
      answer "catch errorNum = " & errorNum --**
      if errorNum is not empty then
        go last card of stack zstack
      end if
    end try
    if there is a button "first" then
      setArrows
      saveData
    end if
    if zstack is not "launcher" then close stack "launcher"
    unlock screen with visual plain
    exit checkRegistration
  end if
  
  lock screen
  if field "firstdate" of stack "Register" is empty then
    put the date into field "firstdate" of stack "Register"
    put "tutorial" into gRegistered
    setLoc "Register"
    topLevel "Register"
    show field "readme" of stack "register"
    set the name of button 2 of stack "register" to "Close License Agreement"
    save stack "register"
    unlock screen with visual plain --****
    answer information "Welcome to Activity & Expense Tracker v3." & return & \
        "  Please read the License Agreement. " & return & \
        "    You may use this software for " & return & \
        "      10 days before registering it. "
    unlock screen with visual plain
    exit checkRegistration
  else
    put the date into endDate
    put  field "firstdate"  of stack "Register" into startDate
    convert endDate to seconds
    convert startDate to seconds
    
    if field "temp" of stack "register" is empty then
      add 60*60*24*10 to startDate
    else
      add 60*60*24*7 to startDate
    end if
    put round((startdate - enddate)/(60*60*24)) into daysleft
    if daysleft < 1 then
      put false into gRegistered
      put "See above for information on" into field "name" of stack "register"
      put "how to register your software." into field "registration" of stack "register"
      topLevel "Register"
      answer warning "Your trial period has expired. Please register your software."
    else
      put daysleft into gRegistered
      answer information "Your trial period for this software will expire in " & daysleft & " days."
    end if
  end if
  unlock screen with visual plain
end checkRegistration

function getFirstField
  global gStack
  put "taskTracker,scheduler,inventory,invoiceTracker,passwords,vehicleExp,versions,writer" into testList
  if testList contains gStack then
    return "date"
  else
    switch gStack
    case "records"
      return "start date"
      break
    case  "contacts"
      return "fname"
      break
    default
      return empty
    end switch
  end if
end getFirstField

on commandKeyDown which
  switch which
  case "q"
    quitSBTracker
    break
  case "n"
    if there is a button "new" then send mouseUp to button "new"
  case "s"
    save this stack
    break
  case "w"
    close this stack
    break
  default
    pass commandKeyDown
  end switch
end commandKeyDown

on edithome
  edit the script of stack "Launcher"
end edithome
  w          	Lavender    white        
       ^ Activity & Expense Tracker     
 U 
Helvetica   U 
Helvetica   U 
helvetica   W 
Helvetica  PW 
Helvetica   W Arial   U 
Helvetica  U 
Helvetica   U arial  
 U arial   U arial  &records,aetv3.mc
launcher,aetmain.mc
       	P on changeStack
  show group "changeStack"
end changeStack

on closeCard
  set the locktext of field "help" to true
  set the traversalOn of field "help" to false
end closeCard
                                             ,  3   
Set Password Ex  ,on mouseUp
  if field "password" is not empty then
    ask password clear "Enter the old password."
    if it is empty then exit mouseUp
    if it is not field "password" then
      answer "Incorrect password. Try again."
      exit mouseUp
    end if
  end if
  ask password clear "Enter a new password."
  if it is empty then
    if field "password" is not empty then
      answer "Do you want to remove the password?" with "Yes" or "No"
      if it is "Yes" then
        put  empty into field "password"
      end if
    end if
    exit mouseUp
  end if
  put it into temp
  ask password clear "Enter the new password again for verification."
  if it is empty then exit mouseUp
  if it is temp then
    put it into field "password"
  else
    answer "Password did not match. Try again."
  end if
end mouseUp
    
LightSkyBlue    e l             	        	Register Ex   yon mouseUp
  lock screen
  open stack "register" in  window of this stack
  unlock screen with visual plain
end mouseUp
    
LightSkyBlue     O             	     
   help  	x   on mouseUp
  if the optionKey is down then
    set the locktext of me to false
    set the traversalOn of me to true
    exit mouseUp
  end if
end mouseUp
        \(             *Welcome to Activity & Expense Tracker v3. 
 @        Black    )  
        1This new version of Activity & Expense Tracker is also available as part of Activity & Expense Tracker Plus which also contains an Invoice Tracker, a Password Tracker and the Universal Calculator which is a simple number calculator that will also handle date, time, currency and measurement conversions.  
      0  
        
Also available from SpiritWorks Software Development is Small Business Tracker Deluxe. This new productivity software allows self-employed professionals, or small businesses, to keep track of their time, expense, contacts, schedules, invoices and even inventory. Small Business Tracker Deluxe includes Activity & Expense Tracker, Invoice Tracker, Password Tracker, Contact Tracker, Schedule Tracker, Task Tracker, Vehicle Expense Tracker, Version Tracker, Writer's Helper, Inventory Tracker and the Universal Calculator.  
      	  
         fFor more information about either of these products go to http://productivity-software.com/sbtracker/ 
       e  
         (Buttons along the bottom of this window 
  @        '  
  @          You can set a security password by clicking the Set Password button. Then each time you launch Activity & Expense Tracker, you will be asked for your password. You may change or clear the password by clicking this same button. 
       0
     0 
     <   
        tThe Prefs button brings up the Preferences window, where you can change Background colors and Button colors as well as the Highlight color. You can also specify the look and feel of the programs buttons and fields. The Look and Feel defaults to Windows 95, but if you like one of the other choices better, you can choose it here. Each tool has its own Preferences window. 
       
      
     	 
  @       
     1 
      
      x
  @     `   
        To register Activity & Expense Tracker v3, click the Register button. Read the instructions for getting a registration number. When you receive your number, fill in your full name and the registration number. You will then be able to continue using the software. 
       5
     5 
     =   
         3The Quit button quits Activity & Expense Tracker.  
       
      
      *   iThe newest version of this software is available at http://productivity-software/aetracker/download.html 
 @      Blue    h  
 @      Blue      ~Your comments, suggestions and bug reports are always welcome. Please send your email to: comments@productivity-software.com. 
       Z
 @      Red  Z "
     |   
         #Thank you for using this software, 
       "  
         Garth Catterall-Heart 
        !SpiritWorks Software Development 
         PO Box 216 
       
 Redwood Valley, CA 95470 
         
                   	`      x ] &
   	password  !`        X                 
   last stack  !`        H                 	`      O   
   top_bg 6
h       @    3           
SWSD Home    logo  	@                                                                                                                             }}      }}  zz      {{  ~~zz  ~~zz  zztt  yytt  {{xx  ||zz  wwqq  xxtt  xxuu  ttnn  wwtt  ttpp  rrll  vvss  ssqq  nnii  kkdd  llhh  ffff  llhh  jjdd  ggbb  ffff  ee__  dd``  bb[[  aa[[  aa\\  ZZRR  YYSS  XXRR  ZZTT  QQII  RRJJ  RRKK  OOHH  MMDD  MMGG  JJCC  KKEE  IIAA  BB::  AA88  BB::  @@66  ::22  9922  88//  22))  11((  //%%  ..$$  ))  **!!  ((  ""                 % 	E - AETlogo.gif   
   version 7   
 *on mouseUp
  topLevel "main"
end mouseUp
       L + ?            v3.0 
   
copyright     
       ([          E 2000-2001, Garth Catterall-Heart, SpiritWorks Software Development    PrintField Epconstant po = 36
local pagenumber #holds pagenumber between handlers
on PrintField HeaderText,BodyText,FooterText,SourceFieldID
  global gPrintStack
  local TActualPageWidth #width of page subtracting right and left print margins
  local TPrintMargins #margins stored in array for script simplification
  local TPageWidth,TPageHeight #height and width of the page
  local TScrolling,TPageLine,TScrollList #scroll values for text height calculations
  lock messages
  set cursor to busy
  --General Initialization
  open printing
  put 50 into TPrintMargins["left"] --** changed these settings
  put 50 into TPrintMargins["top"]
  put 50 into TPrintMargins["right"]
  put 50 into TPrintMargins["bottom"]
  # put item 1 of the printmargins into TPrintMargins["left"]
  # put item 2 of the printmargins into TPrintMargins["top"]
  # put item 3 of the printmargins into TPrintMargins["right"]
  # put item 4 of the printmargins into TPrintMargins["bottom"]
  put item 1 of the printpapersize into TPageWidth
  put item 2 of the printpapersize into TPageHeight
  put 0 into TScrolling
  put 0 into TPageLine
  put 1 into pagenumber
  put TPageWidth -TPrintMargins["right"]-TPrintMargins["left"] into TActualPageWidth
  # prepare template for invisible stacks the width of the page.
  set cursor to busy
  set the backgroundcolor of the templatestack to "white"
  set the visible of the templatestack to false --** comment out for testing
  set the width of  the templatestack to TActualPageWidth
  set formatforprinting of the templatestack to true
  set the destroyStack of the templatestack to true
  # prepare template for fields in these stacks
  set the width of the templatefield to TActualPageWidth
  # the following three properties are set so that text height calculations are correct.
  set cursor to busy
  set the borderwidth of the templatefield to 0
  set the margins of the templatefield to 6
  set the showborder of the templatefield to true
  set the dontwrap of the templatefield to true --** added
  set the opaque of the templatefield to false
  set the fixedlineheight of the templatefield to false
  if SourceFieldID is "report" then
    set the tabstops of the templatefield to the  tabstops of field "report" of stack gPrintStack --** added
  else
    set the textalign of the templatefield to the  textalign of field "tape" of stack "calculator" --** added
  end if
  set the lockloc of the templatefield to true
  # Header and Footer initialization
  set cursor to busy
  if headertext is not empty then
    create stack "PFHEADER"
    set cursor to busy
    set the topleft of stack "PFHEADER" to 0,0 --** added
    set the defaultstack to "PFHEADER"
    PFSetFont SourceFieldID
    get PFCreateHeaderandFooter(headertext)
    # if size of header or footer is greater then current margins will allow, then
    # increase top or bottom margins.
    if it > TPrintMargins["top"] then put it into TPrintMargins["top"]
  end if
  if footertext is not empty then
    create stack "PFFOOTER"
    set cursor to busy
    set the topleft of stack "PFFOOTER" to 0,0 --** added
    set the defaultstack to "PFFOOTER"
    PFSetFont SourceFieldID
    get PFCreateHeaderandFooter(footertext)
    if it>TPrintMargins["bottom"] then put it into TPrintMargins["bottom"]
  end if
  
  --Body initialization
  set cursor to busy
  set height of the templatestack to TPageHeight - TPrintMargins["bottom"] - TPrintMargins["top"]
  create stack "PFBODY"
  set cursor to busy
  set the topleft of stack "PFBODY" to 0,0 --** added
  set the defaultstack to "PFBODY"
  PFSetFont SourceFieldID
  create field
  set the rect of field 1 to rect of this card
  PFSetText bodytext
  put the pageheights of field 1 into TScrollList
  
  --Printing Cycle
  # headers and footers are split up into three fields by tab items
  set the itemdelimiter to tab
  repeat forever
    set cursor to busy
    If headertext is not empty then
      set the defaultstack to "PFHEADER"
      PFSetText headertext
      put item 3 of field 1 into field 3
      put item 2 of field 1 into field 2
      put item 1 of field 1 into field 1
      print this card into TPrintMargins["left"],po,TPageWidth-TPrintMargins["right"],po+the height of stack "PFHEADER"
    end if
    If footertext is not empty then
      set the defaultstack to "PFFOOTER"
      PFSetText footertext
      put "page" && pagenumber && "of" && (the number of lines of TScrollList) into field 3
      put the long date into field 2
      --   put item 3 of field 1 into field 3
      --   put item 2 of field 1 into field 2
      put item 1 of field 1 into field 1
      print this card into TPrintMargins["left"],TPageHeight-po-height of stack "PFFOOTER",TPageWidth-TPrintMargins["right"],TpageHeight-po
    end if
    add 1 to TPageLine
    add 1 to pagenumber
    set the defaultstack to "PFBODY"
    --  answer  "tpageline =" &&  tpageline & return & "TScrollList =" && TScrollList --**
    --  answer line tpageline of TScrollList --**
    if TScrollList is not empty then --** added
      set the height of fld 1 to line tpageline of TScrollList
      set the scroll of fld 1 to TScrolling
      add line TPageLine of TScrollList to TScrolling
    end if
    set cursor to busy
    print this card into TPrintMargins["left"],TPrintMargins["top"],TPageWidth-TPrintMargins["right"],TPageHeight - TPrintMargins["bottom"]
    if TScrollList is empty or TPageLine is the number of lines of TScrollList then exit repeat --** changed
    print break
  end repeat
  -----------------------------------------------Clean up
  close printing
  if headertext is not empty then delete stack "PFHEADER"
  if footertext is not empty then delete stack "PFFOOTER"
  delete stack "PFBODY"
  reset the templatestack
  reset the templatefield
end PrintField

on PFSetText thetext
  local ExpressionStart, ExpressionEnd
  if "<p>" is in thetext or matchChunk(thetext, "<(.+>.+</.+)>") is true then
    set the htmltext of field 1 to thetext
  else
    put thetext into field 1
  end if
  set cursor to busy
  -- no idea about these next lines
  repeat until matchChunk(field 1, "<%(.[^<]*)%>", ExpressionStart, ExpressionEnd) is false
    put value(char ExpressionStart to ExpressionEnd of field 1) into char ExpressionStart-2 to ExpressionEnd+2 of field 1
  end repeat
end PFSetText

# Need to set the font after the stack is created to prevent inheritance of
# non-formatForPrinting fonts from Home stack
on PFSetFont SourceFieldID
  global gPrintStack
  --  if SourceFieldID is not empty \
      --     and (the effective textFont of SourceFieldID is not "Helvetica" or the effective textSize of SourceFieldID is not 14) then
  if SourceFieldID is "report" then
    set the textFont of this stack to the textFont of field "report" of stack gPrintStack
    set the textSize of this stack to the  textSize of field "report" of stack gPrintStack
  else
    set the textFont of this stack to the textFont of  field "tape" of stack "calculator"
    set the textSize of this stack to the textSize of field "tape" of stack "calculator"
  end if
  set cursor to busy
  --    set the textFont of this stack to the effective textFont of SourceFieldID
  --    set the textSize of this stack to the effective textSize of SourceFieldID
  --   set the textStyle of this stack to the effective textStyle of SourceFieldID
  --  else set the textSize of this stack to 12
end PFSetFont

function PFCreateHeaderandFooter thetext
  create field
  PFSetText thetext
  set the height of this stack to the formattedheight of field 1
  create field
  create field
  get rect of this card
  set the rect of field 1 to it
  set the rect of field 2 to it
  set the rect of field 3 to it
  set the textalign of field 1 to left
  set the textalign of field 2 to "center"
  set the textalign of field 3 to right
  return height of this stack+po
end PFCreateHeaderandFooter
    
LightSkyBlue   (h \ 0             	     
   menuchoices  !h 	 
        x                 
   menustacks  !h 	 
        x            
   
last card  !`       hH          card id 1002 of stack launcher    	SaveHelp EpWon exportHelp
  global gStackName, gHowMany
  
  answer question "Save all topics or just this one?" with "Just this one" or "All"
  if it is "Just this one" then
    put the short name of this card into temp
    put "one" into gHowMany
  else
    put "all" into gHowMany
  end if
  
  answer question "Save as text or html?" with "Text" or "HTML" or "Cancel"
  if it is "Cancel" then exit exportHelp
  if it is "Text" then put ".txt" into fType
  else put ".html" into fType
  
  if gHowMany is "one" then
    ask file "Save this help topic as..." with temp &"_help" & fType
  else
    ask file "Save all help topics as..." with "HelpText" & fType
  end if
  if the result is "Cancel" then exit exportHelp
  put it into fileName
  open file fileName for write
  if the result <> empty then
    answer "There was a problem saving this file." & return & the result & return & sysError()
    exit exportHelp
  end if
  
  if fType is ".html" then
    put "<html>" & return & "<head> " & return & "<title>" & gStackName & "</title>" & return & "</head>" & return & "<body  bgcolor="& quote&"#ffffff"& quote&">" & return into startHtml
    write startHtml to file fileName
  end if
  
  if gHowMany is "All" then
    repeat with i = 1 to the number of cards - 2
      exportText i,fType,fileName
      if fType is ".txt" then
        write "=====================================================" & return & return to file fileName
      end if
    end repeat
  else
    put the number of this card into n
    -- put the htmltext of  field "main" into gHelpText --**
    -- write gHelpText & "<p>&nbsp;<p>"  & return to file fileName --**
    exportText n,fType,fileName
  end if
  
  if fType is ".html" then
    put return & "</body>" & return & "</html> " & return into endHtml
    write endHtml to file fileName
  end if
  
  close file fileName
end exportHelp

on exportText n,fType,fileName
  global gHelpText
  if the short name of card n is "Help Index" then
    put  "Index" into theField
  else
    put  "Main" into theField
  end if
  
  if fType is ".txt" then
    put field theField of card n into gHelpText
    repeat while last char of gHelpText is return
      delete last char of gHelpText
    end repeat
    write gHelpText & return & return to file fileName
  else
    put the htmltext of  field theField of card n into gHelpText
    exportHTML
    write gHelpText & "<p>&nbsp;<p>"  & return to file fileName
  end if
end exportText

on exportHTML
  global gHelpText,gHowMany
  
  set cursor to busy
  put "<p>" & return & "<p>" into temp
  repeat while offset(temp,gHelpText) > 0
    delete line lineOffset(temp,gHelpText) of gHelpText
  end repeat
  
  repeat while offset("&amp;",gHelpText) > 0
    put offset("&amp;",gHelpText) into firstchar
    put "&" into char firstchar to (firstChar + 4) of gHelpText
  end repeat
  
  if gHowMany is "all" then
    -- add name tags
    put "<FONT color="& quote & "#FF0000" & quote & "><B>" into astring
    put "<FONT color="& quote & "#FF0000" & quote & ">" into bstring
    put length(astring) into al
    put length("</B></FONT>") into cl
    repeat while offset(astring,gHelpText) > 0
      put offset(astring,gHelpText) into a
      put char a to (a+256) of gHelpText into temp
      put offset("</B></FONT>",temp) into c
      -- put char (a+al) to (c-1) of temp into zname
      put char (al + 1) to (c-1) of temp into zname
      put length(zname) into zl
      put bstring & "<A NAME=" & quote & zname & quote & "></A><B>" & zname & "</B></FONT>" into char a to (a + al + cl + zl) of gHelpText
    end repeat
  end if
  
  -- delete <group> and add <a href> tags
  repeat with x = 1 to 3
    switch x
    case 1
      put "<FONT color="& quote&"#0000FF"&quote&"><GROUP><U><B>" into astring
      put "</B></U></GROUP></FONT>" into zstring
      break
    case 2
      put "<FONT color="& quote&"#0000FF"&quote&"><U><GROUP><B>" into astring
      put "</B></GROUP></U></FONT>" into zstring
    end switch
    
    if gHowMany is "all" then
      put "<FONT color="& quote&"#0000FF"&quote&"><U><B><A HREF=" into bstring
      put "</A></B></U></FONT>" into cstring
    else
      put "<FONT color="& quote&"#0000FF"&quote&"><B>" into bstring
      put "</B></FONT>" into cstring
    end if
    put length(astring) into al
    put length(cstring) into cl
    put length(zstring) into zl
    
    repeat while offset(astring,gHelpText) > 0
      put offset(astring,gHelpText) into a
      put char a to (a+256) of gHelpText into temp
      put offset(zstring,temp) into c
      put char (al + 1) to (c-1) of temp into zname
      put length(zname) into bl
      if gHowMany is "one" then
        switch char (c + zl ) of temp
        case "."
          put bstring  & zname & cstring & "." into char a to (a + al + bl + zl ) of gHelpText
          break
        case "<"
          put bstring  & zname & cstring into char a to (a + al + bl + zl ) of gHelpText
          break
        default
          put bstring  & zname & cstring & space into char a to (a + al + bl + zl ) of gHelpText
        end switch
      else
        if last char of zname is "." then
          delete last char of zname
          put bstring & quote & "#" & zname & quote & ">" & zname & "." & cstring into char a to (a + al + bl + zl ) of gHelpText
        else
          switch char (c + zl ) of temp
          case "."
            put bstring & quote & "#" & zname & quote & ">" & zname & "." & cstring into char a to (a + al + bl + zl ) of gHelpText
            break
          case "<"
            put bstring & quote & "#" & zname & quote & ">" & zname & cstring into char a to (a + al + bl + zl) of gHelpText
            break
          default
            put bstring & quote & "#" & zname & quote & ">" & zname & cstring & space into char a to (a + al + bl + zl) of gHelpText
          end switch
        end if
      end if
    end repeat
  end repeat
  
  put "http://productivity-software/sbtracker/download.html" into temp
  if offset(temp,gHelpText) > 0 then
    put offset(temp,gHelpText) into a
    put length(temp) -1 into z
    put "<A HREF=" & quote & temp & quote & ">" & temp & "</a>" into char a to (a+z) of gHelpText
  end if
  
  put "comments@productivity-software.com" into temp
  if offset(temp,gHelpText) > 0 then
    put offset(temp,gHelpText) into a
    put length(temp) -1 into z
    put "<A HREF=" & quote & "mailto:" & temp & quote & ">" & temp & "</a>" into char a to (a+z) of gHelpText
  end if
end exportHTML
    
LightSkyBlue   (, \ 0             	        Prefs Ex   "on mouseUp
  goPrefs
end mouseUp
    
LightSkyBlue   4 P             	        Quit ex   (on mouseUp
  quitSBTracker
end mouseUp
    
LightSkyBlue    
 Q      Quit         	       , changeStack   a          
     )`                         
    label1 	 
                      !Switch stack from which to which   % from   i          | X  ! 	from SBT @D 
    
LightSkyBlue      t              	   	       " 
from SBTD @D 
    
LightSkyBlue      t              	    # 	from AET @D 
    
LightSkyBlue     t              	     $ from IT @D 
    
LightSkyBlue     t              	     & to   i         | X  ' to SBT @D 
    
LightSkyBlue     t              	     ( to SBTD @D 
    
LightSkyBlue     t              	     ) to AET @D 
    
LightSkyBlue    t              	    * to IT @D 
    
LightSkyBlue    t              	     + Pt 1 Ex 
 
on mouseUp
  global gstackName,gmenuName
  put word 2 of the hilitedbuttonName of group "from" into oldName
  put word 2 of the hilitedbuttonName of group "to" into newName
  if oldName is empty or newName is empty then exit mouseUp
  switch oldName
  case "sbt"
    put "Small Business Tracker" into fromName
    break
  case "sbtd"
    put "Small Business Tracker Deluxe" into fromName
    break
  case "aet"
    put "Activity & Expense Tracker Plus" into fromName
    break
  case "it"
    put "Invoice Tracker Plus" into fromName
    break
  end switch
  
  switch newName
  case "sbt"
    put "Small Business Tracker" into toName
    put "Small Business Tracker" into gmenuName
    put "SBTLogo.gif" into logoName
    put "sbmain.mc" into gstackName
    put "$79" into zprice
    put 2468 into zcode
    break
  case "sbtd"
    put "Small Business Tracker Deluxe" into toName
    put "Small Business Tracker" into gmenuName
    put "SBTDeluxLogo.gif" into logoName
    put "sbdmain.mc" into gstackName
    put "$99" into zprice
    put 1954 into zcode
    break
  case "aet"
    put "Activity & Expense Tracker Plus" into toName
    put "A & E Tracker" into gmenuName
    put "AETPlusLogo.gif" into logoName
    put "aetmain.mc" into gstackName
    put "$49" into zprice
    put 1357 into zcode
    break
  case "it"
    put "Inventory Tracker Plus" into toName
    put "Inventory Tracker Plus" into gmenuName
    put "ITPlusLogo.gif" into logoName
    put "itmain.mc" into gstackName
    put "$49" into zprice
    put 2345 into zcode
    break
  end switch
  set the fileName of image "logo" of stack "launcher" to logoName
  set the fileName of image "logo" of stack "launch prefs" to logoName
  set the fileName of image "logo" of stack "register" to logoName
  set the title of stack "launcher" to toName
  set the label of button "main menu" to gmenuName && "Menu"
  put zcode into field "zcode"
  
  repeat forever
    find string fromName
    if the result is empty then put "xxxxx" into the foundchunk
    else exit repeat
  end repeat
  
  repeat forever
    find string "xxxxx"
    if the result is empty then put toName into the foundchunk
    else exit repeat
  end repeat
  
  go stack "register"
  repeat forever
    find string fromName
    if the result is empty then put "xxxxx" into the foundchunk
    else exit repeat
  end repeat
  
  repeat forever
    find string "xxxxx"
    if the result is empty then put toName into the foundchunk
    else exit repeat
  end repeat
  put offset("$",field "text") into firstChar
  put zprice into char firstChar to firstChar+2 of field "text" of stack "register"
  ask "Copy me" with toName
  edit the script of stack "launcher"
end mouseUp
    
LightSkyBlue    L 4              	       / Pt 2 Ex 
  on mouseUp
  edit the script of field "name" of stack "register"
  edit the script of field "registration" of stack "register"
  version
end mouseUp
    
LightSkyBlue    L 4              	       0 Save Ex 
 Lon mouseUp
  global gmenuName,gstackName
  hide group "changestack"
  put "(" & gmenuName && "Welcome" into last line of field "menuChoices" of stack "launcher"
  put gstackName into last item of field "menuStacks" of stack "launcher"
  save stack "launcher" as gstackName
  answer gstackName && "successfully created"
end mouseUp
    
LightSkyBlue    L 4              	     
  2 zcode  )`       , 4          1357        - close Ex 
  3on mouseUp
  hide group "changestack"
end mouseUp
    
LightSkyBlue   4L 4              	       3 5Click here to start using Activity & Expense Tracker Ex   Ion mouseUp
  goSBTrackerStack  "Activity & Expense Tracker"
end mouseUp
    
LightSkyBlue    - @8             	       a Ask Dialog   ron openCard
end openCard

on preOpenCard
end preOpenCard

on closeCard
end closeCard

on openStack
end openStack
    	Lavender    2 @                     U 
Helvetica       	Pon doresize
  local twidth, iwidth
  put the width of this stack into twidth
  set the width of field 1 to twidth - 64
  set the left of field 1 to 48
  set the width of field 2 to twidth - 64
  set the left of field 2 to 48
  set the top of field 2 to the bottom of field 1
  set the top of button 1 to the height of field 1 div 2 - 8
  put (twidth - 120 ) div 3 into iwidth
  put iwidth into twidth
  set the default of button 2 to false
  repeat with i = 2 to the number of buttons
    set the left of button i to twidth
    set the bottom of button i to the height of this stack - 12
    add the width of button i + iwidth to twidth
  end repeat
  set the default of button 2 to true
end doresize

on star
  local tstring
  put empty into tstring
  repeat with i = 1 to the number of characters in field 3
    put "*" after tstring
  end repeat
  put tstring into field 2
end star

on preOpenStack
  local twidth
  set the itemDelimiter to numToChar(0)
  set the fieldmode of me to word 2 of item 1 of the dialogData
  if item 2 of the dialogData is empty
  then set the title of this stack to space
  else set the title of this stack to item 2 of the dialogData
  put item 3 of the dialogData into field 1
  put max(the formattedWidth of field 1 + 64,\
      the formattedWidth of field 2 + 64, 320) into twidth
  set the width of this stack to twidth
  set the height of field 1 to the formattedHeight of field 1
  set the top of field 1 to 8
  set the height of this stack to (the height of field 1) + 100
  doresize
  if the fieldmode of me is not "plain" then
    put item 4 of the dialogData into field 3
    star
  else put item 4 of the dialogData into field 2
  set the dialogData to numToChar(0)
  set the itemDelimiter to comma
  set the icon of button 1 to item itemOffset(the lookAndFeel,"Motif,Macintosh,Windows 95") of "330,994,998"
end preOpenStack

on keyDown which
  local tpos
  if the name of the target contains "field" and the fieldmode of me is not "plain" then
    put the selectedChunk into tpos
    put which into character (word 2 of tpos) to (word 4 of tpos) of field 3
    star
    select after character (word 2 of tpos) of field 2
  else pass keyDown
end keyDown

on deleteKey
  if the fieldmode of me is not "plain"
  then deleteone
  else pass deleteKey
end deleteKey

on backspaceKey
  if the fieldmode of me is not "plain"
  then deleteone
  else pass backspaceKey
end backspaceKey

on deleteone
  local tpos
  put word 2 of the selectedChunk into tpos
  put empty into character (tpos - 1) of field 3
  star
  select before character (tpos - 1) of field 2
end deleteone

on commandKeyDown which
  if the fieldmode of me is not "plain"
  then
    local tpos
    switch which
    case "D"
      put word 2 of the selectedChunk into tpos
      put empty into character tpos of field 3
      star
      select before character tpos of field 1
      break
    case "H"
      deleteone
      break
    default
      pass commandKeyDown
    end switch
  else pass commandKeyDown
end commandKeyDown

on openField
  select the text of the target
end openField

on resizeStack
  doresize
end resizeStack

on returnInField
  click at the loc of button "OK"
end returnInField

on closeStack
  put empty into field 1
  put empty into field 2
  put empty into field 3
end closeStack
          @    
fieldmode  plain  a    _  \  ]  `
             0                  \ OK Lp on mouseUp
  switch the fieldmode of this card
  case "plain"
    get field 2
    break
  case "clear"
    get field 3
    break
  case "password"
    get mcencrypt(field 3)
    break
  end switch
  set the dialogData to it
  close this stack
end mouseUp
    
LightSkyBlue    B \ 4             	     ] Cancel Dp +on mouseUp
  close this stack
end mouseUp
    
LightSkyBlue     \ <             	   
  _   `       0 (              
  `   
!`       b 8 |             a New Button B@   
LightSkyBlue      $ (          	      Answer Dialog   on resizeStack
end resizeStack

on openStack
end openStack

on preOpenCard
end preOpenCard

on openCard
end openCard

on closeCard
end closeCard
    	Lavender   e   d   macintoshIcons  992,993,994,995motifIcons  328,329,330,331windows95Icons  996,997,998,999                U 
Helvetica       	P(on preOpenStack
  local dtype, foffset, oldwidth, bwidth, twidth, iwidth, theight, curx, nchoices
  set the itemDelimiter to numToChar(0)
  if word 2 of item 1 of the dialogData is "plain" then
    hide button 1
    put 0 into foffset
  else
    show button 1
    switch the lookAndFeel
    case "Motif"
      get the motifIcons of this stack
      break
    case "Macintosh"
      get the macintoshIcons of this stack
      break
    default
      get the windows95Icons of this stack
    end switch
    put word 2 of item 1 of the dialogData into dtype
    set the itemDelimiter to comma
    set the icon of button "icon" to item itemOffset(dtype, "error,information,question,warning") of it
    set the itemDelimiter to numToChar(0)
    put 40 into foffset
  end if
  if item 2 of the dialogData is empty
  then set the title of this stack to space
  else set the title of this stack to item 2 of the dialogData
  put item 3 of dialogData into field 1
  get item 4 of dialogData
  if it is empty then get "OK"
  put the number of lines in it into nchoices
  put 32 into bwidth
  if nchoices > the number of buttons - 1
  then put the number of buttons - 1 into nchoices
  repeat with i = 2 to nchoices + 1
    show button i
    set the name of button i to line nchoices + 2 - i of it
    set the width of button i to the formattedWidth of button i + 24
    add the width of button i + 32 to bwidth
  end repeat
  set the dontWrap of field 1 to true
  put max(the formattedWidth of field 1 + foffset + 16, bwidth) into twidth
  if twidth > 600 then
    put 600 into twidth
    set the dontWrap of field 1 to false
  end if
  put the width of this stack into oldwidth
  set the width of this stack to twidth
  set the width of field 1 to twidth - foffset - 16
  put the formattedHeight of field 1 + 68 into theight
  if theight > 400 then
    set the vScrollbar of field 1 to true
    put 400 into theight
  else set the vScrollbar of field 1 to false
  set the height of this stack to theight
  set the height of field 1 to theight - 68
  set the top of button 1 to the height of field 1 div 2 - 12
  set the topLeft of field 1 to foffset + 8, 8
  put (twidth - bwidth) div (nchoices + 1) + 32 into iwidth
  put iwidth into curx
  if the lookAndFeel is "Macintosh" then
    repeat with i = nchoices + 1 down to 2
      set the left of button i to round(curx)
      add the width of button i + iwidth to curx
      set the bottom of button i to the height of this stack - 16
    end repeat
  else
    repeat with i = 2 to nchoices + 1
      set the left of button i to round(curx)
      add the width of button i + iwidth to curx
      set the bottom of button i to the height of this stack - 16
    end repeat
  end if
  set the default of button 2 to true
  set the dialogData to empty
end preOpenStack

on closeStack
  repeat with i = 3 to the number of buttons
    hide button i
  end repeat
  set the default of button 2 to false
end closeStack

on mouseUp
  if the name of the target contains "button" then
    set the dialogData to the short name of the target
    close this stack
  end if
end mouseUp
             d  z                
     @                      Have you saved and quit first?   z icon BP on mouseUp
end mouseUp
    
LightSkyBlue      , (         	      Do it D`   
LightSkyBlue    ! 6 <            	      Yes D`   
LightSkyBlue    ~ 6 8            	      OK D`   
LightSkyBlue     6 4            	      Task D`   
LightSkyBlue   f 6 ?            	      Cancel D`   
LightSkyBlue    6 L            	      x D`   
LightSkyBlue    i 4 '            	      w D`   
LightSkyBlue      4 )            	      Cursors       	Lavender                    U 
Helvetica       	@                     	@                     	@                     	@                     	@                     	@                     	@                     	@                     	@                     	@                     	@                 	    	@                 
    	@                   c5   	D               0 0       d    Ă Nw     @A@``   0 p 08 8     ^  8    < 8> > O?  ">߀ > ?     `  ǂ  p     j     w    0??         c11   	D               0 0       [  
  5 [       @   A   H 0      J   
 $ p       > | x       [    ?        ?              c12   	D               0 0       Y >    
   ?  0 @   A          .       > | x p    Y >    
       ?              c16  	D               8 8     K  ! A A        ? 0     2   > > ~ ~          B
D? 
P 
   ?B           c17   	D               8 8     I 0   p x< ~    ~ x< p   0     <                A?P 
   ?B         c18   	D               8 8     K 0 ?        A A !      2       ~ ~ > >      B
D? 
P 
   ?B         c19   	D               8 8     K  ? _ O      O _ ?      -   0 x< | ~ | x< 0      B
D? 
P 
   ?B         c20   	D               8 8     K  ! A A        ? 0     2   > > ~ ~          B
D? 
P 
   ?B         c21   	D               8 8     I 0   p x< ~    ~ x< p   0     <                B
D? 
P 
   ?B         c22   	D               8 8     K 0 ?        A A !      2       ~ ~ > >      B
D? 
P 
   ?B         c23   	D               8 8     K  ? _ O      O _ ?      -   0 x< | ~ | x< 0      B
D? 
P 
   ?B         c1   	D               8 8     B         @     	     7 @ ` p x | ~   | l L      J   ` p X p E 0E     E       c8   	D               8 8     J 	 	 	 	 	 	 踂  * 
 ` 0       G       @ gP wԂ ?         C   5  %%%%?     File Selector      	Lavender    4 ,=         Save          U 
Helvetica    File Selector Card   	Pon help
  go to card "File Selector" of stack "Dialog Box Help" as modeless
end help

on refresh
  local filterstring, fnames
  set the cursor to watch
  lock screen
  set the itemDelimiter to "/"
  if the number of items in field "Directory" > 1 and the last char of field "Directory" is not "/"
  then put the last item of field "Directory" into filterstring
  if filterstring is empty then put "*" into filterstring
  put the directory into field "Directory"
  if the last char of field "Directory" is not "/"
  then put "/" after field "Directory"
  put filterstring after field "Directory"
  put the directories into field "Directories"
  if field "Directories" is empty
  then put ".." into field "Directories"
  else sort field "Directories"
  if the visible of field "Files" then
    put the files into fnames
    filter fnames with filterstring
    put fnames into field "Files"
    sort field "Files"
    local dirwidth, filewidth, cwidth
    put max(48, the formattedWidth of field "Directories") into dirwidth
    put max(48, the formattedWidth of field "Files") into filewidth
    put max(the formattedWidth of field "Directory" + 16, dirwidth + filewidth + 24, 250) into cwidth
    set the width of field "Directories" to dirwidth
    set the width of field "Files" to filewidth
    set the left of field "Files" to the right of field "Directories" + 8
    set the left of field "Flabel" to max(the right of field "Dlabel", the left of field "Files" - 8)
  else
    set the width of field "Directories" to 304
    put 320 into cwidth
  end if
  set the width of this stack to cwidth
  local twidth, perspace, toffset
  repeat with i = 1 to the number of buttons
    add the width of button i to twidth
  end repeat
  put (cwidth - twidth) / 5 into perspace
  put perspace into toffset
  repeat with i = 1 to the number of buttons
    set the left of button i to round(toffset)
    add the width of button i + perspace to toffset
  end repeat
  set the width of field "Directory" to cwidth - 16
  set the width of field "Selection" to cwidth - 32
  set the scroll of field "Directories" to 0
  unlock screen
end refresh

on returnKey
  send "mouseUp" to button id 1013
end returnKey

on escapeKey
  send "mouseUp" to button id 1014
end escapeKey

# command, title, prompt, filter, response
on preOpenCard
  set the itemDelimiter to numToChar(0)
  if item 2 of the dialogData is empty then
    if word 1 of item 1 of the dialogData is "answer" then
      if word 2 of item 1 of the dialogData is "folder"
      then set the title of this stack to "Choose Directory"
      else set the title of this stack to "Open"
    else set the title of this stack to "Save"
  else set the title of this stack to item 2 of the dialogData
  put item 3 of the dialogData into field "Prompt"
  put the directory & "/" & item 4 of the dialogData into field "Directory"
  put item 5 of the dialogData into field "Selection"
  if word 2 of item 1 of the dialogData is "folder" then
    hide field "Files"
    hide field "Flabel"
    set the name of button id 1013 to "Choose"
  else
    show field "Files"
    show field "Flabel"
    if word 1 of item 1 of the dialogData is "answer"
    then set the name of button id 1013 to "Open"
    else set the name of button id 1013 to "Save"
  end if
  refresh
end preOpenCard

on closeStack
  put empty into field "Directory"
  put empty into field "Directories"
  put empty into field "Files"
  put empty into field "Selection"
  put empty into field "Prompt"
  set the dialogData to empty
end closeStack

on resizeStack
  local cheight
  put the height of this card into cheight
  repeat with i = 1 to 4
    set the bottom of button i to cheight - 12
  end repeat
  set the bottom of field "Selection" to the top of button 1 - 12
  set the bottom of field "Prompt" to the top of field "Selection" - 2
  set the height of field "Directories" to the top of field "Prompt" - 4 - the top of field "Directories"
  set the height of field "Files" to the top of field "Prompt" - 4 - the top of field "Files"
end resizeStack
           =                        
   Directories )pon mouseUp
  if not the visible of field "Files" then put the selectedText of me into field "Selection"
end mouseUp

on mouseDoubleUp
  local olddir
  put the directory into olddir
  set the directory to olddir & "/" & the clickText
  if the result is not empty then
    answer "Can't set to that directory."
    set the directory to olddir
  else refresh
  if not the visible of field "Files" then put empty into field "Selection"
end mouseDoubleUp
         T                    )`    @   U   
   Files )p on mouseUp
  put the clickText into field "Selection"
end mouseUp

on mouseDoubleUp
  send "mouseUp" to button id 1013
end mouseDoubleUp

on rawKeyUp
  put the selectedText of me into field "Selection"
end rawKeyUp
         T                   )`    @ $ U   
   Dlabel           < \            
Directories: 
   Flabel           < 0            Files: 
   Prompt          @             
   
Directory ipon closeField
  local olddir, newdir
  put the directory into olddir
  put me into newdir
  if newdir contains "/" then
    repeat until the last char of newdir is "/"
      delete last char of newdir
    end repeat
  end if
  set the directory to newdir
  if the result is not empty then
    answer "Can't set to that directory."
    set the directory to olddir
    put olddir into me
  else refresh
end closeField

on openField
  select after last char of me
end openField
         -                Save Dpron mouseUp
  local fname
  put field "Selection" into fname
  if the visible of field "Files" then
    repeat for each char c in fname
      if c is in " :?*<>/\()[]{}|'`" & quote & tab then
        answer "Invalid file name character" && quote & c & quote && "in" & cr & fname
        exit to MetaCard
      end if
    end repeat
  end if
  if the short name of me is "Save" and there is a file fname then
    answer question "File" && fname && "exists.  Overwrite?"  with "Yes" or "No"
    if it is not "Yes" then exit to MetaCard
  end if
  close this stack
  set the dialogData to the directory & "/" & fname
end mouseUp
    
LightSkyBlue    ` <            	      Cancel Dp +on mouseUp
  close this stack
end mouseUp
    
LightSkyBlue    ` :            	      Help Dp on mouseUp
  help
end mouseUp
    
LightSkyBlue    ` ,            	   
               P            
File Filter: 
   
Selection ip Gon returnInField
  send "mouseUp" to button id 1013
end returnInField
        8                Filter D`   
LightSkyBlue    e` 4            	     # 
launch prefs  
on openCard
  global gVeffect,gStack,gTimeErrorReminder,gDollarSign,gBgBtnHl
  global gNewWindow,gTallWindows,gUSDateFormat,gUSNumFormat
  global gBgColor,gBtnColor,gHlColor,gDistanceFormat
  
  lock screen
  if gUSDateFormat then set the hilite of button "us" to true
  else set the hilite of button "other" to true
  if gUSNumFormat then set the hilite of button "usnum" to true
  else set the hilite of button "euronum" to true
  put "bg" into gBgBtnHl
  set the hilite of button "bg" to true
  if gVeffect then
    set the hilite of button "On" to true
  else
    set the hilite of button "Off" to true
  end if
  set  the hilitedButtonName of group "LookNFeel" to the lookAndFeel
  if  the twelveHourTime then
    set the hilitedButtonName of group "timeFormat" to "AM/PM"
  else
    set the hilitedButtonName of group "timeFormat" to "24 Hrs"
  end if
  if gDollarSign is empty then put "$" into gDollarSign
  put gDollarSign into field "symbol"
  if gTimeErrorReminder then
    set the hilite of button "tOn" to true
    set the hilite of button "tOff" to false
  else
    set the hilite of button "tOff" to true
    set the hilite of button "tOn" to false
  end if
  if there is a stack "itmain.mc" then
    set the disabled of group "dFormat" to true
    put "Miles" into gDistanceFormat
  else
    set the disabled of group "dFormat" to false
    if the hilite of button "miles" then
      put "Miles" into gDistanceFormat
    else
      put "km" into gDistanceFormat
    end if
  end if
  -- if gNewWindow is empty then put false into gNewWindow
  -- set the hilite of button "New window" to gNewWindow
  
  if gTallWindows is empty then put true into gTallWindows
  if (item 4 of screenRect() > 500) then
    set the disabled of button "Tall Windows" to false
    if gTallWindows is empty then
      put true into gTallWindows
    end if
  else
    set the disabled of button "Tall Windows" to true
    put false into gTallWindows
  end if
  set the hilite of button "Tall Windows" to gTallWindows
  
  set the hilite of button "Bg" to true
  set the hilite of button "Btn" to false
  -- set the hilite of button "change all" to false
  repeat with i = 1 to the number of lines of field "btncolors"
    if line i of field "btncolors" is gBgColor then
      set the hilitedlines of field "btncolors" to i
      exit repeat
    end if
  end repeat
  
  put field "hColor" into zColor
  repeat with i = 1 to the number of lines of field "hilitecolor"
    if line i of field "hilitecolor" is zcolor then
      set the hilitedlines of field "hilitecolor" to i
      exit repeat
    end if
  end repeat
  unlock screen with visual plain
end openCard

on closeStack
  set the locktext of field "help" to true
  set the traversalOn of  field "help"  to false
  set the label of button "help" to "Help"
  hide field "help"
end closeStack

on setDollarLabels
  global gDollarSign
 if there is a stack "records" then put "Expense" && gDollarSign into field "ExpenseLabel" of stack "records"
  setMilesLabels
end setDollarLabels

on setMilesLabels
  global gDollarSign,gDistanceFormat
  if there is a stack "records" then put gDistanceFormat into field "milesLabel" of stack "records"
  if gDistanceFormat is "km" then
    if there is a stack "records" then
      put gDollarSign & "/" & gDistanceFormat into field "perMileLabel" of stack "records"
    end if
  else
    if there is a stack "records" then
      put gDollarSign & "/mile" into field "perMileLabel" of stack "records"
    end if
  end if
end setMilesLabels
    	Lavender    
       ^ Preferences    	  U 
Helvetica   U Arial   U 
Helvetica  
 U 
Helvetica   U 
Helvetica   W Arial   W 
Helvetica  PW 
Helvetica  U 
Helvetica       IP <on clearAll
  global gStack
  answer "Have you saved and quit first?" with "Yes" or "Do it"
  if it is "do it" then quitSBTracker
  lock messages
  put  "launcher" into gStack
  put empty into field "password" of stack gStack
  put empty into field "last stack" of stack gStack
  set the regNumber of stack "register" to empty --***
  clearstack
  put "records" into gStack
  lock screen
  go stack gStack
  clearstack
  unlock screen
  put  "launcher" into gStack
  resetColors
  save stack "launcher"
  answer "All Done!" with "Quit" or "OK"
  if it is "quit" then quit
end clearAll

on clearStack
  global gStack
  
  resetColors
  switch gStack
  case "launcher"
    put "register" into regStack
    put "launch prefs" into PrefsStack
    put empty into field "Find" of stack "atFind"
    set the hilite of button 1 of stack "atFind" to true
    set the hilite of button 2 of stack "atFind" to false
    set the hilite of button 3 of stack "atFind" to false
    put empty into gHelpStack
    set the topleft of stack regStack to 10,15
    set the topleft of stack PrefsStack to 10,15
    set the topleft of stack gStack to 10,15
    put empty into field "password" of stack gStack
    put empty into field "last stack" of stack gStack
    set the lockText of field "help" of stack gStack to true
    
    put empty into field "name" of stack regStack
    put empty into field "registration" of stack regStack
    put empty into field "temp" of stack regStack
    set the lockText of field "text" of stack regStack to true
    set the lockText of field "readme" of stack regStack to true
    put empty into field "firstdate" of stack regStack
    put empty into field "hColor" of stack "launch prefs"
    save stack gStack
    break
    
  case "records"
    put "main" into zmainstack
    put "output" into reportStack
    put "Help" into gHelpStack
    
    set the height of stack "records" to 440
    send mouseUp to button "setShort" of stack "records"
    set the height of stack reportStack to 440
    send mouseUp to button "setShort" of stack reportStack
    
    set the topleft of stack zmainStack to 10,15
    put the substacks of stack zmainStack into temp
    repeat with i = 1 to the number of lines of temp
      resetLoc  line i of temp
      if line i of temp is "records" then next repeat
      close stack line i of temp
    end repeat
    
    repeat with i = 1 to 3
      put empty into field i of stack "reports"
    end repeat
    repeat with i = 6 to 8
      put empty into field i of stack "reports"
    end repeat
    put empty into field "header" of stack "reports"
    put empty into field "footer" of stack "reports"
    repeat with i = 8 to 45
      set the hilite of button i of stack "reports" to false
    end repeat
    set the hilite of button "all activity" of stack "reports" to true
    set the hilite of button "show activity notes" of stack "reports" to true
    set the hilite of button "show daily totals" of stack "reports" to true
    set the hilite of button "date" of stack "reports" to true
    set the hilite of button "all dates" of stack "reports" to true
    set the hilite of button "all projects" of stack "reports" to true
    set the label of button "round times" of stack "reports" to "Round off times to              mins"
    put "15" into field "roundoff" of stack "reports"
    set the hilite of button "mins" of stack "reports" to true
    set the hilite of button "hrs" of stack "reports" to false
    set the disabled of button "project" of group "sort" of stack "reports" to false
    set the disabled of button "expense" of group "sort" of stack "reports" to true
    set the disabled of button "activity" of group "sort" of stack "reports" to false
    put empty into field "report" of stack "output"
    set textfont of field "report" of stack "output" to "Arial"
    set textsize of field "report" of stack "output" to "10"
    put 13 into field "lHeight" of stack "output"
    repeat with i = 1 to 6
      set the hilite of button i of group "sizes" of stack "output" to false
    end repeat
    set the hilite of button "10 pt" stack "output" to true
    hide group "font" of stack "output"
    put "70" into field "lLength" of stack "output"
    
    put empty into field "projects" of stack "projects"
    put "Administration" & return & "Lunch" & return & "Phone call" into field "tasks" of stack "activity"
    put "Itemized" & return & "Long distance call" & return &  "Meal"  into field "expenses" of stack "expenses"
    
    repeat with x = 1 to 6
      put empty into field x of stack "quickcheck"
    end repeat
    
    put ".33" into field "$/mile" of stack "records"
    put "Total Time" into field "elabel" of stack "records"
    hide field "start items" of stack "records"
    hide field "end items" of stack "records"
    show button "Start timer" of stack "records"
    hide button "Stop" of stack "records"
    show group "edate" of stack "records"
    if the label of button "GP" of stack "records" is "Go" then
      set the label of button "GP" of stack "records" to "Pause"
    end if
    hide button "gp" of stack "records"
    
    setLocDeleteCards
    save stack gStack
  end switch
end clearStack

on setLocDeleteCards
  global gStack,gHelpStack
  set the topleft of stack gStack to 10,15
  put the substacks of stack gStack into temp
  repeat with i = 1 to the number of lines of temp
    resetLoc line i of temp
    close stack line i of temp
  end repeat
  
  if gHelpStack is not empty then
    set the traversalOn of field "main" of stack gHelpStack to false
    set the lockText of field "main" of stack gHelpStack to true
  end if
  
  repeat with x = the number of cards of stack gStack down to 2
    delete card x of stack gStack
  end repeat
  send clearCardOne to stack gStack
end setLocDeleteCards

on resetLoc zstack
  put the width of stack zstack into zwidth
  if zwidth <= 400 then
    set the loc of stack zstack to "210,245"
  else
    set the loc of stack zstack to "300,245"
  end if
end resetLoc

on resetColors
  global gStack
  
  switch gStack
  case "launcher"
    put "Lavender" into defaultBgColor
    put "LightSkyBlue" into defaultBtnColor
    break
  case "records"
    put "LightSkyBlue" into defaultBgColor
    put "CornflowerBlue" into defaultBtnColor
    break
  case "contacts"
    put "DeepSkyBlue" into defaultBgColor
    put "Lavender" into defaultBtnColor
    break
  case "scheduler"
    put "Cyan" into defaultBgColor
    put "LightPink" into defaultBtnColor
    break
  case "taskTracker"
    put "Wheat" into defaultBgColor
    put "LightSalmon" into defaultBtnColor
    break
  case "inventory"
    put "Gold" into defaultBgColor
    put "Wheat" into defaultBtnColor
    break
  case "invoiceTracker"
    put "Aquamarine" into defaultBgColor
    put "Salmon" into defaultBtnColor
    break
  case "passwords"
    put "salmon" into defaultBgColor
    put "wheat" into defaultBtnColor
    break
  case "vehicleExp"
    put "Burlywood" into defaultBgColor
    put "Wheat" into defaultBtnColor
    break
  case "calculator"
    put "CornflowerBlue" into defaultBgColor
    put "cyan" into defaultBtnColor
    break
  case "versions"
    put "CornflowerBlue" into defaultBgColor
    put "LightSkyBlue" into defaultBtnColor
    break
  case "writer"
    put "Lavender" into defaultBgColor
    put "Orchid" into defaultBtnColor
  end switch
  
  if gStack is "records" then put "main" into gStack
  put the substacks of stack gStack into temp
  repeat with i = 1 to the number of lines of temp
    repeat with n = 1 to the number of btns of stack (line i of temp) of stack gStack
      set the backgroundcolor of btn n of stack (line i of temp) of stack gStack to defaultBtnColor
    end repeat
  end repeat
  repeat with n = 1 to the number of btns of stack gStack
    set the backgroundcolor of btn n of stack gStack to defaultBtnColor
  end repeat
  
  set the backgroundcolor of stack gStack to defaultBgColor
  put the substacks of stack gStack into temp
  repeat with i = 1 to the number of lines of temp
    set the backgroundcolor of stack line i of temp of stack gStack to defaultBgColor
  end repeat
  if gStack is "main" then put "records" into gStack
end resetColors

on mouseUp
  -- trap
end mouseUp
                 <                                                                           !    < 
Close Window Ex  on mouseUp
  global gStack
  
  set cursor to watch
  save this stack
  close this stack
  put openstacks() into temp
  if temp contains gStack AND line 1 of temp <> gStack \
      AND the platform contains "win" then
    close stack gStack
  end if
  topLevel gStack
end mouseUp
    
LightSkyBlue       
traversal  false            	     
   hColor  !`       |                
   top_bg 6
h       @    3           
SWSD Home 
   version 7  
 *on mouseUp
  topLevel "main"
end mouseUp
       L + ?            v3.0    Logo  	@                                                                                                                             }}      }}  zz      {{  ~~zz  ~~zz  zztt  yytt  {{xx  ||zz  wwqq  xxtt  xxuu  ttnn  wwtt  ttpp  rrll  vvss  ssqq  nnii  kkdd  llhh  ffff  llhh  jjdd  ggbb  ffff  ee__  dd``  bb[[  aa[[  aa\\  ZZRR  YYSS  XXRR  ZZTT  QQII  RRJJ  RRKK  OOHH  MMDD  MMGG  JJCC  KKEE  IIAA  BB::  AA88  BB::  @@66  ::22  9922  88//  22))  11((  //%%  ..$$  ))  **!!  ((  ""                 % 	E - AETlogo.gif         K          ? l a   
   label1 	          A t            Look and Feel    
LooknFeel     on mouseUp
  set the lookAndFeel to the hilitedButtonName of me
  if the lookAndFeel = "Macintosh" then
    set the hilitecolor to "CornflowerBlue"
  else
    set the hilitecolor to "DarkBlue"
  end if
  put the hilitecolor into field "hcolor"
  openCard
end mouseUp
         T t M   Motif `D     
LightSkyBlue   
 o l    
traversal  false             	      Windows 95 `D     
LightSkyBlue   
  l    
traversal  false             	     
Macintosh `D     
LightSkyBlue   
 X l    
traversal  false             	   
   label4 	           t            Time Format       K           l B      timeFormat              t 3   AM/PM `D   hon mouseUp
  set twelveHourTime to true
  answer information "The time is now" && the time
end mouseUp
    
LightSkyBlue     l    
traversal  false             	     24 Hrs `D   ion mouseUp
  set twelveHourTime to false
  answer information "The time is now" && the time
end mouseUp
    
LightSkyBlue     l    
traversal  false             	   
   label8 	         {              Time Error Reminder       K         v   6         K         9 l 8   
   label7 	         < i            Visual Effects       K         v(  j      timeErrorReminder              t     tOn `d   Won mouseUp
  global gTimeErrorReminder
  put true into gTimeErrorReminder
end mouseUp
    
LightSkyBlue    l    
traversal  false     On          	     tOff `d   Xon mouseUp
  global gTimeErrorReminder
  put false into gTimeErrorReminder
end mouseUp
    
LightSkyBlue    <    
traversal  false     Off          	      visualEffects            P l     On `D   Con mouseUp
  global gVeffect
  put true into gVeffect
end mouseUp
    
LightSkyBlue   T 2    
traversal  false             	      Off `D   Don mouseUp
  global gVeffect
  put false into gVeffect
end mouseUp
    
LightSkyBlue   :T 6    
traversal  false             	        C         v        New Window @d   Son mouseUp
  global gNewWindow
  put the hilite of me into gNewWindow
end mouseUp
    
LightSkyBlue   
y     
traversal  false     &Open new tools in a different window?          	         K         x l       
Tall Windows @D  on mouseUp
  global gTallWindows
  put the hilite of me into gTallWindows
  
  put openstacks() into temp
  repeat with i  = 1 to the number of lines of temp
    if there is a button "setlong" of stack (line i of temp) then
      lock screen
      if gTallWindows then
        set the height of stack (line i of temp) to 550
        send mouseUp to button "setlong" of stack (line i of temp)
        get the loc of stack (line i of temp)
        add 55 to item 2 of it
        set the loc of stack (line i of temp) to it
      else
        set the height of stack (line i of temp) to 440
        send mouseUp to button "setshort" of stack (line i of temp)
        get the loc of stack (line i of temp)
        subtract 55 from item 2 of it
        set the loc of stack (line i of temp) to it
      end if
      unlock screen with visual plain
    end if
  end repeat
  topLevel "launch prefs"
end mouseUp
    
LightSkyBlue   
z l    
traversal  false             	        K         v ?    
   
btnColors  )x  
on mouseUp
  global gHLineNum
  put the hilitedlines of me into gHLineNum
  setBgColor
end mouseUp

on arrowKey which
  global gHLineNum,gStack
  if gHLineNum is empty then
    put the hilitedlines of me into gHLineNum
  end if
  put the number of lines of me into numLines
  if which is "up" then
    if gHLineNum > 1 then
      subtract 1 from gHLineNum
    end if
  end if
  if which is "down" then
    if gHLineNum < numLines then
      add 1 to gHLineNum
    end if
  end if
  setBgColor
  pass arrowkey
end arrowKey

on setBgColor
  global gStack
  
  if gStack is "records" then put "main" into gStack
    switchColors(gStack)
  if gStack is "main" then put "records" into gStack
end setBGColor

on switchColors whichStack
  global gHLineNum,gBgColor,gBtnColor,gBgBtnHl
  
  set cursor to watch
  switch gBgBtnHl
  case "bg"
    put line gHLineNum of me into gBgColor
    set the backgroundcolor of stack whichStack to gBgColor
    put the substacks of stack whichStack into temp
    repeat with i = 1 to the number of lines of temp
      set the backgroundcolor of stack (line i of temp) of stack whichStack to gBgColor
    end repeat
    break
  case "btn"
    put line gHLineNum of me into gBtnColor
    repeat with n = 1 to the number of btns of stack whichStack
      set the backgroundcolor of btn n of stack whichStack to gBtnColor
    end repeat
    put the substacks of stack whichStack into temp
    repeat with i = 1 to the number of lines of temp
      repeat with n = 1 to the number of btns of stack (line i of temp) of stack whichStack
        set the backgroundcolor of btn n of stack (line i of temp) of stack whichStack to gBtnColor
      end repeat
    end repeat
    break
  end switch
  set cursor to watch
  save stack whichStack
end switchColors
        F |            Aquamarine  
Burlywood  CornflowerBlue  Cyan  	DarkGray  DeepSkyBlue  ForestGreen  Gold  Gray  Green  HotPink  	Lavender  
LightBlue  LightGreen  
LightPink  LightSalmon  LightSeaGreen  
LightSkyBlue  LightYellow  
LimeGreen  Magenta  
MistyRose  Orange  Orchid  Pink  Plum  Red  
RoyalBlue  Salmon  Sienna  
SteelBlue  
Turquoise  Violet  Wheat  WhiteSmoke  Yellow       	`    @ s G      colors     on setHilitedLine
  global gBgColor,gBtnColor,gBgBtnHl
  
  switch gBgBtnHl
  case "bg"
    put gBgColor into zcolor
    break
  case "btn"
    put gBtnColor into zcolor
    break
  end switch
  
  repeat with i = 1 to the number of lines of field "btncolors"
    if line i of field "btncolors" is zcolor then
      set the hilitedlines of field "btncolors" to i
      exit repeat
    end if
  end repeat
end setHilitedLine
        ~   3   btn `d   Son mouseUp
  global gBgBtnHl
  put "btn" into gBgBtnHl
setHilitedLine
end mouseUp
    
LightSkyBlue     l    
traversal  false     
Button Color          	      bg `d   Ton mouseUp
  global gBgBtnHl
  put "bg" into gBgBtnHl
  setHilitedLine
end mouseUp
    
LightSkyBlue         
traversal  false     Background Color          	  
   
instruction2 	         ~ B  p           Click a button below, then choose a color from the list to the right. You can use the arrow keys to move up and down the list.    dateFormat           

 t 7   us `d   Mon mouseUp
  global gUSdateFormat
  put true into gUSdateFormat
end mouseUp
    
LightSkyBlue   l    
traversal  false     	MM/DD/YY          	     other `d   on mouseUp
  global gUSdateFormat
  -- put false into gUSdateFormat
  answer "Not implemented yet."
  set the hilite of me to false
  set the hilite of button "US" to true
end mouseUp
    
LightSkyBlue  ( l    
traversal  false     	DD/MM/YY          	   
    label4         
  t            Date Format       C           P      
numFormat           
f t 7   usnum `d   Kon mouseUp
  global gUSNumFormat
  put true into gUSNumFormat
end mouseUp
    
LightSkyBlue  j l    
traversal  false     123,456.78          	     euronum `d   on mouseUp
  global gUSNumFormat
  -- put false into gUSNumFormat
  answer "Not implemented yet."
  set the hilite of me to false
  set the hilite of button "USnum" to true
end mouseUp
    
LightSkyBlue   l    
traversal  false     123.456,78          	   
   label4         
Q u            Number Format       C        H  T      schedTimes   a        t  V
   label61 
         x |            List times between 
   AM  7)x  zon mouseUp
  global gAM
  put field "AM" into temp
  ask "At what time would you like your schdules to begin?" with temp
  if it is empty then exit mouseUp
  
  put it into ztime
  if it is a date then
    put ztime into field "AM"
  else
    answer "Please enter a time between 1:00 AM and 12:00 AM."
    exit mouseUp
  end if
  
  put convert2num(ztime) into gAM
end mouseUp
        2 J            7:00 AM 
   PM  7)x  uon mouseUp
  global gPM
  put field "PM" into temp
  ask "At what time would you like your schdules to end?" with temp
  if it is empty then exit mouseUp
  put it into ztime
  if it is a date then
    put ztime into field "PM"
  else
    answer "Please enter a time between 1:00 PM and 12:00 PM."
    exit mouseUp
  end if
  
  put convert2num(ztime) into gPM
end mouseUp
        Q J            8:00 PM    money   i        x4  W
   
Symbol label          |8 |            Monetary Symbol 
   Symbol  x  on mouseUp
  global gDollarSign
  put field "symbol" into zword
  ask "Enter a new monetary symbol." with zWord
  if it is empty then exit mouseUp
  put it into zword
  if length (it) > 3 then
    answer error "Symbol can't be more than 3 characters. Please try again."
    exit mouseUp
  else
    put zword into field "symbol"
    put zword into gDollarSign
  end if
  setDollarLabels
end mouseUp
        Q 4          $    Change Ux   9on mouseUp
  send mouseUp to field "symbol"
end mouseUp
    
LightSkyBlue   q T    
traversal  false            	        
Hilite Color   i               hcrect   K             
   hiliteColor  )x  kon mouseUp
  global gHlColor
  put the hilitedlines of me into gHlColor
  setHlColor
end mouseUp

on arrowKey which
  global gHlColor
  if gHlColor is empty then
    put the hilitedlines of me into gHlColor
  end if
  put the number of lines of me into numLines
  if which is "up" then
    if gHlColor > 1 then
      subtract 1 from gHlColor
    end if
  end if
  if which is "down" then
    if gHlColor < numLines then
      add 1 to gHlColor
    end if
  end if
  setHlColor
  --pass arrowkey
end arrowKey

on setHlColor
  global gHlColor
  put line gHlColor of me into zcolor
  set the hilitecolor to zcolor
  put zColor into field "hColor"
  repeat with i = 1 to the number of lines of field "hilitecolor"
    if line i of field "hilitecolor" is zcolor then
      set the hilitedlines of field "hilitecolor" to i
      exit repeat
    end if
  end repeat
end setHlColor
        |            Aquamarine  
Burlywood  CornflowerBlue  Cyan  	DarkBlue  	DarkGray  DeepSkyBlue  ForestGreen  Gold  Gray  Green  HotPink  	Lavender  
LightBlue  LightGreen  
LightPink  LightSalmon  LightSeaGreen  
LightSkyBlue  LightYellow  
LimeGreen  Magenta  
MistyRose  Orange  Orchid  Pink  Plum  Red  
RoyalBlue  Salmon  Sienna  
SteelBlue  
Turquoise  Violet  Wheat  WhiteSmoke  Yellow       	`    @ s   
   label3 	          x            Highlight Color       K           l F      dFormat              t 3   Miles `D   con mouseUp
  global gDistanceFormat
  put "Miles" into gDistanceFormat
setMilesLabels
end mouseUp
    
LightSkyBlue    l    
traversal  false             	      Kilometers `D   `on mouseUp
  global gDistanceFormat
  put "km" into gDistanceFormat
setMilesLabels
end mouseUp
    
LightSkyBlue    l    
traversal  false             	   
  ! label4 	           t            Distance Format    Default Settings Ux  on mouseUp
  global gDollarSign,gVeffect,gTimeErrorReminder,gNewWindow,gTallWindows
  global gStack,gAM,gPM,gBgBtnHl,gUSNumFormat,gUSDateFormat,gDistanceFormat
  
  lock screen
  repeat with i = 1 to the number of buttons
    set the hilite of button i to false
  end repeat
 -- set the hilite of button "Change all" to false
  put true into gTallWindows
  set the hilite of button "Tall Windows" to true
  put false into gNewWindow
  set the hilite of button "New window" to false
  set the hilite of button "Windows 95" to true
  set the lookAndFeel to "Windows 95"
  set twelveHourTime to true
  set the hilite of button "AM/PM" to true
  set the hilite of button "On" to false
  set the hilite of button "Off" to true
  put false into gVeffect
  set the hilite of button "tOn" to true
  set the hilite of button "tOff" to false
  put true into gTimeErrorReminder
  put "0700" into gAM
  put "2000" into gPM
  put "7:00 AM" into field "AM"
  put "8:00 PM" into field "PM"
  put true into gUSDateFormat
  set the hilite of button "us" to true
  put true into gUSNumFormat
  set the hilite of button "usnum" to true
  put "Miles" into gDistanceFormat
  set the hilite of button "Miles" to true
  put "bg" into gBgBtnHl
  set the hilite of button "bg" to true
  
  if the lookAndFeel = "Macintosh" then
    set the hilitecolor to "CornflowerBlue"
  else
    set the hilitecolor to "DarkBlue"
  end if
  put the hilitecolor into field "hcolor"
  put "$" into field "symbol"
  put "$" into gDollarSign
  setMilesLabels
  setDollarLabels
  
  resetColors
  unlock screen
  openCard
  if the optionKey is down and the environment contains "development"  then
    version
    clearAll
  end if
end mouseUp
    
LightSkyBlue    {    
traversal  false            	        Help ex   on mouseUp
  if the visible of field "help" then
    hide field "help"
    set the label of me to "Help"
  else
    show field "help"
    set the label of me to "Hide Help"
  end if
end mouseUp
    
LightSkyBlue    {    
traversal  false     Help         	     
   help  p on mouseUp
  if the optionKey is down then
    set the locktext of me to false
    set the traversalOn of me to true
    exit mouseUp
  end if
end mouseUp
         ?T         Preferences 
  @          
         NYou can change many things about this program here in the Preferences Window. 
       M  
        The Look and Feel defaults to Windows 95, but if you like one of the other choices better, you can choose it here. In Windows 95 mode, the shortcut for the button is indicated by an underlined letter in the button's name. In Macintosh mode, the keyboard shortcuts are not visible.  
       
      
      e
     v 

      a
      	
      /  
         jThe Time Format defaults to AM/PM, but if you would want times displayed in 24 hour format, click 24 Hrs. 
       
      
      Z  
         \The Distance Format allows you to change appropriate labels to Kilometers instead of Miles. 
       
      
      +
     ? 

     I 
     U 
     Z   
         lIf you click the Visual Effects box, you will see a wipe effect when you switch from one record to another. 
       
      
      L  
        You can change the background color by clicking the  Background color radio button. Then choose a color from the colors list. The background color will automatically change to the new color. You can use the up and down arrow keys to change the colors after selecting the first one. 
       5
     5 
     F   
        You can change the button colors by clicking the Button colors radio button. Then choose a color from the colors list. The button colors will automatically change to the new color. You can use the up and down arrow keys to change the colors after selecting the first one. 
       1
     1 

     >   
         Play around with these selections until you find a color combination that is pleasing to your eyes. Each tool has its own combination of colors, so it is easier to tell the tools apart. 
         
        You can also change the highlight color by clicking the Highlight color radio button. Then choose a color from the colors list. The highlight color will automatically change to the new color. You can use the up and down arrow keys to change the colors after selecting the first one. 
       8
     8 
     G   
         You specify whether you want to be reminded when end times are before start times by clicking On or Off in the Time Error Reminder section. 
       ^
     ^ 
     ` 
     d 
     g 
     o 
      	  
         You can set the Monetary Symbol to something other than the dollar sign ($), if you use a different one, by clicking the Change button. You will be asked for a new symbol. You can use any character or up to 3 letters for the monetary symbol.  
       
      
        
        ^If your screen is larger than 640x480, some windows will open in Tall Windows mode. This allows for slightly larger buttons and fields near the bottom of the screen and adds a mileage reimbursement  feature in A&E Tracker. The report windows will also be taller. If you want all the windows to always be their smallest size then uncheck this button. 
       A
 @        Black  A 

     N  
         WClick the Default Settings button to return all settings back to their default values. 
       

     
 
      <       
    	`    @ { @ R    Message Box     	Lavender                     J  U 
Helvetica   U Clean   U 
Helvetica   W 
Helvetica   U 
Helvetica   U 
Helvetica   U 
Helvetica  W 
Helvetica  W 
Helvetica  U 
Helvetica   U 
Helvetica   W 
Helvetica  U 
Helvetica   U Courier   W Courier   U 
Helvetica   U 
Helvetica   U 
Helvetica   W 
Helvetica  U 
Helvetica  U 
Helvetica  @U 
Helvetica  U 
Helvetica  AW 
Helvetica  W 
Helvetica  W 
Helvetica  PW 
Helvetica  TW 
Helvetica  U 
Helvetica  U 
Helvetica  
 U 
Helvetica  
 U Courier  
 U Courier   U Courier   U 
LucidaBright   U Symbol   U charter   U 
Helvetica   U Lucida   U Lucida   U Clean   U Courier   U fixed   U times   U 
Helvetica   U Font|clean   U Font   U Superscript   U Color|-   U Color   U charter   W Lucida  W Lucida  W clean   W 
Helvetica   U Clean   W Clean   W 
Helvetica   U 
Helvetica   W 
Helvetica  @U 
Helvetica  DU 
Helvetica  HU 
Helvetica   W charter  U charter   U 
Helvetica  U charter   W 
Helvetica   U nil   U charter   U 
Helvetica   U fixed   U fangsong ti  ! U 
Helvetica    Message Box Card   	Plocal initted

on resizeStack
  set the rect of field 1 to the rect of me
end resizeStack

on preOpenCard
  if not initted then
    set the topleft of this stack to the left of the topStack -\
        (the width of this stack - the width of the topStack) div 2, the bottom of the topStack + 32
    send "init" to field 1
    put true into initted
  end if
end preOpenCard

on closeCard
  put empty into field 1
end closeCard

on changed which, old, new
  put new into field 1 of me
end changed
               
   Message Field  )plocal it
local MessageBoxHistory, MessageBoxIndex

on init
  put 1 into MessageBoxIndex
  put empty & return into MessageBoxHistory
  put empty into field 1
end init

on errorDialog
  if the scriptError is not empty then
    modeless "Script Error"
    set scriptError to empty
  else modeless "Execution Error"
end errorDialog

on returnInField
  local debugging, command, cword
  if the title of this stack is empty
  then put false into debugging
  else put true into debugging
  lock error dialogs
  put return after MessageBoxHistory
  put me into command
  if command is empty
  then exit to MetaCard
  put command into the last line of MessageBoxHistory
  if the number of lines in MessageBoxHistory > 20
  then delete line 1 of MessageBoxHistory
  if the traceStack is not empty
  then set defaultStack to the traceStack
  else set defaultStack to the topStack
  put empty into msg
  set scriptError to empty
  put 1 into MessageBoxIndex
  put word 1 of command into cword
  if cword is not in the commandNames then
    if cword is "the" or cword is a number or token 2 of cword is "("
    then put value(command, this card)
    else send command to this card
  else
    if debugging
    then debugdo command & return & "if the result is not empty then put the result"
    else do "global" && the globals & return & command \
        & return & "if the result is not empty then put the result"
  end if
  unlock error dialogs
end returnInField

on prevline
  subtract 1 from MessageBoxIndex
  if MessageBoxIndex is 0
  then put the number of lines in MessageBoxHistory into MessageBoxIndex
  put line MessageBoxIndex of MessageBoxHistory into me
  exit to MetaCard
end prevline

on nextline
  add 1 to MessageBoxIndex
  if MessageBoxIndex > the number of lines in MessageBoxHistory
  then put 1 into MessageBoxIndex
  put line MessageBoxIndex of MessageBoxHistory into me
  exit to MetaCard
end nextline

on commandKeyDown which
  if which is "P"
  then prevline
  if which is "N"
  then nextline
  if which is "U"
  then put empty into msg
  pass commandKeyDown
end commandKeyDown

on arrowKey which
  if which is "up"
  then prevline
  if which is "down"
  then nextline
  pass arrowKey
end arrowKey
     @                     
 Execution Error               	Lavender    ,              U 
Helvetica    e Execution Error Card   	plocal ee

on returnInField
  send "mouseUp" to button "Ignore"
end returnInField

on returnKey
  send "mouseUp" to button "Ignore"
end returnKey

on closeCard
  set executionError to empty
  show button "Script..."
  show button "Set Breakpoint..."
  put empty into field "Error Message"
  put empty into field "Object"
  put empty into field "Bad Token"
end closeCard

on preOpenCard
  put empty into field "Error Message"
  send "geterrs" to me in 1 tick
end preOpenCard

on geterrs
  local ec
  put the executionError into ee
  put the number of lines in ee into ec
  if ec > 100
  then delete line 100 to ec of ee
  repeat with i = the number of lines in ee down to 1
    get item 1 of line i of ee
    put line It of field "Messages" & return before field "Error Message"
    if item 2 of line i of ee is not 0 then
      put item 2 of line i of ee into field "Line"
      put item 3 of line i of ee into field "Column"
      put item 4 of line i of ee into field "Bad Token"
    end if
    if item 4 of line i of ee is not empty
    then put item 4 of line i of ee into field "Bad Token"
  end repeat
  delete last char of field "Error Message"
  if the errorObject is empty\
      or the short name of the errorObject is "Message Field" \
      or the script of the errorObject is empty \
      or "mctools.mc" is not in the frontscripts \
      or word 1 of the mainStacks is not "Home" then
    hide button "Script..."
    hide button "Set Breakpoint..."
    put item 4 of last line of ee into field "Object"
  else
    put the long name of the errorObject into field "Object"
  end if
  set the loc of this stack to the screenLoc
end geterrs

on openCard
  set the hilitedLines of field 1 to 1
end openCard

on openStack
end openStack
on preOpenStack
end preOpenStack
on openBackground
end openBackground
on preOpenBackground
end preOpenBackground

on seterror which
  put item 2 of line which of ee into field "Line"
  put item 3 of line which of ee into field "Column"
  put item 4 of line which of ee into field "Bad Token"
end seterror
                  
               
                     
    	Messages   @       
 
|         e /Handler: Running low on memory, script aborted  !Handler: Recursion limit reached   abs: error in source expression  accept: bad expression  &aclip: playLoudness is not an integer  !acos: error in source expression  acos: domain error  -add: destination has a bad format (numeric?)   add: error in source expression  add: can't set destination  %Operators and: error in left operand  &Operators and: error in right operand  (Operators bitAnd: error in left operand  )Operators bitAnd: error in right operand  $annuity: error in period expression  "annuity: error in rate expression  %answer: error in question expression  %answer: error in response expression  "answer: error in title expression  (arrowKey: error in direction expression  arrowKey: not a direction  !asin: error in source expression  asin: domain error  "ask: error in question expression  ask: error in reply expression  ask: error in title expression  !atan2: error in first expression  "atan2: error in second expression  atan2: domain error  !atan: error in source expression  atan: domain error  $average: error in source expression  )base64Decode: error in source expression  )base64Encode: error in source expression  "baseConvert: bad destination base  (baseConvert: error in source expression  baseConvert: bad source base  'baseConvert: can't convert this number  (baseConvert: destination is not base 10  beep: error in expression  ,binaryDecode: destination is not a variable  )binaryDecode: invalid data for parameter  $binaryDecode: not enough parameters  )binaryDecode: error in source expression  )binaryEncode: invalid data for parameter  $binaryEncode: not enough parameters  )binaryEncode: error in source expression  !Button: bad accelerator modifier  !Button: family is not an integer  %Button: menuButton is not an integer  &Button: menuHistory is not an integer  $Button: menuLines is not an integer  #Button: mnemonic is not an integer  %cancel: message id is not an integer  &charToNum: error in source expression  choose: error in expression  choose: not a tool  &Chunk: error in background expression   Chunk: error in card expression   Chunk: error in character range  *Chunk: container is not a button or field  !Chunk: error in chunk expression  Chunk: error in item range  Chunk: error in line range  "Chunk: error in object expression  %Chunk: error in range end expression  'Chunk: error in range start expression  !Chunk: error in stack expression  Chunk: error in text string  Chunk: can't separate tokens  Chunk: can't separate words  Chunk: can't delete object  Chunk: can't find object  #Chunk: can't get object attributes  0Chunk: can't get value of destination container  Chunk: can't get number  Chunk: can't get source string  Chunk: can't get substring  Chunk: can't find substring  Chunk: can't set attributes  ,Chunk: can't store to destination container  Chunk: can't set as a number  Chunk: can't find background  Chunk: can't find card  Chunk: no such object  Chunk: can't set property  Chunk: can't find stack  Chunk: no target found  +Chunk: can't select object that isn't open  !Chunk: source is not a container  'Chunk: can't find object to store into  'Chunk: can't get source from container  &Chunk: destination is not a container  click: script aborted  )click: expression is not a button number  !click: error in point expression  !click: expression is not a point  click: stack is not open   clone: error in name expression  clone: can't clone this object  clone: stack is locked  "clone: can't find object to clone   close: error in name expression  close: can't find stack  #color: error setting selectedColor  "compact: can't find stack to save  compact: object is not a stack  &compound: error in periods expression  #compound: error in rate expression  %compress: error in source expression  ,compress: error occurred during compression  $Operators &&: error in left operand  %Operators &&: error in right operand  #Operators &: error in left operand  $Operators &: error in right operand  *Operators contains: error in left operand  +Operators contains: error in right operand  #convert: can't read from container  convert: can't set container  !copy: invalid destination object  $copy: can't find destination object  copy: can't copy source object  copy: can't find source object  "copy: stack is password protected   cos: error in source expression  cos: domain error  5create: error in bad parent or background expression  create: error in expression  %create: stack is locked (cantModify)  cut: can't find or copy object  'decompress: error in source expression  *decompress: string is not compressed data  'decompress: error during decompression  &delete: error in file name expression  delete: can't find object  disable: can't find object  ,Stack: stack has not been given a file name  0divide: destination has a bad format (numeric?)  #divide: error in source expression  divide: can't set destination  divide: divide by zero  divide: range error (overflow)  %Operators div: error in left operand  &Operators div: error in right operand  &Operators div: range error (overflow)  Operators div: divide by zero  do: aborted  do: error in source expression  do: error in statement  do: error in expression  0do: unexpected end of line in source expression  do: can't find command  do: not a command  do: license limit exceeded  doMenu: error in expression  "doMenu: don't know this menu item  drag: script aborted  drag: bad "button" number  drag: bad end point expression  drag: end point is not a point  !drag: bad start point expression  !drag: start point is not a point  !drives: error in type expression  edit: can't find object  $encrypt: error in source expression  Operators =: error in operand  "exp10: error in source expression  exp10: domain error  !exp1: error in source expression  exp1: domain error  !exp2: error in source expression  exp2: domain error  5export: error in file (or mask file) name expression  'export: can't open file (or mask file)  +export: can't write to file (or mask file)  -export: no image selected, or image not open  (export: selected object is not an image  $Expression: error in numeric factor  #Expression: error in string factor   exp: error in source expression  exp: domain error  Factor: error in left operand  Factor: error in right operand  Field: bad text attributes  %Field: hilitedLine is not an integer  (Field: scrollbarWidth is not an integer  Field: shift is not an integer  *Field: tabstops is not a positive integer  2files: no permission to list files or directories  filter: bad source string  filter: bad pattern string  filter: can't set destination  find: bad source string  flushEvents: bad event type  focus: not a valid control  fontSizes: bad font name  fontStyles: bad font name  fontStyles: bad font size  0format: bad format string or parameter mismatch  $Function: error in function handler  %Function: error in source expression  !Function: source is not a number  Function: is not a number  get: error in expression  get: can't set destination  %globalLoc: coordinate is not a point  #go: error in background expression  go: error in card expression  go: error in stack expression  go: error in window expression  *go: can't attach menu to this object type  go: can't find destination  grab: can't find object  graphic: not an integer   Operators >=: error in operands  Operators >: error in operands  Group: backSize is not a point  'Group: hilitedButton is not an integer  Group: bad object type  %Operators (): error in right operand  Handler: aborted  Handler: error in statement  'Handler: error in parameter expression  %Handler: not a valid parameter index  !hasMemory: bad amount expression  (hide: error in visual effect expression  hide: can't find object  (hostAddress: error in socket expression  /hostAddressToName: error in address expression  #hostName: error in name expression  ,hostNameToAddress: error in name expression  if-then: aborted  'if-then: error in condition expression  if-then: error in statement  Image: bad pixmap id  !Image: hotspot is not an integer  Image: id is not an integer  .Image: id is already in use by another object  $Image: image must be open to set id  #Image: hotSpot x is not an integer  #Image: hotSpot y is not an integer  import: error in expression  .import: can't open file, mask file or display  .import: can't read file, mask file or display  1import: destination stack is locked (cantModify)  insert: can't find object  insert: license limit exceeded   intersect: two objects required  $Operators is: error in left operand  %Operators is: error in right operand  %Operators is: can't compare operands  6Operators is: left operand of 'within' is not a point  ;Operators is: right operand of 'within' is not a rectangle  %isNumber: error in source expression  "isoToMac: error source expression  #Operators ,: error in left operand  $Operators ,: error in right operand  "keys: parameter is not a variable  kill: no such process  kill: bad number  (launch: error in application expression  #length: error in source expression   Operators <=: error in operands  Operators <: error in operands   ln1: error in source expression  ln1: domain error  ln: error in source expression  ln: domain error  load: error in url expression  "load: error in message expression  $localLoc: coordinate is not a point  "log10: error in source expression  log10: domain error  !log2: error in source expression  log2: domain error  "macToIso: error source expression  mark: bad card expression  mark: error in find expression  +matchChunk: can't set destination variable  %matchChunk: bad or missing parameter  (matchChunk: error in pattern expression  'matchChunk: error in source expression   max: error in source expression  *MCISendString: error in source expression  &MD5digest: error in source expression  #Operators -: error in left operand  $Operators -: error in right operand  $Operators -: range error (overflow)   min: error in source expression  %Operators mod: error in left operand  &Operators mod: error in right operand  &Operators mod: range error (overflow)  Operators mod: divide by zero  "mouse: error in source expression  move: script aborted  move: can't find object  move: bad end point expression  move: end point is not a point  move: bad duration expression  move: duration is not a number  !move: bad start point expression  !move: start point is not a point  2multiply: destination has a bad format (numeric?)  %multiply: error in source expression   multiply: can't set destination  !multiply: range error (overflow)   Operators <>: error in operands  &Operators not: error in right operand  )Operators bitNot: error in right operand  &numToChar: error in source expression  !Object: bad textAlign expression  Object: unknown color  Object: error in colors  'Object: card must be open to set layer  Object: not a textStyle  6Object: stack locked, or object's script is executing  +Object: object does not have this property  !Object: height is not an integer   Object: layer is not an integer  !Object: margin is not an integer  /Object: value is not a boolean (true or false)  
Object Name:  #Object: property is not an integer  "Object: coordinate is not a point  )Object: rectangle does not have 4 points  Object: no Home stack  Object: license limit exceeded  &Object: pixel value is not an integer  !Object: pixmap is not an integer  /Object: can't set script while it is executing   Object: can't set this property  %Object: textheight is not an integer  #Object: textsize is not an integer  )offset: error in start offset expression  !offset: error in part expression  "offset: error in whole expression  "open: error in message expression  open: error in name expression  /open: no permission to open files or processes  $Operators or: error in left operand  %Operators or: error in right operand  'Operators bitOr: error in left operand  (Operators bitOr: error in right operand  #Operators /: error in left operand  $Operators /: error in right operand  $Operators /: range error (overflow)  Operators /: divide by zero  param: error in expression  param: bad parameter index  "param: error in source expression  param: is not a number  $paste: stack is locked (cantModify)  (peerAddress: error in socket expression  =place: group is not in this stack or is already on this card  place: can't find group  place: can't find card  place: source is not a group  !place: destination is not a card  $play: can't get sound or movie name  play: bad movie location  play: bad movie options  *play: can't read sound or movie from file  %play: can't find sound or movie file  #Operators +: error in left operand  $Operators +: error in right operand  $Operators +: range error (overflow)  pop: can't set destination  post: can't get source  post: can't get destination  pow: error in left operand  pow: error in right operand  pow: range error (overflow)  ,print: can't get 'from' or 'to' coordinates  !print: can't get number of cards  print: can't get rectangle  print: error printing  'print: error writing file (disk full?)  print: coordinate not a point  %print: expression is not a rectangle  print: not a card  .print: card or stack must be open to print it  print: no card specified  arcAngle: not an integer  blinkRate: not a number  penColor: bad color  "colormap: bad color name or value  )Object: error counting objects as number  'Object: error counting objects as text  dragSpeed: not a number  effectRate: not a number  extendKey: not a number  Property: bad array expression  gridSize: not an integer  idleRate: not a number  lineSize: not an integer  moveSpeed: not a number  multiSpace: not a number  polySides: not an integer  repeatDelay: not a number  repeatRate: not a number  !doubleClickDelta: not an integer  doubleClickTime: not a number  roundRadius: not an integer  slices: not an integer  startAngle: not an integer  traceDelay: not a number  traceStack: not a stack name  print: bad property value  syncRate: not a number  tooltipDelay: not a number  typeRate: not a number  userLevel: not an integer  beep: not an integer  brush: not an integer  brush: can't find image  #brushPattern: not a valid image id  brushPattern: can't find image  "Object: no object to set property  "Object: can't set object property  cursor: not an integer  cursor: can't find image  5Property: value is not a boolean ("true" or "false")   Property: value is not a number  defaultStack: can't find stack  !defaultMenuBar: can't find group  $Object: does not have this property  #Object: property is not an integer  !penPattern: not a valid image id  penPattern: can't find image  'randomSeed: property is not an integer  socketTimeout: not a number  "umask: property is not an integer  push: object is not a card  push: can't find card  put: error in expression  put: can't set destination   put: can't put into destination  *queryRegistry: error in source expression  #random: error in source expression  read: aborted  read: error in 'at' expression  $read: error in condition expression   read: error in count expression  read: error reading  read: count is not an integer  "read: error in 'until' expression  read: file is not open   read: error in 'for' expression  read: process is not open  remove: can't find object  remove: object is not a group  remove: object is not a card  #rename: error in source expression  (rename: error in destination expression  repeat: aborted  ,repeat: error in 'for' condition expression  repeat: error in statement  .repeat: error in 'until' condition expression  .repeat: error in 'while' condition expression  1repeat: error in 'with' end condition expression  3repeat: error in 'with' start condition expression  2repeat: error in 'with' step condition expression  &repeat: error setting 'with' variable  replace: can't set container  %replace: error in pattern expression  )replace: error in replacement expression  'replace: error in container expression  replaceText: bad parameter  replaceText: bad source string  #reply: error in keyword expression  #reply: error in message expression  %request: error in keyword expression  %request: error in message expression  %request: error in program expression  "request: no permission to request  "getResources: error in expression  ,getResources: no permission to access files  return: error in expression   revert: can't revert Home stack  +round: error in source or digit expression  $save: error in file name expression  save: saving disabled  save: can't find stack to save  save: object is not a stack  $seek: error in file name expression  !seek: error in offset expression  seek: file is not open  select: can't select target  3selectedChunk: error in button or field expression  &selectedButton: bad family expression  -selectedButton: bad parent object expression  )send: error in message handler execution  "send: error in message expression  send: error in 'in' expression  "send: error in program expression  send: bad target expression  send: no permission to send   set: error in source expression  set: can't set property  2setRegistry: no permission to get or set registry  (setRegistry: error in source expression  shell: aborted  shell: can't run shell command  "shell: error in source expression  %shell: no permission to run commands  (show: error in visual effect expression  #show: error in location expression  *show: error in number of cards expression  )show: location is not in proper x,y form  show: can't find object   sin: error in source expression  sin: domain error   sort: can't find object to sort  sort: error sorting  sort: can't find field  !sqrt: error in source expression  sqrt: domain error  Stack: bad decoration  4Stack: invalid id (must be greater than current id)  Stack: invalid key  Stack: bad substack name  ,Stack: can't set mainStack (has substacks?)  "Stack: deskIcon is not an integer  #Stack: userLevel is not an integer  Stack: size is not an integer  #Stack: stack is password protected  Stack: can't find mainStack   Stack: stack is not a mainStack  *Stack: error in external function handler  start: can't find object  start: stack is locked  !start: expression is not a group  start: license limit exceeded  $Handler: error in source expression  Handler: can't find handler  stop: error in expression  stop: target is not a group  2subtract: destination has a bad format (numeric?)  %subtract: error in source expression   subtract: can't set destination  subwindow: error in expression  subwindow: can't find stack   sum: error in source expression  &switch: error in condition expression  !switch: error in case expression  switch: error in statement  !textHeightSum: can't find object   tan: error in source expression  tan: domain error  "there: error in source expression  "throw: error in source expression  #Operators *: error in left operand  $Operators *: error in right operand  $Operators *: range error (overflow)  $toLower: error in source expression  %topStack: error in source expression  $toUpper: error in source expression  "trunc: error in source expression  try: error in statement  type: script aborted  type: bad string expression  ungroup: can't find group  ungroup: target is not a group  &uniDecode: error in source expression  &uniEncode: error in source expression   unload: error in url expression  *unlock: expression is not a visual effect  &urlDecode: error in source expression  &urlEncode: error in source expression  #urlStatus: error in url expression  "value: error in source expression  "value: error executing expression  value: can't find object  Array: bad index expression  Chunk: source is not a number  visual: bad effect expression  wait: aborted  wait: error in expression  !wait: expression is not a number  within: can't find control  within: not a point  write: error in expression  (Operators bitXor: error in left operand  )Operators bitXor: error in right operand      
 Ignore p Ion mouseUp
  set executionError to empty
  close this stack
end mouseUp
    
LightSkyBlue    * | H                     	   e 
    
Perror Field  	                  0 H       
      	          8 @         e Object: 
   
   	          \ ,         e Line: 
    Line  	         0 \ 0         e 9 
      	         ` \ @         e Column: 
    Column  	          \ >         e 7     
Script... p Don mouseUp
  editScript the long id of the errorObject
end mouseUp
    
LightSkyBlue     | O                     	   e 
    Object  	         @ 8 $        e  
      	          \ X         e Bad Token: 
    
Bad Token  	        6 \          e      Help p on mouseUp
  help
end mouseUp
    
LightSkyBlue    | D                     	   e     Set Breakpoint... p 5on mouseUp
  modeless "Script Debugger"
end mouseUp
    
LightSkyBlue   
 |                      	   e 
    Error Message  )pon mouseDoubleUp which
  if which is 3 and there is a file "eetext" then
    set the cursor to watch
    open file "eetext"
    read from file "eetext" until eof
    put it into field "Messages"
    close file "eetext"
    beep 1
  else
    local term
    put item 1 of the clickText into term
    if there is a card term of stack "MetaTalk Reference"
    then go to card term of stack "MetaTalk Reference"
  end if
end mouseDoubleUp

on mouseUp
  seterror word 2 of the clickLine
end mouseUp
          (               
    	`    @  	  &    	Register      	Lavender   
    
regNumber         ^ 	Register    
  U Arial  
 U 
Helvetica   U Arial  
 U Arial   U 
Helvetica   U 
Helvetica   W 
Helvetica  U 
Helvetica   U 
Helvetica   W Arial       IPTon closeCard
  set the locktext of field "text" to true
  set the traversalOn of field "text" to false
  set the locktext of field "readme" to true
  set the traversalOn of field "readme" to false
  
  if the visible of field "readme" then
    set the name of button 2 to "License Agreement"
    hide field "readme"
  end if
end closeCard
                                        
   text  	x   on mouseUp
  if the optionKey is down then
    set the locktext of me to false
    set the traversalOn of me to true
    exit mouseUp
  end if
end mouseUp
         T          This version of Activity & Expense Tracker is shareware. To continue using this software after 10 days, please send a money order (in US dollars) for US$35 along with your full name and either a mailing address or an e-mail address to: 
       9
     9 c
      O   Garth Catterall-Heart  !SpiritWorks Software Development  PO Box 216  Redwood Valley, CA 95470    oFor Site License information, contact the author at the address above or at license@productivity-software.com.    =You may also pay by credit card or other methods by going to 
 @      Red    < http://www.productivity-software.com/aetracker/register.html or by double-clicking the Register.url file included with this program. 
 @      Red      
 @      Red      An alternate way to register this software is available at ShareIt! This option may be better for European users or corporations wishing to use purchase orders. 
 @      Blue      
 @      Blue      Just go to http://www.shareit.com and enter the program ID number 146783 in the search window at the bottom of the screen or by double-clicking the ShareIt.url file. 
 @      Blue      
 @      Blue      rIf you are not yet on-line, you can place your order with our customer service team by phone, fax or postal mail. 
 @      Blue    q  
 @      Blue      APlease provide the following information, and fax or mail it to: 
 @      Blue    @  
 @      Blue      	ShareIt! 
 @      Blue     
element 5 AG 
 @      Blue     Vogelsanger Str. 78 
 @      Blue     50823 Cologne 
 @      Blue    
 Germany 
 @      Blue      
 @      Blue      Phone:     +49-221-31088-20 
 @      Blue     Fax:     +49-221-31088-29 
 @      Blue     E-Mail: service@shareit.com 
 @      Blue      
 @      Blue      NUS and Canadian customers may also order by calling toll-free 1-800-903-4152. 
 @      Blue    M  
 @      Blue      This hotline is only for ordering. If you need technical assistance or technical information about the program, please contact the developer directly at: support@productivity-software.com 
 @      Blue      
 @      Blue      :US check and cash orders can be sent to our US office at: 
 @      Blue    9 ShareIt! Inc. 
 @      Blue    
 
P.O. Box 844 
 @      Blue     Greensburg, PA 15601, USA 
 @      Blue     Phone: (724) 850 - 8186 
 @      Blue     Fax: (724) 850 - 8187 
 @      Blue      
 @      Blue      4*** ALL CHECKS SENT TO THE U.S. OFFICE MUST BE MADE 
 @      Blue    3 !PAYABLE TO:  "ShareIt! Inc." *** 
 @      Blue       
 @      Blue      MRequired ShareIt! Registration Information for Activity & Expense Tracker v3 
 @      Red    L  
 @      Blue      Program-ID : 146783 
 @      Blue      
 @      Blue      ;Last Name, First Name, Company, VAI-ID-No. (if applicable) 
 @      Blue    : 'Address, Postal Code and City, Country 
 @      Blue    & Phone, Fax, E-Mail 
 @      Blue      
 @      Blue      Also include how would you like to receive the registration key (e-mail - fax - postal mail) and how would you like to pay the registration fee (credit card - wire transfer - check - cash) and the following Credit Card Information (if applicable): 
 @      Blue      
 @      Blue      SCredit Cards accepted: Visa - Eurocard/Mastercard - American Express - Diners Club 
 @      Blue    R  
 @      Blue      3Card Holder Name: ________________________________ 
 @      Blue    2  
 @      Blue      .Card No.: ___________________________________ 
 @      Blue    -  
 @      Blue      Expiration Date: ________ 
 @      Blue      
 @      Blue      .Date / Signature: ___________________________ 
 @      Blue    -   After payment is received you will be issued a registration number which will allow you to continue using the software and entitle you to Activity & Expense Tracker updates as they become available.    }The newest version of this software will always be available at http://www.productivity-software.com/aetracker/download.html    rYour comments, suggestions and bug reports are always welcome. Please email to comments@productivity-software.com    #Thank you for using this software.              	`    @ y U   
   instruction 	         v             %Enter your registration number here. 
   name  )x  -on openField
  pass openField
end openField

on closeField
  global gRegistered
  if field "name" is "(temp)" then
    if field "temp" is empty then
      put the date into field "temp"
      put the date into field "firstdate"
      put "Expires soon." into field "registration"
      put 7 into gRegistered
    else
      put empty into field "registration"
      put "1/1/01" into field "firstdate"
      put false into gRegistered
    end if
    save this stack
    exit closeField
  end if
  if the optionKey is "up" then exit closeField
  put field "name" into username
  if username is empty then
    answer "First enter your full name exactly as registered."
    exit closeField
  end if
  put checkRegNumber(username,"comp",0) & "-10250" into field "registration" --****
  set the regNumber of stack "register" to field "registration"
  put true into gRegistered
  -- put "registered" into field "firstdate"
  save this stack
end closeField

on returnInField
  send closeField to me
end returnInField

on enterInField
  send closeField to me
end enterInField
        Z            
   
instruction1 	         X             Enter your full name here. 
   temp  !`        h                
   readme  x   on mouseUp
  if the optionKey is down then
    set the locktext of me to false
    set the traversalOn of me to true
    exit mouseUp
  end if
end mouseUp
         T8         4Thanks for Installing Activity & Expense Tracker v3 
       3   Please read the terms of the License Agreement below. If you do not agree to the terms, close this window and quit the program. 
 @      Red       License Agreement 
         Please read this Software License Agreement ("the License") before using Activity & Expense Tracker and any accompanying files ("the Software"). The Software is a proprietary product of Spiritworks Software Development ("the Author") and is protected by copyright law. By using the Software, you are agreeing to be bound by the terms of this License. If you do not agree to the terms of this License, you must promptly dispose of any copies of the Software in your possession. 
         1. License 
       
9The Software is licensed, not sold, to you by the Author. All copies and distributions of the Software which this License authorizes you to make are also governed by the terms of this License. All rights pertaining to the Software that are not expressly granted to you in this License are retained by the Author.   3In the ten (10) days following the date on which you first installed the Software on one or more of the computers owned by you, and prior to the date on which you purchase the Software ("The Evaluation Period"), the Author grants you a non-exclusive right to use the Software on any computers owned by you.    Following the expiration of the Evaluation Period, you may continue to use the Software provided that you purchase one of the following options:    ma) A single user license for each computer on which you have installed the Software ("Single User License").    b) A license for each computer in your organization ("Site License"). Please contact the author for site licensing information at license@productivity-software.com.   <The purchase of a Single User License gives you the right to continue to use the Software following the expiration of the Evaluation Period on a single computer owned by you. If you would like to use the Software on more than one computer, you must purchase multiple Single User Licenses or purchase a Site License.   }The purchase of a Site License gives you the right to continue to use the Software following the expiration of the Evaluation Period on any computer owned by you or your organization. Members, employees, or agents of your organization who use the Software are also governed by the terms of this License and you agree to inform them of the restrictions and rights contained herein.   Upon purchase of a Single User License, Site License, or at the discretion of the Author, you will be provided with a registration code ("The Registration Code"). After you enter the Registration Code into the Software, as described in the documentation accompanying the Software, the altered version of the Software ("The Registered Software"), will no longer display occasional messages. Prior to your entry of this Registration Code, the Software is considered unregistered ("The Unregistered Software").        
2. Ownership 
       Ownership of the legal rights, titles, and interest in the Software remains solely with the Author. These rights may include copyrights, trademarks, trade secrets, and other rights as applicable. You may not decompile, reverse engineer, disassemble, modify, rent, lease, loan, sublicense, distribute, duplicate, create derivative works based on the Software, or transmit the Software over a network except as expressly permitted under the terms of this License.    73. Duplication & Distribution of Unregistered Software 
       6 Prior to the expiration of the Evaluation Period, and in accordance with the other terms of this License, the Author grants you the non-exclusive right to duplicate and install the Unregistered Software on any computer.   Unless expressly prohibited by the Author, such as may be the case with non-public pre-release versions of the Software, the Unregistered Software may be distributed through the internet, electronic bulletin boards, and other computer networks, or from person to person.   Whenever the Unregistered Software is distributed, all files accompanying the Unregistered Software (the documentation, the Installer, and any other accompanying files) must be distributed along with the Unregistered Software. The accompanying files and the Unregistered Software must be distributed intact and in their original form, without modification and without exception. If the Unregistered Software and all accompanying files are contained in a single Installer program, only that Installer may be distributed.   Distributors of the Unregistered Software may not sell, charge for, or otherwise demand payment for the Unregistered Software for their own profit, or otherwise misrepresent or misconstrue the terms of the License under which the Software may be purchased by the end user.   With the consent of the Author, CD-ROM distributors may charge end users for those costs associated with the distribution of the material upon which the Unregistered Software is recorded, such as the costs associated with materials, postage, packaging, or labor. CD-ROM distributors may not attempt to make a direct profit from such charges. With the consent of the Author, CD-ROM distributors may provide end users with copies of the Unregistered Software free-of-charge for the purpose of promoting or marketing another product by which the distributors hope to make a profit (such as a magazine), as long as the other terms of this License with respect to the distribution of the Unregistered Software are met.    94. Duplication & Distribution of the Registered Software 
       8 The Author grants the purchaser of a Single User License the right to make two (2) copies of the Registered Software for their own personal archival purposes, for as many computers as they have purchased Single User Licenses.   The purchaser of a Single User License may duplicate the Registered Software and install it on a computer different from the computer for which the Single User License was purchased, provided that the Registered Software on the original computer is then promptly deleted.    The purchaser of a Site License may duplicate and install the Registered Software on any machine governed by the terms of the Site License as detailed in section one (1) of this License.    You may not distribute the Registered Software in any other way, including but not limited to any computer-readable material, floppy disk, CD-ROM, computer network, electronic bulletin-board service, or the Internet.   The Registration Code may not be distributed in any way, including but not limited to any computer-readable material, floppy disk, CD-ROM, computer network, electronic bulletin board service, the Internet, oral, written, or signed communication, telephone, telegraph, or fax machine. You may store the Registration Code for your own personal use for the purpose of reinstalling the Software as necessary on the computer or computers governed by the terms of this License.    )5. Warranty and limitations of liability 
       (%THE SOFTWARE IS PROVIDED "AS IS". USE THE SOFTWARE AT YOUR OWN RISK. THE AUTHOR MAKES NO WARRANTIES AS TO PERFORMANCE, MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, OR ANY OTHER WARRANTIES WHETHER EXPRESSED OR IMPLIED. NO ORAL OR WRITTEN COMMUNICATION FROM OR INFORMATION PROVIDED BY THE AUTHOR OR SPIRITWORKS SOFTWARE DEVELOPMENT SHALL CREATE A WARRANTY. UNDER NO CIRCUMSTANCES SHALL THE AUTHOR OR SPIRITWORKS SOFTWARE DEVELOPMENT BE LIABLE FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES RESULTING FROM THE USE, MISUSE, OR INABILITY TO USE THE SOFTWARE, EVEN IF THE AUTHOR HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES. THESE EXCLUSIONS AND LIMITATIONS MAY NOT APPLY IN ALL JURISDICTIONS. YOU MAY HAVE ADDITIONAL RIGHTS AND SOME OF THESE LIMITATIONS MAY NOT APPLY TO YOU.    In no event shall the Author's total liability to you for actual damages, from any cause whatsoever and regardless of the form of the action, whether in contract, product liability, tort (including negligence), or otherwise, exceed US $35.    
6. Export 
       	 You agree to comply with the laws and regulations of the United States of America and other countries regarding the export of computer software as those laws and regulations pertain to the Software governed by this License.    7. Governing law 
        hThis License shall be governed by the laws of the State of California and the United States of America.    8. Severability 
       JIf for any reason a court of competent jurisdiction finds any provision of this License, or portion thereof, to be unenforceable, that provision of the License shall be enforced to the maximum extent permissible so as to effect the intent of the parties, and the remainder of this License shall continue in full force and effect.    9. Amendments 
       
This License constitutes the entire agreement between the parties with respect to the use of the Software and supersedes any prior agreements or understandings. No amendment to this License will be binding unless agreed to and signed by the Author in writing.      Copyrights 
 @      Red    
    Activity & Expense Tracker (TM)  >2001 Garth Catterall-Heart, SpiritWorks Software Development  All Rights Reserved Worldwide    xYour comments and suggestions are always welcome. You may e-mail them to comments@productivity-software.com or mail to:  Garth Catterall-Heart  !SpiritWorks Software Development  PO Box 216  Redwood Valley, CA 95470  %http://www.productivity-software.com         	`    @ y U 6    License Agreement Ex   on mouseUp
  if the visible of field "readme" then
    set the name of me to "License Agreement"
    hide field "readme"
  else
    set the name of me to "Registration Information"
    show field "readme"
  end if
end mouseUp
    
LightSkyBlue    
               	     
   
copyright    
         C[          E 2000-2001, Garth Catterall-Heart, SpiritWorks Software Development 
   version 7  
 *on mouseUp
  topLevel "main"
end mouseUp
       L + ?            v3.0 
    
firstdate  !`          \                   logo  	@       % 	E - AETlogo.gif   
   top_bg 6
h 	      @    3           
SWSD Home 
   
registration  )x  on openField
  put field "name" into temp
  if temp is empty then
    answer information "Please enter your full name exactly as registered first."
    exit openField
  end if
end openField

on closeField
  global gRegistered
  put field "name" into username
  put field "registration" into registrationNum
  if NOT checkRegNumber(username,registrationNum,0) then --****
    answer warning "That registration number is invalid. Please double-check " & return & " both the user name and number. Both are case sensitive."
    if field "temp" is empty then
      put the date into field "temp"
      put the date into field "firstdate"
      put "Expires soon." into field "registration"
      put 7 into gRegistered
    else
      put empty into field "registration"
      put "1/1/01" into field "firstdate"
      put false into gRegistered
    end if
    set the regNumber of stack "register" to empty --***
  else
    -- put "registered" into field "firstdate"
    set the regNumber of stack "register" to field "registration" --***
    put true into gRegistered
  end if
  save stack "register"
end closeField

on returnInField
  send closeField to me
end returnInField

on enterInField
  send closeField to me
end enterInField
        v                    
Close Window Ex   on mouseUp
  global gRegistered
  lock screen
  set the name of button 2 to "License Agreement"
  hide field "readme"
  open stack "launcher" in  window of this stack
  unlock screen with visual plain
end mouseUp
    
LightSkyBlue                 	       	 atFind      	Lavender   
T          Find      U 
Helvetica   U 
Helvetica   W 
Helvetica    
Find Card   	Pon ATFind
  global gFoundOne,gString,gFindStack
  local thilited, tstring
  set the cursor to watch
  put the hilitedButton of group 1 into thilited
  put field "Find" into tstring
  if field "Find" <> gString then put false into gFoundOne
  put tstring into gString
  
  set the caseSensitive to the hilite of button "case sensitive"
  set the defaultStack to gFindStack
  if thilited is 1
  then find tstring
  else if thilited is 2
  then find whole tstring
  
  if the result is empty then
    put true into gFoundOne
    if NOT gFindStack contains "help" then
      send setarrows to stack gFindStack
      saveData
    end if
  end if
  if the result is "not found" and gFoundOne then
    answer information "No more found."
  else
    if the result is "not found" then
      answer information "Not found."
    end if
  end if
end ATFind

on openCard
  global gFoundOne
  put false into gFoundOne
end openCard

on closeCard
  -- trap
end closeCard

on returnInField
  ATFind
end returnInField
           T               	   Type             =     partial words  D       
LightSkyBlue     A h             	     whole words  D       
LightSkyBlue    p A j             	      Search Lx   !on mouseUp
  ATFind
end mouseUp
    
LightSkyBlue     _ t            	      Help Dx  &on mouseUp
  answer information "You can search for the first part of a word," & return \
      & "or search for one or more whole words. " & return &\
      "You may need to move the search window so that " & return &\
  "you can see all the fields in the window being searched."
end mouseUp
    
LightSkyBlue     _ T            	   
   Find  )`         D              case sensitive  D       
LightSkyBlue     A x             	   
   instruction 	         H            4Enter a partial or whole word, or a phrase to find.   	 Close Dx   +on mouseUp
  close this stack
end mouseUp
    
LightSkyBlue     _ T            	     5 dates  Ion openStack
  global gYear,gMonth,gDay
  put the date into temp
  convert temp to dateItems
  -- if gYear is empty then
  put item 1 of temp into gYear
  set the label of button "thisyear" to gYear
  set the label of button "nextyear" to gYear + 1
  set the label of button "thirdyear" to gYear + 2
  set the hilitedbuttonName of group "year" to "thisyear"
  -- end if
  --  if gMonth is empty OR item 2 of temp <> gMonth then
  put item 2 of temp into gMonth
  send mouseUp to field ("m" & gMonth)
  --  end if
  put item 3 of temp into gDay
  --  answer gMonth && item 2 of temp && "Day=" && gDay--**
  if gMonth is item 2 of temp then
    repeat with i = 1 to 42
      if field ("day" & i) is gDay then
        set the textstyle of word 1 of field ("day" & i) to "bold"
        set the textstyle of word 1 of field ("day" & i) to "underline"
        set the textcolor of word 1 of field ("day" & i) to "red"
        exit repeat
      end if
    end repeat
  end if
end openStack

on closeCard
  -- trap
end closeCard

on setDate which
  global gYear,gMonth, gDateField,gStack
  if there is a field which AND field which is empty then exit setDate
  put which into temp
  if char 1 of which is "m" then
    delete char 1 of temp
    -- put the hilitedbuttonName of group "year" into gYear
    put temp into gMonth
    setMonth gMonth,gYear
  end if
  if char 1 of which is "y" then
    delete char 1 of temp
    put temp into gYear
    setMonth gMonth,gYear
  end if
  if char 1 of which is "d" then
    put field which into zday
    put the date into temp
    convert temp to dateItems
    put gYear into item 1 of temp
    put gMonth into item 2 of temp
    put zday into item 3 of temp
    switch gStack
    case "records"
      convert temp to long date
      put temp into field gDateField of stack gStack
      send checkTime to stack "records"
      break
    case "quickcheck"
      convert temp to long date
      put temp into field gDateField of stack gStack
      send checkDate to stack gStack
      break
    case "vreports"
      convert temp to short date
      put temp into field gDateField of stack gStack
      send checkTime to stack "vreports"
      break
    case "reports"
      convert temp to short date
      put temp into field gDateField of stack gStack
      send checkTime to stack "reports"
      break
    case "vehicledb"
      convert temp to short date
      put temp into field gDateField of stack gStack
      break
    case "invReportOpts"
      convert temp to short date
      put temp into field gDateField of stack gStack
      break
    case "scheduler"
      if gDateField is "Until Date" then
        convert temp to abbr date
        put word 1 of temp into zday
        convert temp to short date
        put zday && temp into field gDateField of stack gStack
        close this stack
        send listRepeatDates to stack "scheduler"
      else
        convert temp to long date
        put temp into field gDateField of stack gStack
        if field "repeat" of stack gStack is not "none" then
          close this stack
          send listRepeatDates to stack "scheduler"
        end if
      end if
      break
    case "sLists"
      convert temp to long date
      put temp into field gDateField of stack gStack
      close this stack
      send mouseUp to button "create report" of stack "sLists"
      break
    case "inventory"
      if gDateField is "date" then
        convert temp to long date
        put temp into field gDateField of stack gStack
        close this stack
      else
        convert temp to short date
        close this stack
        send "addDateQtyPrice temp" to button "today2" of stack gStack
      end if
      break
    case "calculator"
      convert temp to long date
      put temp into field gDateField of stack gStack
      close this stack
      if gDateField is "cdate" then
        send calculateDate to field "cdate" of stack gStack
      end if
      break
    default
      convert temp to long date
      put temp into field gDateField of stack gStack
    end switch
    close this stack
  end if
end setDate

on setMonth zmonth,zyear
  
  put daysofmonth (zmonth, zyear) into zdays
  put zyear into item 1 of temp
  put zmonth into item 2 of temp
  put ",1,1,1,1,1" after temp
  convert temp to long date
  -- answer temp
  put word 2 of temp && zyear into field "month"
  -- answer word 1 of temp && zdays
  put word 1 of temp into firstDay
  delete last char of firstday
  switch firstDay
  case "sunday"
    put 1 into startNum
    break
  case "monday"
    put 2 into startNum
    break
  case "tuesday"
    put 3 into startNum
    break
  case "wednesday"
    put 4 into startNum
    break
  case "thursday"
    put 5 into startNum
    break
  case "friday"
    put 6 into startNum
    break
  case "saturday"
    put 7 into startNum
    break
  default
    put 0 into startNum
    break
  end switch
  
  repeat with i = 1 to startNum
    put empty into field ("day" & i)
  end repeat
  
  put the date into temp
  convert temp to dateItems
  put item 1 of temp into tYear
  put item 3 of temp into tDay
  
  repeat with i = 1 to zdays
    put i into field ("day" & startNum)
    if zMonth is item 2 of temp AND i = tDay AND tYear = zYear then
      set the textstyle of word 1 of field ("day" & startNum) to "bold"
      set the textstyle of word 1 of field ("day" & startNum) to "underline"
      set the textcolor of word 1 of field ("day" & startNum) to "red"
    else
      set the textstyle of word 1 of field ("day" & startNum) to "plain"
      set the textcolor of word 1 of field ("day" & startNum) to "black"
    end if
    add 1 to startNum
  end repeat
  
  repeat with i = startNum to 42
    put empty into field ("day" & i)
  end repeat
end setMonth

on mouseDoubleDown
  --trap
end mouseDoubleDown

function daysofmonth zmonth, zyear
  put "1,3,5,7,8,10,12" into longMonth
  repeat with i = 1 to the number of items of longMonth
    if item i of longMonth is zmonth then
      return 31
    end if
  end repeat
  if zmonth = 2 then -- Feb
    if zyear/4 = trunc(zyear/4) then
      return 29
    else
      return 28
    end if
  else -- all other months
    return 30
  end if
end daysofmonth
  w          	Lavender    white        h  e         Choose a Start Date      U 
helvetica  
 U 
helvetica   W 
helvetica   W 
helvetica   U 
helvetica  
 W 
helvetica  
U 
helvetica       	@           e                                                           	  
      
                                         !  "  #  $  %  &  '  (  )  *  0  2  4  5
   month  +h          t           August 2001      
   h1  +x   #on mouseUp
setDate h1
end mouseUp
                    S      
   h2  +x   #on mouseUp
setDate h2
end mouseUp
        +            M 
   h3  +x   #on mouseUp
setDate h3
end mouseUp
        C            T 
   h4  +x   #on mouseUp
setDate h4
end mouseUp
        [            W 
   h5  +x   #on mouseUp
setDate h5
end mouseUp
        s            T 
   h6  +x   #on mouseUp
setDate h6
end mouseUp
                    F 
   h7  +x   #on mouseUp
setDate h7
end mouseUp
                    S 
   day3  +x   %on mouseUp
setDate day3
end mouseUp
        C             
   day4  +x   %on mouseUp
setDate day4
end mouseUp
        [            1 
 @        black    
   day5  +x   %on mouseUp
setDate day5
end mouseUp
        s            2 
 @        black    
   day6  +x   %on mouseUp
setDate day6
end mouseUp
                    3 
 @        black    
   day7  +x   %on mouseUp
setDate day7
end mouseUp
                    4 
 @        black    
   day1  +x   %on mouseUp
setDate day1
end mouseUp
                     
   day2  +x   %on mouseUp
setDate day2
end mouseUp
        +             
   day10  +x   &on mouseUp
setDate day10
end mouseUp
        C            7 
 @        black    
   day11  +x   &on mouseUp
setDate day11
end mouseUp
        [            8 
 @      red    
   day12  +x   &on mouseUp
setDate day12
end mouseUp
        s            9 
 @        black    
   day13  +x   &on mouseUp
setDate day13
end mouseUp
                    10 
 @        black    
    day14  +x   &on mouseUp
setDate day14
end mouseUp
                    11 
 @        black    
   day8  +x   %on mouseUp
setDate day8
end mouseUp
                    5 
 @        black    
   day9  +x   %on mouseUp
setDate day9
end mouseUp
        +            6 
 @        black    
   day17  +x   &on mouseUp
setDate day17
end mouseUp
        C            14 
 @        black    
   day18  +x   &on mouseUp
setDate day18
end mouseUp
        [            15 
 @        black    
   day19  +x   &on mouseUp
setDate day19
end mouseUp
        s            16 
 @        black    
   day20  +x   &on mouseUp
setDate day20
end mouseUp
                    17 
 @        black    
   day21  +x   &on mouseUp
setDate day21
end mouseUp
                    18 
 @        black    
   day15  +x   &on mouseUp
setDate day15
end mouseUp
                    12 
 @        black    
  	 day16  +x   &on mouseUp
setDate day16
end mouseUp
        +            13 
 @        black    
  
 day24  +x   &on mouseUp
setDate day24
end mouseUp
        C            21 
 @        black    
   day25  +x   &on mouseUp
setDate day25
end mouseUp
        [            22 
 @        black    
   day26  +x   &on mouseUp
setDate day26
end mouseUp
        s            23 
 @        black    
  
 day27  +x   &on mouseUp
setDate day27
end mouseUp
                    24 
 @        black    
   day28  +x   &on mouseUp
setDate day28
end mouseUp
                    25 
 @        black    
   day22  +x   &on mouseUp
setDate day22
end mouseUp
                    19 
 @        black    
   day23  +x   &on mouseUp
setDate day23
end mouseUp
        +            20 
 @        black    
   day31  +x   &on mouseUp
setDate day31
end mouseUp
        C           28 
 @        black    
   day32  +x   &on mouseUp
setDate day32
end mouseUp
        [           29 
 @        black    
   day33  +x   &on mouseUp
setDate day33
end mouseUp
        s           30 
 @        black    
   day34  +x   &on mouseUp
setDate day34
end mouseUp
                   31 
 @        black    
   day35  +x   &on mouseUp
setDate day35
end mouseUp
                    
   day29  +x   &on mouseUp
setDate day29
end mouseUp
                   26 
 @        black    
   day30  +x   &on mouseUp
setDate day30
end mouseUp
        +           27 
 @        black    
   day38  +x   &on mouseUp
setDate day38
end mouseUp
        C            
   day39  +x   &on mouseUp
setDate day39
end mouseUp
        [            
   day36  +x   &on mouseUp
setDate day36
end mouseUp
                    
   day37  +x   &on mouseUp
setDate day37
end mouseUp
        +            
   day40  +x   &on mouseUp
setDate day40
end mouseUp
        s            
   day41  +x   &on mouseUp
setDate day41
end mouseUp
                    
   day42  +x   &on mouseUp
setDate day42
end mouseUp
                    
   m1  +x   #on mouseUp
setDate m1
end mouseUp
         @           Jan 
    m3  +x   #on mouseUp
setDate m3
end mouseUp
        K @           Mar 
  ! m4  +x   #on mouseUp
setDate m4
end mouseUp
        g @           Apr 
  " m5  +x   #on mouseUp
setDate m5
end mouseUp
         @           May 
  # m6  +x   #on mouseUp
setDate m6
end mouseUp
         @           June 
  $ m2  +x   #on mouseUp
setDate m2
end mouseUp
        / @           Feb 
  % m8  +x   #on mouseUp
setDate m8
end mouseUp
        / X           Aug 
  & m9  +x   #on mouseUp
setDate m9
end mouseUp
        K X           Sep 
  ' m7  +x   #on mouseUp
setDate m7
end mouseUp
         X           July 
  ( m10  +x   $on mouseUp
setDate m10
end mouseUp
        g X           Oct 
  ) m11  +x   $on mouseUp
setDate m11
end mouseUp
         X           Nov 
  * m12  +x   $on mouseUp
setDate m12
end mouseUp
         X           Dec   0 year   i         #    - 	thisyear @d   Ion mouseUp
put y & the label of me into temp
  setDate temp
end mouseUp
    
LightSkyBlue     ' 4      2001          	  	       . 	nextyear @d   Kon mouseUp
  put y & the label of me into temp
  setDate temp
end mouseUp
    
LightSkyBlue    N ' 4      2002          	   	       / 
thirdyear @d   Kon mouseUp
  put y & the label of me into temp
  setDate temp
end mouseUp
    
LightSkyBlue     ' 4      2003          	   
  2 inst 	         	              !Click on a year, month and date.   4 Cancel Ex   +on mouseUp
  close this stack
end mouseUp
    
LightSkyBlue    cD Y             	       5 Help Ex   on mouseUp
  answer "Click on a month or a year to display the " & return & "calendar for that month. Then click on a date."
end mouseUp
    
LightSkyBlue    D D             	        Moved Icons      	Lavender                             	@              H      	@              I      	@              J      	@              K      	@                    	@                    	@                    	@                    	@                    	@                    	@                    	@                    	@                    	@                    	@              ?  	    	@              @      	@              A  
    	@              B  H i328  	D     ffffff             0 0       S  8 `    %       B  "    
     0     _   8 p p   q 9   p x ?     W        p @ H @ D @ B @ A @ @@ @            c  ?   6 σ? ?  ?       I i329  	D     ffffff             0 0       Q                       a                       U                        u                            J i330  	D    ffffff             0 0       b     0          ` `              b             x            \              p    @ @ @     {     ? > < <     ~                 K i331  	D     ffffff             0 0       `                           k                         ` @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @ @  @ @ @                                       	D        ``    ``    Ș``  Ș  0000``     0 0        
  6
7o$$$$$ | | |  "         _          @ @ @ @ @ @ @ @ @ @ @ @ @ @ @      @                             @        @  @      o   	  	  	  I  I  I  I  I  I! @" 5        @  0     i   @ @ @ @ @ @ @           ?             @        ??          	D   
          Ș  @@@@@@  Ș``          ````      0000``     0 0       23" P" P" PB$" `w PB" `
q	 PB" vw
 PB" `qwh	P"" pwP" qwP" qwhP"
 WUWUWUwhP" whP" whP" WUWUWwhP" whP" whP" WUWUw	hP"BD whP" whP" WUuUuUwhP" wP" wP" `wh	P"D vh P" `f	 P" P" P" P D PU           	D   
          Ș  @@@@@@  Ș``          ````      0000``     0 0       23" P" P" PB$" `w PB" `
q	 PB" vw
 PB" `qwh	P"" pwP" qwP" qwUuwhP" wWuwUwhP" wWuwUwhP" wUwhP" wWuwhP" wUwhP" wWuwhP" wWuw	hP"BD whP" wWuwhP" wWuwhP" wP" wP" `wh	P"D vh P" `f	 P" P" P" P D PU           	D                  Ș``  @@@@@@  PPPPPP     0 0          @ `   0    0   a C Â  
@`  0  0 `@      X  @    H   @    @    @   @       |        0 0 8 ,8 ,< \< \> > ? |? |?????    j                 @ @              : @         @     ?      @ @     
 ?              ? ?     ??        	D  xx            xx||xx       0 0              @     @ @ @         @ @ @        @        |    B?>????>?      e                   8 x   ` ?     P @  > | | ?     ? | | >  @    ~    ??  ?          	D  xx||xx                       0 0                 @ @        @ @     < x    <     8     H      @  @ @  @              }    ??????&??????????       @    C                 p @                  @             `        ??  ?    x 8          	D  xx||xx                       0 0                 @ @        @ @     < x    <     8     [        (    @  $   @                |    *?????       @    p @                  @             `    D   0 < <                 ??  ?    x 8          	D  xx||                  xx||xx     0 0       z         @ @                 @ @     @            ? ?  p p (x x | | ~ ~   ???    K   @           @             @ @                    @  @                  |   0             ` ` 0 0                  ? ?       ???     icon 1   	d                0 0       j       `  `  `              Y                    m                      icon 1   	d                0 0       e           ` `  `          T                   h                    ? i319  	D                0 0       ] R @ A@ A@ B@ B@ DD @H @H @P @P @H @H @D @DB@ B@ A@ A @     X   :             _  J               @ i320  	D                0 0       d   
 
   #   @ @   @ @   #   
 
      R       ? ?   ? ?          b       ? ?       ? ?           A i321  	D                0 0       d ` ` P P H H Ă         ă H H P P ` `    R     0 0 8         8 0 0        b ` ` p p x x           x x p p ` `     B i322  	D                0 0       \ W   A  A  !  !     	  	      	  	     !  !  A  A        X      "          \ W               