{Just a note about my source code.  It ain't pretty, but does the job (usually) I am making it available not
so much for people to remake the binary clock (which you can) but rather to utuilize the smaller examples
within to do things like make tranparent backgrounds, etc.}

unit HBinary1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, Registry, Math;

type
  TForm1 = class(TForm)
    Image1: TImage;
    Timer1: TTimer;
    procedure Timer1Timer(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure DrawRoundRectRegion(wnd : HWND; wrect : TRect);
    procedure Panel1MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure Panel1MouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure Panel1MouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure FormDestroy(Sender: TObject);
    procedure SwitchLights(SL1,SL2 : integer);
    procedure RepaintForm;
    procedure FormActivate(Sender: TObject);
  private
    { Private declarations }
     rgn  : HRGN;              {These are needed for the DrawRectRegion stuff}
     wrect : TRect;
     LbDown : boolean;
  public
    { Public declarations }
  end;

var
  Form1: TForm1;
  IntMe,PadY,IWide,IHigh,CHigh,CWide     : longint;
  Blink,Moveable,OneT1                   : boolean;
  Seconds,Vertical,FTime,LeastTop,HideIt : boolean;
  SmallFont                              : boolean;
  NewStr,OldStr,DiffStr,S1,S2,PicStr     : string;
  OldBStr,BStr,OldPM,TempStr5            : string;
  TempStr1,TempStr2,TempStr3,TempStr4    : string;
  Int1,FH,Pad,K,LedSize                  : integer;
  ImageOn                                : array [0..2,0..5] of Boolean;  {LED Lights array}
  DC                                     : HDc;
  Canv                                   : TCanvas;
  LedOnIn, LedOnOut, LedOffIn, LedOffOut : TColor;
  HighLightOn,HighLightOff,Backgrnd      : TColor;
  PMWide,Back,FirstTime,MaxHeight,MaxWidth : integer;
  DriveStr,DirectoryStr,TopPos           : string;
  Military,OnTop,Top2,Top3,Left2,Left3   : integer;
  OldP, OldQ                             : TPoint;
  FTop,FLeft,TempS1                      : string;

implementation

uses HBinary3, HBinary4, HBinary2;

{$R *.DFM}

function LoadStringFromRegistry(sKey, sItem, sDefVal : string): string;  {Read from the registry}
var
  reg : TRegIniFile;
begin
  reg := TRegIniFile.Create( sKey );
  Result := reg.ReadString('', sItem, sDefVal);
  reg.Free;
end;

procedure SaveStringToRegistry(sKey, sItem, sVal : string );      {Write to the registry}
var
  reg : TRegIniFile;
begin
  reg := TRegIniFile.Create( sKey );
  reg.WriteString('', sItem, sVal + #0);
  reg.Free;
end;

procedure TForm1.DrawRoundRectRegion(wnd : HWND; wrect : TRect);  {Draw the form as a rounded rectangle}
begin
  rgn := CreateRoundRectRgn(wrect.left, wrect.top, wrect.right, wrect.bottom, (LEDSize), (LEDSize));
  SetWindowRgn(wnd, rgn, TRUE);
end;

procedure TForm1.RepaintForm;  {Repaint all the various items in the form (image, leds, etc.)}
var
   NewRect: TRect;
   I,J : integer;
begin
   if (Back=0) then
      begin
         Form1.Image1.Canvas.Brush.Color:=Backgrnd;
         NewRect := Rect(0, 0, Form1.Image1.Width, Form1.Image1.Height);
         Form1.Image1.Canvas.FillRect(NewRect);

         Form2.Image1.Canvas.Brush.Color:=Backgrnd;
         NewRect := Rect(0, 0, Form2.Image1.Width, Form2.Image1.Height);
         Form2.Image1.Canvas.FillRect(NewRect);

         Form3.Image1.Canvas.Brush.Color:=Backgrnd;
         NewRect := Rect(0, 0, Form3.Image1.Width, Form3.Image1.Height);
         Form3.Image1.Canvas.FillRect(NewRect);

      end;
   If ((Back=1)and (PicStr<>'')) then
      begin
         try Form1.Image1.Picture.LoadFromFile(PicStr);
         except
            on EInvalidGraphic do
               begin
                  ShowMessage('Invalid graphic name.');
               end;
            on EFOpenError do
               begin
                  ShowMessage('Could not open the graphic file requested.');
               end;
         end;
         try Form2.Image1.Picture.LoadFromFile(PicStr);
         except
            on EInvalidGraphic do
               begin
                  ShowMessage('Invalid graphic name.');
               end;
            on EFOpenError do
               begin
                  ShowMessage('Could not open the graphic file requested.');
               end;
         end;
         try Form3.Image1.Picture.LoadFromFile(PicStr);
         except
            on EInvalidGraphic do
               begin
                  ShowMessage('Invalid graphic name.');
               end;
            on EFOpenError do
               begin
                  ShowMessage('Could not open the graphic file requested.');
               end;
         end;
      end;

   if (Vertical) then
      begin
         Form1.ClientHeight:=Round((LEDSize*6.2));
         Form1.ClientWidth :=Round((LEDSize*1.2));
         Form2.ClientHeight:=Round((LEDSize*6.2));
         Form2.ClientWidth :=Round((LEDSize*1.2));
         Form3.ClientHeight:=Round((LEDSize*6.2));
         Form3.ClientWidth :=Round((LEDSize*1.2));
         if (Back=1) then
            begin
               Form1.Image1.Width  :=Form1.ClientWidth;
               Form1.Image1.Height :=Form1.ClientHeight;
               Form2.Image1.Width  :=Form2.ClientWidth;
               Form2.Image1.Height :=Form2.ClientHeight;
               Form3.Image1.Width  :=Form3.ClientWidth;
               Form3.Image1.Height :=Form3.ClientHeight;
            end
         else
            begin
              Form1.Image1.Picture.Bitmap.Width  :=Form1.ClientWidth;
              Form1.Image1.Picture.Bitmap.Height :=Form1.ClientHeight;
              Form2.Image1.Picture.Bitmap.Width  :=Form2.ClientWidth;
              Form2.Image1.Picture.Bitmap.Height :=Form2.ClientHeight;
              Form3.Image1.Picture.Bitmap.Width  :=Form3.ClientWidth;
              Form3.Image1.Picture.Bitmap.Height :=Form3.ClientHeight;
            end;
      end
   else
      begin
         Form1.ClientWidth  :=Round((LEDSize*6.2));
         Form1.ClientHeight :=Round((LEDSize*1.2));
         Form2.ClientWidth  :=Round((LEDSize*6.2));
         Form2.ClientHeight :=Round((LEDSize*1.2));
         Form3.ClientWidth  :=Round((LEDSize*6.2));
         Form3.ClientHeight :=Round((LEDSize*1.2));
         if (Back=1) then
            begin
               Form1.Image1.Width  :=Form1.ClientWidth;
               Form1.Image1.Height :=Form1.ClientHeight;
               Form2.Image1.Width  :=Form2.ClientWidth;
               Form2.Image1.Height :=Form2.ClientHeight;
               Form3.Image1.Width  :=Form3.ClientWidth;
               Form3.Image1.Height :=Form3.ClientHeight;
            end
         else
            begin
              Form1.Image1.Picture.Bitmap.Width  :=Form1.ClientWidth;
              Form1.Image1.Picture.Bitmap.Height :=Form1.ClientHeight;
              Form2.Image1.Picture.Bitmap.Width  :=Form2.ClientWidth;
              Form2.Image1.Picture.Bitmap.Height :=Form2.ClientHeight;
              Form3.Image1.Picture.Bitmap.Width  :=Form3.ClientWidth;
              Form3.Image1.Picture.Bitmap.Height :=Form3.ClientHeight;
            end;
      end;


         if (OnTop=0) then
            begin
               SetWindowPos(Form1.Handle,HWND_TOPMOST,0,0,0,0,SWP_NOMOVE or SWP_NOSIZE or SWP_SHOWWINDOW);
               SetWindowPos(Form2.Handle,HWND_TOPMOST,0,0,0,0,SWP_NOMOVE or SWP_NOSIZE or SWP_SHOWWINDOW);
               SetWindowPos(Form3.Handle,HWND_TOPMOST,0,0,0,0,SWP_NOMOVE or SWP_NOSIZE or SWP_SHOWWINDOW);
            end;
         if (OnTop=1) then
            begin
               SetWindowPos(Form1.Handle,HWND_NOTOPMOST,0,0,0,0,SWP_NOMOVE or SWP_NOSIZE or SWP_SHOWWINDOW);
               SetWindowPos(Form2.Handle,HWND_NOTOPMOST,0,0,0,0,SWP_NOMOVE or SWP_NOSIZE or SWP_SHOWWINDOW);
               SetWindowPos(Form3.Handle,HWND_NOTOPMOST,0,0,0,0,SWP_NOMOVE or SWP_NOSIZE or SWP_SHOWWINDOW);
            end;
         if (OnTop=2) then
            begin
               SetWindowPos(Form1.Handle,HWND_NOTOPMOST,0,0,0,0,SWP_NOMOVE or SWP_NOSIZE or SWP_SHOWWINDOW);
               SetWindowPos(Form2.Handle,HWND_NOTOPMOST,0,0,0,0,SWP_NOMOVE or SWP_NOSIZE or SWP_SHOWWINDOW);
               SetWindowPos(Form3.Handle,HWND_NOTOPMOST,0,0,0,0,SWP_NOMOVE or SWP_NOSIZE or SWP_SHOWWINDOW);
               SetWindowPos(Form1.Handle,HWND_BOTTOM,0,0,0,0,SWP_NOMOVE or SWP_NOSIZE or SWP_SHOWWINDOW);
               SetWindowPos(Form2.Handle,HWND_BOTTOM,0,0,0,0,SWP_NOMOVE or SWP_NOSIZE or SWP_SHOWWINDOW);
               SetWindowPos(Form3.Handle,HWND_BOTTOM,0,0,0,0,SWP_NOMOVE or SWP_NOSIZE or SWP_SHOWWINDOW);
            end;

   DrawRoundRectRegion(Form1.Handle, Form1.ClientRect);
   DrawRoundRectRegion(Form2.Handle, Form2.ClientRect);
   DrawRoundRectRegion(Form3.Handle, Form3.ClientRect);

   OldBStr:='0000000000000000000000000';

    if not(LeastTop) then
       begin
          For I := 0 to 2 do
             For J := 0 to 5 do
                begin
                   ImageOn[I,J]:=True;
                   SwitchLights(I,J);
                end;
       end
    else
       begin
          For I := 0 to 2 do
             For J :=  5 downto 0 do
                begin
                   ImageOn[I,J]:=True;
                   SwitchLights(I,J);
                end;
       end;

end;

procedure TForm1.SwitchLights(SL1,SL2 : integer);   {This routine switches the LEDS on or off. It is a     }
                                                    {major pain since I opted not to use matrix multiplying}
                                                    {but did trial and error using the LED size to determine}
                                                    {the location of the leds.}
begin
   If (ImageOn[Sl1,SL2]=false) then    // SL1=0 Hours   SL1=1 Minutes  SL1=2 Seconds
       begin
          case SL1 of
             0  : Pad:=0;
             1  : Pad:=0;
             2  : Pad:=0;
          end;
          ImageOn[SL1,SL2]:=true;
          If (SL1=0) then
             begin
                Form1.Image1.Canvas.Pen.Color:=LedOnOut;
                Form1.Image1.Canvas.Brush.Color:=LedOnOut;
                Form1.Image1.Canvas.Brush.Style:=bsSolid;
                if (Vertical) then Form1.Image1.Canvas.Ellipse(1+Pad,SL2*LEDSize+1,
                                   LEDSize+Pad,(SL2*LEDSize)+LEDSize)
                else Form1.Image1.Canvas.Ellipse(SL2*LEDSize+1,1+Pad,(SL2*LEDSize)+LEDSize,LEDSize+Pad);
                Form1.Image1.Canvas.Pen.Color:=LedOnIn;
                Form1.Image1.Canvas.Brush.Color:=LedOnIn;
                Form1.Image1.Canvas.Brush.Style:=bsSolid;
                if (Vertical) then
                   Form1.Image1.Canvas.Ellipse(((LEDSize div 8)+1)+Pad,SL2*LEDSize+((LEDSize div 8)+1),
                           (LEDSize-(LEDSize div 8))+Pad,(SL2*LEDSize)+(LEDSize-(LEDSize div 8)))
                else
                   Form1.Image1.Canvas.Ellipse(SL2*LEDSize+((LEDSize div 8)+1),((LEDSize div 8)+1)+Pad,
                           (SL2*LEDSize)+(LEDSize-(LEDSize div 8)),(LEDSize-(LEDSize div 8))+Pad);
                Form1.Image1.Canvas.Pen.Color:=HighLightOn;
                Form1.Image1.Canvas.Brush.Color:=HighLightOn;
                Form1.Image1.Canvas.Brush.Style:=bsSolid;
                if (Vertical) then Form1.Image1.Canvas.Ellipse(((LEDSize div 3))+Pad,SL2*LEDSize+((LEDSize div 3)),
                     ((LEDSize div 3))+Pad+(LEDSize div 5),(SL2*LEDSize)+((LEDSize div 3))+(LEDSize div 5))
                else Form1.Image1.Canvas.Ellipse(SL2*LEDSize+((LEDSize div 3)),((LEDSize div 3))+Pad,
                     (SL2*LEDSize)+((LEDSize div 3))+(LEDSize div 5),((LEDSize div 3))+Pad+(LEDSize div 5));
                Form1.Image1.Repaint;
             end
          else
          If (SL1=1) then
             begin
                Form2.Image1.Canvas.Pen.Color:=LedOnOut;
                Form2.Image1.Canvas.Brush.Color:=LedOnOut;
                Form2.Image1.Canvas.Brush.Style:=bsSolid;
                if (Vertical) then Form2.Image1.Canvas.Ellipse(1+Pad,SL2*LEDSize+1,LEDSize+Pad,(SL2*LEDSize)+LEDSize)
                else Form2.Image1.Canvas.Ellipse(SL2*LEDSize+1,1+Pad,(SL2*LEDSize)+LEDSize,LEDSize+Pad);
                Form2.Image1.Canvas.Pen.Color:=LedOnIn;
                Form2.Image1.Canvas.Brush.Color:=LedOnIn;
                Form2.Image1.Canvas.Brush.Style:=bsSolid;
                if (Vertical) then
                   Form2.Image1.Canvas.Ellipse(((LEDSize div 8)+1)+Pad,SL2*LEDSize+((LEDSize div 8)+1),
                           (LEDSize-(LEDSize div 8))+Pad,(SL2*LEDSize)+(LEDSize-(LEDSize div 8)))
                else
                   Form2.Image1.Canvas.Ellipse(SL2*LEDSize+((LEDSize div 8)+1),((LEDSize div 8)+1)+Pad,
                           (SL2*LEDSize)+(LEDSize-(LEDSize div 8)),(LEDSize-(LEDSize div 8))+Pad);
                Form2.Image1.Canvas.Pen.Color:=HighLightOn;
                Form2.Image1.Canvas.Brush.Color:=HighLightOn;
                Form2.Image1.Canvas.Brush.Style:=bsSolid;
                if (Vertical) then Form2.Image1.Canvas.Ellipse(((LEDSize div 3))+Pad,SL2*LEDSize+((LEDSize div 3)),
                     ((LEDSize div 3))+Pad+(LEDSize div 5),(SL2*LEDSize)+((LEDSize div 3))+(LEDSize div 5))
                else Form2.Image1.Canvas.Ellipse(SL2*LEDSize+((LEDSize div 3)),((LEDSize div 3))+Pad,
                     (SL2*LEDSize)+((LEDSize div 3))+(LEDSize div 5),((LEDSize div 3))+Pad+(LEDSize div 5));
                Form2.Image1.Repaint;
             end
          else
          If (SL1=2) then
             begin
                Form3.Image1.Canvas.Pen.Color:=LedOnOut;
                Form3.Image1.Canvas.Brush.Color:=LedOnOut;
                Form3.Image1.Canvas.Brush.Style:=bsSolid;
                if (Vertical) then Form3.Image1.Canvas.Ellipse(1+Pad,SL2*LEDSize+1,LEDSize+Pad,(SL2*LEDSize)+LEDSize)
                else Form3.Image1.Canvas.Ellipse(SL2*LEDSize+1,1+Pad,(SL2*LEDSize)+LEDSize,LEDSize+Pad);
                Form3.Image1.Canvas.Pen.Color:=LedOnIn;
                Form3.Image1.Canvas.Brush.Color:=LedOnIn;
                Form3.Image1.Canvas.Brush.Style:=bsSolid;
                if (Vertical) then
                   Form3.Image1.Canvas.Ellipse(((LEDSize div 8)+1)+Pad,SL2*LEDSize+((LEDSize div 8)+1),
                           (LEDSize-(LEDSize div 8))+Pad,(SL2*LEDSize)+(LEDSize-(LEDSize div 8)))
                else
                   Form3.Image1.Canvas.Ellipse(SL2*LEDSize+((LEDSize div 8)+1),((LEDSize div 8)+1)+Pad,
                           (SL2*LEDSize)+(LEDSize-(LEDSize div 8)),(LEDSize-(LEDSize div 8))+Pad);
                Form3.Image1.Canvas.Pen.Color:=HighLightOn;
                Form3.Image1.Canvas.Brush.Color:=HighLightOn;
                Form3.Image1.Canvas.Brush.Style:=bsSolid;
                if (Vertical) then Form3.Image1.Canvas.Ellipse(((LEDSize div 3))+Pad,SL2*LEDSize+((LEDSize div 3)),
                     ((LEDSize div 3))+Pad+(LEDSize div 5),(SL2*LEDSize)+((LEDSize div 3))+(LEDSize div 5))
                else Form3.Image1.Canvas.Ellipse(SL2*LEDSize+((LEDSize div 3)),((LEDSize div 3))+Pad,
                     (SL2*LEDSize)+((LEDSize div 3))+(LEDSize div 5),((LEDSize div 3))+Pad+(LEDSize div 5));
                Form3.Image1.Repaint;
             end;
       end
   else
       begin
          case SL1 of
             0  : Pad:=0;
             1  : Pad:=0;
             2  : Pad:=0;
          end;
          ImageOn[SL1,SL2]:=false;
          If (SL1=0) then
             begin
                Form1.Image1.Canvas.Pen.Color:=LedOffOut;
                Form1.Image1.Canvas.Brush.Color:=LedOffOut;
                Form1.Image1.Canvas.Brush.Style:=bsSolid;
                if (Vertical) then Form1.Image1.Canvas.Ellipse(1+Pad,SL2*LEDSize+1,LEDSize+Pad,(SL2*LEDSize)+LEDSize)
                else Form1.Image1.Canvas.Ellipse(SL2*LEDSize+1,1+Pad,(SL2*LEDSize)+LEDSize,LEDSize+Pad);
                Form1.Image1.Canvas.Pen.Color:=LedOffIn;
                Form1.Image1.Canvas.Brush.Color:=LedOffIn;
                Form1.Image1.Canvas.Brush.Style:=bsSolid;
                if (Vertical) then
                   Form1.Image1.Canvas.Ellipse(((LEDSize div 8)+1)+Pad,SL2*LEDSize+((LEDSize div 8)+1),
                           (LEDSize-(LEDSize div 8))+Pad,(SL2*LEDSize)+(LEDSize-(LEDSize div 8)))
                else
                   Form1.Image1.Canvas.Ellipse(SL2*LEDSize+((LEDSize div 8)+1),((LEDSize div 8)+1)+Pad,
                           (SL2*LEDSize)+(LEDSize-(LEDSize div 8)),(LEDSize-(LEDSize div 8))+Pad);
                Form1.Image1.Canvas.Pen.Color:=HighLightOff;
                Form1.Image1.Canvas.Brush.Color:=HighLightOff;
                Form1.Image1.Canvas.Brush.Style:=bsSolid;
                if (Vertical) then Form1.Image1.Canvas.Ellipse(((LEDSize div 3))+Pad,SL2*LEDSize+((LEDSize div 3)),
                     ((LEDSize div 3))+Pad+(LEDSize div 5),(SL2*LEDSize)+((LEDSize div 3))+(LEDSize div 5))
                else Form1.Image1.Canvas.Ellipse(SL2*LEDSize+((LEDSize div 3)),((LEDSize div 3))+Pad,
                     (SL2*LEDSize)+((LEDSize div 3))+(LEDSize div 5),((LEDSize div 3))+Pad+(LEDSize div 5));
                Form1.Image1.Repaint;
             end
          else
          If (SL1=1) then
             begin
                Form2.Image1.Canvas.Pen.Color:=LedOffOut;
                Form2.Image1.Canvas.Brush.Color:=LedOffOut;
                Form2.Image1.Canvas.Brush.Style:=bsSolid;
                if (Vertical) then Form2.Image1.Canvas.Ellipse(1+Pad,SL2*LEDSize+1,LEDSize+Pad,(SL2*LEDSize)+LEDSize)
                else Form2.Image1.Canvas.Ellipse(SL2*LEDSize+1,1+Pad,(SL2*LEDSize)+LEDSize,LEDSize+Pad);
                Form2.Image1.Canvas.Pen.Color:=LedOffIn;
                Form2.Image1.Canvas.Brush.Color:=LedOffIn;
                Form2.Image1.Canvas.Brush.Style:=bsSolid;
                if (Vertical) then
                   Form2.Image1.Canvas.Ellipse(((LEDSize div 8)+1)+Pad,SL2*LEDSize+((LEDSize div 8)+1),
                           (LEDSize-(LEDSize div 8))+Pad,(SL2*LEDSize)+(LEDSize-(LEDSize div 8)))
                else
                   Form2.Image1.Canvas.Ellipse(SL2*LEDSize+((LEDSize div 8)+1),((LEDSize div 8)+1)+Pad,
                           (SL2*LEDSize)+(LEDSize-(LEDSize div 8)),(LEDSize-(LEDSize div 8))+Pad);
                Form2.Image1.Canvas.Pen.Color:=HighLightOff;
                Form2.Image1.Canvas.Brush.Color:=HighLightOff;
                Form2.Image1.Canvas.Brush.Style:=bsSolid;
                if (Vertical) then Form2.Image1.Canvas.Ellipse(((LEDSize div 3))+Pad,SL2*LEDSize+((LEDSize div 3)),
                     ((LEDSize div 3))+Pad+(LEDSize div 5),(SL2*LEDSize)+((LEDSize div 3))+(LEDSize div 5))
                else Form2.Image1.Canvas.Ellipse(SL2*LEDSize+((LEDSize div 3)),((LEDSize div 3))+Pad,
                     (SL2*LEDSize)+((LEDSize div 3))+(LEDSize div 5),((LEDSize div 3))+Pad+(LEDSize div 5));
                Form2.Image1.Repaint;
             end
          else
          If (SL1=2) then
             begin
                Form3.Image1.Canvas.Pen.Color:=LedOffOut;
                Form3.Image1.Canvas.Brush.Color:=LedOffOut;
                Form3.Image1.Canvas.Brush.Style:=bsSolid;
                if (Vertical) then Form3.Image1.Canvas.Ellipse(1+Pad,SL2*LEDSize+1,LEDSize+Pad,(SL2*LEDSize)+LEDSize)
                else Form3.Image1.Canvas.Ellipse(SL2*LEDSize+1,1+Pad,(SL2*LEDSize)+LEDSize,LEDSize+Pad);
                Form3.Image1.Canvas.Pen.Color:=LedOffIn;
                Form3.Image1.Canvas.Brush.Color:=LedOffIn;
                Form3.Image1.Canvas.Brush.Style:=bsSolid;
                if (Vertical) then
                   Form3.Image1.Canvas.Ellipse(((LEDSize div 8)+1)+Pad,SL2*LEDSize+((LEDSize div 8)+1),
                           (LEDSize-(LEDSize div 8))+Pad,(SL2*LEDSize)+(LEDSize-(LEDSize div 8)))
                else
                   Form3.Image1.Canvas.Ellipse(SL2*LEDSize+((LEDSize div 8)+1),((LEDSize div 8)+1)+Pad,
                           (SL2*LEDSize)+(LEDSize-(LEDSize div 8)),(LEDSize-(LEDSize div 8))+Pad);
                Form3.Image1.Canvas.Pen.Color:=HighLightOff;
                Form3.Image1.Canvas.Brush.Color:=HighLightOff;
                Form3.Image1.Canvas.Brush.Style:=bsSolid;
                if (Vertical) then Form3.Image1.Canvas.Ellipse(((LEDSize div 3))+Pad,SL2*LEDSize+((LEDSize div 3)),
                     ((LEDSize div 3))+Pad+(LEDSize div 5),(SL2*LEDSize)+((LEDSize div 3))+(LEDSize div 5))
                else Form3.Image1.Canvas.Ellipse(SL2*LEDSize+((LEDSize div 3)),((LEDSize div 3))+Pad,
                     (SL2*LEDSize)+((LEDSize div 3))+(LEDSize div 5),((LEDSize div 3))+Pad+(LEDSize div 5));
                Form3.Image1.Repaint;
             end;
       end;

    {If the form is off the screen for some reason, put it back...}

     MaxHeight:=GetSystemMetrics(SM_CYMAXIMIZED);
     MaxWidth:=GetSystemMetrics(SM_CXMAXIMIZED);

     If (MaxHeight-Form1.Height<Form1.Top) then Form1.Top:=MaxHeight-Form1.Height;
     If (MaxWidth-Form1.Width<Form1.Left) then Form1.Left:=MaxWidth-Form1.Width;
     If (MaxHeight-Form2.Height<Form2.Top) then Form2.Top:=MaxHeight-Form2.Height;
     If (MaxWidth-Form2.Width<Form2.Left) then Form2.Left:=MaxWidth-Form2.Width;
     If (MaxHeight-Form3.Height<Form3.Top) then Form3.Top:=MaxHeight-Form3.Height;
     If (MaxWidth-Form3.Width<Form3.Left) then Form3.Left:=MaxWidth-Form3.Width;

     if (Form1.Top<1) then Form1.Top:=1;
     if (Form1.Left<1) then Form1.Left:=1;
     if (Form2.Top<1) then Form2.Top:=1;
     if (Form2.Left<1) then Form2.Left:=1;
     if (Form3.Top<1) then Form3.Top:=1;
     if (Form3.Left<1) then Form3.Left:=1;

end;


function BinStr(value : LongInt) : string;  {This function converts an integer into a binary string}
var
   T1,T2 : extended;
   Str1  : string;
   I : integer;
begin
   Str1:='';
   T2:=value;
   For I:= 31 downto 0 do
      begin
         T1:=power(2,I);
         if ((T2/T1)<1) then Str1:=Str1+'0'
         else
            begin
              Str1:=Str1+'1';
              T2:=T2-T1;
            end;
      end;
   BinStr:=Str1;
end;

procedure TForm1.FormCreate(Sender: TObject);  {Here is where it starts, read the registry and set everything up}
begin
   OneT1:=false;
   OnTop        :=StrToInt(LoadStringFromRegistry('Software\PatrickDugan\BinaryClock3','OnTop','1'));
   Backgrnd     :=StringToColor(LoadStringFromRegistry('Software\PatrickDugan\BinaryClock3','Backgrnd','clBlack'));
   LedOnIn      :=StringToColor(LoadStringFromRegistry('Software\PatrickDugan\BinaryClock3','LedOnIn','clRed'));
   LedOnOut     :=StringToColor(LoadStringFromRegistry('Software\PatrickDugan\BinaryClock3','LedOnOut','clMaroon'));
   LedOffIn     :=StringToColor(LoadStringFromRegistry('Software\PatrickDugan\BinaryClock3','LedOffIn','$00000055'));
   LedOffOut    :=StringToColor(LoadStringFromRegistry('Software\PatrickDugan\BinaryClock3','LedOffOut','$11111122'));
   HighLightOn  :=StringToColor(LoadStringFromRegistry('Software\PatrickDugan\BinaryClock3','HighLightOn','clWhite'));
   HighLightOff :=StringToColor(LoadStringFromRegistry('Software\PatrickDugan\BinaryClock3','HighLightOff','clSilver'));

   FTop     :=LoadStringFromRegistry('Software\PatrickDugan\BinaryClock3','Top','135');
   FLeft    :=LoadStringFromRegistry('Software\PatrickDugan\BinaryClock3','Left','20');
   Top2     :=StrToInt(LoadStringFromRegistry('Software\PatrickDugan\BinaryClock3','Top2','135'));
   Left2    :=StrToInt(LoadStringFromRegistry('Software\PatrickDugan\BinaryClock3','Left2','100'));
   Top3     :=StrToInt(LoadStringFromRegistry('Software\PatrickDugan\BinaryClock3','Top3','135'));
   Left3    :=StrToInt(LoadStringFromRegistry('Software\PatrickDugan\BinaryClock3','Left3','180'));

   LEDSize  :=StrToInt(LoadStringFromRegistry('Software\PatrickDugan\BinaryClock3','LEDSize','16'));
   IWide    :=StrToInt(LoadStringFromRegistry('Software\PatrickDugan\BinaryClock3','IWide','136'));
   IHigh    :=StrToInt(LoadStringFromRegistry('Software\PatrickDugan\BinaryClock3','IHigh','72'));
   CWide    :=StrToInt(LoadStringFromRegistry('Software\PatrickDugan\BinaryClock3','CWide','136'));
   CHigh    :=StrToInt(LoadStringFromRegistry('Software\PatrickDugan\BinaryClock3','CHigh','72'));
   Back      :=StrToInt(LoadStringFromRegistry('Software\PatrickDugan\BinaryClock3','Back','0'));
   PicStr    :=LoadStringFromRegistry('Software\PatrickDugan\BinaryClock3','Picture','');
   DriveStr    :=LoadStringFromRegistry('Software\PatrickDugan\BinaryClock3','DriveStr','');
   DirectoryStr:=LoadStringFromRegistry('Software\PatrickDugan\BinaryClock3','DirectoryStr','');
   Military    :=StrToInt(LoadStringFromRegistry('Software\PatrickDugan\BinaryClock3','Military','3'));

   TempS1  :=LoadStringFromRegistry('Software\PatrickDugan\BinaryClock3','LeastTop','false');
   if (TempS1='true') then LeastTop:=true else LeastTop:=false;

   TempS1  :=LoadStringFromRegistry('Software\PatrickDugan\BinaryClock3','Hide','false');
   if (TempS1='true') then HideIt:=true else HideIt:=false;

   TempS1  :=LoadStringFromRegistry('Software\PatrickDugan\BinaryClock3','Moveable','true');
   if (TempS1='true') then Moveable:=true else Moveable:=false;

   TempS1  :=LoadStringFromRegistry('Software\PatrickDugan\BinaryClock3','Seconds','true');
   if (TempS1='true') then Seconds:=true else Seconds:=false;

   TempS1  :=LoadStringFromRegistry('Software\PatrickDugan\BinaryClock3','Vertical','true');
   if (TempS1='true') then Vertical:=true else Vertical:=false;

   TempS1  :=LoadStringFromRegistry('Software\PatrickDugan\BinaryClock3','SmallFont','false');
   if (TempS1='true') then SmallFont:=true else SmallFont:=false;

end;

procedure TForm1.Timer1Timer(Sender: TObject);  {This is the primary timer to get the time and translate to the leds}
var
   I,J : integer;
   H2,M2,PM,S2,TStr,Comp1,Comp2 : string;
   MilStr,MH2,MM2,MS2         : string;
begin
    LongTimeFormat:='h:nn:ss AM/PM';
    TStr:=TimeToStr(Time);
    PM:=Copy(TStr,Length(TStr)-1,2);
    if (Military=4) then
       begin
          LongTimeFormat:='hh:nn:ss';
          MilStr:=TimeToStr(Time);
          MH2:=Copy(BinStr(StrToInt(Copy(MilStr,1,2))),27,6);
          MM2:=Copy(BinStr(StrToInt(Copy(MilStr,4,2))),27,6);
          MS2:=Copy(BinStr(StrToInt(Copy(MilStr,7,2))),27,6);
       end;
    If ((Military=3) and (length(TStr)=10)) then
       begin
          H2:=Copy(BinStr(StrToInt(Copy(TStr,1,1))),27,6);
          M2:=Copy(BinStr(StrToInt(Copy(TStr,3,2))),27,6);
          S2:=Copy(BinStr(StrToInt(Copy(TStr,6,2))),27,6);
       end
    else
    If ((Military=3) and (length(TStr)<>10)) then
       begin
          H2:=Copy(BinStr(StrToInt(Copy(TStr,1,2))),27,6);
          M2:=Copy(BinStr(StrToInt(Copy(TStr,4,2))),27,6);
          S2:=Copy(BinStr(StrToInt(Copy(TStr,7,2))),27,6);
       end;

    if (Military=3) then BStr:=H2+M2+S2
    else BStr:=MH2+MM2+MS2;
    K:=0;

    if not(LeastTop) then
       begin
          For I := 0 to 2 do
             For J := 0 to 5 do
                begin
                   K:=K+1;
                   Comp1:=Copy(OldBStr,K,1);
                   Comp2:=Copy(BStr,K,1);
                   If (Comp1<>Comp2) then SwitchLights(I,J);
                end;
       end
    else
       begin
          For I := 0 to 2 do
             For J := 5 downto 0 do
                begin
                   K:=K+1;
                   Comp1:=Copy(OldBStr,K,1);
                   Comp2:=Copy(BStr,K,1);
                   If (Comp1<>Comp2) then SwitchLights(I,J);
                end;
       end;

    OldBStr:=BStr;
    if (FTime) then
       begin
         RepaintForm;
         FTime:=false;
       end;

end;

procedure TForm1.Panel1MouseDown(Sender: TObject; Button: TMouseButton; {check for mouse buttons}
  Shift: TShiftState; X, Y: Integer);
begin
  if (Button=mbLeft) then LBDown:=true;
  if (Button=mbRight) then Form4.visible:=true;
  if (LBDown) then
     begin
        OldP.X:=X;
        OldP.Y:=Y;
        OldP := ClientToScreen(OldP);            { Q is the TPoint for the screen }
        OldQ:=OldP;
     end;
end;

procedure TForm1.Panel1MouseMove(Sender: TObject; Shift: TShiftState; X, {If left mouse down on upper display panel then move form}
  Y: Integer);
var
  P, Q : TPoint;
begin
   if ((LBDown) and (Moveable)) then
      begin
        P.X := X;                          { P is the TPoint record for the form}
        P.Y := Y;
        Q := ClientToScreen(P);            { Q is the TPoint for the screen }
        if ((Q.X<>OldQ.X) or (Q.Y<>OldQ.Y)) then
           begin
              Form1.Left:=Form1.Left+(Q.X-OldQ.X);
              Form1.Top:= Form1.Top +(Q.Y-OldQ.Y);
           end;
        OldQ:=Q;
      end;
end;

procedure TForm1.Panel1MouseUp(Sender: TObject; Button: TMouseButton;  {If right mouse button is raised then repaint form}
  Shift: TShiftState; X, Y: Integer);
begin
  if (Button=mbLeft) then  LBDown:=false;
  if (Button=mbRight) then Form4.Visible:=true;
end;

procedure TForm1.FormDestroy(Sender: TObject);  {write values to registry and exit}
begin

   if (Vertical) then
      begin
         Form1.ClientHeight:=Round((LEDSize*6.2));
         Form1.ClientWidth :=Round((LEDSize*1.2));
      end
   else
      begin
         Form1.ClientWidth :=Round((LEDSize*6.2));
         Form1.ClientHeight:=Round((LEDSize*1.2));
      end;

   Form1.Image1.Height:=Form1.ClientHeight;
   Form1.Image1.Width:=Form1.ClientWidth;

   SaveStringToRegistry('Software\PatrickDugan\BinaryClock3','OnTop',IntToStr(OnTop));
   SaveStringToRegistry('Software\PatrickDugan\BinaryClock3','Backgrnd',ColorToString(Backgrnd));
   SaveStringToRegistry('Software\PatrickDugan\BinaryClock3','LEDOnIn',ColorToString(LEDOnIn));
   SaveStringToRegistry('Software\PatrickDugan\BinaryClock3','LEDOnOut',ColorToString(LEDOnOut));
   SaveStringToRegistry('Software\PatrickDugan\BinaryClock3','LEDOffIn',ColorToString(LEDOffIn));
   SaveStringToRegistry('Software\PatrickDugan\BinaryClock3','LEDOffOut',ColorToString(LEDOffOut));
   SaveStringToRegistry('Software\PatrickDugan\BinaryClock3','HighLightOn',ColorToString(HighLightOn));
   SaveStringToRegistry('Software\PatrickDugan\BinaryClock3','HighLightOff',ColorToString(HighLightOff));

   SaveStringToRegistry('Software\PatrickDugan\BinaryClock3','Top',IntToStr(Form1.Top));
   SaveStringToRegistry('Software\PatrickDugan\BinaryClock3','Left',IntToStr(Form1.Left));

   SaveStringToRegistry('Software\PatrickDugan\BinaryClock3','Top2',IntToStr(Top2));
   SaveStringToRegistry('Software\PatrickDugan\BinaryClock3','Left2',IntToStr(Left2));

   SaveStringToRegistry('Software\PatrickDugan\BinaryClock3','Top3',IntToStr(Top3));
   SaveStringToRegistry('Software\PatrickDugan\BinaryClock3','Left3',IntToStr(Left3));

   SaveStringToRegistry('Software\PatrickDugan\BinaryClock3','LEDSize',IntToStr(LEDSize));
   SaveStringToRegistry('Software\PatrickDugan\BinaryClock3','IWide',IntToStr(Form1.Image1.Width));
   SaveStringToRegistry('Software\PatrickDugan\BinaryClock3','IHigh',IntToStr(Form1.Image1.Height));
   SaveStringToRegistry('Software\PatrickDugan\BinaryClock3','CWide',IntToStr(ClientWidth));
   SaveStringToRegistry('Software\PatrickDugan\BinaryClock3','CHigh',IntToStr(ClientHeight));
   if (Moveable) then SaveStringToRegistry('Software\PatrickDugan\BinaryClock3','Moveable','true')
   else SaveStringToRegistry('Software\PatrickDugan\BinaryClock3','Moveable','false');
   if (Seconds) then SaveStringToRegistry('Software\PatrickDugan\BinaryClock3','Seconds','true')
   else SaveStringToRegistry('Software\PatrickDugan\BinaryClock3','Seconds','false');
   if (Vertical) then SaveStringToRegistry('Software\PatrickDugan\BinaryClock3','Vertical','true')
   else SaveStringToRegistry('Software\PatrickDugan\BinaryClock3','Vertical','false');
   if (LeastTop) then SaveStringToRegistry('Software\PatrickDugan\BinaryClock3','LeastTop','true')
   else SaveStringToRegistry('Software\PatrickDugan\BinaryClock3','LeastTop','false');
   if (HideIt) then SaveStringToRegistry('Software\PatrickDugan\BinaryClock3','Hide','true')
   else SaveStringToRegistry('Software\PatrickDugan\BinaryClock3','Hide','false');
   if (SmallFont) then SaveStringToRegistry('Software\PatrickDugan\BinaryClock3','SmallFont','true')
   else SaveStringToRegistry('Software\PatrickDugan\BinaryClock3','SmallFont','false');
   SaveStringToRegistry('Software\PatrickDugan\BinaryClock3','Back',IntToStr(Back));
   SaveStringToRegistry('Software\PatrickDugan\BinaryClock3','Picture',PicStr);
   SaveStringToRegistry('Software\PatrickDugan\BinaryClock3','DriveStr',DriveStr);
   SaveStringToRegistry('Software\PatrickDugan\BinaryClock3','DirectoryStr',DirectoryStr);
   SaveStringToRegistry('Software\PatrickDugan\BinaryClock3','Military',IntToStr(Military));
end;

procedure TForm1.FormActivate(Sender: TObject);
var
   I,J : integer;
   NewRect: TRect;
begin
   {Start up stuff here to avoid access violation of two other forms...}
   if not(OneT1) then
      begin
         OneT1:=True;

         Form1.ClientHeight:=CHigh;
         Form1.ClientWidth:=CWide;
         Form1.Image1.Height:=IHigh;
         Form1.Image1.Width:=IWide;
         Form1.Top:=StrToInt(FTop);
         Form1.Left:=StrToInt(FLeft);
         Form2.ClientHeight:=CHigh;
         Form2.ClientWidth:=CWide;
         Form2.Image1.Height:=IHigh;
         Form2.Image1.Width:=IWide;
         Form2.Top:=Top2;
         Form2.Left:=Left2;
         Form3.ClientHeight:=CHigh;
         Form3.ClientWidth:=CWide;
         Form3.Image1.Height:=IHigh;
         Form3.Image1.Width:=IWide;
         Form3.Top:=Top3;
         Form3.Left:=Left3;

         DrawRoundRectRegion(Form1.Handle, Form1.ClientRect);
         DrawRoundRectRegion(Form2.Handle, Form2.ClientRect);
         DrawRoundRectRegion(Form3.Handle, Form3.ClientRect);

         if (Back=0) then
            begin
               Form1.Image1.Canvas.Brush.Color:=Backgrnd;
               NewRect := Rect(0, 0, Form1.Image1.Width, Form1.Image1.Height);
               Form1.Image1.Canvas.FillRect(NewRect);
               Form2.Image1.Canvas.Brush.Color:=Backgrnd;
               NewRect := Rect(0, 0, Form2.Image1.Width, Form2.Image1.Height);
               Form2.Image1.Canvas.FillRect(NewRect);
               Form3.Image1.Canvas.Brush.Color:=Backgrnd;
               NewRect := Rect(0, 0, Form3.Image1.Width, Form3.Image1.Height);
               Form3.Image1.Canvas.FillRect(NewRect);
            end;

         If ((Back=1)and (PicStr<>'')) then
            begin
               try Form1.Image1.Picture.LoadFromFile(PicStr);
               except
                  on EInvalidGraphic do
                     begin
                        ShowMessage('Invalid graphic name.');
                     end;
                  on EFOpenError do
                     begin
                        ShowMessage('Could not open the graphic file requested.');
                     end;
               end;
               try Form2.Image1.Picture.LoadFromFile(PicStr);
               except
                  on EInvalidGraphic do
                     begin
                        ShowMessage('Invalid graphic name.');
                     end;
                  on EFOpenError do
                     begin
                        ShowMessage('Could not open the graphic file requested.');
                     end;
               end;
               try Form3.Image1.Picture.LoadFromFile(PicStr);
               except
                  on EInvalidGraphic do
                     begin
                        ShowMessage('Invalid graphic name.');
                     end;
                  on EFOpenError do
                     begin
                        ShowMessage('Could not open the graphic file requested.');
                     end;
               end;
            end;

         DrawRoundRectRegion(Form1.Handle, Form1.ClientRect);
         DrawRoundRectRegion(Form2.Handle, Form2.ClientRect);
         DrawRoundRectRegion(Form3.Handle, Form3.ClientRect);

         Blink:=False;
         OldBStr:='0000000000000000000000000';

          if not(LeastTop) then
             begin
                For I := 0 to 2 do
                   For J := 0 to 5 do
                      begin
                         ImageOn[I,J]:=True;
                         SwitchLights(I,J);
                      end;
             end
          else
             begin
                For I := 0 to 2 do
                   For J :=  5 downto 0 do
                      begin
                         ImageOn[I,J]:=True;
                         SwitchLights(I,J);
                      end;
             end;

         OldPM:='AM';
         FTime:=true;
         Timer1.Enabled:=true;

         if (OnTop=0) then
            begin
               SetWindowPos(Form1.Handle,HWND_TOPMOST,0,0,0,0,SWP_NOMOVE or SWP_NOSIZE or SWP_SHOWWINDOW);
               SetWindowPos(Form2.Handle,HWND_TOPMOST,0,0,0,0,SWP_NOMOVE or SWP_NOSIZE or SWP_SHOWWINDOW);
               SetWindowPos(Form3.Handle,HWND_TOPMOST,0,0,0,0,SWP_NOMOVE or SWP_NOSIZE or SWP_SHOWWINDOW);
            end;
         if (OnTop=1) then
            begin
               SetWindowPos(Form1.Handle,HWND_NOTOPMOST,0,0,0,0,SWP_NOMOVE or SWP_NOSIZE or SWP_SHOWWINDOW);
               SetWindowPos(Form2.Handle,HWND_NOTOPMOST,0,0,0,0,SWP_NOMOVE or SWP_NOSIZE or SWP_SHOWWINDOW);
               SetWindowPos(Form3.Handle,HWND_NOTOPMOST,0,0,0,0,SWP_NOMOVE or SWP_NOSIZE or SWP_SHOWWINDOW);
            end;
         if (OnTop=2) then
            begin
               SetWindowPos(Form1.Handle,HWND_NOTOPMOST,0,0,0,0,SWP_NOMOVE or SWP_NOSIZE or SWP_SHOWWINDOW);
               SetWindowPos(Form2.Handle,HWND_NOTOPMOST,0,0,0,0,SWP_NOMOVE or SWP_NOSIZE or SWP_SHOWWINDOW);
               SetWindowPos(Form3.Handle,HWND_NOTOPMOST,0,0,0,0,SWP_NOMOVE or SWP_NOSIZE or SWP_SHOWWINDOW);
               SetWindowPos(Form1.Handle,HWND_BOTTOM,0,0,0,0,SWP_NOMOVE or SWP_NOSIZE or SWP_SHOWWINDOW);
               SetWindowPos(Form2.Handle,HWND_BOTTOM,0,0,0,0,SWP_NOMOVE or SWP_NOSIZE or SWP_SHOWWINDOW);
               SetWindowPos(Form3.Handle,HWND_BOTTOM,0,0,0,0,SWP_NOMOVE or SWP_NOSIZE or SWP_SHOWWINDOW);
            end;

     end;
end;



end.
