// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- // 
// C++ Header File Name: gxshttpc.h
// C++ Compiler Used: MSVC, BCC32, GCC, HPUX aCC, SOLARIS CC
// Produced By: glNET Software
// File Creation Date: 01/25/2000
// Date Last Modified: 06/27/2001
// Copyright (c) 2001 glNET Software
// ----------------------------------------------------------- // 
// ---------- Include File Description and Details  ---------- // 
// ----------------------------------------------------------- // 
/*
This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.
 
This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  
USA

HTTP client class.
*/
// ----------------------------------------------------------- // 
#ifndef __GX_SOCKET_HTTP_CLIENT__HPP__
#define __GX_SOCKET_HTTP_CLIENT__HPP__

#include <fstream.h>
#include "devcache.h"
#include "gxsocket.h"
#include "gxsurl.h"
#include "gxshttp.h"

// --------------------------------------------------------------
// Type definitions
// --------------------------------------------------------------
typedef MemoryBuffer MEMTYPE; // Resizable memory buffers
typedef gxDeviceCachePtr httpCachePointer; // Pointer to cache
// --------------------------------------------------------------

// --------------------------------------------------------------
// Constants 
// --------------------------------------------------------------
const int __HTTP_DEFAULT_CACHE_SIZE__  = 1024;  // Default cache size  
const int __HTTP_DEFAULT_PACKET_SIZE__ = 1024;  // Maximum length of each block

// Adjust these values for maximum performance
const int __HTTP_CACHE_SIZE__  = 1024;  // Number of cache buckets used
const int __HTTP_PACKET_SIZE__ = 32767; // Maximum packet size
// --------------------------------------------------------------

class gxsHTTPClient : public gxSocket, public gxDeviceCache
{
public:
  gxsHTTPClient(int CacheSize = __HTTP_DEFAULT_CACHE_SIZE__);
  ~gxsHTTPClient();

public:
  void Flush() { cache.Flush(); } // Flush the cache buckets
  unsigned BucketsInUse() { return cache.BucketsInUse(); }
  int ConnectClient(const char *host, int port = gxSOCKET_HTTP_PORT);
  int RequestHeader(const gxsURLInfo &u, gxsHTTPHeader &hdr);
  int SimpleRequest(const gxsURLInfo &u, fstream *stream);
  int SimpleRequest(const gxsURLInfo &u, MemoryBuffer &mbuf);
  int RequestFile(const gxsURLInfo &u, const gxsHTTPHeader &hdr,
		  fstream *stream);
  int RequestFile(const gxsURLInfo &u, const gxsHTTPHeader &hdr,
		  MemoryBuffer &mbuf);
  char *GetMethod(int method);
  char *GetProtocolString(int protocol);
  void BuildRequestString(const gxsURLInfo &u, int method, gxString &request);
  void BuildSimpleRequestString(const gxsURLInfo &u, int method,
				gxString &request);
  int ParseHTTPHeader(const gxsURLInfo &u, const gxString &header,
		      gxsHTTPHeader &hdr);

private: // Device cache base class interface
  void Read(void *buf, unsigned Bytes, gxDeviceTypes dev);
  void Write(const void *buf, unsigned Bytes, gxDeviceTypes dev);

public: // Client header information that can or must be modified
        // according to the application. These values will be used
        // when a request string is built.
  gxString HTTP_VERSION_STRING; // HTTP requested version string
  gxString HTTP_AGENT_STRING;   // Application name;
  gxString HTTP_ACCEPT_STRING;  // File types that will be accepted
  gxString HTTP_PRAGMA_STRING;  // Implementation-specific directives 

  // Used to provide information left earlier by some server.
  // Usage: "Cookie: persistent data\r\n"
  gxString HTTP_COOKIE_STRING; 
  
  // Default file name used if no file is specified. NOTE: defaults to " /"
  gxString HTTP_DEFAULT_FILE_REQUEST_STRING;

  // This value will be set to null by default. The application must set
  // this value in order to include it in the request string. NOTE: The
  // following syntax must be used when setting this value:
  // "Referer: http://www.w3.org/hypertext/DataSources/Overview.html\r\n"
  gxString HTTP_REFERER_STRING; // The Referer request-header field allows
                                // the client to specify, for the server's
                                // benefit, the address (URI) of the resource
                                // from which the Request-URI was obtained. 
  
  // This value will be set to null by default. The application must set
  // this value in order to include it in the request string. NOTE: The
  // following syntax must be used when setting this value:
  // "If-Modified-Since: Sat, 29 Oct 1999 19:43:31 GMT\r\n"
  // There are three accepted date formats: RFC 822, RFC 850, asctime()
  gxString HTTP_IF_MOD_STRING; // Used with the GET method to make it
                               // conditional: if the requested resource has
                               // not been modified since the time specified
                               // in this field, a copy of the resource will
                               // not be returned from the server; instead, a
                               // 304 (not modified) response will be returned
                               // without any Entity-Body. 
  
private:
  gxsURL url;              // Used to process URL infomation
  int write_error;         // Holds the last write error, if any
  int read_error;          // Holds the last read error, if any
  unsigned bytes_received; // Number of bytes read from an open socket

private: // I/O device members
  fstream *file_ptr;                   // Pointer to an open file
  char rxBuffer[__HTTP_PACKET_SIZE__]; // Receiver memory buffer

private: // Device cache
  gxDeviceBucketCache cache;

public: // Functions used to get the current device cache
  gxDeviceBucketCache *GetCache() { return &cache; }
};

#endif // __GX_SOCKET_HTTP_CLIENT__HPP__
// ----------------------------------------------------------- //
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
