// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- // 
// C++ Source Code File Name: testprog.cpp
// C++ Compiler Used: MSVC, BCC32, GCC, HPUX aCC, SOLARIS CC
// Produced By: glNET Software
// File Creation Date: 09/21/1997
// Date Last Modified: 05/25/2001
// Copyright (c) 2001 glNET Software
// ----------------------------------------------------------- // 
// ------------- Program Description and Details ------------- // 
// ----------------------------------------------------------- // 
/*
This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.
 
This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  
USA

This is a test program for the FString class. 
*/
// ----------------------------------------------------------- // 
#include <iostream.h>
#include "fstring.h"

#ifdef __MSVC_DEBUG__
#include "leaktest.h"
#endif

int main()
{
#ifdef __MSVC_DEBUG__
  InitLeakTest();
#endif

  FString sz;
  cout << "Size of FString object = " << sz.SizeOf() << endl;
 
  cout << "Constructing FString class objects..." << endl;
  FString a("DOG");
  FString b("CAT");
  FString c("MOUSE");
  FString d("BIRD");

  cout << "Testing copy constructor..." << endl;
  FString e(a);  

  cout << "Testing assignment operator..." << endl;
  a = b;

  cout << endl;
  cout << "Testing overloaded << operator..."  << endl;
  cout << a << ' ' << b  << ' ' << c  << ' ' << d << ' ' << e << endl;

  cout << endl;
  cout << "Testing c_str() function..." << endl;
  cout << a.c_str() << endl;
  cout << b.c_str() << endl;
  cout << c.c_str() << endl;
  cout << d.c_str() << endl;
  cout << e.c_str() << endl;

  cout << endl;
  cout << "Testing overloaded >> operator..." << endl;
  FString buf;
  cout << "Enter a string up to " << FStringLength << " characters long: ";
  cin >> buf;

  cout << endl;
  cout << "Data entered = " << buf << endl;

  cout << endl;
  cout << "Testing FString boundaries..." << endl;
  char *s = "ABCDEFGHIJKLMNOPQRSTUVWXYZ 0123456789";
  FString x(s);
  cout << "Alphabet string = " << x.c_str() << endl;

  return 0;
}
// ----------------------------------------------------------- //
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
