// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- // 
// C++ Source Code File Name: server.cpp
// C++ Compiler Used: MSVC, BCC32, GCC, HPUX aCC, SOLARIS CC
// Produced By: glNET Software
// File Creation Date: 09/20/1999
// Date Last Modified: 05/25/2001
// Copyright (c) 2001 glNET Software
// ----------------------------------------------------------- // 
// ------------- Program Description and Details ------------- // 
// ----------------------------------------------------------- // 
/*
This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.
 
This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  
USA

This program is used to the gxStream class.
*/
// ----------------------------------------------------------- // 
#include <iostream.h>
#include <string.h>
#include <stdlib.h>
#include "gxstream.h"

int ReadBlock(gxStream *server, gxBlockHeader &gx)
{
  cout << "Reading a raw block of data" << endl;
  
  char *buf = new char[(__ULWORD__)gx.block_length];
  if(server->ReadRemoteBlock(buf, gx) != 0) return 1;

  buf[(__ULWORD__)gx.block_length] = 0;
  cout << buf;
  cout << server->BytesRead() << " bytes received." << endl;
  
  delete buf;
  return 0;
}

int AnswerRequest(gxStream *server, gxBlockHeader &gx)
{
  cout << "Client has requested a block" << endl;
 
  char *test_block = "The quick brown fox jumps over the lazy dog \
0123456789\n";

  char *buf = new char[(__ULWORD__)gx.block_length];
  if(server->ReadRemoteBlock(buf, gx) != 0) return 1;

  buf[(__ULWORD__)gx.block_length] = 0;
  cout << "Client has requested block: " << buf << endl;
  delete buf;

  cout << "Answering request" << endl;
  
  if(server->WriteRemoteBlock((char *)test_block, strlen(test_block))
			      != 0) return 1;
  return 0;
}

int ChangeBlock(gxStream *server, gxBlockHeader &gx)
{
  cout << "Received a change block request" << endl;
 
  char *buf = new char[(__ULWORD__)gx.block_length];
  if(server->ReadRemoteBlock(buf, gx) != 0) return 1;

  buf[(__ULWORD__)gx.block_length] = 0;
  cout << "Client requested that block \"" << buf << "\" be changed to:" 
       << endl << flush;
  delete buf;

  gxBlockHeader block_header;
  if(server->ReadClientHeader(block_header) != 0) return 1;

  char *block = new char[(__ULWORD__)block_header.block_length];
  if(server->ReadRemoteBlock((char *)block, block_header) != 0) return 1;

  block[(__ULWORD__)block_header.block_length] = 0;
  cout << block << flush;

  delete block;
  return 0;
}

int AddBlock(gxStream *server, gxBlockHeader &gx)
{
  cout << "Received an add block request" << endl;
  
  char *block = new char[(__ULWORD__)gx.block_length];
  if(server->ReadRemoteBlock(block, gx) != 0) return 1;

  block[(__ULWORD__)gx.block_length] = 0;
  cout << "Client has requested the following block be added:" << endl;
  cout << block << flush;
  delete block;
  
  return 0;
}

int DeleteBlock(gxStream *server, gxBlockHeader &gx)
{
  cout << "Received a delete block request" << endl;
  
  char *buf = new char[(__ULWORD__)gx.block_length];
  if(server->ReadRemoteBlock(buf, gx) != 0) return 1;

  buf[(__ULWORD__)gx.block_length] = 0;
  cout << "Client has requested block \"" << buf << "\" be deleted" << endl;
  delete buf;
  
  return 0;
}

int main(int argc, char **argv)
{
  // Check arguments. Should be only one: the port number to bind to.
  if(argc != 2) {
    cerr << "Usage: " << argv[0] << " port" << endl;
    return 1;
  }

  gxStream server;
  gxsSocket_t remote_socket;
  unsigned short port = (unsigned short) atoi(argv[1]);

  cout << "Initializing the GX stream server..." << endl;
  if(server.StreamServer(port) != 0) {
    cout << server.SocketExceptionMessage() << endl;
    return 1;
  }
  
  // Get the host name assigned to this machine
  char hostname[gxsMAX_NAME_LEN];
  if(server.HostName(hostname) != 0) {
    cout << server.SocketExceptionMessage() << endl;
    return 1;
  }
  cout << "Opening stream server on host " << hostname << endl;
    
  while(1) { // Block until the next read. 
    cout << "Listening on port " << port << endl;
    remote_socket = server.Accept();

    if(remote_socket < 0) {
      cout << server.SocketExceptionMessage() << endl;
      return 1;
    }
    
    // Read the block following a client connection
    gxBlockHeader gx;
    if(server.ReadClientHeader(gx) != 0) {
      cout << server.SocketExceptionMessage() << endl;
      return 1;
    }

    // Get the client info
    char client_name[gxsMAX_NAME_LEN]; int r_port = -1;
    server.GetClientInfo(client_name, r_port);
    cout << client_name << " connecting on port " << r_port << endl;

    // Read the status byte to determine what to do with this block
    __ULWORD__ block_status = gx.block_status;
    __SBYTE__ status = (__SBYTE__)((block_status & 0xFF00)>>8);

    switch(status) { 
      // Process each block of data
      case gxAcknowledgeBlock:
	cout << "Received an acknowledge block command" << endl;
	cout << "Sending acknowledgment" << endl;
	if(server.WriteRemoteAckBlock() != 0)
	  cout << server.SocketExceptionMessage() << endl;	  
	server.CloseRemoteSocket();
	break;

      case gxAddRemoteBlock:
	if(AddBlock(&server, gx) != 0) 
	  cout << server.SocketExceptionMessage() << endl;
	server.CloseRemoteSocket();
	break;

      case gxChangeRemoteBlock:
	if(ChangeBlock(&server, gx) != 0) 
	  cout << server.SocketExceptionMessage() << endl;
	server.CloseRemoteSocket();
	break;

      case gxRequestBlock:
	if(AnswerRequest(&server, gx) != 0) 
	  cout << server.SocketExceptionMessage() << endl;
	server.CloseRemoteSocket();
	break;

      case gxDeleteRemoteBlock:
	if(DeleteBlock(&server, gx) != 0) 
	  cout << server.SocketExceptionMessage() << endl;
	server.CloseRemoteSocket();
	break;

      case gxSendBlock :  
	if(ReadBlock(&server, gx) != 0) 
	  cout << server.SocketExceptionMessage() << endl;
	server.CloseRemoteSocket();
	break;

      case gxCloseConnection : 
	cout << "Client sent a close connection command" << endl;
	server.CloseRemoteSocket();
	break;

      case gxKillServer:
	cout << "Client shutdown the server" << endl;
	server.Close();
	return 0;
	
      default:
	cout << "Received bad block command from client" << endl;
	server.CloseRemoteSocket();
	break;
    }
  }

  cout << "Exiting..." << endl;
  return 0;
}
// ----------------------------------------------------------- // 
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
