// ------------------------------- //
// -------- Start of File -------- //
// ------------------------------- //
// ----------------------------------------------------------- // 
// C++ Source Code File Name: testprog.cpp
// C++ Compiler Used: MSVC, BCC32, GCC, HPUX aCC, SOLARIS CC
// Produced By: glNET Software
// File Creation Date: 09/20/1999
// Date Last Modified: 05/25/2001
// Copyright (c) 2001 glNET Software
// ----------------------------------------------------------- // 
// ------------- Program Description and Details ------------- // 
// ----------------------------------------------------------- // 
/*
This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.
 
This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.
 
You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  
USA

Program used to test the GXS library service file functions.
*/
// ----------------------------------------------------------- // 
#include <iostream.h>
#include <fstream.h>
#include <ctype.h>
#include <stdlib.h>
#include "gxsutils.h"

#ifdef __MSVC_DEBUG__
#include "leaktest.h"
#endif

int main(int argc, char **argv)
{
#ifdef __MSVC_DEBUG__
  InitLeakTest();
#endif
  
  // Check the command line arguments
  if(argc != 2) {
    cout << endl;
    cout << "Usage: " << argv[0] << " services file" << endl;
#if defined (__WIN32__)
    cout << "Example: " << argv[0] << " c:\\windows\\services" << endl;
#else
    cout << "Example: " << argv[0] << " /etc/services" << endl;
#endif
    return 1;
  }

  char *fname = argv[1];
  const int MaxLine = 1024;
  char entry[MaxLine];
  
#ifdef __BCC32__
  // The BCC 32 ios class does not have an enumeration for "nocreate"
  ifstream infile(fname, ios::in);
#else
  ifstream infile(fname, ios::in|ios::nocreate);
#endif
  if(!infile) {
    cout << "Cannot open the " << fname << " file" << endl;
    return 1; 
  }
        
  while(!infile.eof()) {
    // Clear the line buffer before each read
    for(int i = 0; i < MaxLine; i++) entry[i] = 0;

    // Read in config file line by line
    infile.getline(entry, MaxLine);

    char service[MaxLine];
    int port;
    char protocol[MaxLine];
    char aliases[MaxLine];
    char comment[MaxLine];
    if(ParseServiceFileEntry(entry, service, &port, 
			     protocol, aliases, comment)) {
      cout << endl;
      if(service[0] != 0) 
	cout << "Name:     " << service << endl;
      if(protocol[0] != 0) 
	cout << "Protocol: " << protocol << endl;
      if(port > 0) 
	cout << "Port:     " << port << endl;
      if(aliases[0] != 0) 
	cout << "Aliases:  " << aliases << endl;
      if(comment[0] != 0) 
	cout << "Comment:  " << comment << endl;
    }
  }
  infile.close();

  return 0;
}
// ----------------------------------------------------------- // 
// ------------------------------- //
// --------- End of File --------- //
// ------------------------------- //
