//PasScript interpreter of the Object Pascal language, version 6.51
//Copyright (c) by Alexander Baranovsky, 1999-2002
//File 'fmCompiling.pas'

unit fmCompiling;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls;

type
  TCompiling = class(TForm)
    Button1: TButton;
    Panel1: TPanel;
    PanelProject: TPanel;
    PanelStatus: TPanel;
    PanelCurrLine: TPanel;
    PanelAllLines: TPanel;
    PanelError: TPanel;
    LabelProject: TLabel;
    LabelStatus: TLabel;
    LabelCurrLine: TLabel;
    LabelAllLines: TLabel;
    LabelError: TLabel;
    LabelCurrLineNumber: TLabel;
    LabelAllLinesNumber: TLabel;
    procedure Button1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
    ToBeClosed: boolean;
    function CancelParsing: boolean;
  public
     procedure WaitForEnter;
     procedure CreateParams(var Params: TCreateParams); override; 
    { Public declarations }
  end;

var
  Compiling: TCompiling;

implementation

uses fmMain, PasScr;

{$R *.DFM}

procedure TCompiling.CreateParams(var Params: TCreateParams);
begin
  inherited CreateParams(Params);
  Params.Style := WS_CAPTION;
end;

function TCompiling.CancelParsing: boolean;
begin
  result := true;
end;

procedure TCompiling.Button1Click(Sender: TObject);
begin
  if Form1.CompileStage then
    Form1.PasScript.OnCancelParsing := CancelParsing
  else
    ToBeClosed := true;
end;

procedure TCompiling.WaitForEnter;
var
  Msg: TMsg;
begin
  SetFocus;
  repeat
    while PeekMessage(Msg, 0, 0, 0, PM_REMOVE) do
    begin
      if Msg.Message = WM_KEYDOWN then
        if Msg.WParam = VK_RETURN then
           Exit;
      TranslateMessage(msg);
      DispatchMessage(msg);
    end;
    if ToBeClosed then
    begin
      ToBeClosed := false;
      Exit;
    end;
  until false;
end;

procedure TCompiling.FormCreate(Sender: TObject);
begin
  ToBeClosed := false;
end;

end.
