unit Score;

{  ******
   *
   * Module:    Score
   * Author:    Joe Kessler
   *            IntegrationWare - A New Generation of Extraordinary PC Solutions
   *            www.integrationware.com
   *
   * Purpose:
   *
   *    This module implements the TScoreBoard object, which is a special
   *    derivation of a Text object.  This class also keeps tracks of a numeric
   *    score, and the number of lives that the player still has remaining.
   *
   ****** }

interface
uses SoundDev, Text, Visible, Graphics, Classes, SysUtils;

type TScoreBoard = class(TTextObject)
    private
        m_iCurrentScore: Integer;   { The player's current score. }
        m_lstBarts: TList;          { List of fake Bart objects. }

        { Methods for getting/setting property values. }
        procedure SetScore(iNewScore: Integer);
        procedure SetBartCount(iNewCount: Integer);
        function iGetBartCount: Integer;

    public
        { Class constructor and destructor. }
        constructor Create(lstObjects: TList);
        destructor Destroy; Override;

        { Exposed properties. }
        property iCurrentScore: Integer     Read m_iCurrentScore    Write SetScore;
        property iBartCount: Integer        Read iGetBartCount      Write SetBartCount;
end;

implementation

constructor TScoreBoard.Create(lstObjects: TList);
begin
    { Start off with a bank of zeros. }
    inherited Create(lstObjects, '000000', clAqua);

    { Create the static Bart list and score digit list. }
    m_lstBarts := TList.Create;

    { Start with an initial score of zero. }
    SetScore(0);
end;

destructor TScoreBoard.Destroy;
var
    iIndex: Integer;
begin
    { Free our list of Bart objects. }
    for iIndex := 0 to (m_lstBarts.Count - 1) do
        TVisibleObject(m_lstBarts.Items[iIndex]).KillObject(False, 0, 0, 0, 0);
    m_lstBarts.Free;

    { Perform default cleanup. }
    inherited Destroy;
end;

procedure TScoreBoard.SetScore(iNewScore: Integer);
begin
    { Stash the new score, and alter the scoreboard text. }
    m_iCurrentScore := iNewScore;

     { Format a new six-digit score text. }
    szText := Format('%6.6d', [m_iCurrentScore]);
end;

procedure TScoreBoard.SetBartCount(iNewCount: Integer);
var
    iIndex: Integer;
    objObject: TVisibleObject;
    iBartPosX: Integer;
begin
    { Get rid of all of the Barts currently being displayed. }
    for iIndex := 0 to (m_lstBarts.Count - 1) do
        TVisibleObject(m_lstBarts.Items[iIndex]).KillObject(False, 0, 0, 0, 0);
    m_lstBarts.Clear;

    { Now, create a new set of Barts. }
    iBartPosX := 180;
    for iIndex := 1 to iNewCount do
    begin
        { Create a new object and add it to the global object list. }
        objObject := TVisibleObject.Create(lstUniverse, iCollisionID);
        lstUniverse.Add(objObject);
        m_lstBarts.Add(objObject);

        { Assign the image of Bart. }
        objObject.IncludeShape('Bart', 0, 0, clRed, False);
        objObject.mtrxTransform.SetTranslation(iBartPosX, 20);
        objObject.mtrxTransform.fScale := 0.75;
        objObject.iGroupId := iGroupID;

        { Move to the next static Bart position. }
        Dec(iBartPosX, 20);
    end;
end;

function TScoreBoard.iGetBartCount: Integer;
begin
    Result := m_lstBarts.Count;
end;

end.
